/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.APlaneHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeneralPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NGon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyLine;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.PlanarConstraint;

public class PolyUtil {
    public static IPolygon newPoly(Point3d ... point3dArray) {
        return PolyUtil.newPoly(Util3D.isConvex(1.0E-9, point3dArray), point3dArray);
    }

    public static IPolygon newPoly(boolean bl, Point3d ... point3dArray) {
        if (point3dArray.length == 3) {
            return new Triangle(point3dArray[0], point3dArray[1], point3dArray[2]);
        }
        if (point3dArray.length == 4 && bl) {
            return new Quad(point3dArray[0], point3dArray[1], point3dArray[2], point3dArray[3]);
        }
        return new NGon(point3dArray);
    }

    public static IPolygon newPoly(Point3d[] point3dArray, int[] nArray) {
        if (nArray.length <= 1) {
            return PolyUtil.newPoly(point3dArray);
        }
        return new GeneralPoly(point3dArray, nArray);
    }

    public static IPolygon newPoly(Point3d[][] point3dArray) {
        if (point3dArray.length == 0) {
            return new NGon(new Point3d[0]);
        }
        if (point3dArray.length == 1) {
            return PolyUtil.newPoly(point3dArray[0]);
        }
        return new GeneralPoly(point3dArray);
    }

    public static boolean polysEqual(IPolygon iPolygon, IPolygon iPolygon2) {
        int n = iPolygon.getNumLoops();
        if (n != iPolygon2.getNumLoops()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = iPolygon.getNumPoints(i);
            if (n3 != iPolygon2.getNumPoints(i)) {
                return false;
            }
            if (n3 == 0) {
                return true;
            }
            int n4 = -1;
            Point3d point3d = iPolygon.getPoint(i, 0);
            for (n2 = 0; n2 < n3; ++n2) {
                if (!point3d.equals(iPolygon2.getPoint(i, n2))) continue;
                n4 = n2;
                break;
            }
            if (n4 == -1) {
                return false;
            }
            int n5 = (n4 + 1) % n3;
            for (n2 = 1; n2 < n3; ++n2) {
                Point3d point3d2;
                Point3d point3d3 = iPolygon.getPoint(i, n2);
                if (!point3d3.equals(point3d2 = iPolygon2.getPoint(i, n5))) {
                    return false;
                }
                n5 = (n5 + 1) % n3;
            }
        }
        return true;
    }

    public static void getBoundary(List<ICurve> list, IPolygon iPolygon) {
        for (int i = 0; i < iPolygon.getNumLoops(); ++i) {
            Point3d[] point3dArray = new Point3d[iPolygon.getNumPoints(i) + 1];
            for (int j = 0; j < point3dArray.length - 1; ++j) {
                point3dArray[j] = iPolygon.getPoint(i, j);
            }
            point3dArray[point3dArray.length - 1] = point3dArray[0];
            list.add(new PolyLine(point3dArray));
        }
    }

    public static Point3d[] getAllVerts(IPolygon iPolygon, boolean bl) {
        int n;
        if (!bl && iPolygon instanceof NGon) {
            return ((NGon)iPolygon).points;
        }
        if (!bl && iPolygon instanceof GeneralPoly) {
            return ((GeneralPoly)iPolygon).points;
        }
        int n2 = 0;
        for (n = 0; n < iPolygon.getNumLoops(); ++n) {
            n2 += iPolygon.getNumPoints(n);
        }
        n = 0;
        Point3d[] point3dArray = new Point3d[n2];
        for (int i = 0; i < iPolygon.getNumLoops(); ++i) {
            int n3 = iPolygon.getNumPoints(i);
            for (int j = 0; j < n3; ++j) {
                point3dArray[n++] = iPolygon.getPoint(i, j);
            }
        }
        return point3dArray;
    }

    public static Point3d[][] getLoops(IPolygon iPolygon, boolean bl) {
        if (!bl && iPolygon instanceof NGon) {
            return new Point3d[][]{((NGon)iPolygon).points};
        }
        Point3d[][] point3dArray = new Point3d[iPolygon.getNumLoops()][];
        for (int i = 0; i < point3dArray.length; ++i) {
            point3dArray[i] = PolyUtil.getLoop(iPolygon, i, bl);
        }
        return point3dArray;
    }

    public static int[] getLoopOffsets(IPolygon iPolygon, boolean bl) {
        if (!bl && iPolygon instanceof GeneralPoly) {
            return ((GeneralPoly)iPolygon).loopOffsets;
        }
        int[] nArray = new int[iPolygon.getNumLoops()];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
            n += iPolygon.getNumPoints(i);
        }
        return nArray;
    }

    public static Point3d[] getLoop(IPolygon iPolygon, int n, boolean bl) {
        if (!bl && iPolygon instanceof NGon) {
            assert (n == 0);
            return ((NGon)iPolygon).points;
        }
        int n2 = iPolygon.getNumPoints(n);
        Point3d[] point3dArray = new Point3d[n2];
        for (int i = 0; i < n2; ++i) {
            point3dArray[i] = iPolygon.getPoint(n, i);
        }
        return point3dArray;
    }

    public static boolean isConvex(IPolygon iPolygon) {
        if (iPolygon.getNumLoops() != 1) {
            return false;
        }
        if (iPolygon instanceof Triangle || iPolygon.getNumPoints(0) == 3) {
            return true;
        }
        Point3d[] point3dArray = PolyUtil.getLoop(iPolygon, 0, false);
        return Util3D.isConvex(1.0E-6, point3dArray);
    }

    public static boolean intersectsBox(Object object, IPolygon iPolygon, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        block11: {
            block12: {
                block10: {
                    if (!iIsectFilter.acceptGeomType(object, GeomType.FACE)) break block10;
                    if (PolyUtil.isConvex(iPolygon)) {
                        assert (iPolygon.getNumLoops() == 1);
                        int n = iPolygon.getNumPoints(0);
                        Point3d[] point3dArray = new Point3d[n];
                        for (int i = 0; i < n; ++i) {
                            point3dArray[i] = iPolygon.getPoint(0, i);
                        }
                        if (convexHull.intersectsConvexPoly(1.0E-6, point3dArray)) {
                            return true;
                        }
                    } else {
                        Mesh mesh = iPolygon.triangulate(1.0E-6);
                        Point3d[] point3dArray = new Point3d[3];
                        int n = 0;
                        while (n < mesh.indices.length) {
                            point3dArray[0] = mesh.vertices[mesh.indices[n++]];
                            point3dArray[1] = mesh.vertices[mesh.indices[n++]];
                            point3dArray[2] = mesh.vertices[mesh.indices[n++]];
                            if (!convexHull.intersectsConvexPoly(1.0E-6, point3dArray)) continue;
                            return true;
                        }
                    }
                    break block11;
                }
                if (!iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE)) break block12;
                int n = iPolygon.getNumLoops();
                for (int i = 0; i < n; ++i) {
                    int n2 = iPolygon.getNumPoints(i);
                    for (int j = 0; j < n2; ++j) {
                        Point3d point3d;
                        Point3d point3d2 = iPolygon.getPoint(i, j);
                        if (!convexHull.intersectsLineSeg(point3d2, point3d = iPolygon.getPoint(i, (j + 1) % n2), 1.0E-6)) continue;
                        return true;
                    }
                }
                break block11;
            }
            if (!iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) break block11;
            int n = iPolygon.getNumLoops();
            for (int i = 0; i < n; ++i) {
                int n3 = iPolygon.getNumPoints(i);
                for (int j = 0; j < n3; ++j) {
                    if (!convexHull.contains(iPolygon.getPoint(i, j), 1.0E-6)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void pickPoints(IPolygon iPolygon, IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        Point3d point3d3;
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE) && (point3d3 = PolyUtil.getFaceIsect(iPolygon, object, point3d, point3d2, vector3d)) != null) {
            iIsectCollector.add(object, point3d3, GeomType.FACE, iPolygon);
        }
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) {
            PolyUtil.getFaceVertices(iPolygon, object, iIsectCollector);
        }
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE)) {
            PolyUtil.getClosestToEdges(iPolygon, object, iIsectCollector, point3d, point3d2, vector3d);
        }
    }

    private static void getFaceVertices(IPolygon iPolygon, Object object, IIsectCollector iIsectCollector) {
        int n = iPolygon.getNumLoops();
        for (int i = 0; i < n; ++i) {
            int n2 = iPolygon.getNumPoints(i);
            for (int j = 0; j < n2; ++j) {
                Point3d point3d = iPolygon.getPoint(i, j);
                iIsectCollector.add(object, point3d, GeomType.FACE_VERTEX, iPolygon);
            }
        }
    }

    private static void getClosestToEdges(IPolygon iPolygon, Object object, IIsectCollector iIsectCollector, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Point3d point3d3 = new Point3d();
        int n = iPolygon.getNumLoops();
        for (int i = 0; i < n; ++i) {
            int n2 = iPolygon.getNumPoints(i);
            if (n2 == 0) continue;
            Point3d point3d4 = iPolygon.getPoint(i, 0);
            for (int j = 1; j <= n2; ++j) {
                Point3d point3d5 = iPolygon.getPoint(i, j % n2);
                boolean bl = Inter3D.lineLineSegProximity(null, point3d3, point3d, vector3d, point3d4, point3d5);
                if (bl) {
                    iIsectCollector.add(object, new Point3d(point3d3), GeomType.FACE_EDGE, iPolygon);
                }
                point3d4 = point3d5;
            }
        }
    }

    private static Point3d getFaceIsect(IPolygon iPolygon, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Plane3d plane3d = PolyUtil.getPlane(iPolygon);
        if (!plane3d.isValid()) {
            return null;
        }
        Point3d point3d3 = Inter3D.lineSegPlaneIntersection(point3d, point3d2, plane3d, 1.0E-6);
        if (point3d3 == null) {
            return null;
        }
        return iPolygon.classify((Point3d)point3d3, (double)1.0E-6).positive ? point3d3 : null;
    }

    public static Plane3d getPlane(IPolygon iPolygon) {
        if (iPolygon.getNumLoops() == 0 || iPolygon.getNumPoints(0) == 0) {
            return new Plane3d(0.0, 0.0, 1.0, 0.0);
        }
        Vector3d vector3d = iPolygon.getNormal();
        Point3d point3d = iPolygon.getPoint(0, 0);
        return new Plane3d(vector3d, point3d);
    }

    public static IPolygon reverse(IPolygon iPolygon) {
        int n = iPolygon.getNumLoops();
        Point3d[][] point3dArray = new Point3d[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = iPolygon.getNumPoints(i);
            Point3d[] point3dArray2 = new Point3d[n2];
            for (int j = 0; j < n2; ++j) {
                point3dArray2[n2 - 1 - j] = iPolygon.getPoint(i, j);
            }
            point3dArray[i] = point3dArray2;
        }
        return PolyUtil.newPoly(point3dArray);
    }

    protected static IFace.PointClassify classify(IPolygon iPolygon, Point3d point3d, double d) {
        int n;
        if (iPolygon.getNumLoops() == 0 || iPolygon.getNumPoints(0) == 0) {
            return IFace.PointClassify.OUTSIDE;
        }
        if (iPolygon.getNumLoops() == 1 && (n = iPolygon.getNumPoints(0)) == 3) {
            return PolyUtil.convert(Inter3D.classifyConvexPolyPoint(d, point3d, iPolygon.getPoint(0, 0), iPolygon.getPoint(0, 1), iPolygon.getPoint(0, 2)));
        }
        Plane3d plane3d = new Plane3d(iPolygon.getNormal(), iPolygon.getPoint(0, 0));
        Point3d[][] point3dArray = PolyUtil.getLoops(iPolygon, false);
        return PolyUtil.convert(Inter3D.classifySimplePolyPoint(1.0E-6, point3d, plane3d, point3dArray));
    }

    private static IFace.PointClassify convert(Inter3D.PointClassify pointClassify) {
        switch (pointClassify) {
            case INSIDE: {
                return IFace.PointClassify.INSIDE;
            }
            case ON_BOUNDARY: {
                return IFace.PointClassify.ON_BOUNDARY;
            }
        }
        return IFace.PointClassify.OUTSIDE;
    }

    public static Collection<? extends IHandle> generateManipHandles(IPolygon iPolygon) {
        ArrayList<IHandle> arrayList = new ArrayList<IHandle>();
        int n = iPolygon.getNumLoops();
        for (int i = 0; i < n; ++i) {
            int n2 = iPolygon.getNumPoints(i);
            for (int j = 0; j < n2; ++j) {
                arrayList.add(new VertHandle(iPolygon, i, j));
            }
        }
        arrayList.add(new OffsetHandle(iPolygon));
        return arrayList;
    }

    private static class OffsetHandle
    extends APlaneHandle<IPolygon> {
        public OffsetHandle(IPolygon iPolygon) {
            super(iPolygon);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && object instanceof OffsetHandle;
        }

        @Override
        public IGeom getGeom() {
            return (IGeom)this.getManipGeom();
        }

        @Override
        protected Vector3d getPlaneNormal(IPolygon iPolygon) {
            return iPolygon.getNormal();
        }

        @Override
        protected IPolygon modify(IPolygon iPolygon, double d) {
            Vector3d vector3d = iPolygon.getNormal();
            Matrix4d matrix4d = Util.translateMat(vector3d.x * d, vector3d.y * d, vector3d.z * d);
            return iPolygon.transform(matrix4d);
        }
    }

    private static class VertHandle
    implements IHandle {
        private IPolygon geom;
        private final int loop;
        private final int vert;
        private Point3d[][] d_loops;

        public VertHandle(IPolygon iPolygon, int n, int n2) {
            this.geom = iPolygon;
            this.loop = n;
            this.vert = n2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof VertHandle)) {
                return false;
            }
            VertHandle vertHandle = (VertHandle)object;
            return vertHandle.loop == this.loop && vertHandle.vert == this.vert;
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.getLocation());
        }

        protected Point3d getLocation() {
            return this.geom.getPoint(this.loop, this.vert);
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            Plane3d plane3d = PolyUtil.getPlane(this.geom);
            return new PlanarConstraint(plane3d);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.d_loops = PolyUtil.getLoops(this.geom, true);
        }

        @Override
        public IPolygon modify(Point3d point3d) throws Exception {
            this.d_loops[this.loop][this.vert] = point3d;
            this.geom = PolyUtil.newPoly(this.d_loops);
            return this.geom;
        }

        @Override
        public Object end() {
            this.d_loops = null;
            return this.geom;
        }
    }
}

