/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ACurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ILinearCurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NullOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;

public class PolyLine
extends ACurve
implements ILinearCurve,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d[] verts;

    public PolyLine(Point3d ... point3dArray) {
        this.verts = point3dArray;
        assert (point3dArray.length > 1);
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.PolyLine(this.verts);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.verts);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public int getNumVerts() {
        return this.verts.length;
    }

    @Override
    public Point3d getVert(int n) {
        return this.verts[n];
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d matrix4d) {
        return false;
    }

    @Override
    public boolean isShell() {
        return true;
    }

    @Override
    public ICurve optimize(IPointOptimizer iPointOptimizer) {
        if (iPointOptimizer instanceof NullOptimizer) {
            return this;
        }
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[this.verts.length];
        for (int i = 0; i < this.verts.length; ++i) {
            Point3d point3d = this.verts[i];
            Point3d point3d2 = iPointOptimizer.getExisting(point3d);
            bl |= point3d2 != point3d;
            point3dArray[i] = point3d2;
        }
        return bl ? new PolyLine(point3dArray) : this;
    }

    public IGeom transform(Matrix4d matrix4d, boolean bl) {
        return this.transform(matrix4d);
    }

    @Override
    public ICurve transform(Matrix4d matrix4d) {
        return new PolyLine(GeomUtil.xformVerts(this.verts, matrix4d));
    }

    @Override
    public Mesh getSegments(double d) {
        int[] nArray = new int[(this.verts.length - 1) * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.verts.length - 1) {
            nArray[n++] = n2++;
            nArray[n++] = n2;
        }
        return new Mesh(this.verts, nArray, 1);
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        block3: {
            block2: {
                if (!iIsectFilter.acceptGeomType(object, GeomType.EDGE)) break block2;
                for (int i = 0; i < this.verts.length - 1; ++i) {
                    Point3d point3d = this.verts[i];
                    Point3d point3d2 = this.verts[i + 1];
                    if (!convexHull.intersectsLineSeg(point3d, point3d2, 1.0E-6)) continue;
                    return true;
                }
                break block3;
            }
            if (!iIsectFilter.acceptGeomType(object, GeomType.VERTEX)) break block3;
            for (Point3d point3d : this.verts) {
                if (!convexHull.contains(point3d, 1.0E-6)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (iIsectFilter.acceptGeomType(object, GeomType.VERTEX)) {
            for (Point3d object2 : this.verts) {
                iIsectCollector.add(object, object2, GeomType.VERTEX, this);
            }
        }
        if (iIsectFilter.acceptGeomType(object, GeomType.EDGE)) {
            for (int i = 0; i < this.verts.length - 1; ++i) {
                Point3d point3d3 = this.verts[i];
                Point3d point3d4 = this.verts[i + 1];
                double[] dArray = Inter3D.lineSegLineSegProximityT(point3d, point3d2, point3d3, point3d4, 1.0E-6);
                if (dArray == null || dArray[1] == 1.0 && i < this.verts.length - 2) continue;
                iIsectCollector.add(object, Util3D.linesegPoint(point3d3, point3d4, dArray[1]), GeomType.EDGE, this);
            }
        }
    }

    @Override
    public Point3d project(Point3d point3d, double d) {
        Point3d point3d2 = null;
        double d2 = Double.MAX_VALUE;
        for (int i = 0; i < this.verts.length - 1; ++i) {
            Point3d point3d3 = this.verts[i];
            Point3d point3d4 = this.verts[i + 1];
            Point3d point3d5 = Inter3D.nearestPointOnLineSeg(point3d3, point3d4, point3d);
            double d3 = point3d.distanceSquared(point3d5);
            if (!(d3 < d2)) continue;
            d2 = d3;
            point3d2 = point3d5;
        }
        return point3d2;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<Handle> arrayList = new ArrayList<Handle>(this.verts.length);
        for (int i = 0; i < this.verts.length; ++i) {
            arrayList.add(new Handle(this, i));
        }
        return arrayList;
    }

    private static class Handle
    implements IHandle {
        private PolyLine d_geom;
        private final int d_ix;
        private Point3d[] t_verts;

        public Handle(PolyLine polyLine, int n) {
            this.d_geom = polyLine;
            this.d_ix = n;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle && ((Handle)object).d_ix == this.d_ix;
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.d_geom.verts[this.d_ix]);
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return null;
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.t_verts = Arrays.copyOf(this.d_geom.verts, this.d_geom.verts.length);
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            this.t_verts[this.d_ix] = point3d;
            this.d_geom = new PolyLine(this.t_verts);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.t_verts = null;
            return this.d_geom;
        }
    }
}

