/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ACurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;

public class PolyCurve
extends ACurve
implements ICurve,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final ICurve[] curves;

    public PolyCurve(ICurve ... iCurveArray) {
        this.curves = iCurveArray;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        thunderheadeng.geometry.objs.ICurve[] iCurveArray = new thunderheadeng.geometry.objs.ICurve[this.curves.length];
        for (int i = 0; i < this.curves.length; ++i) {
            iCurveArray[i] = (thunderheadeng.geometry.objs.ICurve)legacyDictionary_2012_1.get(this.curves[i]);
        }
        return new thunderheadeng.geometry.objs.PolyCurve(iCurveArray);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        for (ICurve iCurve : this.curves) {
            iCurve.getBoundingBox(aABox);
        }
        return aABox;
    }

    @Override
    public ICurve optimize(IPointOptimizer iPointOptimizer) {
        ICurve[] iCurveArray = new ICurve[this.curves.length];
        boolean bl = false;
        for (int i = 0; i < this.curves.length; ++i) {
            ICurve iCurve = this.curves[i];
            ICurve iCurve2 = iCurve.optimize(iPointOptimizer);
            bl |= iCurve != iCurve2;
            iCurveArray[i] = iCurve2;
        }
        return bl ? new PolyCurve(iCurveArray) : this;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public PolyCurve transform(Matrix4d matrix4d) {
        ICurve[] iCurveArray = new ICurve[this.curves.length];
        for (int i = 0; i < this.curves.length; ++i) {
            iCurveArray[i] = this.curves[i].transform(matrix4d);
        }
        return new PolyCurve(iCurveArray);
    }

    @Override
    public Mesh getSegments(double d) {
        Mesh[] meshArray = new Mesh[this.curves.length];
        for (int i = 0; i < this.curves.length; ++i) {
            meshArray[i] = this.curves[i].getSegments(d);
        }
        return Mesh.merge(meshArray);
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (iIsectFilter.acceptGeomType(object, GeomType.EDGE)) {
            for (ICurve iCurve : this.curves) {
                if (!iCurve.intersectsBox(object, iIsectFilter, convexHull)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        for (ICurve iCurve : this.curves) {
            iIsectCollector.getProgress().check();
            iCurve.pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
        }
    }

    @Override
    public Point3d project(Point3d point3d, double d) {
        Point3d point3d2 = null;
        double d2 = Double.MAX_VALUE;
        for (ICurve iCurve : this.curves) {
            Point3d point3d3 = iCurve.project(point3d, d);
            double d3 = point3d.distanceSquared(point3d3);
            if (!(d3 < d2)) continue;
            d2 = d3;
            point3d2 = point3d3;
        }
        return point3d2;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        for (int i = 0; i < this.curves.length; ++i) {
            ICurve iCurve = this.curves[i];
            if (!(iCurve instanceof IManipulatable)) continue;
            for (IHandle iHandle : ((IManipulatable)((Object)iCurve)).generateManipHandles()) {
                arrayList.add(new Handle(this, i, iHandle));
            }
        }
        return arrayList;
    }

    private static class Handle
    implements IHandle {
        private PolyCurve d_geom;
        private final int d_curveIx;
        private final IHandle d_curveHandle;
        private ICurve[] t_curves;

        public Handle(PolyCurve polyCurve, int n, IHandle iHandle) {
            this.d_geom = polyCurve;
            this.d_curveIx = n;
            this.d_curveHandle = iHandle;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle && ((Handle)object).d_curveIx == this.d_curveIx && ((Handle)object).d_curveHandle.equals(this.d_curveHandle);
        }

        @Override
        public IGeom getGeom() {
            return this.d_curveHandle.getGeom();
        }

        @Override
        public IIsectFilter getPickFilter() {
            return this.d_curveHandle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return this.d_curveHandle.getConstraint(point3d);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.t_curves = Arrays.copyOf(this.d_geom.curves, this.d_geom.curves.length);
            this.d_curveHandle.begin(point3d, iSnapConstraint);
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            Object object = this.d_curveHandle.modify(point3d);
            this.d_geom = this.replace(object);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.replace(this.d_curveHandle.end());
            this.t_curves = null;
            return this.d_geom;
        }

        private PolyCurve replace(Object object) {
            PolyCurve polyCurve = this.d_geom;
            if (object instanceof ICurve) {
                this.t_curves[this.d_curveIx] = (ICurve)object;
                polyCurve = new PolyCurve(this.t_curves);
            }
            return polyCurve;
        }
    }
}

