/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.APrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;

public class Point
extends APrimitive
implements IPrimitive,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final Point3d loc;

    public Point(Point3d point3d) {
        this.loc = point3d;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.Point(this.loc);
    }

    @Override
    public Point optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.loc);
        return point3d != this.loc ? new Point(point3d) : this;
    }

    public int hashCode() {
        return 65087 + this.loc.hashCode();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Point && ((Point)object).loc.equals(this.loc);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.loc);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public Point transform(Matrix4d matrix4d) {
        return new Point(Util3D.xform(matrix4d, this.loc));
    }

    @Override
    protected int getPrimType() {
        return 4;
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (iIsectFilter.acceptGeomType(object, GeomType.VERTEX)) {
            return convexHull.contains(this.loc, 1.0E-6);
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (iIsectFilter.acceptGeomType(object, GeomType.VERTEX)) {
            iIsectCollector.add(object, this.loc, GeomType.VERTEX, this);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this));
    }

    private static class Handle
    implements IHandle {
        private Point geom;

        public Handle(Point point) {
            this.geom = point;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle;
        }

        @Override
        public IGeom getGeom() {
            return this.geom;
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return null;
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            this.geom = new Point(point3d);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }
}

