/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class PlanarSurface
extends AFace {
    private static final long serialVersionUID = 1L;
    public final Plane3d plane;
    private static final AABox s_infBox = new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public PlanarSurface(Plane3d plane3d) {
        this.plane = plane3d;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.PlanarSurface((thunderheadeng.geometry.Plane3d)legacyDictionary_2012_1.get(this.plane));
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        boolean bl = theUtil.eq0(this.plane.x, 1.0E-9);
        boolean bl2 = theUtil.eq0(this.plane.y, 1.0E-9);
        if (bl && bl2) {
            aABox.add(new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -this.plane.z * this.plane.w, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, -this.plane.z * this.plane.w));
            return aABox;
        }
        boolean bl3 = theUtil.eq0(this.plane.z, 1.0E-9);
        if (bl && bl3) {
            aABox.add(new AABox(Double.NEGATIVE_INFINITY, -this.plane.y * this.plane.w, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -this.plane.y * this.plane.w, Double.POSITIVE_INFINITY));
            return aABox;
        }
        if (bl2 && bl3) {
            aABox.add(new AABox(-this.plane.x * this.plane.w, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -this.plane.x * this.plane.w, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
            return aABox;
        }
        aABox.add(s_infBox);
        return aABox;
    }

    @Override
    public void getBoundary(List<ICurve> list) {
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IFace optimize(IPointOptimizer iPointOptimizer) {
        return this;
    }

    @Override
    public IFace transform(Matrix4d matrix4d) {
        return new PlanarSurface(this.plane.transformBy(matrix4d));
    }

    @Override
    public Mesh triangulate(double d) {
        return new Mesh(new Point3d[0], new int[0], 2);
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE)) {
            // empty if block
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        Point3d point3d3;
        if (iIsectFilter.acceptGeomType(object, GeomType.FACE) && (point3d3 = Inter3D.lineSegPlaneIntersection(point3d, point3d2, this.plane, 1.0E-6)) != null) {
            iIsectCollector.add(object, point3d3, GeomType.FACE, this);
        }
    }

    @Override
    public Point3d project(Point3d point3d) {
        return this.plane.projectOntoPlane(point3d);
    }

    @Override
    public IFace.PointClassify classify(Point3d point3d, double d) {
        return IFace.PointClassify.INSIDE;
    }
}

