/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.MeshBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.TriangulatorInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NullOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;

public class NGon
extends AFace
implements IPolygon,
IManipulatable {
    static final long serialVersionUID = 1L;
    public final Point3d[] points;

    public NGon(Collection<Point3d> collection) {
        this(collection.toArray(new Point3d[collection.size()]));
    }

    public NGon(Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        this.points = point3dArray;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.NGon(this.points);
    }

    @Override
    public NGon optimize(IPointOptimizer iPointOptimizer) {
        if (iPointOptimizer instanceof NullOptimizer) {
            return this;
        }
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            point3dArray[i] = iPointOptimizer.getExisting(this.points[i]);
            bl |= point3dArray[i] != this.points[i];
        }
        return bl ? new NGon(point3dArray) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.points);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public NGon transform(Matrix4d matrix4d) {
        Point3d[] point3dArray = new Point3d[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            point3dArray[i] = Util3D.xform(matrix4d, this.points[i]);
        }
        return new NGon(point3dArray);
    }

    @Override
    public void getBoundary(List<ICurve> list) {
        PolyUtil.getBoundary(list, this);
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int n) {
        return this.points.length;
    }

    @Override
    public Point3d getPoint(int n, int n2) {
        return this.points[n2];
    }

    @Override
    public Vector3d getNormal() {
        Vector3d vector3d = Util3D.simplePolygonNormal(Arrays.asList(this.points), 1.0E-6);
        return vector3d == null ? GeomConstants.VEC3D_ZERO : vector3d;
    }

    @Override
    public Mesh triangulate(double d) {
        int n;
        Cloneable cloneable;
        Point2d point2d;
        int n2;
        HashMap<Point2d, Point3d> hashMap = new HashMap<Point2d, Point3d>();
        Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(this.points), 1.0E-6);
        if (plane3d == null) {
            return null;
        }
        Matrix4d matrix4d = Util.getWorldToLocalXform(plane3d);
        Matrix4d matrix4d2 = Util.getLocalToWorldXform(plane3d);
        Point2d[] point2dArray = new Point2d[this.points.length];
        MeshBuilder meshBuilder = new MeshBuilder(1.0E-6);
        for (n2 = 0; n2 < this.points.length; ++n2) {
            point2d = Util3D.xform2d(matrix4d, this.points[n2]);
            hashMap.put(point2d, this.points[n2]);
            point2dArray[n2] = point2d;
        }
        for (n2 = 0; n2 < this.points.length; ++n2) {
            point2d = point2dArray[n2];
            cloneable = point2dArray[(n2 + 1) % this.points.length];
            meshBuilder.addEdge(point2d, (Point2d)cloneable);
        }
        pyrosim.legacy_2012_1.thunderheadeng.delaunay.Mesh mesh = meshBuilder.build();
        boolean bl = mesh.triangulateEvenOdd(0, 0.0);
        if (!bl) {
            return null;
        }
        cloneable = new LinkedHashMap();
        TriangulatorInfo triangulatorInfo = mesh.getOutput();
        int[] nArray = new int[triangulatorInfo.points.length];
        for (n = 0; n < triangulatorInfo.points.length; ++n) {
            Integer n3;
            Point2d point2d2 = triangulatorInfo.points[n];
            Point3d point3d = (Point3d)hashMap.get(point2d2);
            if (point3d == null) {
                point3d = Util3D.xform(matrix4d2, new Point3d(point2d2.x, point2d2.y, 0.0));
            }
            if ((n3 = (Integer)cloneable.get(point3d)) == null) {
                n3 = cloneable.size();
                cloneable.put(point3d, n3);
            }
            nArray[n] = n3;
        }
        for (n = 0; n < triangulatorInfo.triangles.length; ++n) {
            triangulatorInfo.triangles[n] = nArray[triangulatorInfo.triangles[n]];
        }
        return new Mesh(cloneable.keySet().toArray(new Point3d[cloneable.size()]), triangulatorInfo.triangles, 2);
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        return PolyUtil.intersectsBox(object, this, iIsectFilter, convexHull);
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        PolyUtil.pickPoints(this, iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public Point3d project(Point3d point3d) {
        return PolyUtil.getPlane(this).projectOntoPlane(point3d);
    }

    @Override
    public IFace.PointClassify classify(Point3d point3d, double d) {
        return PolyUtil.classify(this, point3d, d);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return PolyUtil.generateManipHandles(this);
    }
}

