/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NullOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Mesh
implements IGeom,
IManipulatable {
    static final long serialVersionUID = 1L;
    public static final byte PT_POINTS = 0;
    public static final byte PT_LINESEGS = 1;
    public static final byte PT_TRIANGLES = 2;
    public static final byte PT_QUADS = 3;
    public static final int FLAG_SMOOTHNORMALS = 2;
    public static final int FLAG_SOLID = 4;
    public final byte primtype;
    public final Point3d[] vertices;
    public final int[] indices;
    public final int flags;

    public Mesh(Point3d[] point3dArray, int[] nArray, byte by) {
        this(point3dArray, nArray, by, 0);
    }

    public Mesh(Point3d[] point3dArray, int[] nArray, byte by, int n) {
        assert (nArray.length % Mesh.getNumVertsPerElement(by) == 0);
        this.vertices = point3dArray;
        this.indices = nArray;
        this.flags = n;
        this.primtype = by;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.Mesh(this.vertices, this.indices, this.primtype, this.flags);
    }

    @Override
    public IGeom optimize(IPointOptimizer iPointOptimizer) {
        int n = this.getNumPrims(7);
        if (n == 1) {
            return this.getPrimitive(0).optimize(iPointOptimizer);
        }
        if (iPointOptimizer instanceof NullOptimizer) {
            return this;
        }
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            point3dArray[i] = iPointOptimizer.getExisting(this.vertices[i]);
            bl |= point3dArray[i] != this.vertices[i];
        }
        return bl ? new Mesh(point3dArray, this.indices, this.primtype, this.flags) : this;
    }

    public Mesh toSolid() {
        if (this.testFlag(4)) {
            return this;
        }
        return new Mesh(this.vertices, this.indices, this.primtype, this.flags | 4);
    }

    public Mesh toShell() {
        if (!this.testFlag(4)) {
            return this;
        }
        return new Mesh(this.vertices, this.indices, this.primtype, this.flags & 0xFFFFFFFB);
    }

    public boolean testFlag(int n) {
        return (this.flags & n) == n;
    }

    public int getNumVertsPerPrim() {
        switch (this.primtype) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.vertices);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(Matrix4d matrix4d, IGeom.XformOp xformOp) {
        return new Mesh(GeomUtil.xformVerts(this.vertices, matrix4d), this.indices, this.primtype, this.flags);
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d matrix4d) {
        return false;
    }

    @Override
    public boolean isShell() {
        return !this.testFlag(4);
    }

    private static int getNumVertsPerElement(byte by) {
        switch (by) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int n) {
        if ((n & 1) != 0 && (this.primtype == 2 || this.primtype == 3)) {
            return this.indices.length / Mesh.getNumVertsPerElement(this.primtype);
        }
        if ((n & 2) != 0 && this.primtype == 1) {
            return this.indices.length / 2;
        }
        if ((n & 4) != 0 && this.primtype == 0) {
            return this.indices.length;
        }
        return 0;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        Point3d[] point3dArray = this.vertices;
        switch (this.primtype) {
            case 0: {
                int n = 0;
                while (n < this.indices.length) {
                    Point3d point3d = point3dArray[this.indices[n++]];
                    collection.add(new Point(point3d));
                }
                break;
            }
            case 1: {
                int n = 0;
                while (n < this.indices.length) {
                    Point3d point3d = point3dArray[this.indices[n++]];
                    Point3d point3d2 = point3dArray[this.indices[n++]];
                    collection.add(new LineSeg(point3d, point3d2));
                }
                break;
            }
            case 2: {
                int n = 0;
                while (n < this.indices.length) {
                    Point3d point3d = point3dArray[this.indices[n++]];
                    Point3d point3d3 = point3dArray[this.indices[n++]];
                    Point3d point3d4 = point3dArray[this.indices[n++]];
                    collection.add(new Triangle(point3d, point3d3, point3d4));
                }
                break;
            }
            case 3: {
                int n = 0;
                while (n < this.indices.length) {
                    Point3d point3d = point3dArray[this.indices[n++]];
                    Point3d point3d5 = point3dArray[this.indices[n++]];
                    Point3d point3d6 = point3dArray[this.indices[n++]];
                    Point3d point3d7 = point3dArray[this.indices[n++]];
                    collection.add(new Quad(point3d, point3d5, point3d6, point3d7));
                }
                break;
            }
        }
        return collection;
    }

    public boolean isValid() {
        for (int n : this.indices) {
            if (n < this.vertices.length && n >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isClosed() {
        return this.testClosed().v1 == ClosedTest.CLOSED;
    }

    public Pair<ClosedTest, Object> testClosed() {
        Object object;
        int n;
        int n2;
        if (this.primtype != 2 && this.primtype != 3) {
            return new Pair<ClosedTest, Object>(ClosedTest.WRONG_TYPE, null);
        }
        int n3 = n2 = this.primtype == 2 ? 3 : 4;
        if (this.indices.length == n2) {
            return new Pair<ClosedTest, Object>(ClosedTest.ONE_FACE, null);
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (int i = 0; i < this.indices.length; i += n2) {
            for (int j = 0; j < n2; ++j) {
                n = this.indices[i + j];
                int n4 = this.indices[i + (j + 1) % n2];
                object = new EdgeHash(n, n4);
                Integer n5 = (Integer)hashMap.get(object);
                n5 = n5 == null ? Integer.valueOf(1) : Integer.valueOf(n5 + 1);
                hashMap.put(object, n5);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            n = (Integer)entry.getValue();
            if (n > 1) continue;
            Point3d point3d = this.vertices[((EdgeHash)entry.getKey()).e1];
            object = this.vertices[((EdgeHash)entry.getKey()).e2];
            return new Pair<ClosedTest, Point3d[]>(ClosedTest.EDGE_OPEN, new Point3d[]{point3d, object});
        }
        return new Pair<ClosedTest, Object>(ClosedTest.CLOSED, null);
    }

    public static Mesh merge(Mesh ... meshArray) {
        if (meshArray.length == 0) {
            return new Mesh(new Point3d[0], new int[0], 0);
        }
        byte by = meshArray[0].primtype;
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Mesh mesh : meshArray) {
            assert (mesh.primtype == by);
            int[] nArray = new int[mesh.vertices.length];
            for (int i = 0; i < mesh.vertices.length; ++i) {
                Point3d point3d = mesh.vertices[i];
                Integer n = (Integer)linkedHashMap.get(point3d);
                if (n == null) {
                    n = linkedHashMap.size();
                    linkedHashMap.put(point3d, n);
                }
                nArray[i] = n;
            }
            for (int n : mesh.indices) {
                arrayList.add(nArray[n]);
            }
        }
        return new Mesh(linkedHashMap.keySet().toArray(new Point3d[linkedHashMap.size()]), theUtil.toIntArray(arrayList), by);
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        switch (this.primtype) {
            case 0: {
                if (!iIsectFilter.acceptGeomType(object, GeomType.VERTEX)) break;
                for (int i = 0; i < this.indices.length; ++i) {
                    if (!convexHull.contains(this.vertices[this.indices[i]])) continue;
                    return true;
                }
                break;
            }
            case 1: {
                if (iIsectFilter.acceptGeomType(object, GeomType.EDGE)) {
                    int n = 0;
                    while (n < this.indices.length) {
                        Point3d point3d;
                        Point3d point3d2;
                        if (!convexHull.intersectsLineSeg(point3d2 = this.vertices[this.indices[n++]], point3d = this.vertices[this.indices[n++]], 1.0E-6)) continue;
                        return true;
                    }
                } else {
                    if (!iIsectFilter.acceptGeomType(object, GeomType.VERTEX)) break;
                    for (Point3d point3d : this.vertices) {
                        if (!convexHull.contains(point3d, 1.0E-6)) continue;
                        return true;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                if (iIsectFilter.acceptGeomType(object, GeomType.FACE)) {
                    Point3d[] point3dArray = new Point3d[Mesh.getNumVertsPerElement(this.primtype)];
                    int n = 0;
                    while (n < this.indices.length) {
                        for (int i = 0; i < point3dArray.length; ++i) {
                            point3dArray[i] = this.vertices[this.indices[n++]];
                        }
                        if (!convexHull.intersectsConvexPoly(1.0E-6, point3dArray)) continue;
                        return true;
                    }
                } else if (iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE)) {
                    int n = Mesh.getNumVertsPerElement(this.primtype);
                    for (int i = 0; i < this.indices.length; i += n) {
                        for (int j = 0; j < n; ++j) {
                            Point3d point3d = this.vertices[this.indices[i + j]];
                            Point3d point3d3 = this.vertices[this.indices[i + (j + 1) % n]];
                            if (!convexHull.intersectsLineSeg(point3d, point3d3, 1.0E-6)) continue;
                            return true;
                        }
                    }
                } else {
                    if (!iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) break;
                    for (Point3d point3d : this.vertices) {
                        if (!convexHull.contains(point3d)) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        GeomType geomType = null;
        GeomType geomType2 = null;
        GeomType geomType3 = null;
        switch (this.primtype) {
            case 0: {
                geomType = GeomType.VERTEX;
                break;
            }
            case 1: {
                geomType = GeomType.VERTEX;
                geomType2 = GeomType.EDGE;
                break;
            }
            case 2: 
            case 3: {
                geomType = GeomType.FACE_VERTEX;
                geomType2 = GeomType.FACE_EDGE;
                geomType3 = GeomType.FACE;
            }
        }
        if (geomType != null && iIsectFilter.acceptGeomType(object, geomType)) {
            this.pickVerts(iIsectCollector, object, geomType);
        }
        if (geomType2 != null && iIsectFilter.acceptGeomType(object, geomType2)) {
            this.pickEdges(iIsectCollector, object, point3d, point3d2, vector3d, iTest);
        }
        if (geomType3 != null && iIsectFilter.acceptGeomType(object, geomType3)) {
            this.pickFaces(iIsectCollector, object, point3d, point3d2, vector3d, iTest);
        }
    }

    private void pickVerts(IIsectCollector iIsectCollector, Object object, GeomType geomType) {
        for (Point3d point3d : this.vertices) {
            iIsectCollector.add(object, point3d, geomType, new Point(point3d));
        }
    }

    private void pickEdges(IIsectCollector iIsectCollector, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        AABox aABox = new AABox();
        if (this.primtype == 1) {
            int n = 0;
            while (n < this.indices.length) {
                Point3d point3d3 = this.vertices[this.indices[n++]];
                Point3d point3d4 = this.vertices[this.indices[n++]];
                aABox.reset();
                aABox.add(point3d3, point3d4);
                if (!iTest.test((AABox)aABox).positive) continue;
                double[] dArray = Inter3D.lineSegLineSegProximityT(point3d, point3d2, point3d3, point3d4, 1.0E-6);
                if (dArray != null) {
                    iIsectCollector.add(object, Util3D.linesegPoint(point3d3, point3d4, dArray[1]), GeomType.EDGE, new LineSeg(point3d3, point3d4));
                    continue;
                }
                iIsectCollector.getProgress().check();
            }
        } else {
            int n = this.getNumVertsPerPrim();
            Point3d[] point3dArray = new Point3d[n];
            for (int i = 0; i < this.indices.length; i += n) {
                IPolygon iPolygon = null;
                for (int j = 0; j < n; ++j) {
                    int n2 = this.indices[i + j];
                    int n3 = this.indices[i + (j + 1) % n];
                    Point3d point3d5 = this.vertices[n2];
                    Point3d point3d6 = this.vertices[n3];
                    aABox.reset();
                    aABox.add(point3d5, point3d6);
                    if (!iTest.test((AABox)aABox).positive) continue;
                    double[] dArray = Inter3D.lineSegLineSegProximityT(point3d, point3d2, point3d5, point3d6, 1.0E-6);
                    if (dArray != null) {
                        if (iPolygon == null) {
                            for (int k = 0; k < n; ++k) {
                                point3dArray[k] = this.vertices[this.indices[k]];
                            }
                            iPolygon = PolyUtil.newPoly(point3dArray);
                        }
                        iIsectCollector.add(object, Util3D.linesegPoint(point3d5, point3d6, dArray[1]), GeomType.FACE_EDGE, iPolygon);
                        continue;
                    }
                    iIsectCollector.getProgress().check();
                }
            }
        }
    }

    private void pickFaces(IIsectCollector iIsectCollector, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        Plane3d plane3d = new Plane3d();
        int n = this.getNumVertsPerPrim();
        Point3d[] point3dArray = new Point3d[n];
        for (int i = 0; i < this.indices.length; i += n) {
            for (int j = 0; j < n; ++j) {
                point3dArray[j] = this.vertices[this.indices[i + j]];
            }
            plane3d.set(1.0E-6, point3dArray);
            if (!plane3d.isValid()) continue;
            Point3d point3d3 = Inter3D.lineSegPlaneIntersection(point3d, point3d2, plane3d, 1.0E-6);
            if (point3d3 != null && Inter3D.pointInPoly(1.0E-6, point3d3, point3dArray)) {
                IPolygon iPolygon = PolyUtil.newPoly(point3dArray);
                iIsectCollector.add(object, point3d3, GeomType.FACE, iPolygon);
                continue;
            }
            iIsectCollector.getProgress().check();
        }
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        AABox aABox = new AABox();
        Collection<IGeom> collection = this.explode(new ArrayList<IGeom>(this.getNumPrims(7)));
        for (IGeom iGeom : collection) {
            aABox.reset();
            iGeom.getBoundingBox(aABox);
            Containment containment = iTest.test(aABox);
            if (!containment.positive) continue;
            iResult.mark((IPrimitive)iGeom, containment);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        Collection<IGeom> collection = this.explode(new ArrayList<IGeom>(this.getNumPrims(7)));
        for (IGeom iGeom : collection) {
            iResult.mark((IPrimitive)iGeom, Containment.INSIDE);
        }
    }

    public Mesh fix() {
        Object object;
        if (this.primtype != 3) {
            return this;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.indices.length) {
            object = this.vertices[this.indices[n++]];
            Point3d point3d = this.vertices[this.indices[n++]];
            Point3d point3d2 = this.vertices[this.indices[n++]];
            Point3d point3d3 = this.vertices[this.indices[n++]];
            if (!((Tuple3d)object).equals(point3d) && !point3d.equals(point3d2) && !point3d2.equals(point3d3) && !point3d3.equals((Tuple3d)object) && Util3D.areCoplanar(1.0E-6, new Point3d[]{object, point3d, point3d2, point3d3})) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return this;
        }
        n = this.indices.length / 4 * 2;
        object = new int[n * 3];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.indices.length) {
            int n4 = this.indices[n3++];
            int n5 = this.indices[n3++];
            int n6 = this.indices[n3++];
            int n7 = this.indices[n3++];
            Point3d point3d = this.vertices[n4];
            Point3d point3d4 = this.vertices[n5];
            Point3d point3d5 = this.vertices[n6];
            Point3d point3d6 = this.vertices[n7];
            if (point3d.equals(point3d4)) {
                n2 = Mesh.addTri((int[])object, n2, n4, n6, n7);
                continue;
            }
            if (point3d4.equals(point3d5)) {
                n2 = Mesh.addTri((int[])object, n2, n4, n5, n7);
                continue;
            }
            if (point3d5.equals(point3d6)) {
                n2 = Mesh.addTri((int[])object, n2, n4, n5, n6);
                continue;
            }
            if (point3d6.equals(point3d)) {
                n2 = Mesh.addTri((int[])object, n2, n4, n5, n6);
                continue;
            }
            n2 = Mesh.addTri((int[])object, n2, n4, n5, n6);
            n2 = Mesh.addTri((int[])object, n2, n4, n6, n7);
        }
        if (n2 < ((Object)object).length) {
            object = Arrays.copyOf((int[])object, n2);
        }
        return new Mesh(this.vertices, (int[])object, 2, this.flags);
    }

    private static int addTri(int[] nArray, int n, int n2, int n3, int n4) {
        nArray[n++] = n2;
        nArray[n++] = n3;
        nArray[n++] = n4;
        return n;
    }

    public IPrimitive getPrimitive(int n) {
        int n2 = Mesh.getNumVertsPerElement(this.primtype);
        int n3 = n2 * n;
        switch (this.primtype) {
            case 0: {
                return new Point(this.vertices[this.indices[n3]]);
            }
            case 1: {
                Point3d point3d = this.vertices[this.indices[n3++]];
                Point3d point3d2 = this.vertices[this.indices[n3++]];
                return new LineSeg(point3d, point3d2);
            }
            case 2: {
                Point3d point3d = this.vertices[this.indices[n3++]];
                Point3d point3d3 = this.vertices[this.indices[n3++]];
                Point3d point3d4 = this.vertices[this.indices[n3++]];
                return new Triangle(point3d, point3d3, point3d4);
            }
            case 3: {
                Point3d point3d = this.vertices[this.indices[n3++]];
                Point3d point3d5 = this.vertices[this.indices[n3++]];
                Point3d point3d6 = this.vertices[this.indices[n3++]];
                Point3d point3d7 = this.vertices[this.indices[n3++]];
                return new Quad(point3d, point3d5, point3d6, point3d7);
            }
        }
        return null;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        ArrayList<VertHandle> arrayList = new ArrayList<VertHandle>(this.vertices.length);
        for (int i = 0; i < this.vertices.length; ++i) {
            arrayList.add(new VertHandle(this, i));
        }
        return arrayList;
    }

    private static class VertHandle
    implements IHandle {
        private Mesh d_geom;
        private final int d_vertIx;
        private Point3d[] t_verts;

        public VertHandle(Mesh mesh, int n) {
            this.d_geom = mesh;
            this.d_vertIx = n;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof VertHandle && ((VertHandle)object).d_vertIx == this.d_vertIx;
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.d_geom.vertices[this.d_vertIx]);
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return null;
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.t_verts = Arrays.copyOf(this.d_geom.vertices, this.d_geom.vertices.length);
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            this.t_verts[this.d_vertIx] = point3d;
            this.d_geom = new Mesh(this.t_verts, this.d_geom.indices, this.d_geom.primtype, this.d_geom.flags);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.t_verts = null;
            return this.d_geom;
        }
    }

    private static class EdgeHash {
        private int e1;
        private int e2;

        public EdgeHash() {
        }

        public EdgeHash(int n, int n2) {
            this.e1 = n;
            this.e2 = n2;
        }

        public void set(int n, int n2) {
            this.e1 = n;
            this.e2 = n2;
        }

        public int hashCode() {
            return this.e1 + this.e2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof EdgeHash)) {
                return false;
            }
            EdgeHash edgeHash = (EdgeHash)object;
            return object instanceof EdgeHash && edgeHash.e1 == this.e1 && edgeHash.e2 == this.e2 || edgeHash.e1 == this.e2 && edgeHash.e2 == this.e1;
        }
    }

    public static enum ClosedTest {
        CLOSED,
        WRONG_TYPE,
        ONE_FACE,
        EDGE_OPEN;

    }
}

