/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ACurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ILinearCurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;

public class LineSeg
extends ACurve
implements ILinearCurve,
IManipulatable {
    static final long serialVersionUID = 1L;
    public final Point3d p1;
    public final Point3d p2;

    public LineSeg(Point3d point3d, Point3d point3d2) {
        this.p1 = point3d;
        this.p2 = point3d2;
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.LineSeg(this.p1, this.p2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineSeg)) {
            return false;
        }
        return this.equals((LineSeg)object, true);
    }

    public boolean equals(LineSeg lineSeg, boolean bl) {
        if (lineSeg == this) {
            return true;
        }
        if (!bl) {
            return this.p1.equals(lineSeg.p1) && this.p2.equals(lineSeg.p2) || this.p1.equals(lineSeg.p2) && this.p2.equals(lineSeg.p1);
        }
        return this.p1.equals(lineSeg.p1) && this.p2.equals(lineSeg.p2);
    }

    @Override
    public int getNumVerts() {
        return 2;
    }

    @Override
    public Point3d getVert(int n) {
        return n == 0 ? this.p1 : this.p2;
    }

    public double getT(Point3d point3d) {
        return Util3D.tOnLineSeg(this.p1, this.p2, point3d);
    }

    @Override
    public LineSeg optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.p1);
        Point3d point3d2 = iPointOptimizer.getExisting(this.p2);
        return point3d != this.p1 || point3d2 != this.p2 ? new LineSeg(point3d, point3d2) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.p1);
        aABox.add(this.p2);
        return aABox;
    }

    public Vector3d getTangent(double d, ICurve.Orient orient, boolean bl) {
        Vector3d vector3d;
        switch (orient) {
            case POSITIVE: {
                vector3d = Util3D.vector(this.p1, this.p2);
                break;
            }
            default: {
                vector3d = Util3D.vector(this.p2, this.p1);
            }
        }
        if (bl) {
            vector3d.normalize();
        }
        return vector3d;
    }

    public Point3d evaluate(double d) {
        if (d == 0.0) {
            return new Point3d(this.p1);
        }
        if (d == 1.0) {
            return new Point3d(this.p2);
        }
        return Util3D.linesegPoint(this.p1, this.p2, d);
    }

    public LineSeg negate() {
        return new LineSeg(this.p2, this.p1);
    }

    public LineSeg trim(double d, double d2) {
        if (d == 0.0 && d2 == 1.0) {
            return this;
        }
        return new LineSeg(this.evaluate(d), this.evaluate(d2));
    }

    public double length() {
        return this.p1.distance(this.p2);
    }

    public double lengthSq() {
        return this.p1.distanceSquared(this.p2);
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public LineSeg transform(Matrix4d matrix4d) {
        return new LineSeg(Util3D.xform(matrix4d, this.p1), Util3D.xform(matrix4d, this.p2));
    }

    @Override
    public Mesh getSegments(double d) {
        Point3d[] point3dArray = new Point3d[]{this.p1, this.p2};
        return new Mesh(point3dArray, new int[]{0, 1}, 1);
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (iIsectFilter.acceptGeomType(object, GeomType.EDGE)) {
            return convexHull.intersectsLineSeg(this.p1, this.p2, 1.0E-6);
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        double[] dArray;
        if (iIsectFilter.acceptGeomType(object, GeomType.VERTEX)) {
            iIsectCollector.add(object, this.p1, GeomType.VERTEX, this);
            iIsectCollector.add(object, this.p2, GeomType.VERTEX, this);
        }
        if (iIsectFilter.acceptGeomType(object, GeomType.EDGE) && (dArray = Inter3D.lineSegLineSegProximityT(point3d, point3d2, this.p1, this.p2, 1.0E-6)) != null) {
            Point3d point3d3 = Util3D.linesegPoint(this.p1, this.p2, dArray[1]);
            iIsectCollector.add(object, point3d3, GeomType.EDGE, this);
        }
    }

    @Override
    public Point3d project(Point3d point3d, double d) {
        return Inter3D.nearestPointOnLineSeg(this.p1, this.p2, point3d);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this, 0), new Handle(this, 1));
    }

    private static class Handle
    implements IHandle {
        private LineSeg d_geom;
        private final int d_ix;

        public Handle(LineSeg lineSeg, int n) {
            this.d_geom = lineSeg;
            this.d_ix = n;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle && ((Handle)object).d_ix == this.d_ix;
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.getLocation());
        }

        protected Point3d getLocation() {
            return this.d_ix == 0 ? this.d_geom.p1 : this.d_geom.p2;
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return null;
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            Point3d[] point3dArray = new Point3d[]{this.d_geom.p1, this.d_geom.p2};
            point3dArray[this.d_ix] = point3d;
            this.d_geom = new LineSeg(point3dArray[0], point3dArray[1]);
            return this.d_geom;
        }

        @Override
        public Object end() {
            return this.d_geom;
        }
    }
}

