/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Set;
import javax.vecmath.Matrix4d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;

public interface IDOF {
    public static final IDOF FREE = new IDOF(){

        @Override
        public boolean accept(Matrix4d matrix4d) {
            return true;
        }

        @Override
        public void describeRules(Set<String> set) {
        }
    };
    public static final IDOF ALIGNED = new IDOF(){

        @Override
        public boolean accept(Matrix4d matrix4d) {
            return GeomUtil.isAxisAlignedTransform(matrix4d);
        }

        @Override
        public void describeRules(Set<String> set) {
            set.add(Intl.intl("Rotation must be in 90 degree increments about the X, Y, or Z axis."));
        }
    };
    public static final IDOF NONE = new IDOF(){

        @Override
        public boolean accept(Matrix4d matrix4d) {
            return matrix4d.m00 > 0.0 && matrix4d.m01 == 0.0 && matrix4d.m02 == 0.0 && matrix4d.m10 == 0.0 && matrix4d.m11 > 0.0 && matrix4d.m12 == 0.0 && matrix4d.m20 == 0.0 && matrix4d.m21 == 0.0 && matrix4d.m22 > 0.0 && matrix4d.m30 == 0.0 && matrix4d.m31 == 0.0 && matrix4d.m32 == 0.0 && matrix4d.m33 > 0.0;
        }

        @Override
        public void describeRules(Set<String> set) {
            set.add(Intl.intl("Rotation and mirroring are not allowed."));
        }
    };
    public static final IDOF ROT_Z = new IDOF(){

        @Override
        public boolean accept(Matrix4d matrix4d) {
            return GeomUtil.isZRotation(matrix4d);
        }

        @Override
        public void describeRules(Set<String> set) {
            set.add(Intl.intl("Rotation may only be about the Z-axis."));
        }
    };

    public boolean accept(Matrix4d var1);

    public void describeRules(Set<String> var1);

    public static class CompositeDOF
    implements IDOF {
        public final Set<? extends IDOF> dofs;

        public CompositeDOF(Set<? extends IDOF> set) {
            this.dofs = set;
        }

        @Override
        public boolean accept(Matrix4d matrix4d) {
            for (IDOF iDOF : this.dofs) {
                if (iDOF.accept(matrix4d)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void describeRules(Set<String> set) {
            for (IDOF iDOF : this.dofs) {
                iDOF.describeRules(set);
            }
        }
    }
}

