/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class GeomUtil {
    public static final Vector3d[] AXIS_VECS = new Vector3d[]{new Vector3d(-1.0, 0.0, 0.0), new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, -1.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 0.0, 1.0)};

    public static List<IPrimitive> explodeToTypes(IGeom iGeom, int n) {
        return GeomUtil.explodeToTypes(Arrays.asList(iGeom), n);
    }

    public static List<IPrimitive> explodeToTypes(Collection<? extends IGeom> collection, int n) {
        Class<? extends IPrimitive>[] classArray = GeomUtil.getPrimClasses(n);
        int n2 = 0;
        for (IGeom iGeom : collection) {
            n2 += iGeom.getNumPrims(n);
        }
        ArrayList arrayList = new ArrayList(n2);
        GeomUtil.explodeToTypes(collection, classArray, arrayList);
        assert (arrayList.size() == n2);
        return arrayList;
    }

    public static <T extends IPrimitive> List<T> explode(IGeom iGeom, Class<? extends T> ... classArray) {
        return GeomUtil.explode(Arrays.asList(iGeom), classArray);
    }

    public static <T extends IPrimitive> List<T> explode(Collection<? extends IGeom> collection, Class<? extends T> ... classArray) {
        ArrayList arrayList = new ArrayList();
        GeomUtil.explodeToTypes(collection, classArray, arrayList);
        return arrayList;
    }

    private static <T extends IPrimitive> void explodeToTypes(Collection<? extends IGeom> collection, Class<? extends T>[] classArray, List<T> list) {
        for (IGeom iGeom : collection) {
            if (GeomUtil.isType(iGeom, classArray)) {
                list.add((IPrimitive)iGeom);
                continue;
            }
            if (!iGeom.canExplode()) continue;
            Collection<IGeom> collection2 = iGeom.explode(new ArrayList<IGeom>());
            GeomUtil.explodeToTypes(collection2, classArray, list);
        }
    }

    public static boolean isEmpty(IGeom iGeom) {
        return iGeom == EmptyGeom.INSTANCE || iGeom.getNumPrims(7) == 0;
    }

    private static Class<? extends IPrimitive>[] getPrimClasses(int n) {
        int n2 = Integer.bitCount(n &= 7);
        Class[] classArray = new Class[n2];
        int n3 = 0;
        if ((n & 1) != 0) {
            classArray[n3++] = IFace.class;
        }
        if ((n & 2) != 0) {
            classArray[n3++] = ICurve.class;
        }
        if ((n & 4) != 0) {
            classArray[n3++] = Point.class;
        }
        return classArray;
    }

    public static boolean isType(Object object, Class ... classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static IPolygon newPoly(Point3d[] point3dArray) {
        return PolyUtil.newPoly(point3dArray);
    }

    public static IPolygon newPoly(Point3d[] point3dArray, int[] nArray) {
        return PolyUtil.newPoly(point3dArray, nArray);
    }

    public static IPolygon newPoly(Point3d[][] point3dArray) {
        return PolyUtil.newPoly(point3dArray);
    }

    public static boolean polysEqual(IPolygon iPolygon, IPolygon iPolygon2) {
        return PolyUtil.polysEqual(iPolygon, iPolygon2);
    }

    public static boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    public static boolean isAxisAlignedTransform(Matrix4d matrix4d) {
        if (matrix4d.m00 == 0.0 || matrix4d.m11 == 0.0 || matrix4d.m22 == 0.0) {
            return true;
        }
        AxisAngle4d axisAngle4d = GeomUtil.getRotation(matrix4d);
        if (axisAngle4d == null) {
            return false;
        }
        if (axisAngle4d.angle == 0.0) {
            return true;
        }
        Vector3d vector3d = new Vector3d(axisAngle4d.x, axisAngle4d.y, axisAngle4d.z);
        vector3d.normalize();
        if (vector3d.epsilonEquals(GeomConstants.VEC3D_XPOS, 1.0E-6) || vector3d.epsilonEquals(GeomConstants.VEC3D_XNEG, 1.0E-6) || vector3d.epsilonEquals(GeomConstants.VEC3D_YPOS, 1.0E-6) || vector3d.epsilonEquals(GeomConstants.VEC3D_YNEG, 1.0E-6) || vector3d.epsilonEquals(GeomConstants.VEC3D_ZPOS, 1.0E-6) || vector3d.epsilonEquals(GeomConstants.VEC3D_ZNEG, 1.0E-6)) {
            double d = Math.abs(axisAngle4d.angle / 1.5707963267948966);
            return theUtil.eq0(d - Math.floor(d), 1.0E-6);
        }
        return false;
    }

    public static List<Pair<ICurve, Integer>> getFaceOutlines(IGeom iGeom) {
        ArrayList<ICurve> arrayList = new ArrayList<ICurve>();
        ArrayList<Pair<ICurve, Integer>> arrayList2 = new ArrayList<Pair<ICurve, Integer>>(iGeom.getNumPrims(1));
        List<IPrimitive> list = GeomUtil.explodeToTypes(iGeom, 1);
        for (int i = 0; i < list.size(); ++i) {
            IFace iFace = (IFace)list.get(i);
            if (iFace == null) continue;
            arrayList.clear();
            iFace.getBoundary(arrayList);
            for (ICurve iCurve : arrayList) {
                arrayList2.add(new Pair<ICurve, Integer>(iCurve, i));
            }
        }
        return arrayList2;
    }

    public static void getBoundary(List<ICurve> list, IPolygon iPolygon) {
        PolyUtil.getBoundary(list, iPolygon);
    }

    public static Point3d[] getAllVerts(IPolygon iPolygon) {
        return PolyUtil.getAllVerts(iPolygon, false);
    }

    public static Point3d[][] getLoops(IPolygon iPolygon) {
        return PolyUtil.getLoops(iPolygon, false);
    }

    public static int[] getLoopOffsets(IPolygon iPolygon) {
        return PolyUtil.getLoopOffsets(iPolygon, false);
    }

    public static void flatten(IGeom iGeom, List<IGeom> list) {
        if (iGeom instanceof GeomGroup) {
            for (IGeom iGeom2 : ((GeomGroup)iGeom).children) {
                GeomUtil.flatten(iGeom2, list);
            }
        } else {
            list.add(iGeom);
        }
    }

    public static List<IGeom> flatten(IGeom iGeom) {
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>();
        GeomUtil.flatten(iGeom, arrayList);
        return arrayList;
    }

    public static boolean isZRotation(Matrix4d matrix4d) {
        AxisAngle4d axisAngle4d = GeomUtil.getRotation(matrix4d);
        if (axisAngle4d == null) {
            return false;
        }
        return theUtil.eq0(axisAngle4d.angle, 1.0E-9) || theUtil.eq0(axisAngle4d.x, 1.0E-9) && theUtil.eq0(axisAngle4d.y, 1.0E-9) && !theUtil.eq0(axisAngle4d.z, 1.0E-9);
    }

    public static AxisAngle4d getRotation(Matrix4d matrix4d) {
        AxisAngle4d axisAngle4d = new AxisAngle4d();
        axisAngle4d.set(matrix4d);
        if (axisAngle4d.x == 0.0 && axisAngle4d.y == 1.0 && axisAngle4d.z == 0.0 && axisAngle4d.angle == 0.0) {
            double d = Math.signum(matrix4d.m00);
            double d2 = Math.signum(matrix4d.m11);
            double d3 = Math.signum(matrix4d.m22);
            if (d != 0.0 && d2 != 0.0 && d3 != 0.0 && theUtil.eq0(matrix4d.m01, 1.0E-12) && theUtil.eq0(matrix4d.m10, 1.0E-12) && theUtil.eq0(matrix4d.m20, 1.0E-12) && theUtil.eq0(matrix4d.m02, 1.0E-12) && theUtil.eq0(matrix4d.m21, 1.0E-12) && theUtil.eq0(matrix4d.m12, 1.0E-12)) {
                if (d != d2 && d2 == d3) {
                    axisAngle4d.set(1.0, 0.0, 0.0, Math.PI);
                } else if (d != d2 && d == d3) {
                    axisAngle4d.set(0.0, 1.0, 0.0, Math.PI);
                } else if (d == d2 && d2 != d3) {
                    axisAngle4d.set(0.0, 0.0, 1.0, Math.PI);
                } else {
                    axisAngle4d.set(0.0, 0.0, 1.0, 0.0);
                }
            } else {
                return null;
            }
        }
        return axisAngle4d;
    }

    public static Point3d[] xformVerts(Point3d[] point3dArray, Matrix4d matrix4d) {
        Point3d[] point3dArray2 = new Point3d[point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            point3dArray2[i] = Util3D.xform(matrix4d, point3dArray[i]);
        }
        return point3dArray2;
    }

    public static Vector3d getClosestAxis(Vector3d vector3d) {
        double d = 0.0;
        int n = -1;
        Vector3d[] vector3dArray = new Vector3d[]{GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS};
        for (int i = 0; i < vector3dArray.length; ++i) {
            double d2 = vector3d.dot(vector3dArray[i]);
            if (!(Math.abs(d2) > Math.abs(d))) continue;
            d = d2;
            n = i;
        }
        if (n == -1) {
            return GeomConstants.VEC3D_XNEG;
        }
        if (d < 0.0) {
            switch (n) {
                case 0: {
                    return GeomConstants.VEC3D_XNEG;
                }
                case 1: {
                    return GeomConstants.VEC3D_YNEG;
                }
                case 2: {
                    return GeomConstants.VEC3D_ZNEG;
                }
            }
        }
        return vector3dArray[n];
    }

    public static List<LineSeg> getLineSegs(double d, ICurve ... iCurveArray) {
        return GeomUtil.getLineSegs(d, Arrays.asList(iCurveArray));
    }

    public static List<LineSeg> getLineSegs(double d, Collection<? extends ICurve> collection) {
        ArrayList<LineSeg> arrayList = new ArrayList<LineSeg>();
        for (ICurve iCurve : collection) {
            Mesh mesh = iCurve.getSegments(d);
            int n = 0;
            while (n < mesh.indices.length) {
                Point3d point3d = mesh.vertices[mesh.indices[n++]];
                Point3d point3d2 = mesh.vertices[mesh.indices[n++]];
                arrayList.add(new LineSeg(point3d, point3d2));
            }
        }
        return arrayList;
    }

    public static List<LineSeg> convertToLineSegs(double d, IGeom iGeom) {
        return GeomUtil.convertToLineSegs(d, Arrays.asList(iGeom));
    }

    public static List<LineSeg> convertToLineSegs(double d, Collection<? extends IGeom> collection) {
        List<IPrimitive> list = GeomUtil.explodeToTypes(collection, 2);
        return GeomUtil.getLineSegs(d, new FilteredCollection<ICurve>(list, ICurve.class));
    }

    public static List<Triangle> convertToTriangles(double d, IGeom iGeom) {
        return GeomUtil.convertToTriangles(d, Arrays.asList(iGeom));
    }

    public static List<Triangle> convertToTriangles(double d, Collection<? extends IGeom> collection) {
        List<IPrimitive> list = GeomUtil.explodeToTypes(collection, 1);
        return GeomUtil.getTriangles(d, new FilteredCollection<IFace>(list, IFace.class));
    }

    public static List<Triangle> getTriangles(double d, IFace ... iFaceArray) {
        return GeomUtil.getTriangles(d, Arrays.asList(iFaceArray));
    }

    public static List<Triangle> getTriangles(double d, Collection<? extends IFace> collection) {
        ArrayList<Triangle> arrayList = new ArrayList<Triangle>();
        for (IFace iFace : collection) {
            Mesh mesh = iFace.triangulate(d);
            int n = 0;
            while (n < mesh.indices.length) {
                Point3d point3d = mesh.vertices[mesh.indices[n++]];
                Point3d point3d2 = mesh.vertices[mesh.indices[n++]];
                Point3d point3d3 = mesh.vertices[mesh.indices[n++]];
                arrayList.add(new Triangle(point3d, point3d2, point3d3));
            }
        }
        return arrayList;
    }

    public static IGeom group(IGeom ... iGeomArray) {
        if (iGeomArray.length == 0) {
            return EmptyGeom.INSTANCE;
        }
        if (iGeomArray.length == 1) {
            return iGeomArray[0];
        }
        return new GeomGroup(Arrays.asList(iGeomArray));
    }

    public static IGeom group(Collection<? extends IGeom> collection) {
        if (collection.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        return new GeomGroup(collection);
    }

    public static IGeom filter(IGeom iGeom, int n) {
        List<IPrimitive> list = GeomUtil.explodeToTypes(iGeom, n);
        return GeomUtil.group(list);
    }

    public static IDOF groupDOFs(Collection<? extends IDOF> collection) {
        Set<Object> set;
        Set<Object> set2 = set = collection instanceof Set ? (Set<Object>)collection : new HashSet<IDOF>(collection);
        if (set.isEmpty()) {
            return IDOF.FREE;
        }
        if (set.size() == 1) {
            return (IDOF)set.iterator().next();
        }
        return new IDOF.CompositeDOF((Set<? extends IDOF>)set);
    }
}

