/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.util.theUtil;

public class GeomGroup
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public final List<IGeom> children;

    public GeomGroup(Collection<? extends IGeom> collection) {
        this.children = new ArrayList<IGeom>(collection);
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        if (this.children.isEmpty()) {
            return EmptyGeom.INSTANCE;
        }
        Predicate<IGeom> predicate = iGeom -> legacyDictionary_2012_1.get((ILegacy_2012_1)iGeom) instanceof thunderheadeng.geometry.objs.IGeom;
        Function<IGeom, thunderheadeng.geometry.objs.IGeom> function = iGeom -> (thunderheadeng.geometry.objs.IGeom)legacyDictionary_2012_1.get((ILegacy_2012_1)iGeom);
        if (this.children.stream().allMatch(predicate)) {
            return new thunderheadeng.geometry.objs.GeomGroup(theUtil.map(this.children, function));
        }
        ArrayList<IGeomNode> arrayList = new ArrayList<IGeomNode>();
        int n = 0;
        while (n < this.children.size()) {
            Object object = legacyDictionary_2012_1.get(this.children.get(n));
            if (object instanceof thunderheadeng.geometry.objs.IGeom) {
                int n2 = theUtil.getMatchCount(this.children.subList(n, this.children.size()), predicate);
                ArrayList<thunderheadeng.geometry.objs.IGeom> arrayList2 = new ArrayList<thunderheadeng.geometry.objs.IGeom>();
                int n3 = n + n2;
                for (int i = n; i < n3; ++i) {
                    arrayList2.add(function.apply(this.children.get(i)));
                }
                arrayList.add(GeomNodeUtil.newNode(thunderheadeng.geometry.objs.GeomUtil.group(arrayList2)));
                n += n2;
                continue;
            }
            arrayList.add((IGeomNode)object);
            ++n;
        }
        return GeomNodeUtil.newNode(arrayList).prune();
    }

    @Override
    public GeomGroup optimize(IPointOptimizer iPointOptimizer) {
        boolean bl = false;
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>(this.children.size());
        for (int i = 0; i < this.children.size(); ++i) {
            IGeom iGeom = this.children.get(i);
            IGeom iGeom2 = iGeom.optimize(iPointOptimizer);
            arrayList.add(iGeom2);
            bl |= iGeom != iGeom2;
        }
        return bl ? new GeomGroup(arrayList) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).getBoundingBox(aABox);
        }
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        LinkedHashSet<IDOF> linkedHashSet = new LinkedHashSet<IDOF>();
        for (IGeom iGeom : this.children) {
            linkedHashSet.add(iGeom.getDOF());
        }
        return GeomUtil.groupDOFs(linkedHashSet);
    }

    @Override
    public IGeom transform(Matrix4d matrix4d, IGeom.XformOp xformOp) {
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>(this.children.size());
        for (IGeom iGeom : this.children) {
            arrayList.add(iGeom.transform(matrix4d, xformOp));
        }
        return new GeomGroup(arrayList);
    }

    @Override
    public boolean canExplode() {
        return !this.children.isEmpty();
    }

    @Override
    public int getNumPrims(int n) {
        int n2 = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            n2 += this.children.get(i).getNumPrims(n);
        }
        return n2;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        collection.addAll(this.children);
        return collection;
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d matrix4d) {
        return false;
    }

    @Override
    public boolean isShell() {
        if (this.children.isEmpty()) {
            return true;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).isShell()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        for (IGeom iGeom : this.children) {
            if (!iGeom.intersectsBox(object, iIsectFilter, convexHull)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        AABox aABox = new AABox();
        for (IGeom iGeom : this.children) {
            iIsectCollector.getProgress().check();
            aABox.reset();
            iGeom.getBoundingBox(aABox);
            if (!iTest.test((AABox)aABox).positive) continue;
            iGeom.pickPoints(iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
        }
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        AABox aABox = new AABox();
        for (IGeom iGeom : this.children) {
            aABox.reset();
            iGeom.getBoundingBox(aABox);
            if (!iTest.test((AABox)aABox).positive) continue;
            iGeom.find(iTest, iResult);
        }
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        for (IGeom iGeom : this.children) {
            iGeom.getAll(iResult);
        }
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        if (this.children.size() > 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Handle> arrayList = new ArrayList<Handle>();
        for (int i = 0; i < this.children.size(); ++i) {
            IGeom iGeom = this.children.get(i);
            if (!(iGeom instanceof IManipulatable)) continue;
            for (IHandle iHandle : ((IManipulatable)((Object)iGeom)).generateManipHandles()) {
                arrayList.add(new Handle(this, i, iHandle));
            }
        }
        return arrayList;
    }

    private static class Handle
    implements IHandle {
        private GeomGroup d_geom;
        private final int d_ix;
        private final IHandle d_handle;
        private List<IGeom> t_children;

        public Handle(GeomGroup geomGroup, int n, IHandle iHandle) {
            this.d_geom = geomGroup;
            this.d_ix = n;
            this.d_handle = iHandle;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle && ((Handle)object).d_ix == this.d_ix && ((Handle)object).d_handle.equals(this.d_handle);
        }

        @Override
        public IGeom getGeom() {
            return this.d_handle.getGeom();
        }

        @Override
        public IIsectFilter getPickFilter() {
            return this.d_handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return this.d_handle.getConstraint(point3d);
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.t_children = new ArrayList<IGeom>(this.d_geom.children);
            this.d_handle.begin(point3d, iSnapConstraint);
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            Object object = this.d_handle.modify(point3d);
            this.d_geom = this.modify(object);
            return this.d_geom;
        }

        @Override
        public Object end() {
            this.d_geom = this.modify(this.d_handle.end());
            this.t_children = null;
            return this.d_geom;
        }

        private GeomGroup modify(Object object) {
            if (object instanceof IGeom) {
                this.t_children.set(this.d_ix, (IGeom)object);
                return new GeomGroup(this.t_children);
            }
            return this.d_geom;
        }
    }
}

