/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.MeshBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.TriangulatorInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NullOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;

public class GeneralPoly
extends AFace
implements IPolygon,
IManipulatable {
    static final long serialVersionUID = 1L;
    public final Point3d[] points;
    public final int[] loopOffsets;

    public GeneralPoly(Collection<Point3d> collection, int ... nArray) {
        this(collection.toArray(new Point3d[collection.size()]), nArray);
    }

    public GeneralPoly(Point3d[] point3dArray, int ... nArray) {
        assert (point3dArray.length >= 3);
        assert (GeneralPoly.checkLoopOffsets(point3dArray, nArray));
        this.points = point3dArray;
        this.loopOffsets = nArray;
    }

    public GeneralPoly(Point3d[][] point3dArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < point3dArray.length; ++n) {
            n2 += point3dArray[n].length;
        }
        this.points = new Point3d[n2];
        n = 0;
        this.loopOffsets = new int[point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            this.loopOffsets[i] = n;
            Point3d[] point3dArray2 = point3dArray[i];
            for (int j = 0; j < point3dArray2.length; ++j) {
                this.points[n + j] = point3dArray2[j];
            }
            n += point3dArray[i].length;
        }
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.GeneralPoly(this.points, this.loopOffsets);
    }

    public static boolean checkLoopOffsets(Point3d[] point3dArray, int ... nArray) {
        for (int n : nArray) {
            if (n >= 0 && n < point3dArray.length) continue;
            return false;
        }
        return true;
    }

    @Override
    public GeneralPoly optimize(IPointOptimizer iPointOptimizer) {
        if (iPointOptimizer instanceof NullOptimizer) {
            return this;
        }
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            point3dArray[i] = iPointOptimizer.getExisting(this.points[i]);
            bl |= point3dArray[i] != this.points[i];
        }
        return bl ? new GeneralPoly(point3dArray, this.loopOffsets) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(this.points);
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public GeneralPoly transform(Matrix4d matrix4d) {
        Point3d[] point3dArray = GeomUtil.xformVerts(this.points, matrix4d);
        return new GeneralPoly(point3dArray, this.loopOffsets);
    }

    @Override
    public int getNumLoops() {
        return this.loopOffsets.length;
    }

    @Override
    public int getNumPoints(int n) {
        assert (n >= 0 && n < this.loopOffsets.length);
        if (n == this.loopOffsets.length - 1) {
            return this.points.length - this.loopOffsets[n];
        }
        return this.loopOffsets[n + 1] - this.loopOffsets[n];
    }

    @Override
    public Point3d getPoint(int n, int n2) {
        assert (n >= 0 && n < this.loopOffsets.length);
        return this.points[this.loopOffsets[n] + n2];
    }

    @Override
    public Vector3d getNormal() {
        Point3d[] point3dArray = this.loopOffsets.length <= 1 ? this.points : Arrays.copyOf(this.points, this.loopOffsets[1]);
        Vector3d vector3d = Util3D.simplePolygonNormal(Arrays.asList(point3dArray), 1.0E-6);
        return vector3d == null ? GeomConstants.VEC3D_ZERO : vector3d;
    }

    @Override
    public void getBoundary(List<ICurve> list) {
        PolyUtil.getBoundary(list, this);
    }

    @Override
    public Mesh triangulate(double d) {
        int n;
        Object object;
        int n2;
        HashMap<Point2d, Point3d> hashMap = new HashMap<Point2d, Point3d>();
        Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(this.points), 1.0E-6);
        if (plane3d == null) {
            return null;
        }
        Matrix4d matrix4d = Util.getWorldToLocalXform(plane3d);
        Matrix4d matrix4d2 = Util.getLocalToWorldXform(plane3d);
        Point2d[] point2dArray = new Point2d[this.points.length];
        MeshBuilder meshBuilder = new MeshBuilder(1.0E-6);
        for (n2 = 0; n2 < this.points.length; ++n2) {
            Point2d point2d = Util3D.xform2d(matrix4d, this.points[n2]);
            hashMap.put(point2d, this.points[n2]);
            point2dArray[n2] = point2d;
        }
        for (n2 = 0; n2 < this.loopOffsets.length; ++n2) {
            int n3 = this.getNumPoints(n2);
            int n4 = this.loopOffsets[n2];
            for (int i = 0; i < n3; ++i) {
                object = point2dArray[n4 + i];
                Point2d point2d = point2dArray[n4 + (i + 1) % n3];
                meshBuilder.addEdge((Point2d)object, point2d);
            }
        }
        pyrosim.legacy_2012_1.thunderheadeng.delaunay.Mesh mesh = meshBuilder.build();
        boolean bl = mesh.triangulateEvenOdd(0, 0.0);
        if (!bl) {
            return null;
        }
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        TriangulatorInfo triangulatorInfo = mesh.getOutput();
        object = new int[triangulatorInfo.points.length];
        for (n = 0; n < triangulatorInfo.points.length; ++n) {
            Integer n5;
            Point2d point2d = triangulatorInfo.points[n];
            Point3d point3d = (Point3d)hashMap.get(point2d);
            if (point3d == null) {
                point3d = Util3D.xform(matrix4d2, new Point3d(point2d.x, point2d.y, 0.0));
            }
            if ((n5 = (Integer)linkedHashMap.get(point3d)) == null) {
                n5 = linkedHashMap.size();
                linkedHashMap.put(point3d, n5);
            }
            object[n] = n5;
        }
        for (n = 0; n < triangulatorInfo.triangles.length; ++n) {
            triangulatorInfo.triangles[n] = (int)object[triangulatorInfo.triangles[n]];
        }
        return new Mesh(linkedHashMap.keySet().toArray(new Point3d[linkedHashMap.size()]), triangulatorInfo.triangles, 2);
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        return PolyUtil.intersectsBox(object, this, iIsectFilter, convexHull);
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        PolyUtil.pickPoints(this, iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public Point3d project(Point3d point3d) {
        return PolyUtil.getPlane(this).projectOntoPlane(point3d);
    }

    @Override
    public IFace.PointClassify classify(Point3d point3d, double d) {
        return PolyUtil.classify(this, point3d, d);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return PolyUtil.generateManipHandles(this);
    }
}

