/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.APlaneHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ICurve;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.PlanarConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class AARectangle
extends AFace
implements IPolygon,
IManipulatable {
    static final long serialVersionUID = 1L;
    public static final byte X = 0;
    public static final byte Y = 1;
    public static final byte Z = 2;
    public final byte d_plane;
    public final double d_planeVal;
    public final double d_minx;
    public final double d_miny;
    public final double d_maxx;
    public final double d_maxy;

    public AARectangle() {
        this(2, 0.0, 0.0, 0.0, 1.0, 1.0);
    }

    public AARectangle(byte by, double d, double d2, double d3, double d4, double d5) {
        this.d_minx = d2;
        this.d_miny = d3;
        this.d_maxx = d4;
        this.d_maxy = d5;
        this.d_plane = by;
        this.d_planeVal = d;
    }

    @Override
    public thunderheadeng.geometry.objs.AARectangle fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.AARectangle(this.d_plane, this.d_planeVal, this.d_minx, this.d_miny, this.d_maxx, this.d_maxy, false);
    }

    @Override
    public IPolygon optimize(IPointOptimizer iPointOptimizer) {
        return this;
    }

    public static AARectangle construct(Point3d point3d, Point3d point3d2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        byte by;
        if (theUtil.eq(point3d.x, point3d2.x, 1.0E-9)) {
            by = 0;
            d5 = point3d.x;
            d4 = Math.min(point3d.y, point3d2.y);
            d3 = Math.max(point3d.y, point3d2.y);
            d2 = Math.min(point3d.z, point3d2.z);
            d = Math.max(point3d.z, point3d2.z);
        } else if (theUtil.eq(point3d.y, point3d2.y, 1.0E-9)) {
            by = 1;
            d5 = point3d.y;
            d4 = Math.min(point3d.x, point3d2.x);
            d3 = Math.max(point3d.x, point3d2.x);
            d2 = Math.min(point3d.z, point3d2.z);
            d = Math.max(point3d.z, point3d2.z);
        } else if (theUtil.eq(point3d.z, point3d2.z, 1.0E-9)) {
            by = 2;
            d5 = point3d.z;
            d4 = Math.min(point3d.x, point3d2.x);
            d3 = Math.max(point3d.x, point3d2.x);
            d2 = Math.min(point3d.y, point3d2.y);
            d = Math.max(point3d.y, point3d2.y);
        } else {
            return null;
        }
        return new AARectangle(by, d5, d4, d2, d3, d);
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        switch (this.d_plane) {
            case 0: {
                aABox.addPoint(this.d_planeVal, this.d_minx, this.d_miny);
                aABox.addPoint(this.d_planeVal, this.d_maxx, this.d_maxy);
                break;
            }
            case 1: {
                aABox.addPoint(this.d_minx, this.d_planeVal, this.d_miny);
                aABox.addPoint(this.d_maxx, this.d_planeVal, this.d_maxy);
                break;
            }
            case 2: {
                aABox.addPoint(this.d_minx, this.d_miny, this.d_planeVal);
                aABox.addPoint(this.d_maxx, this.d_maxy, this.d_planeVal);
            }
        }
        return aABox;
    }

    @Override
    public void getBoundary(List<ICurve> list) {
        PolyUtil.getBoundary(list, this);
    }

    public Point2d getMin() {
        return new Point2d(this.d_minx, this.d_miny);
    }

    public Point2d getMax() {
        return new Point2d(this.d_maxx, this.d_maxy);
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    private AARectangle transformAligned(Matrix4d matrix4d) {
        AABox aABox = this.getBoundingBox(new AABox());
        Point3d point3d = Util3D.xform(matrix4d, aABox.getMin());
        Point3d point3d2 = Util3D.xform(matrix4d, aABox.getMax());
        return AARectangle.construct(point3d, point3d2);
    }

    @Override
    public IPolygon transform(Matrix4d matrix4d) {
        if (IDOF.ALIGNED.accept(matrix4d)) {
            return this.transformAligned(matrix4d);
        }
        return this.toQuad(matrix4d);
    }

    @Override
    public IGeom transform(Matrix4d matrix4d, IGeom.XformOp xformOp) {
        if (IDOF.ALIGNED.accept(matrix4d)) {
            return this.transformAligned(matrix4d);
        }
        switch (xformOp) {
            case RETAINED: {
                return new TransformedGeom(matrix4d, this);
            }
        }
        return this.toQuad(matrix4d);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AARectangle)) {
            return false;
        }
        AARectangle aARectangle = (AARectangle)object;
        return this.d_plane == aARectangle.d_plane && this.d_planeVal == aARectangle.d_planeVal && this.getMin().equals(aARectangle.getMin()) && this.getMax().equals(aARectangle.getMax());
    }

    public int hashCode() {
        return this.d_plane + theUtil.hashCode(this.d_planeVal) + this.getMin().hashCode() + this.getMax().hashCode();
    }

    public Quad toQuad(Matrix4d matrix4d) {
        Point3d point3d;
        Point3d point3d2;
        Point3d point3d3;
        Point3d point3d4;
        switch (this.d_plane) {
            case 0: {
                point3d4 = new Point3d(this.d_planeVal, this.d_minx, this.d_miny);
                point3d3 = new Point3d(this.d_planeVal, this.d_maxx, this.d_miny);
                point3d2 = new Point3d(this.d_planeVal, this.d_maxx, this.d_maxy);
                point3d = new Point3d(this.d_planeVal, this.d_minx, this.d_maxy);
                break;
            }
            case 1: {
                point3d4 = new Point3d(this.d_minx, this.d_planeVal, this.d_miny);
                point3d3 = new Point3d(this.d_maxx, this.d_planeVal, this.d_miny);
                point3d2 = new Point3d(this.d_maxx, this.d_planeVal, this.d_maxy);
                point3d = new Point3d(this.d_minx, this.d_planeVal, this.d_maxy);
                break;
            }
            default: {
                point3d4 = new Point3d(this.d_minx, this.d_miny, this.d_planeVal);
                point3d3 = new Point3d(this.d_maxx, this.d_miny, this.d_planeVal);
                point3d2 = new Point3d(this.d_maxx, this.d_maxy, this.d_planeVal);
                point3d = new Point3d(this.d_minx, this.d_maxy, this.d_planeVal);
            }
        }
        if (matrix4d != null) {
            matrix4d.transform(point3d4);
            matrix4d.transform(point3d3);
            matrix4d.transform(point3d2);
            matrix4d.transform(point3d);
        }
        return new Quad(point3d4, point3d3, point3d2, point3d);
    }

    @Override
    public Vector3d getNormal() {
        switch (this.d_plane) {
            case 0: {
                return new Vector3d(1.0, 0.0, 0.0);
            }
            case 1: {
                return new Vector3d(0.0, 1.0, 0.0);
            }
        }
        return new Vector3d(0.0, 0.0, 1.0);
    }

    @Override
    public int getNumLoops() {
        return 1;
    }

    @Override
    public int getNumPoints(int n) {
        assert (n == 0);
        return 4;
    }

    @Override
    public Point3d getPoint(int n, int n2) {
        assert (n2 < 4 && n == 0);
        switch (this.d_plane) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return new Point3d(this.d_planeVal, this.d_minx, this.d_miny);
                    }
                    case 1: {
                        return new Point3d(this.d_planeVal, this.d_maxx, this.d_miny);
                    }
                    case 2: {
                        return new Point3d(this.d_planeVal, this.d_maxx, this.d_maxy);
                    }
                }
                return new Point3d(this.d_planeVal, this.d_minx, this.d_maxy);
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return new Point3d(this.d_minx, this.d_planeVal, this.d_miny);
                    }
                    case 1: {
                        return new Point3d(this.d_minx, this.d_planeVal, this.d_maxy);
                    }
                    case 2: {
                        return new Point3d(this.d_maxx, this.d_planeVal, this.d_maxy);
                    }
                }
                return new Point3d(this.d_maxx, this.d_planeVal, this.d_miny);
            }
        }
        switch (n2) {
            case 0: {
                return new Point3d(this.d_minx, this.d_miny, this.d_planeVal);
            }
            case 1: {
                return new Point3d(this.d_maxx, this.d_miny, this.d_planeVal);
            }
            case 2: {
                return new Point3d(this.d_maxx, this.d_maxy, this.d_planeVal);
            }
        }
        return new Point3d(this.d_minx, this.d_maxy, this.d_planeVal);
    }

    @Override
    public Mesh triangulate(double d) {
        return this.toQuad(null).triangulate(d);
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        return PolyUtil.intersectsBox(object, this, iIsectFilter, convexHull);
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        PolyUtil.pickPoints(this, iIsectCollector, iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public Point3d project(Point3d point3d) {
        return this.getPlane().projectOntoPlane(point3d);
    }

    @Override
    public IFace.PointClassify classify(Point3d point3d, double d) {
        switch (this.d_plane) {
            case 0: {
                return AARectangle.classify(point3d.y, point3d.z, this.d_minx, this.d_maxx, this.d_miny, this.d_maxy, d);
            }
            case 1: {
                return AARectangle.classify(point3d.x, point3d.z, this.d_minx, this.d_maxx, this.d_miny, this.d_maxy, d);
            }
        }
        return AARectangle.classify(point3d.x, point3d.y, this.d_minx, this.d_maxx, this.d_miny, this.d_maxy, d);
    }

    private static IFace.PointClassify classify(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (theUtil.ge(d, d3, d7) && theUtil.le(d, d4, d7) && theUtil.ge(d2, d5, d7) && theUtil.le(d2, d6, d7)) {
            if (theUtil.eq(d, d3, d7) || theUtil.eq(d, d4, d7) || theUtil.eq(d2, d5, d7) || theUtil.eq(d2, d6, d7)) {
                return IFace.PointClassify.ON_BOUNDARY;
            }
            return IFace.PointClassify.INSIDE;
        }
        return IFace.PointClassify.OUTSIDE;
    }

    public Plane3d getPlane() {
        switch (this.d_plane) {
            case 0: {
                return new Plane3d(1.0, 0.0, 0.0, -this.d_planeVal);
            }
            case 1: {
                return new Plane3d(0.0, 1.0, 0.0, -this.d_planeVal);
            }
            case 2: {
                return new Plane3d(0.0, 0.0, 1.0, -this.d_planeVal);
            }
        }
        return null;
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new VertHandle(this, 0, 1), new VertHandle(this, 0, 3), new VertHandle(this, 2, 1), new VertHandle(this, 2, 3), new PlaneHandle(this));
    }

    public static class VertHandle
    implements IHandle {
        public static final int MIN_X = 0;
        public static final int MIN_Y = 1;
        public static final int MAX_X = 2;
        public static final int MAX_Y = 3;
        private AARectangle geom;
        private final double[] bounds;
        private final int[] coords;

        public VertHandle(AARectangle aARectangle, int n, int n2) {
            this.geom = aARectangle;
            double[] dArray = new double[]{-1.7976931348623157E308, -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE};
            this.bounds = VertHandle.getCoords(aARectangle);
            this.bounds[n] = dArray[n];
            this.bounds[n2] = dArray[n2];
            this.coords = new int[]{n, n2};
        }

        public boolean equals(Object object) {
            return object == this || object instanceof VertHandle && Arrays.equals(((VertHandle)object).coords, this.coords);
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        private static double[] getCoords(AARectangle aARectangle) {
            return new double[]{aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy};
        }

        @Override
        public IGeom getGeom() {
            return new Point(this.getLocation());
        }

        protected Point3d getLocation() {
            double[] dArray = VertHandle.getCoords(this.geom);
            double d = dArray[this.coords[0]];
            double d2 = dArray[this.coords[1]];
            double d3 = this.geom.d_planeVal;
            switch (this.geom.d_plane) {
                case 0: {
                    return new Point3d(d3, d, d2);
                }
                case 1: {
                    return new Point3d(d, d3, d2);
                }
                case 2: {
                    return new Point3d(d, d2, d3);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return new PlanarConstraint(this.geom.getPlane());
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
        }

        @Override
        public AARectangle modify(Point3d point3d) throws Exception {
            double d;
            double d2;
            switch (this.geom.d_plane) {
                case 0: {
                    d2 = point3d.y;
                    d = point3d.z;
                    break;
                }
                case 1: {
                    d2 = point3d.x;
                    d = point3d.z;
                    break;
                }
                case 2: {
                    d2 = point3d.x;
                    d = point3d.y;
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
            if (d2 < this.bounds[0]) {
                d2 = this.bounds[0];
            } else if (d2 > this.bounds[2]) {
                d2 = this.bounds[2];
            }
            if (d < this.bounds[1]) {
                d = this.bounds[1];
            } else if (d > this.bounds[3]) {
                d = this.bounds[3];
            }
            double[] dArray = VertHandle.getCoords(this.geom);
            dArray[this.coords[0]] = d2;
            dArray[this.coords[1]] = d;
            this.geom = new AARectangle(this.geom.d_plane, this.geom.d_planeVal, dArray[0], dArray[1], dArray[2], dArray[3]);
            return this.geom;
        }

        @Override
        public Object end() {
            return this.geom;
        }
    }

    public static class PlaneHandle
    extends APlaneHandle<AARectangle> {
        public PlaneHandle(AARectangle aARectangle) {
            super(aARectangle);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && object instanceof PlaneHandle;
        }

        @Override
        public IGeom getGeom() {
            return (IGeom)this.getManipGeom();
        }

        @Override
        protected Vector3d getPlaneNormal(AARectangle aARectangle) {
            return aARectangle.getPlane().getNormal();
        }

        @Override
        protected AARectangle modify(AARectangle aARectangle, double d) {
            return new AARectangle(aARectangle.d_plane, aARectangle.d_planeVal + d, aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy);
        }
    }
}

