/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.objs;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.APlaneHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IManipulatable;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPrimitive;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.GeomType;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;

public class AABoxGeom
implements IGeom,
IManipulatable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_X = 0;
    public static final int MAX_X = 1;
    public static final int MIN_Y = 2;
    public static final int MAX_Y = 3;
    public static final int MIN_Z = 4;
    public static final int MAX_Z = 5;
    private static final short NATURAL_SWIZZLE = AABoxGeom.encodeSwzl(0, 2, 4);
    private static final int[] NATURAL_ORDER = new int[]{0, 1, 2, 3, 4, 5};
    public final Point3d min;
    public final Point3d max;
    public final short swizzle;
    private static final int[][] s_faces = new int[][]{{2, 0, 1, 3}, {4, 6, 7, 5}, {0, 4, 5, 1}, {6, 2, 3, 7}, {0, 2, 6, 4}, {5, 7, 3, 1}};
    private static final int[][] s_edgeTests = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}};

    public AABoxGeom(AABox aABox) {
        this(aABox.getMin(), aABox.getMax(), 0);
    }

    public AABoxGeom(Point3d point3d, Point3d point3d2, int n) {
        this.min = point3d;
        this.max = point3d2;
        this.swizzle = n == 0 ? NATURAL_SWIZZLE : (short)n;
    }

    private static short encodeSwzl(int n, int n2, int n3) {
        return (short)(n | n2 << 4 | n3 << 8);
    }

    private static int[] decodeSwzl(short s) {
        return new int[]{s & 0xF, (s & 0xF0) >> 4, (s & 0xF00) >> 8};
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.objs.AABoxGeom(this.min, this.max, this.swizzle);
    }

    public int hashCode() {
        return 4739 + this.min.hashCode() + this.max.hashCode() + this.swizzle;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof AABoxGeom && ((AABoxGeom)object).min.equals(this.min) && ((AABoxGeom)object).max.equals(this.max) && ((AABoxGeom)object).swizzle == this.swizzle;
    }

    public boolean isNaturallyOrdered() {
        return this.swizzle == NATURAL_SWIZZLE;
    }

    public int[] getIndexToNameFaceOrder() {
        if (this.isNaturallyOrdered()) {
            return NATURAL_ORDER;
        }
        int[] nArray = AABoxGeom.decodeSwzl(this.swizzle);
        int n = nArray[0];
        int n2 = AABoxGeom.oppositeix(n);
        int n3 = nArray[1];
        int n4 = AABoxGeom.oppositeix(n3);
        int n5 = nArray[2];
        int n6 = AABoxGeom.oppositeix(n5);
        int[] nArray2 = new int[]{n, n2, n3, n4, n5, n6};
        return nArray2;
    }

    public int[] getNameToIndexFaceOrder() {
        if (this.isNaturallyOrdered()) {
            return NATURAL_ORDER;
        }
        int[] nArray = AABoxGeom.decodeSwzl(this.swizzle);
        int n = nArray[0];
        int n2 = AABoxGeom.oppositeix(n);
        int n3 = nArray[1];
        int n4 = AABoxGeom.oppositeix(n3);
        int n5 = nArray[2];
        int n6 = AABoxGeom.oppositeix(n5);
        int[] nArray2 = new int[6];
        nArray2[n] = 0;
        nArray2[n2] = 1;
        nArray2[n3] = 2;
        nArray2[n4] = 3;
        nArray2[n5] = 4;
        nArray2[n6] = 5;
        return nArray2;
    }

    @Override
    public AABoxGeom optimize(IPointOptimizer iPointOptimizer) {
        Point3d point3d = iPointOptimizer.getExisting(this.min);
        Point3d point3d2 = iPointOptimizer.getExisting(this.max);
        return point3d != this.min || point3d2 != this.max ? new AABoxGeom(point3d, point3d2, this.swizzle) : this;
    }

    @Override
    public AABox getBoundingBox(AABox aABox) {
        aABox.add(new AABox(this.min, this.max));
        return aABox;
    }

    @Override
    public IDOF getDOF() {
        return IDOF.FREE;
    }

    @Override
    public IGeom transform(Matrix4d matrix4d, IGeom.XformOp xformOp) {
        if (IDOF.ALIGNED.accept(matrix4d)) {
            int n;
            Point3d point3d = Util3D.xform(matrix4d, this.min);
            Point3d point3d2 = Util3D.xform(matrix4d, this.max);
            Util3D.rectify(point3d, point3d2);
            Vector3d[] vector3dArray = this.getMinVecs();
            for (n = 0; n < vector3dArray.length; ++n) {
                vector3dArray[n] = Util3D.xform(matrix4d, vector3dArray[n]);
                if (vector3dArray[n].lengthSquared() == 0.0) continue;
                vector3dArray[n].normalize();
            }
            n = this.getAxis(vector3dArray[0]);
            int n2 = this.getAxis(vector3dArray[1]);
            int n3 = this.getAxis(vector3dArray[2]);
            short s = AABoxGeom.encodeSwzl(n, n2, n3);
            return new AABoxGeom(point3d, point3d2, s);
        }
        switch (xformOp) {
            case RETAINED: {
                return new TransformedGeom(matrix4d, this);
            }
        }
        return this.toMesh(matrix4d);
    }

    private int getAxis(Vector3d vector3d) {
        Vector3d vector3d2 = GeomUtil.getClosestAxis(vector3d);
        for (int i = 0; i < GeomUtil.AXIS_VECS.length; ++i) {
            if (!vector3d2.equals(GeomUtil.AXIS_VECS[i])) continue;
            return i;
        }
        return 0;
    }

    private Vector3d[] getMinVecs() {
        int[] nArray = AABoxGeom.decodeSwzl(this.swizzle);
        Vector3d[] vector3dArray = new Vector3d[3];
        for (int i = 0; i < 3; ++i) {
            vector3dArray[i] = GeomUtil.AXIS_VECS[nArray[i]];
        }
        return vector3dArray;
    }

    @Override
    public boolean isAxisAlignedBlock(Matrix4d matrix4d) {
        return matrix4d == null || GeomConstants.IDENTITY4d.equals(matrix4d);
    }

    @Override
    public boolean isShell() {
        return Boolean.FALSE;
    }

    @Override
    public boolean canExplode() {
        return true;
    }

    @Override
    public int getNumPrims(int n) {
        return (n & 1) != 0 ? 6 : 0;
    }

    @Override
    public Collection<IGeom> explode(Collection<IGeom> collection) {
        collection.add(this.toMesh(null));
        return collection;
    }

    private Mesh toMesh(Matrix4d matrix4d) {
        Point3d[] point3dArray = new Point3d[]{this.min, new Point3d(this.min.x, this.min.y, this.max.z), new Point3d(this.min.x, this.max.y, this.min.z), new Point3d(this.min.x, this.max.y, this.max.z), new Point3d(this.max.x, this.min.y, this.min.z), new Point3d(this.max.x, this.min.y, this.max.z), new Point3d(this.max.x, this.max.y, this.min.z), this.max};
        if (matrix4d != null) {
            for (int i = 1; i < 7; ++i) {
                matrix4d.transform(point3dArray[i]);
            }
            point3dArray[0] = Util3D.xform(matrix4d, point3dArray[0]);
            point3dArray[7] = Util3D.xform(matrix4d, point3dArray[7]);
        }
        int[] nArray = this.getIndexToNameFaceOrder();
        int[] nArray2 = new int[24];
        for (int i = 0; i < 6; ++i) {
            AABoxGeom.setFaces(nArray2, i, s_faces[nArray[i]]);
        }
        return new Mesh(point3dArray, nArray2, 3, 4);
    }

    private static int oppositeix(int n) {
        if (n % 2 == 0) {
            return n + 1;
        }
        return n - 1;
    }

    private static void setFaces(int[] nArray, int n, int[] nArray2) {
        int n2 = n * 4;
        nArray[n2 + 0] = nArray2[0];
        nArray[n2 + 1] = nArray2[1];
        nArray[n2 + 2] = nArray2[2];
        nArray[n2 + 3] = nArray2[3];
    }

    @Override
    public boolean intersectsBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        block4: {
            block5: {
                block3: {
                    if (!iIsectFilter.acceptGeomType(object, GeomType.FACE)) break block3;
                    if (convexHull.test((AABox)new AABox((Point3d)this.min, (Point3d)this.max)).positive) {
                        Mesh mesh = this.toMesh(null);
                        return mesh.intersectsBox(object, iIsectFilter, convexHull);
                    }
                    break block4;
                }
                if (!iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE)) break block5;
                Point3d[] point3dArray = this.getVerts();
                for (int i = 0; i < s_edgeTests.length; ++i) {
                    int[] nArray = s_edgeTests[i];
                    Point3d point3d = point3dArray[nArray[0]];
                    Point3d point3d2 = point3dArray[nArray[1]];
                    if (!convexHull.intersectsLineSeg(point3d, point3d2, 1.0E-6)) continue;
                    return true;
                }
                break block4;
            }
            if (!iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX)) break block4;
            for (Point3d point3d : this.getVerts()) {
                if (!convexHull.contains(point3d, 1.0E-6)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        Point3d[] point3dArray;
        boolean bl = iIsectFilter.acceptGeomType(object, GeomType.FACE);
        boolean bl2 = iIsectFilter.acceptGeomType(object, GeomType.FACE_EDGE);
        boolean bl3 = iIsectFilter.acceptGeomType(object, GeomType.FACE_VERTEX);
        if (!(bl || bl2 || bl3)) {
            return;
        }
        Object object2 = point3dArray = bl2 || bl3 ? this.getVerts() : null;
        if (bl) {
            this.getFaceIsects(iIsectCollector, object, point3d, point3d2, vector3d);
        }
        if (bl2) {
            this.getEdgeIsects(iIsectCollector, object, point3dArray, point3d, point3d2, vector3d);
        }
        if (bl3) {
            this.getVertIsects(iIsectCollector, object, point3dArray);
        }
    }

    private void getVertIsects(IIsectCollector iIsectCollector, Object object, Point3d[] point3dArray) {
        for (Point3d point3d : point3dArray) {
            iIsectCollector.add(object, point3d, GeomType.FACE_VERTEX, new Point(point3d));
        }
    }

    private Point3d[] getVerts() {
        AABox aABox = new AABox(this.min, this.max);
        return new Point3d[]{aABox.mmm(), aABox.Mmm(), aABox.MMm(), aABox.mMm(), aABox.mmM(), aABox.MmM(), aABox.MMM(), aABox.mMM()};
    }

    private void getEdgeIsects(IIsectCollector iIsectCollector, Object object, Point3d[] point3dArray, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Point3d[] point3dArray2 = point3dArray;
        Point3d point3d3 = new Point3d();
        for (int i = 0; i < s_edgeTests.length; ++i) {
            int[] nArray = s_edgeTests[i];
            this.edgeIsect(iIsectCollector, object, point3d, vector3d, point3d3, point3dArray2[nArray[0]], point3dArray2[nArray[1]]);
        }
    }

    private void edgeIsect(IIsectCollector iIsectCollector, Object object, Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        boolean bl = Inter3D.lineLineSegProximity(null, point3d2, point3d, vector3d, point3d3, point3d4);
        if (bl) {
            iIsectCollector.add(object, new Point3d(point3d2), GeomType.FACE_EDGE, new LineSeg(point3d3, point3d4));
        }
    }

    private void getFaceIsects(IIsectCollector iIsectCollector, Object object, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        double d;
        double d2 = point3d.distanceSquared(point3d2);
        double[] dArray = new double[]{this.min.x, this.max.x};
        double[] dArray2 = new double[]{this.min.y, this.max.y};
        double[] dArray3 = new double[]{this.min.z, this.max.z};
        for (double d3 : dArray) {
            d = Inter3D.lineXFaceIsect(point3d, vector3d, this.min.y, this.max.y, this.min.z, this.max.z, d3, 1.0E-6);
            if (Double.isNaN(d) || !(d >= 0.0) || !(d * d <= d2)) continue;
            iIsectCollector.add(object, Util3D.linePoint(point3d, vector3d, d), GeomType.FACE, new AARectangle(0, d3, this.min.y, this.min.z, this.max.y, this.max.z));
        }
        for (double d3 : dArray2) {
            d = Inter3D.lineYFaceIsect(point3d, vector3d, this.min.x, this.max.x, this.min.z, this.max.z, d3, 1.0E-6);
            if (Double.isNaN(d) || !(d >= 0.0) || !(d * d <= d2)) continue;
            iIsectCollector.add(object, Util3D.linePoint(point3d, vector3d, d), GeomType.FACE, new AARectangle(1, d3, this.min.x, this.min.z, this.max.x, this.max.z));
        }
        for (double d3 : dArray3) {
            d = Inter3D.lineZFaceIsect(point3d, vector3d, this.min.x, this.max.x, this.min.y, this.max.y, d3, 1.0E-6);
            if (Double.isNaN(d) || !(d >= 0.0) || !(d * d <= d2)) continue;
            iIsectCollector.add(object, Util3D.linePoint(point3d, vector3d, d), GeomType.FACE, new AARectangle(2, d3, this.min.x, this.min.y, this.max.x, this.max.y));
        }
    }

    @Override
    public void find(ITest<AABox> iTest, IResult<? super IPrimitive> iResult) {
        this.toMesh(null).find(iTest, iResult);
    }

    @Override
    public void getAll(IResult<? super IPrimitive> iResult) {
        this.toMesh(null).getAll(iResult);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this, 0, 2, 4), new Handle(this, 1, 2, 4), new Handle(this, 1, 3, 4), new Handle(this, 0, 3, 4), new Handle(this, 0, 2, 5), new Handle(this, 1, 2, 5), new Handle(this, 1, 3, 5), new Handle(this, 0, 3, 5), new FaceHandle(this, 0), new FaceHandle(this, 1), new FaceHandle(this, 2), new FaceHandle(this, 3), new FaceHandle(this, 4), new FaceHandle(this, 5));
    }

    private static class SettableBox {
        private final AABoxGeom d_original;
        private double[] d_coords;

        public SettableBox(AABoxGeom aABoxGeom) {
            this.d_original = aABoxGeom;
            this.d_coords = SettableBox.getCoords(aABoxGeom.min, aABoxGeom.max);
        }

        protected static double[] getCoords(Point3d point3d, Point3d point3d2) {
            double[] dArray = new double[6];
            dArray[0] = point3d.x;
            dArray[2] = point3d.y;
            dArray[4] = point3d.z;
            dArray[1] = point3d2.x;
            dArray[3] = point3d2.y;
            dArray[5] = point3d2.z;
            return dArray;
        }

        public void set(int n, double d) {
            double d2 = -1.7976931348623157E308;
            double d3 = Double.MAX_VALUE;
            switch (n) {
                case 0: {
                    d3 = this.d_coords[1];
                    break;
                }
                case 1: {
                    d2 = this.d_coords[0];
                    break;
                }
                case 2: {
                    d3 = this.d_coords[3];
                    break;
                }
                case 3: {
                    d2 = this.d_coords[2];
                    break;
                }
                case 4: {
                    d3 = this.d_coords[5];
                    break;
                }
                case 5: {
                    d2 = this.d_coords[4];
                }
            }
            if (d < d2) {
                d = d2;
            } else if (d > d3) {
                d = d3;
            }
            this.d_coords[n] = d;
        }

        public double get(int n) {
            return this.d_coords[n];
        }

        public AABoxGeom toBox() {
            Point3d point3d = new Point3d(this.d_coords[0], this.d_coords[2], this.d_coords[4]);
            Point3d point3d2 = new Point3d(this.d_coords[1], this.d_coords[3], this.d_coords[5]);
            return new AABoxGeom(point3d, point3d2, this.d_original.swizzle);
        }
    }

    private static class Handle
    implements IHandle {
        private AABoxGeom d_geom;
        private final int[] d_coords;
        private SettableBox t_box;

        public Handle(AABoxGeom aABoxGeom, int n, int n2, int n3) {
            this.d_geom = aABoxGeom;
            this.d_coords = new int[]{n, n2, n3};
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Handle && Arrays.equals(((Handle)object).d_coords, this.d_coords);
        }

        @Override
        public IGeom getGeom() {
            SettableBox settableBox = new SettableBox(this.d_geom);
            Point3d point3d = new Point3d(settableBox.get(this.d_coords[0]), settableBox.get(this.d_coords[1]), settableBox.get(this.d_coords[2]));
            return new Point(point3d);
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d point3d) {
            return null;
        }

        @Override
        public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            this.t_box = new SettableBox(this.d_geom);
        }

        @Override
        public Object modify(Point3d point3d) throws Exception {
            this.t_box.set(this.d_coords[0], point3d.x);
            this.t_box.set(this.d_coords[1], point3d.y);
            this.t_box.set(this.d_coords[2], point3d.z);
            this.d_geom = this.t_box.toBox();
            return this.d_geom;
        }

        @Override
        public Object end() {
            return this.d_geom;
        }
    }

    private static class FaceHandle
    extends APlaneHandle<AABoxGeom> {
        private final int d_faceIx;

        public FaceHandle(AABoxGeom aABoxGeom, int n) {
            super(aABoxGeom);
            this.d_faceIx = n;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof FaceHandle && ((FaceHandle)object).d_faceIx == this.d_faceIx;
        }

        @Override
        public IGeom getGeom() {
            return ((AABoxGeom)this.getManipGeom()).toMesh(null).getPrimitive(this.d_faceIx);
        }

        @Override
        protected Vector3d getPlaneNormal(AABoxGeom aABoxGeom) {
            switch (this.d_faceIx) {
                case 0: 
                case 1: {
                    return GeomConstants.VEC3D_XPOS;
                }
                case 2: 
                case 3: {
                    return GeomConstants.VEC3D_YPOS;
                }
                case 4: 
                case 5: {
                    return GeomConstants.VEC3D_ZPOS;
                }
            }
            return null;
        }

        @Override
        protected AABoxGeom modify(AABoxGeom aABoxGeom, double d) {
            SettableBox settableBox = new SettableBox(aABoxGeom);
            settableBox.set(this.d_faceIx, settableBox.get(this.d_faceIx) + d);
            return settableBox.toBox();
        }
    }
}

