/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Model;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class NmtUtil {
    public static int[] mergeGroupIds(int[] nArray, int ... nArray2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray2.length);
        for (int n : nArray2) {
            if (NmtUtil.findGroup(nArray, n)) continue;
            arrayList.add(n);
        }
        return theUtil.append(nArray, theUtil.toIntArray(arrayList));
    }

    public static boolean findGroup(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public static boolean equal(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int n : nArray) {
            if (NmtUtil.findGroup(nArray2, n)) continue;
            return false;
        }
        return true;
    }

    public static int getFaceOrient(List<EdgeUse> list, Plane3d plane3d) {
        double d = NmtUtil.loopArea(list, plane3d);
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return 2;
        }
        return 0;
    }

    public static double loopArea(List<EdgeUse> list, Plane3d plane3d) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get((int)i).v1().loc);
        }
        return Util3D.simplePolygonArea(arrayList, plane3d.getNormal());
    }

    public static Plane3d calcLoopPlane(List<EdgeUse> list) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(list.get((int)i).v1().loc);
        }
        return Util3D.simplePolygonPlane(arrayList);
    }

    public static boolean faceInSolid(Model model, Model model2, Face face) {
        Point3d point3d = model2.findPointInFace(face);
        if (point3d == null) {
            return false;
        }
        return model.contains(point3d);
    }

    public static List<LineSeg3D> toCurves(Point3d ... point3dArray) {
        ArrayList<LineSeg3D> arrayList = new ArrayList<LineSeg3D>(point3dArray.length);
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d point3d = point3dArray[i];
            Point3d point3d2 = point3dArray[(i + 1) % point3dArray.length];
            arrayList.add(new LineSeg3D(point3d, point3d2));
        }
        return arrayList;
    }

    public static boolean addFaceToModel(Model model, int n, Plane3d plane3d, Collection<? extends IParametric3D> collection) {
        Point3d[] point3dArray = NmtUtil.getPolygonPoints(collection);
        if (point3dArray != null) {
            return model.addPolygonFace(n, plane3d, point3dArray);
        }
        return model.addFace(n, plane3d, collection);
    }

    public static Point3d[] getPolygonPoints(Collection<? extends IParametric3D> collection) {
        if (collection.size() < 3) {
            return null;
        }
        Iterator<? extends IParametric3D> iterator = collection.iterator();
        IParametric3D iParametric3D = iterator.next();
        if (!iParametric3D.isLinear()) {
            return null;
        }
        double d = 1.0E-12;
        Point3d[] point3dArray = new Point3d[collection.size()];
        point3dArray[0] = iParametric3D.get(0.0);
        Point3d point3d = iParametric3D.get(1.0);
        for (int i = 1; i < point3dArray.length; ++i) {
            IParametric3D iParametric3D2 = iterator.next();
            if (!iParametric3D2.isLinear()) {
                return null;
            }
            Point3d point3d2 = iParametric3D2.get(0.0);
            if (point3d.distanceSquared(point3d2) >= d) {
                return null;
            }
            point3dArray[i] = point3d2;
            point3d = iParametric3D2.get(1.0);
        }
        return point3d.distanceSquared(point3dArray[0]) < d ? point3dArray : null;
    }
}

