/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.TreeMap;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABoxTest;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ISearchVol;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSegRTreeTest;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.RTree;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.TrimmedCurve3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.AModelObj;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.CloneMap;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Edge;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.FaceLoop;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.NmtUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Triangulation;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Vertex;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.CollResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Model
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final int SEARCHACTION_ADD = 0;
    public static final int SEARCHACTION_UPDATE = 1;
    public static final int SEARCHACTION_REMOVE = 2;
    public static final double POINT_TOL = 1.0E-6;
    public static final double CURVE_TOL = 2.0E-6;
    static final boolean DEBUG = false;
    private transient GeomSearcher<Face> d_faceSearch = Model.newSearcher();
    private transient GeomSearcher<Edge> d_edgeSearch = Model.newSearcher();
    private transient GeomSearcher<Vertex> d_vertSearch = Model.newSearcher();
    private Group d_mainGroup = new Group(-1, LinkedIdentityHashSet.class);
    public static double t_pointInFace = 0.0;
    public static int t_nPointInFace = 0;

    private static <T extends AModelObj> GeomSearcher<T> newSearcher() {
        return new TreeSearcher();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (Face aModelObj : this.d_mainGroup.faces) {
            aModelObj.writeTopology(objectOutputStream);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.writeTopology(objectOutputStream);
        }
        for (Vertex vertex : this.d_mainGroup.verts) {
            vertex.writeTopology(objectOutputStream);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        for (Face aModelObj : this.d_mainGroup.faces) {
            aModelObj.readTopology(objectInputStream);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.readTopology(objectInputStream);
        }
        for (Vertex vertex : this.d_mainGroup.verts) {
            vertex.readTopology(objectInputStream);
        }
        this.d_faceSearch = Model.newSearcher();
        this.d_edgeSearch = Model.newSearcher();
        this.d_vertSearch = Model.newSearcher();
        for (Face face : this.d_mainGroup.faces) {
            this.updateFaceSearch(face, 0);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            this.updateEdgeSearch(edge, 0);
        }
        for (Vertex vertex : this.d_mainGroup.verts) {
            this.updateVertexSearch(vertex, 0);
        }
    }

    public void addGroupId(int n) {
        for (Vertex aModelObj : this.d_mainGroup.verts) {
            aModelObj.addGroup(n);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.addGroup(n);
        }
        for (Face face : this.d_mainGroup.faces) {
            face.addGroup(n);
        }
    }

    public void removeGroupIds(int ... nArray) {
        for (Vertex aModelObj : this.d_mainGroup.verts) {
            aModelObj.removeGroups(nArray);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.removeGroups(nArray);
        }
        for (Face face : this.d_mainGroup.faces) {
            face.removeGroups(nArray);
        }
    }

    public Object clone() {
        AModelObj aModelObj;
        Model model;
        try {
            model = (Model)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        model.d_mainGroup = new Group(this.d_mainGroup.id, LinkedIdentityHashSet.class);
        CloneMap cloneMap = new CloneMap();
        for (Vertex aModelObj2 : this.d_mainGroup.verts) {
            aModelObj = (Vertex)aModelObj2.clone();
            cloneMap.put(aModelObj2, (Vertex)aModelObj);
            model.d_mainGroup.verts.add((Vertex)aModelObj);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            aModelObj = edge.clone(cloneMap);
            cloneMap.put(edge, (Edge)aModelObj);
            ((Edge)aModelObj).buildConnections();
            model.d_mainGroup.edges.add((Edge)aModelObj);
        }
        for (Face face : this.d_mainGroup.faces) {
            aModelObj = face.clone(cloneMap);
            cloneMap.put(face, (Face)aModelObj);
            ((Face)aModelObj).buildConnections();
            model.d_mainGroup.faces.add((Face)aModelObj);
        }
        model.d_vertSearch = this.d_vertSearch.clone(cloneMap.getVertMap());
        model.d_edgeSearch = this.d_edgeSearch.clone(cloneMap.getEdgeMap());
        model.d_faceSearch = this.d_faceSearch.clone(cloneMap.getFaceMap());
        return model;
    }

    public void clear() {
        this.d_faceSearch.clear();
        this.d_edgeSearch.clear();
        this.d_vertSearch.clear();
        this.d_mainGroup.clear();
    }

    public Collection<Face> getFaces() {
        return this.d_mainGroup.faces;
    }

    public Collection<Edge> getEdges() {
        return this.d_mainGroup.edges;
    }

    public Collection<Vertex> getVerts() {
        return this.d_mainGroup.verts;
    }

    public AABox getBoundingBox() {
        AABox aABox = new AABox();
        aABox.add(this.d_vertSearch.getBounds());
        aABox.add(this.d_edgeSearch.getBounds());
        aABox.add(this.d_faceSearch.getBounds());
        return aABox;
    }

    public void divideEdges(double d) {
        Edge[] edgeArray;
        if (d == Double.MAX_VALUE || Double.isInfinite(d) || d <= 0.0) {
            return;
        }
        for (Edge edge : edgeArray = this.d_mainGroup.edges.toArray(new Edge[this.d_mainGroup.edges.size()])) {
            this.divideEdge(edge, d);
        }
    }

    private void divideEdge(Edge edge, double d) {
        double d2 = edge.curve.length();
        if (d2 > d) {
            double d3 = d2 / d;
            double d4 = Math.floor(d3);
            double d5 = d3 - d4;
            d3 = theUtil.gt0(d5, 1.0E-6) ? d4 + 1.0 : d4;
            IParametric3D iParametric3D = edge.curve;
            int[] nArray = edge.groups;
            double[] dArray = new double[(int)d3 - 1];
            Vertex[] vertexArray = new Vertex[dArray.length];
            int n = 1;
            while ((double)n < d3) {
                double d6;
                dArray[n - 1] = d6 = (double)n / d3;
                vertexArray[n - 1] = this.addVertexToRegion(iParametric3D.get(d6), nArray);
                ++n;
            }
            this.addVerticesToEdge(edge, dArray, vertexArray);
        }
    }

    public Triangulation triangulate(double d) {
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Face face : this.d_mainGroup.faces) {
            face.triangulate(d, linkedHashMap, arrayList);
        }
        return new Triangulation(linkedHashMap.keySet().toArray(new Point3d[linkedHashMap.size()]), theUtil.toIntArray(arrayList));
    }

    public void addEdges(int n, Collection<? extends IParametric3D> collection) {
        Model model = new Model();
        for (IParametric3D iParametric3D : collection) {
            this.addEdge(n, iParametric3D, model);
        }
    }

    public void addEdge(int n, IParametric3D iParametric3D) {
        Model model = new Model();
        this.addEdge(n, iParametric3D, model);
    }

    private boolean addEdge(int n, IParametric3D iParametric3D, Model model) {
        if (iParametric3D.length() < 1.0E-6) {
            return false;
        }
        Point3d point3d = iParametric3D.get(0.0);
        Point3d point3d2 = iParametric3D.get(1.0);
        model.clear();
        Vertex vertex = model.addVertexToRegion(point3d, n);
        Vertex vertex2 = model.addVertexToRegion(point3d2, n);
        model.addEdgeToRegion(iParametric3D, vertex, vertex2, n);
        this.merge(model);
        return true;
    }

    public void addFace(Face face, int ... nArray) {
        Serializable serializable;
        Object object;
        Model model = new Model();
        IdentityHashMap<Vertex, Vertex> identityHashMap = new IdentityHashMap<Vertex, Vertex>();
        IdentityHashMap<Edge, Vertex> identityHashMap2 = new IdentityHashMap<Edge, Vertex>();
        for (FaceLoop serializable22 : face.edgeLoops) {
            for (Vertex vertex : serializable22.getVerts()) {
                if (identityHashMap.containsKey(vertex)) continue;
                object = nArray.length == 0 ? vertex.groups : nArray;
                serializable = model.addVertexToRegion(vertex.loc, (int[])object);
                identityHashMap.put(vertex, (Vertex)serializable);
            }
        }
        for (FaceLoop faceLoop : face.edgeLoops) {
            for (EdgeUse edgeUse : faceLoop.edges) {
                if (identityHashMap2.containsKey(edgeUse.edge)) continue;
                object = nArray.length == 0 ? edgeUse.edge.groups : nArray;
                serializable = model.addEdgeToRegion(edgeUse.edge.curve, (Vertex)identityHashMap.get(edgeUse.edge.v1), (Vertex)identityHashMap.get(edgeUse.edge.v2), (int[])object);
                identityHashMap2.put(edgeUse.edge, (Vertex)serializable);
            }
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<EdgeUse> arrayList2 = new ArrayList<EdgeUse>();
        for (FaceLoop faceLoop : face.edgeLoops) {
            if (faceLoop.vert != null) {
                arrayList.add(identityHashMap.get(faceLoop.vert));
            }
            object = faceLoop.edges.iterator();
            while (object.hasNext()) {
                serializable = (EdgeUse)object.next();
                Edge edge = (Edge)identityHashMap2.get(((EdgeUse)serializable).edge);
                arrayList2.add(new EdgeUse(edge, ((EdgeUse)serializable).orient));
            }
        }
        Object object2 = nArray.length == 0 ? face.groups : nArray;
        model.addFaceToRegion(face.plane, arrayList2, (List<Vertex>)arrayList, (int[])object2);
        this.merge(model);
    }

    public void deleteFace(Face face, boolean bl, boolean bl2) {
        this.updateFaceSearch(face, 2);
        face.clearConnections();
        this.d_mainGroup.faces.remove(face);
        if (bl || bl2) {
            for (FaceLoop faceLoop : face.edgeLoops) {
                if (faceLoop.vert != null && bl2 && !faceLoop.vert.isConnected()) {
                    this.deleteVertex(faceLoop.vert);
                    continue;
                }
                for (EdgeUse edgeUse : faceLoop.edges) {
                    if (edgeUse.edge.isConnected()) continue;
                    this.deleteEdge(edgeUse.edge, bl2);
                }
            }
        }
    }

    public void deleteEdge(Edge edge, boolean bl) {
        assert (edge.faces.isEmpty());
        this.updateEdgeSearch(edge, 2);
        edge.clearConnections();
        this.d_mainGroup.edges.remove(edge);
        if (bl) {
            if (!edge.v1.isConnected()) {
                this.deleteVertex(edge.v1);
            }
            if (!edge.v2.isConnected()) {
                this.deleteVertex(edge.v2);
            }
        }
    }

    public void deleteVertex(Vertex vertex) {
        assert (vertex.edges.isEmpty() && vertex.face == null);
        this.updateVertexSearch(vertex, 2);
        this.d_mainGroup.verts.remove(vertex);
    }

    public boolean addPolygonFace(int n, Plane3d plane3d, Point3d ... point3dArray) {
        if ((point3dArray = Util3D.deleteDupPoints(2.0E-6, true, point3dArray)).length < 3) {
            return false;
        }
        if (point3dArray.length == 3) {
            Vector3d vector3d = Util3D.vector(point3dArray[0], point3dArray[1]);
            double d = Inter3D.distSqToNearestPtOnLine(point3dArray[0], vector3d, point3dArray[2]);
            if (d < 1.0E-6) {
                return false;
            }
            Model model = new Model();
            Vertex vertex = model.addVertexToRegion(point3dArray[0], n);
            Vertex vertex2 = model.addVertexToRegion(point3dArray[1], n);
            Vertex vertex3 = model.addVertexToRegion(point3dArray[2], n);
            Edge edge = model.addEdgeToRegion(new LineSeg3D(point3dArray[0], point3dArray[1]), vertex, vertex2, n);
            Edge edge2 = model.addEdgeToRegion(new LineSeg3D(point3dArray[1], point3dArray[2]), vertex2, vertex3, n);
            Edge edge3 = model.addEdgeToRegion(new LineSeg3D(point3dArray[2], point3dArray[0]), vertex3, vertex, n);
            EdgeUse edgeUse = new EdgeUse(edge, true);
            EdgeUse edgeUse2 = new EdgeUse(edge2, true);
            EdgeUse edgeUse3 = new EdgeUse(edge3, true);
            model.addFaceToRegion(plane3d, Arrays.asList(edgeUse, edgeUse2, edgeUse3), (List<Vertex>)Collections.EMPTY_LIST, false, n);
            this.merge(model);
            return true;
        }
        if (Util3D.isConvex(1.0E-6, point3dArray)) {
            Model model = new Model();
            Vertex[] vertexArray = new Vertex[point3dArray.length];
            for (int i = 0; i < point3dArray.length; ++i) {
                vertexArray[i] = model.addVertexToRegion(point3dArray[i], n);
            }
            ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>(point3dArray.length);
            for (int i = 0; i < point3dArray.length; ++i) {
                int n2 = (i + 1) % point3dArray.length;
                Point3d point3d = point3dArray[i];
                Point3d point3d2 = point3dArray[n2];
                Vertex vertex = vertexArray[i];
                Vertex vertex4 = vertexArray[n2];
                Edge edge = model.addEdgeToRegion(new LineSeg3D(point3d, point3d2), vertex, vertex4, n);
                arrayList.add(new EdgeUse(edge, true));
            }
            model.addFaceToRegion(plane3d, arrayList, (List<Vertex>)Collections.EMPTY_LIST, false, n);
            this.merge(model);
            return true;
        }
        return this.addFace(n, plane3d, NmtUtil.toCurves(point3dArray));
    }

    public boolean addFace(int n, Plane3d plane3d, Collection<? extends IParametric3D> collection) {
        boolean bl;
        Map<Face, Integer> map;
        Matrix4d matrix4d = Util.getWorldToLocalXform(plane3d);
        AABox aABox = new AABox();
        for (IParametric3D iParametric3D : collection) {
            aABox.add(Util3D.xform(matrix4d, iParametric3D.get(0.0)));
            aABox.add(Util3D.xform(matrix4d, iParametric3D.get(1.0)));
        }
        if (aABox.getMinX() >= aABox.getMaxX() || aABox.getMinY() >= aABox.getMaxY()) {
            return false;
        }
        double d = aABox.getMaxX() - aABox.getMinX();
        double d2 = aABox.getMaxY() - aABox.getMinY();
        aABox.set(new Point3d(aABox.getMinX() - d * 0.5, aABox.getMinY() - d2 * 0.5, 0.0), new Point3d(aABox.getMaxX() + d * 0.5, aABox.getMaxY() + d2 * 0.5, 0.0));
        Matrix4d matrix4d2 = Util.getLocalToWorldXform(plane3d);
        Point3d[] point3dArray = new Point3d[]{Util3D.xformEq(matrix4d2, new Point3d(aABox.getMinX(), aABox.getMinY(), 0.0)), Util3D.xformEq(matrix4d2, new Point3d(aABox.getMaxX(), aABox.getMinY(), 0.0)), Util3D.xformEq(matrix4d2, new Point3d(aABox.getMaxX(), aABox.getMaxY(), 0.0)), Util3D.xformEq(matrix4d2, new Point3d(aABox.getMinX(), aABox.getMaxY(), 0.0))};
        int n2 = n == 0 ? Integer.MAX_VALUE : 0;
        Model model = new Model();
        Vertex[] vertexArray = new Vertex[4];
        for (int i = 0; i < 4; ++i) {
            vertexArray[i] = model.addVertexToRegion(point3dArray[i], n2);
        }
        ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>(4);
        for (int i = 0; i < 4; ++i) {
            map = vertexArray[i];
            Vertex aModelObj = vertexArray[(i + 1) % 4];
            LineSeg3D lineSeg3D = new LineSeg3D(((Vertex)((Object)map)).loc, aModelObj.loc);
            Edge edge = model.addEdgeToRegion(lineSeg3D, (Vertex)((Object)map), aModelObj, n2);
            arrayList.add(new EdgeUse(edge, true));
        }
        model.addFaceToRegion(plane3d, arrayList, (List<Vertex>)Collections.EMPTY_LIST, n2);
        model.addEdges(n, collection);
        Face face = null;
        for (Edge edge : model.getEdges()) {
            if (edge.groups.length != 1 || edge.groups[0] != n2 || edge.faces.isEmpty()) continue;
            assert (edge.faces.size() == 1);
            face = edge.faces.get(0);
            break;
        }
        map = Model.classifyFaces(model, face);
        boolean bl2 = false;
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() % 2 == 0) continue;
            this.addFace((Face)entry.getKey(), n);
            bl = true;
        }
        return bl;
    }

    private static Map<Face, Integer> classifyFaces(Model model, Face face) {
        IdentityHashMap<Face, Integer> identityHashMap = new IdentityHashMap<Face, Integer>();
        Stack<Face> stack = new Stack<Face>();
        Stack<Face> stack2 = new Stack<Face>();
        stack2.push(face);
        int n = 0;
        while (!stack2.isEmpty()) {
            Face face2 = (Face)stack2.pop();
            if (!identityHashMap.containsKey(face2)) {
                identityHashMap.put(face2, n);
                for (FaceLoop faceLoop : face2.edgeLoops) {
                    for (EdgeUse edgeUse : faceLoop.edges) {
                        for (Face face3 : edgeUse.edge.faces) {
                            if (face3 == face2 || identityHashMap.containsKey(face3)) continue;
                            stack.push(face3);
                        }
                    }
                }
            }
            if (!stack2.isEmpty()) continue;
            ++n;
            Stack<Face> stack3 = stack2;
            stack2 = stack;
            stack = stack3;
        }
        return identityHashMap;
    }

    private static Point3d findPointInLoop(Plane3d plane3d, List<IParametric3D> list) {
        for (IParametric3D iParametric3D : list) {
            Point3d point3d = iParametric3D.get(0.0);
            for (IParametric3D iParametric3D2 : list) {
                Point3d point3d2 = iParametric3D2.get(0.5);
                Point3d point3d3 = Util3D.getMidPoint(point3d, point3d2);
                if (Model.pointOnLoop(point3d3, list) || !Model.pointInLoop(list, plane3d, point3d3)) continue;
                return point3d3;
            }
        }
        return null;
    }

    public Point3d findPointInFace(Face face) {
        List<EdgeUse> list = face.getEdges();
        for (int i = 0; i < list.size(); ++i) {
            Point3d point3d = list.get((int)i).edge.curve.get(0.0);
            for (int j = 0; j < list.size(); ++j) {
                Point3d point3d2;
                Point3d point3d3;
                if (i == j || Model.compare(point3d3 = Util3D.getMidPoint(point3d, point3d2 = list.get((int)j).edge.curve.get(0.5)), point3d) || Model.compare(point3d3, point3d2) || this.pointOnBoundary(point3d3, face) || this.pointInFace(face, point3d3) == null) continue;
                return point3d3;
            }
        }
        return null;
    }

    private static List<IParametric3D> getSegs(Map<Point3d, List<IParametric3D>> map, Point3d point3d) {
        List<IParametric3D> list = map.get(point3d);
        if (list == null) {
            list = new ArrayList<IParametric3D>();
            map.put(point3d, list);
        }
        return list;
    }

    private void addToGroups(AModelObj aModelObj, int ... nArray) {
        aModelObj.addGroups(nArray);
        this.d_mainGroup.add(aModelObj);
    }

    public Group getGroup(int n) {
        return this.getGroup(n, true, true, true);
    }

    public Group getGroup(int n, boolean bl, boolean bl2, boolean bl3) {
        Group group = new Group(n, ArrayList.class);
        if (bl) {
            for (Face aModelObj : this.d_mainGroup.faces) {
                if (!aModelObj.partOfGroup(n)) continue;
                group.faces.add(aModelObj);
            }
        }
        if (bl2) {
            for (Edge edge : this.d_mainGroup.edges) {
                if (!edge.partOfGroup(n)) continue;
                group.edges.add(edge);
            }
        }
        if (bl3) {
            for (Vertex vertex : this.d_mainGroup.verts) {
                if (!vertex.partOfGroup(n)) continue;
                group.verts.add(vertex);
            }
        }
        return group;
    }

    private Edge[] addVerticesToEdge(Edge edge, double[] dArray, Vertex[] vertexArray) {
        assert (dArray.length == vertexArray.length);
        Edge[] edgeArray = new Edge[vertexArray.length];
        double d = 0.0;
        Edge edge2 = edge;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            Vertex vertex = vertexArray[i];
            double d3 = (d2 - d) / (1.0 - d);
            edgeArray[i] = this.addVertexToEdge(edge2, d3, vertex);
            edge2 = edgeArray[i];
            d = d2;
        }
        return edgeArray;
    }

    private Edge addVertexToEdge(Edge edge, double d, Vertex vertex) {
        Vertex vertex2 = edge.v2;
        TrimmedCurve3D trimmedCurve3D = new TrimmedCurve3D(edge.curve, 0.0, d);
        TrimmedCurve3D trimmedCurve3D2 = new TrimmedCurve3D(edge.curve, d, 1.0);
        edge.curve = trimmedCurve3D;
        edge.v2 = vertex;
        vertex2.edges.remove(edge);
        vertex.addEdge(edge);
        this.updateEdgeSearch(edge, 1);
        Edge edge2 = this.addEdgeToRegion(trimmedCurve3D2, vertex, vertex2, edge.groups);
        edge2.faces.addAll(edge.faces);
        vertex.addEdge(edge2);
        for (Face face : edge.faces) {
            boolean bl = face.isInternalEdge(edge);
            for (FaceLoop faceLoop : face.edgeLoops) {
                ListIterator<EdgeUse> listIterator = faceLoop.edges.listIterator();
                while (listIterator.hasNext()) {
                    EdgeUse edgeUse = listIterator.next();
                    if (edgeUse.edge != edge) continue;
                    EdgeUse edgeUse2 = new EdgeUse(edge2, edgeUse.orient);
                    if (!edgeUse.orient) {
                        listIterator.set(edgeUse2);
                        listIterator.add(edgeUse);
                        continue;
                    }
                    listIterator.add(edgeUse2);
                }
            }
            if (bl) {
                face.addInternalEdge(edge2);
            }
            if (face.isValid()) continue;
            System.err.println("0a Invalid face orient");
        }
        return edge2;
    }

    public boolean removeVertexFromEdges(Vertex vertex) {
        if (vertex.edges.size() != 2) {
            return false;
        }
        Edge edge = vertex.edges.get(0);
        Edge edge2 = vertex.edges.get(1);
        Vertex vertex2 = vertex == edge.v1 ? edge.v2 : edge.v1;
        Vertex vertex3 = vertex == edge2.v1 ? edge2.v2 : edge2.v1;
        LineSeg3D lineSeg3D = new LineSeg3D(vertex2.loc, vertex3.loc);
        Edge edge3 = this.addEdgeToRegion(lineSeg3D, vertex2, vertex3, NmtUtil.mergeGroupIds(edge.groups, edge2.groups));
        if (!edge.faces.isEmpty()) {
            assert (!edge2.faces.isEmpty());
            for (Face face : edge.faces) {
                boolean bl = face.isInternalEdge(edge);
                assert (bl == face.isInternalEdge(edge2));
                if (bl) {
                    face.removeInternalEdge(edge);
                    face.removeInternalEdge(edge2);
                }
                for (FaceLoop faceLoop : face.edgeLoops) {
                    for (int i = 0; i < faceLoop.edges.size(); ++i) {
                        int n = i;
                        int n2 = (i + 1) % faceLoop.edges.size();
                        EdgeUse edgeUse = faceLoop.edges.get(n);
                        EdgeUse edgeUse2 = faceLoop.edges.get(n2);
                        if ((edgeUse.edge != edge || edgeUse2.edge != edge2) && (edgeUse.edge != edge2 || edgeUse2.edge != edge)) continue;
                        boolean bl2 = edgeUse.v1() == vertex2;
                        EdgeUse edgeUse3 = new EdgeUse(edge3, bl2);
                        if (n2 > n) {
                            faceLoop.edges.remove(n2);
                            faceLoop.edges.remove(n);
                            faceLoop.edges.add(n, edgeUse3);
                            continue;
                        }
                        faceLoop.edges.remove(n);
                        faceLoop.edges.remove(n2);
                        faceLoop.edges.add(n - 1, edgeUse3);
                    }
                }
                edge3.faces.add(face);
                if (bl) {
                    face.addInternalEdge(edge3);
                }
                if (face.isValid()) continue;
                System.err.println("0x29384f Invalid face");
            }
        }
        edge.faces.clear();
        edge2.faces.clear();
        this.deleteEdge(edge, false);
        this.deleteEdge(edge2, false);
        this.deleteVertex(vertex);
        return true;
    }

    private void addVertexToFace(Face face, Vertex vertex) {
        FaceLoop faceLoop = new FaceLoop();
        faceLoop.vert = vertex;
        vertex.face = face;
        face.edgeLoops.add(faceLoop);
    }

    public void removeVertexFromFace(Vertex vertex) {
        assert (vertex.edges.isEmpty() && vertex.face != null);
        for (int i = 0; i < vertex.face.edgeLoops.size(); ++i) {
            if (vertex.face.edgeLoops.get((int)i).vert != vertex) continue;
            vertex.face.edgeLoops.remove(i);
            break;
        }
        vertex.face = null;
        this.deleteVertex(vertex);
    }

    private Vertex addVertexToRegion(Point3d point3d, int ... nArray) {
        Vertex vertex = new Vertex(point3d);
        this.addToGroups(vertex, nArray);
        this.updateVertexSearch(vertex, 0);
        return vertex;
    }

    private Face addEdgeToFace(Face face, Edge edge, FaceEdgeInsert faceEdgeInsert, FaceEdgeInsert faceEdgeInsert2) {
        edge.addFace(face);
        FaceLoop faceLoop = faceEdgeInsert.loop;
        int n = faceEdgeInsert.edgeIx;
        FaceLoop faceLoop2 = faceEdgeInsert2.loop;
        int n2 = faceEdgeInsert2.edgeIx;
        Face face2 = null;
        if (faceLoop.vert != null && faceLoop2.vert != null) {
            faceLoop.removeFace(face);
            faceLoop2.removeFace(face);
            face.edgeLoops.remove(faceLoop);
            face.edgeLoops.remove(faceLoop2);
            FaceLoop faceLoop3 = new FaceLoop();
            faceLoop3.edges.add(new EdgeUse(edge, true));
            faceLoop3.edges.add(new EdgeUse(edge, false));
            face.edgeLoops.add(faceLoop3);
            face.addInternalEdge(edge);
            if (!face.isValid()) {
                System.err.println("0 Invalid face orient");
            }
        } else if (faceLoop.vert != null) {
            faceLoop.removeFace(face);
            face.edgeLoops.remove(faceLoop);
            ListIterator<EdgeUse> listIterator = faceLoop2.edges.listIterator(n2);
            listIterator.add(new EdgeUse(edge, false));
            listIterator.add(new EdgeUse(edge, true));
            face.addInternalEdge(edge);
            if (!face.isValid()) {
                System.err.println("4 Invalid face orient");
            }
        } else if (faceLoop2.vert != null) {
            faceLoop2.removeFace(face);
            face.edgeLoops.remove(faceLoop2);
            ListIterator<EdgeUse> listIterator = faceLoop.edges.listIterator(n);
            listIterator.add(new EdgeUse(edge, true));
            listIterator.add(new EdgeUse(edge, false));
            face.addInternalEdge(edge);
            if (!face.isValid()) {
                System.err.println("5 Invalid face orient");
            }
        } else if (faceLoop != faceLoop2) {
            ListIterator<EdgeUse> listIterator = faceLoop.edges.listIterator(n);
            ListIterator<EdgeUse> listIterator2 = n2 == faceLoop2.edges.size() ? faceLoop2.edges.listIterator() : faceLoop2.edges.listIterator(n2);
            listIterator.add(new EdgeUse(edge, true));
            for (int i = 0; i < faceLoop2.edges.size(); ++i) {
                EdgeUse edgeUse = listIterator2.next();
                listIterator.add(edgeUse);
                if (listIterator2.hasNext()) continue;
                listIterator2 = faceLoop2.edges.listIterator();
            }
            listIterator.add(new EdgeUse(edge, false));
            if (faceLoop2 == face.outerLoop()) {
                face.edgeLoops.remove(faceLoop);
                face.edgeLoops.set(0, faceLoop);
            } else {
                face.edgeLoops.remove(faceLoop2);
            }
            face.addInternalEdge(edge);
            if (!face.isValid()) {
                System.err.println("1 Invalid face orient");
            }
        } else {
            Serializable serializable;
            boolean bl;
            face.clearConnections();
            FaceLoop faceLoop4 = faceLoop;
            boolean bl2 = bl = faceLoop4 == face.outerLoop();
            if (n2 == faceLoop4.edges.size()) {
                n2 = 0;
            }
            if (n == faceLoop4.edges.size()) {
                n = 0;
            }
            ListIterator<EdgeUse> listIterator = faceLoop4.edges.listIterator(n2);
            Serializable serializable2 = new ArrayList<EdgeUse>();
            serializable2.add(new EdgeUse(edge, true));
            while (listIterator.nextIndex() != n) {
                serializable2.add(listIterator.next());
                if (listIterator.hasNext()) continue;
                listIterator = faceLoop4.edges.listIterator();
            }
            ListIterator<EdgeUse> listIterator3 = faceLoop4.edges.listIterator(n);
            ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>();
            arrayList.add(new EdgeUse(edge, false));
            while (listIterator3.nextIndex() != n2) {
                arrayList.add(listIterator3.next());
                if (listIterator3.hasNext()) continue;
                listIterator3 = faceLoop4.edges.listIterator();
            }
            if (!bl && NmtUtil.getFaceOrient(serializable2, face.plane) != 2) {
                serializable = arrayList;
                arrayList = serializable2;
                serializable2 = serializable;
            }
            serializable = new FaceLoop();
            serializable.edges.addAll((Collection<EdgeUse>)((Object)serializable2));
            face.edgeLoops.remove(faceLoop4);
            if (bl) {
                face.edgeLoops.add(0, (FaceLoop)serializable);
            } else {
                face.edgeLoops.add((FaceLoop)serializable);
            }
            face2 = this.addFaceToRegion(face.plane, arrayList, (List<Vertex>)Collections.EMPTY_LIST, true, face.groups);
            FaceLoop[] faceLoopArray = face.edgeLoops.toArray(new FaceLoop[face.edgeLoops.size()]);
            ArrayList<FaceLoop> arrayList2 = new ArrayList<FaceLoop>(faceLoopArray.length);
            for (FaceLoop faceLoop5 : faceLoopArray) {
                if (faceLoop5 == serializable) continue;
                Vertex vertex = Model.findVertex(faceLoop5);
                if (this.pointInFace(face2, vertex.loc) == null) continue;
                arrayList2.add(faceLoop5);
            }
            if (!arrayList2.isEmpty()) {
                for (FaceLoop faceLoop6 : arrayList2) {
                    face.edgeLoops.remove(faceLoop6);
                    face2.edgeLoops.add(faceLoop6);
                    faceLoop6.addFace(face2);
                }
            }
            face.buildConnections();
            for (Edge edge2 : new ArrayList<Edge>(face.getInternalEdges())) {
                int n3 = edge2.faces.contains(face) ? 1 : 0;
                boolean bl3 = edge2.faces.contains(face2);
                if (n3 != 0 && bl3) {
                    face.removeInternalEdge(edge2);
                    continue;
                }
                if (!bl3) continue;
                face.removeInternalEdge(edge2);
                face2.addInternalEdge(edge2);
            }
            if (bl) {
                face.invalidateBounds();
                this.updateFaceSearch(face, 1);
            }
            if (!face.isValid()) {
                System.err.println("2 Invalid face orient");
            }
            if (!face2.isValid()) {
                System.err.println("3 Invalid face orient");
            }
        }
        return face2;
    }

    private static Vertex findVertex(FaceLoop faceLoop) {
        if (faceLoop.vert != null) {
            return faceLoop.vert;
        }
        assert (!faceLoop.edges.isEmpty());
        return faceLoop.edges.get(0).v1();
    }

    public boolean removeEdgeFromFaces(Edge edge) {
        boolean bl;
        if (edge.faces.size() != 2) {
            return false;
        }
        Face face = edge.faces.get(0);
        Face face2 = edge.faces.get(1);
        FaceEdgeInsert faceEdgeInsert = Model.findFaceEdgeDeletion(face, edge);
        if (faceEdgeInsert == null) {
            return false;
        }
        FaceEdgeInsert faceEdgeInsert2 = Model.findFaceEdgeDeletion(face2, edge);
        if (faceEdgeInsert2 == null) {
            return false;
        }
        assert (!face.isInternalEdge(edge) && !face2.isInternalEdge(edge));
        face.clearConnections();
        face2.clearConnections();
        if (face2.outerLoop() != faceEdgeInsert2.loop) {
            assert (face.outerLoop() == faceEdgeInsert.loop);
            FaceEdgeInsert faceEdgeInsert3 = faceEdgeInsert2;
            faceEdgeInsert2 = faceEdgeInsert;
            faceEdgeInsert = faceEdgeInsert3;
            Face face3 = face;
            face = face2;
            face2 = face3;
        }
        boolean bl2 = face.outerLoop() == faceEdgeInsert.loop;
        boolean bl3 = bl = face2.outerLoop() == faceEdgeInsert2.loop;
        assert (bl);
        ListIterator<EdgeUse> listIterator = faceEdgeInsert.loop.edges.listIterator(faceEdgeInsert.edgeIx);
        EdgeUse edgeUse = listIterator.next();
        if (!listIterator.hasNext()) {
            listIterator = faceEdgeInsert.loop.edges.listIterator();
        }
        ListIterator<EdgeUse> listIterator2 = faceEdgeInsert2.loop.edges.listIterator(faceEdgeInsert2.edgeIx);
        EdgeUse edgeUse2 = listIterator2.next();
        ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>(faceEdgeInsert.loop.edges.size() + faceEdgeInsert2.loop.edges.size() - 2);
        if (edgeUse.orient != edgeUse2.orient) {
            if (!listIterator2.hasNext()) {
                listIterator2 = faceEdgeInsert2.loop.edges.listIterator();
            }
            while (listIterator2.nextIndex() != faceEdgeInsert2.edgeIx) {
                arrayList.add(listIterator2.next());
                if (listIterator2.hasNext()) continue;
                listIterator2 = faceEdgeInsert2.loop.edges.listIterator();
            }
        } else {
            listIterator2.previous();
            if (!listIterator2.hasPrevious()) {
                listIterator2 = faceEdgeInsert2.loop.edges.listIterator(faceEdgeInsert2.loop.edges.size());
            }
            while (listIterator2.previousIndex() != faceEdgeInsert2.edgeIx) {
                arrayList.add(listIterator2.previous().reverse());
                if (listIterator2.hasPrevious()) continue;
                listIterator2 = faceEdgeInsert2.loop.edges.listIterator(faceEdgeInsert2.loop.edges.size());
            }
        }
        while (listIterator.nextIndex() != faceEdgeInsert.edgeIx) {
            arrayList.add(listIterator.next());
            if (listIterator.hasNext()) continue;
            listIterator = faceEdgeInsert.loop.edges.listIterator();
        }
        FaceLoop faceLoop = new FaceLoop();
        faceLoop.edges.addAll(arrayList);
        if (bl2) {
            face.edgeLoops.set(0, faceLoop);
        } else {
            face.edgeLoops.remove(faceEdgeInsert.loop);
            face.edgeLoops.add(faceLoop);
        }
        for (int i = 1; i < face2.edgeLoops.size(); ++i) {
            face.edgeLoops.add(face2.edgeLoops.get(i));
        }
        face.addGroups(face2.groups);
        this.deleteFace(face2, false, false);
        edge.faces.clear();
        this.deleteEdge(edge, false);
        face.recalcInternalEdges();
        face.buildConnections();
        face.invalidateBounds();
        this.updateFaceSearch(face, 1);
        return true;
    }

    public boolean removeEdgeFromFace(Edge edge) {
        int n;
        assert (edge.faces.size() == 1);
        Face face = edge.faces.get(0);
        FaceLoop faceLoop = null;
        int n2 = -1;
        int n3 = -1;
        for (FaceLoop faceLoop2 : face.edgeLoops) {
            for (n = 0; n < faceLoop2.edges.size(); ++n) {
                if (faceLoop2.edges.get((int)n).edge != edge) continue;
                faceLoop = faceLoop2;
                if (n2 == -1) {
                    n2 = n;
                    continue;
                }
                n3 = n;
                break;
            }
            if (faceLoop == null) continue;
            break;
        }
        if (faceLoop == null || n2 == -1 || n3 == -1) {
            return false;
        }
        assert (face.isInternalEdge(edge));
        face.clearConnections();
        EdgeUse edgeUse = faceLoop.edges.get(n2);
        boolean bl = (n3 + 1) % faceLoop.edges.size() == n2;
        n = (n2 + 1) % faceLoop.edges.size() == n3 ? 1 : 0;
        FaceLoop faceLoop3 = new FaceLoop();
        FaceLoop faceLoop4 = new FaceLoop();
        if (bl && n != 0) {
            faceLoop3.vert = edgeUse.v1();
            faceLoop4.vert = edgeUse.v2();
            assert (faceLoop != face.outerLoop());
            face.edgeLoops.remove(faceLoop);
            face.edgeLoops.add(faceLoop3);
            face.edgeLoops.add(faceLoop4);
        } else if (bl || n != 0) {
            int n4;
            int n5;
            if (bl) {
                faceLoop3.vert = edgeUse.v1();
                n5 = n2;
                n4 = n3;
            } else {
                faceLoop3.vert = edgeUse.v2();
                n5 = n3;
                n4 = n2;
            }
            int n6 = (n5 + 1) % faceLoop.edges.size();
            while (n6 != n4) {
                faceLoop4.edges.add(faceLoop.edges.get(n6));
                n6 = (n6 + 1) % faceLoop.edges.size();
            }
            if (faceLoop == face.outerLoop()) {
                face.edgeLoops.set(0, faceLoop4);
            } else {
                face.edgeLoops.remove(faceLoop);
                face.edgeLoops.add(faceLoop4);
            }
            face.edgeLoops.add(faceLoop3);
        } else {
            int n7 = (n2 + 1) % faceLoop.edges.size();
            while (n7 != n3) {
                faceLoop3.edges.add(faceLoop.edges.get(n7));
                n7 = (n7 + 1) % faceLoop.edges.size();
            }
            n7 = (n3 + 1) % faceLoop.edges.size();
            while (n7 != n2) {
                faceLoop4.edges.add(faceLoop.edges.get(n7));
                n7 = (n7 + 1) % faceLoop.edges.size();
            }
            if (faceLoop == face.outerLoop()) {
                n7 = 0;
                int n8 = n7 = faceLoop3.isOpen() && NmtUtil.getFaceOrient(faceLoop3.edges, face.plane) == 1 ? 1 : 0;
                if (n7 != 0) {
                    face.edgeLoops.set(0, faceLoop3);
                    face.edgeLoops.add(faceLoop4);
                } else {
                    face.edgeLoops.set(0, faceLoop4);
                    face.edgeLoops.add(faceLoop3);
                }
            } else {
                face.edgeLoops.remove(faceLoop);
                face.edgeLoops.add(faceLoop3);
                face.edgeLoops.add(faceLoop4);
            }
        }
        edge.faces.clear();
        face.buildConnections();
        if (edge.faces.isEmpty()) {
            this.deleteEdge(edge, false);
            face.removeInternalEdge(edge);
        }
        if (!face.isValid()) {
            System.err.println("0x923984 invalid face");
        }
        return true;
    }

    private static FaceEdgeInsert findFaceEdgeDeletion(Face face, Edge edge) {
        for (FaceLoop faceLoop : face.edgeLoops) {
            for (int i = 0; i < faceLoop.edges.size(); ++i) {
                EdgeUse edgeUse = faceLoop.edges.get(i);
                if (edgeUse.edge != edge) continue;
                return new FaceEdgeInsert(faceLoop, i);
            }
        }
        return null;
    }

    private static FaceEdgeInsert[] findInsertPos(Face face, Vertex vertex, Vertex vertex2, IParametric3D iParametric3D) {
        FaceEdgeInsert faceEdgeInsert = Model.findInsertPos(face, vertex, iParametric3D, true);
        if (faceEdgeInsert == null) {
            return null;
        }
        FaceEdgeInsert faceEdgeInsert2 = Model.findInsertPos(face, vertex2, iParametric3D, false);
        if (faceEdgeInsert2 == null) {
            return null;
        }
        return new FaceEdgeInsert[]{faceEdgeInsert, faceEdgeInsert2};
    }

    private static FaceEdgeInsert findInsertPos(Face face, Vertex vertex, IParametric3D iParametric3D, boolean bl) {
        Vector3d vector3d;
        FaceEdgeInsert faceEdgeInsert = new FaceEdgeInsert();
        for (FaceLoop faceLoop : face.edgeLoops) {
            if (faceLoop.vert != vertex) continue;
            faceEdgeInsert.loop = faceLoop;
            faceEdgeInsert.edgeIx = 0;
            return faceEdgeInsert;
        }
        Vector3d vector3d2 = face.plane.getNormal();
        double d = Double.MAX_VALUE;
        if (bl) {
            vector3d = iParametric3D.getTangent(0.0);
        } else {
            vector3d = iParametric3D.getTangent(1.0);
            vector3d.negate();
        }
        for (FaceLoop faceLoop : face.edgeLoops) {
            if (faceLoop.vert != null) continue;
            ListIterator<EdgeUse> listIterator = faceLoop.edges.listIterator();
            while (listIterator.hasNext()) {
                EdgeUse edgeUse = listIterator.next();
                if (edgeUse.v2() != vertex) continue;
                Vector3d vector3d3 = edgeUse.curve().getTangent(1.0);
                vector3d3.negate();
                double d2 = Util3D.angle0To2PI(vector3d, vector3d3, vector3d2);
                if (!(d2 < d)) continue;
                d = d2;
                faceEdgeInsert.loop = faceLoop;
                faceEdgeInsert.edgeIx = listIterator.nextIndex();
            }
        }
        if (faceEdgeInsert.loop == null) {
            return null;
        }
        EdgeUse edgeUse = faceEdgeInsert.edgeIx == faceEdgeInsert.loop.edges.size() ? faceEdgeInsert.loop.edges.get(0) : faceEdgeInsert.loop.edges.get(faceEdgeInsert.edgeIx);
        double d3 = Util3D.angle0To2PI(vector3d, edgeUse.getTangent(0.0), vector3d2);
        if (d3 < d) {
            return null;
        }
        return faceEdgeInsert;
    }

    private Edge addEdgeToRegion(IParametric3D iParametric3D, Vertex vertex, Vertex vertex2, int ... nArray) {
        Edge edge = new Edge(vertex, vertex2, iParametric3D);
        this.addToGroups(edge, nArray);
        edge.buildConnections();
        this.updateEdgeSearch(edge, 0);
        return edge;
    }

    private Face addFaceToRegion(Plane3d plane3d, List<EdgeUse> list, List<Vertex> list2, int ... nArray) {
        return this.addFaceToRegion(plane3d, list, list2, true, nArray);
    }

    private Face addFaceToRegion(Plane3d plane3d, List<EdgeUse> list, List<Vertex> list2, boolean bl, int ... nArray) {
        ArrayList<FaceLoop> arrayList = new ArrayList<FaceLoop>();
        assert (!list.isEmpty());
        FaceLoop faceLoop = new FaceLoop();
        EdgeUse edgeUse = list.get(0);
        faceLoop.edges.add(edgeUse);
        for (int i = 1; i < list.size(); ++i) {
            EdgeUse serializable = list.get(i);
            if (serializable.v1() != edgeUse.v2()) {
                arrayList.add(faceLoop);
                faceLoop = new FaceLoop();
            }
            faceLoop.edges.add(serializable);
            edgeUse = serializable;
        }
        arrayList.add(faceLoop);
        for (Vertex vertex : list2) {
            FaceLoop faceLoop2 = new FaceLoop();
            faceLoop2.vert = vertex;
            arrayList.add(faceLoop2);
        }
        Face face = new Face(plane3d, arrayList, bl);
        this.addToGroups(face, nArray);
        face.buildConnections();
        this.updateFaceSearch(face, 0);
        return face;
    }

    public void updateVertexSearch(Vertex vertex, int n) {
        this.updateSearch(this.d_vertSearch, vertex, n);
    }

    public void updateEdgeSearch(Edge edge, int n) {
        this.updateSearch(this.d_edgeSearch, edge, n);
    }

    public void updateFaceSearch(Face face, int n) {
        this.updateSearch(this.d_faceSearch, face, n);
    }

    private <T extends AModelObj> void updateSearch(GeomSearcher<T> geomSearcher, T t, int n) {
        switch (n) {
            case 0: {
                geomSearcher.add(t);
                break;
            }
            case 1: {
                geomSearcher.update(t);
                break;
            }
            case 2: {
                geomSearcher.remove(t);
            }
        }
    }

    public List<Vertex> findVerts(AABox aABox) {
        return Model.find(this.d_vertSearch, aABox);
    }

    public List<Vertex> findVerts(ITest<AABox> iTest) {
        return Model.find(this.d_vertSearch, iTest);
    }

    public List<Edge> findEdges(AABox aABox) {
        return Model.find(this.d_edgeSearch, aABox);
    }

    public List<Edge> findEdge(ITest<AABox> iTest) {
        return Model.find(this.d_edgeSearch, iTest);
    }

    public List<Face> findFaces(AABox aABox) {
        return Model.find(this.d_faceSearch, aABox);
    }

    public List<Face> findFaces(ITest<AABox> iTest) {
        return Model.find(this.d_faceSearch, iTest);
    }

    private static <T extends AModelObj> List<T> find(GeomSearcher<T> geomSearcher, AABox aABox) {
        return geomSearcher.find(new AABoxTest(aABox, 1.0E-6));
    }

    private static <T extends AModelObj> List<T> find(GeomSearcher<T> geomSearcher, ITest<AABox> iTest) {
        return geomSearcher.find(iTest);
    }

    public Face findFace(Point3d point3d) {
        Face face = null;
        double d = Double.MAX_VALUE;
        for (Face face2 : this.findFaces(new AABox(point3d, point3d))) {
            double d2;
            Point3d point3d2 = this.pointInFace(face2, point3d);
            if (point3d2 == null || !((d2 = point3d2.distanceSquared(point3d)) < d)) continue;
            face = face2;
            d = d2;
        }
        return face;
    }

    public void merge(Model model) {
        int n = this.d_mainGroup.verts.size() + this.d_mainGroup.edges.size() + this.d_mainGroup.faces.size();
        int n2 = model.d_mainGroup.verts.size() + model.d_mainGroup.edges.size() + model.d_mainGroup.faces.size();
        if (n2 > n) {
            model.forceMerge(this);
            Cloneable cloneable = this.d_edgeSearch;
            this.d_edgeSearch = model.d_edgeSearch;
            model.d_edgeSearch = cloneable;
            cloneable = this.d_faceSearch;
            this.d_faceSearch = model.d_faceSearch;
            model.d_faceSearch = cloneable;
            cloneable = this.d_vertSearch;
            this.d_vertSearch = model.d_vertSearch;
            model.d_vertSearch = cloneable;
            cloneable = this.d_mainGroup;
            this.d_mainGroup = model.d_mainGroup;
            model.d_mainGroup = (Group)cloneable;
        } else {
            this.forceMerge(model);
        }
    }

    public void forceMerge(Model model) {
        LinkedIdentityHashMap<Vertex, Vertex> linkedIdentityHashMap = new LinkedIdentityHashMap<Vertex, Vertex>();
        LinkedIdentityHashMap<Vertex, Vertex> linkedIdentityHashMap2 = new LinkedIdentityHashMap<Vertex, Vertex>();
        LinkedIdentityHashMap<Edge, Edge> linkedIdentityHashMap3 = new LinkedIdentityHashMap<Edge, Edge>();
        LinkedIdentityHashMap<Edge, Edge> linkedIdentityHashMap4 = new LinkedIdentityHashMap<Edge, Edge>();
        LinkedIdentityHashMap<Face, Face> linkedIdentityHashMap5 = new LinkedIdentityHashMap<Face, Face>();
        for (Vertex cloneable2 : model.d_mainGroup.verts) {
            Model.setMate(linkedIdentityHashMap2, cloneable2, null);
        }
        for (Edge edge : model.d_mainGroup.edges) {
            Model.setMate(linkedIdentityHashMap4, edge, null);
        }
        for (Face face : model.d_mainGroup.faces) {
            Model.setMate(linkedIdentityHashMap5, face, null);
        }
        Stack stack = new Stack();
        Stack<Face> stack2 = new Stack<Face>();
        Model.vv(this, model, linkedIdentityHashMap, linkedIdentityHashMap2);
        Model.ve(this, model, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap3, linkedIdentityHashMap4);
        Model.vf(this, model, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap5);
        Model.vr(this, model, linkedIdentityHashMap, linkedIdentityHashMap2);
        Model.ee(this, model, stack, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap3, linkedIdentityHashMap4);
        Model.ef(this, model, stack, stack2, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap3, linkedIdentityHashMap4, linkedIdentityHashMap5);
        Model.er(this, model, linkedIdentityHashMap2, linkedIdentityHashMap4);
        Model.ff(this, model, stack2, linkedIdentityHashMap, linkedIdentityHashMap2, linkedIdentityHashMap3, linkedIdentityHashMap4, linkedIdentityHashMap5);
        Model.fr(this, model, linkedIdentityHashMap2, linkedIdentityHashMap4, linkedIdentityHashMap5);
    }

    private static <T> void setMate(Map<T, T> map, T t, T t2) {
        map.put(t, t2);
    }

    private static <T> void setMates(Map<T, T> map, Map<T, T> map2, T t, T t2) {
        map.put(t, t2);
        map2.put(t2, t);
    }

    private static <T> T getMate(Map<T, T> map, T t) {
        return map.get(t);
    }

    private void debugFindVert(Point3d point3d, int n) {
    }

    private static void vv(Model model, Model model2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2) {
        for (Vertex vertex : map2.keySet()) {
            Vertex vertex2 = model.findVertex(vertex.loc);
            if (vertex2 == null) continue;
            Model.setMates(map, map2, vertex2, vertex);
            vertex2.addGroups(vertex.groups);
            vertex.addGroups(vertex2.groups);
        }
    }

    private static void ve(Model model, Model model2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Edge, Edge> map3, Map<Edge, Edge> map4) {
        Cloneable cloneable;
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        for (Edge object3 : map4.keySet()) {
            for (Vertex vertex : model.findVerts(object3.getBounds())) {
                if (map.get(vertex) != null) continue;
                linkedIdentityHashSet.add(vertex);
            }
        }
        for (Vertex vertex : linkedIdentityHashSet) {
            double d = 0.0;
            Point3d point3d = null;
            cloneable = null;
            double d2 = 1.0E-6;
            for (Edge edge : model2.findEdges(vertex.getBounds())) {
                double d3 = edge.curve.getClosestT(vertex.loc);
                Point3d point3d2 = edge.curve.get(d3);
                double d4 = point3d2.distance(vertex.loc);
                if (!(d4 <= d2)) continue;
                d2 = d4;
                cloneable = edge;
                point3d = point3d2;
                d = d3;
            }
            if (cloneable == null) continue;
            model2.debugFindVert(point3d, 600116);
            Object object = NmtUtil.mergeGroupIds(vertex.groups, cloneable.groups);
            vertex.groups = (int[])object;
            Vertex vertex2 = model2.addVertexToRegion(point3d, (int[])object);
            Edge edge = model2.addVertexToEdge((Edge)cloneable, d, vertex2);
            Model.setMates(map, map2, vertex, vertex2);
            Model.setMate(map4, edge, null);
        }
        for (Map.Entry entry : map2.entrySet()) {
            AModelObj aModelObj3;
            if (entry.getValue() != null) continue;
            Vertex vertex = (Vertex)entry.getKey();
            double d = 0.0;
            cloneable = null;
            AModelObj aModelObj2 = null;
            double d5 = 1.0E-6;
            for (AModelObj aModelObj3 : model.findEdges(vertex.getBounds())) {
                double d6 = aModelObj3.curve.getClosestT(vertex.loc);
                Point3d point3d = aModelObj3.curve.get(d6);
                double d7 = point3d.distance(vertex.loc);
                if (!(d7 <= d5)) continue;
                d5 = d7;
                aModelObj2 = aModelObj3;
                cloneable = point3d;
                d = d6;
            }
            if (aModelObj2 == null) continue;
            model.debugFindVert((Point3d)cloneable, 593789949);
            int[] nArray = NmtUtil.mergeGroupIds(vertex.groups, aModelObj2.groups);
            vertex.groups = nArray;
            aModelObj3 = model.addVertexToRegion((Point3d)cloneable, nArray);
            Edge edge = model.addVertexToEdge((Edge)aModelObj2, d, (Vertex)aModelObj3);
            Model.setMates(map, map2, aModelObj3, vertex);
            Model.setMate(map3, edge, null);
        }
    }

    private static void vf(Model model, Model model2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Face, Face> map3) {
        Cloneable cloneable3;
        Object object;
        Cloneable cloneable2;
        Object object2;
        LinkedIdentityHashMap<Vertex, ArrayList<Face>> linkedIdentityHashMap = new LinkedIdentityHashMap<Vertex, ArrayList<Face>>();
        for (Face object5 : map3.keySet()) {
            for (Vertex vertex : model.findVerts(object5.getBounds())) {
                if (map.get(vertex) != null) continue;
                ArrayList<Face> arrayList = (ArrayList<Face>)linkedIdentityHashMap.get(vertex);
                if (arrayList == null) {
                    arrayList = new ArrayList<Face>(2);
                    linkedIdentityHashMap.put(vertex, arrayList);
                }
                arrayList.add(object5);
            }
        }
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            object2 = (Vertex)entry.getKey();
            List list = (List)entry.getValue();
            double d = Double.MAX_VALUE;
            cloneable2 = null;
            object = null;
            for (Cloneable cloneable3 : list) {
                double d2;
                Point3d point3d = model2.pointInFace((Face)cloneable3, ((Vertex)object2).loc);
                if (point3d == null || !((d2 = point3d.distance(((Vertex)object2).loc)) < d)) continue;
                d = d2;
                cloneable2 = point3d;
                object = cloneable3;
            }
            if (object == null) continue;
            model2.debugFindVert((Point3d)cloneable2, 153352767);
            int[] nArray = NmtUtil.mergeGroupIds(((Vertex)object2).groups, ((Face)object).groups);
            ((Vertex)object2).groups = nArray;
            cloneable3 = model2.addVertexToRegion((Point3d)cloneable2, nArray);
            model2.addVertexToFace((Face)object, (Vertex)cloneable3);
            Model.setMates(map, map2, object2, cloneable3);
        }
        for (Map.Entry entry : map2.entrySet()) {
            if (entry.getValue() != null) continue;
            object2 = (Vertex)entry.getKey();
            double d = Double.MAX_VALUE;
            Cloneable cloneable4 = null;
            cloneable2 = null;
            for (Face face : model.findFaces(((Vertex)object2).getBounds())) {
                double d3;
                cloneable3 = model.pointInFace(face, ((Vertex)object2).loc);
                if (cloneable3 == null || !((d3 = ((Point3d)cloneable3).distance(((Vertex)object2).loc)) < d)) continue;
                d = d3;
                cloneable4 = cloneable3;
                cloneable2 = face;
            }
            if (cloneable2 == null) continue;
            model.debugFindVert((Point3d)cloneable4, 35882234);
            object = NmtUtil.mergeGroupIds(((Vertex)object2).groups, ((Face)cloneable2).groups);
            Vertex vertex = model.addVertexToRegion((Point3d)cloneable4, (int[])object);
            ((Vertex)object2).groups = (int[])object;
            model.addVertexToFace((Face)cloneable2, vertex);
            Model.setMates(map, map2, vertex, object2);
        }
    }

    private static void vr(Model model, Model model2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2) {
        for (Map.Entry<Vertex, Vertex> entry : map2.entrySet()) {
            if (entry.getValue() != null) continue;
            Vertex vertex = entry.getKey();
            model.debugFindVert(vertex.loc, 215290);
            Vertex vertex2 = model.addVertexToRegion(vertex.loc, vertex.groups);
            Model.setMates(map, map2, vertex2, vertex);
        }
    }

    private static void ee(Model model, Model model2, Stack<Edge> stack, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Edge, Edge> map3, Map<Edge, Edge> map4) {
        for (Map.Entry<Edge, Edge> entry : map4.entrySet()) {
            if (entry.getValue() != null) continue;
            stack.push(entry.getKey());
        }
        block1: while (!stack.isEmpty()) {
            Edge edge;
            Map.Entry<Edge, Edge> entry;
            Edge edge2 = stack.pop();
            entry = model.findEdges(edge2.getBounds());
            boolean bl = false;
            Iterator iterator = entry.iterator();
            while (iterator.hasNext()) {
                edge = (Edge)iterator.next();
                if (!Model.compare(edge, edge2, map)) continue;
                edge.addGroups(edge2.groups);
                edge2.addGroups(edge.groups);
                Model.setMates(map3, map4, edge, edge2);
                bl = true;
                break;
            }
            if (bl) continue;
            iterator = entry.iterator();
            while (iterator.hasNext()) {
                edge = (Edge)iterator.next();
                double[] dArray = Model.isect(edge.curve, edge2.curve);
                if (dArray == null || dArray.length <= 0) continue;
                Point3d point3d = edge.curve.get(dArray[0]);
                Point3d point3d2 = edge2.curve.get(dArray[1]);
                if (Model.compare(point3d, edge.curve.get(0.0)) || Model.compare(point3d, edge.curve.get(1.0)) || Model.compare(point3d2, edge2.curve.get(0.0)) || Model.compare(point3d2, edge2.curve.get(1.0))) continue;
                int[] nArray = NmtUtil.mergeGroupIds(edge.groups, edge2.groups);
                model.debugFindVert(point3d, 65167);
                Vertex vertex = model.addVertexToRegion(point3d, nArray);
                Edge edge3 = model.addVertexToEdge(edge, dArray[0], vertex);
                model2.debugFindVert(point3d2, 63485);
                Vertex vertex2 = model2.addVertexToRegion(point3d2, nArray);
                Edge edge4 = model2.addVertexToEdge(edge2, dArray[1], vertex2);
                Model.setMates(map, map2, vertex, vertex2);
                Model.setMate(map3, edge3, null);
                Model.setMate(map4, edge4, null);
                stack.push(edge2);
                stack.push(edge4);
                continue block1;
            }
        }
    }

    private static void ef(Model model, Model model2, Stack<Edge> stack, Stack<Face> stack2, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Edge, Edge> map3, Map<Edge, Edge> map4, Map<Face, Face> map5) {
        Vertex vertex;
        Edge edge;
        Vertex vertex2;
        int[] nArray;
        Point3d point3d;
        Object object;
        Object object2;
        Cloneable cloneable;
        Object object3;
        Object object4;
        for (Face entry : map5.keySet()) {
            stack2.push(entry);
        }
        while (!stack2.isEmpty()) {
            object4 = stack2.pop();
            for (Edge edge2 : model.findEdges(((Face)object4).getBounds())) {
                if (map3.get(edge2) != null) continue;
                if (Model.curveOnSurface(edge2.curve, (Face)object4)) {
                    object3 = Model.getMate(map, edge2.v1);
                    cloneable = Model.getMate(map, edge2.v2);
                    if (object3 == null || cloneable == null || (object2 = Model.findInsertPos((Face)object4, (Vertex)object3, cloneable, edge2.curve)) == null) continue;
                    object = NmtUtil.mergeGroupIds(edge2.groups, ((Face)object4).groups);
                    edge2.groups = (int[])object;
                    Edge edge3 = model2.addEdgeToRegion(edge2.curve, (Vertex)object3, (Vertex)cloneable, (int[])object);
                    Face face = model2.addEdgeToFace((Face)object4, edge3, object2[0], object2[1]);
                    Model.setMates(map3, map4, edge2, edge3);
                    if (face == null) continue;
                    Model.setMate(map5, face, null);
                    stack2.push(face);
                    continue;
                }
                object3 = model2.isect(edge2.curve, (Face)object4);
                if (object3 == null || ((Object)object3).length <= 0) continue;
                cloneable = edge2.curve.get(0.0);
                object2 = edge2.curve.get(1.0);
                assert (((Object)object3).length == 1);
                for (Object object5 : object3) {
                    point3d = edge2.curve.get((double)object5);
                    if (Model.compare(point3d, (Point3d)cloneable) || Model.compare(point3d, (Point3d)object2)) continue;
                    nArray = NmtUtil.mergeGroupIds(edge2.groups, ((Face)object4).groups);
                    model.debugFindVert(point3d, 2751);
                    vertex2 = model.addVertexToRegion(point3d, nArray);
                    edge = model.addVertexToEdge(edge2, (double)object5, vertex2);
                    model2.debugFindVert(point3d, 403279);
                    vertex = model2.addVertexToRegion(point3d, nArray);
                    model2.addVertexToFace((Face)object4, vertex);
                    Model.setMates(map, map2, vertex2, vertex);
                    Model.setMate(map3, edge, null);
                }
            }
        }
        for (Map.Entry<Edge, Edge> entry : map4.entrySet()) {
            if (entry.getValue() != null) continue;
            stack.push(entry.getKey());
        }
        block5: while (!stack.isEmpty()) {
            object4 = stack.pop();
            for (Face face : model.findFaces(((Edge)object4).getBounds())) {
                if (Model.curveOnSurface(((Edge)object4).curve, face)) {
                    object3 = Model.getMate(map2, ((Edge)object4).v1);
                    cloneable = Model.getMate(map2, ((Edge)object4).v2);
                    if (object3 == null || cloneable == null) {
                        System.err.println("2 Missing a vertex mate for " + object4);
                        continue;
                    }
                    object2 = Model.findInsertPos(face, (Vertex)object3, cloneable, ((Edge)object4).curve);
                    if (object2 == null) continue;
                    object = NmtUtil.mergeGroupIds(((Edge)object4).groups, face.groups);
                    ((Edge)object4).groups = (int[])object;
                    Edge edge4 = model.addEdgeToRegion(((Edge)object4).curve, (Vertex)object3, (Vertex)cloneable, (int[])object);
                    model.addEdgeToFace(face, edge4, object2[0], object2[1]);
                    Model.setMates(map3, map4, edge4, object4);
                    continue block5;
                }
                object3 = model.isect(((Edge)object4).curve, face);
                if (object3 == null || ((Object)object3).length <= 0) continue;
                cloneable = ((Edge)object4).curve.get(0.0);
                object2 = ((Edge)object4).curve.get(1.0);
                assert (((Object)object3).length == 1);
                for (Object object5 : object3) {
                    point3d = ((Edge)object4).curve.get((double)object5);
                    if (Model.compare(point3d, (Point3d)cloneable) || Model.compare(point3d, (Point3d)object2)) continue;
                    nArray = NmtUtil.mergeGroupIds(face.groups, ((Edge)object4).groups);
                    model2.debugFindVert(point3d, 74655);
                    vertex2 = model2.addVertexToRegion(point3d, nArray);
                    edge = model2.addVertexToEdge((Edge)object4, (double)object5, vertex2);
                    model.debugFindVert(point3d, 156815);
                    vertex = model.addVertexToRegion(point3d, nArray);
                    model.addVertexToFace(face, vertex);
                    Model.setMates(map, map2, vertex, vertex2);
                    Model.setMate(map4, edge, null);
                    stack.push(edge);
                }
            }
        }
    }

    private static void er(Model model, Model model2, Map<Vertex, Vertex> map, Map<Edge, Edge> map2) {
        for (Map.Entry<Edge, Edge> entry : map2.entrySet()) {
            if (entry.getValue() != null) continue;
            Edge edge = entry.getKey();
            Vertex vertex = Model.getMate(map, edge.v1);
            Vertex vertex2 = Model.getMate(map, edge.v2);
            if (vertex == null || vertex2 == null) {
                System.err.println("3 Missing a vertex mate for " + edge);
                continue;
            }
            Edge edge2 = model.addEdgeToRegion(edge.curve, vertex, vertex2, edge.groups);
            Model.setMate(map2, edge, edge2);
        }
    }

    private static void ff(Model model, Model model2, Stack<Face> stack, Map<Vertex, Vertex> map, Map<Vertex, Vertex> map2, Map<Edge, Edge> map3, Map<Edge, Edge> map4, Map<Face, Face> map5) {
        for (Map.Entry<Face, Face> entry : map5.entrySet()) {
            if (entry.getValue() != null) continue;
            stack.push(entry.getKey());
        }
        block1: while (!stack.isEmpty()) {
            Face face = stack.pop();
            boolean bl = false;
            List<Face> list = model.findFaces(face.getBounds());
            if (list.isEmpty()) continue;
            for (Face face2 : list) {
                if (!Model.compare(face2, face, map, map3)) continue;
                face2.addGroups(face.groups);
                face.addGroups(face2.groups);
                Model.setMate(map5, face, face2);
                bl = true;
                break;
            }
            if (bl) continue;
            IdentityHashSet identityHashSet = new IdentityHashSet();
            for (Serializable serializable : face.edgeLoops) {
                for (Vertex vertex : Vertices.get(serializable)) {
                    identityHashSet.add(vertex);
                }
            }
            for (Serializable serializable : list) {
                Object object;
                Object object2;
                LineSeg3D lineSeg3D = Model.isect(((Face)serializable).plane, face.plane);
                if (lineSeg3D == null) continue;
                TreeMap<Double, Pair<Vertex, Object>> treeMap = new TreeMap<Double, Pair<Vertex, Object>>();
                for (int i = 0; i < ((Face)serializable).edgeLoops.size(); ++i) {
                    object2 = ((Face)serializable).edgeLoops.get(i);
                    for (Vertex vertex : Vertices.get((FaceLoop)object2)) {
                        object = map.get(vertex);
                        if (object == null || !identityHashSet.contains(object)) continue;
                        double d = Util3D.tOnLineSeg(lineSeg3D.p1, lineSeg3D.p2, vertex.loc);
                        treeMap.put(d, new Pair<Vertex, Object>(vertex, object));
                    }
                }
                if (treeMap.size() <= 1) continue;
                int[] nArray = NmtUtil.mergeGroupIds(((Face)serializable).groups, face.groups);
                object2 = treeMap.entrySet().iterator();
                Object object3 = (Map.Entry)object2.next();
                boolean bl2 = false;
                while (object2.hasNext()) {
                    FaceEdgeInsert[] faceEdgeInsertArray;
                    FaceEdgeInsert[] faceEdgeInsertArray2;
                    object = (Map.Entry)object2.next();
                    Point3d point3d = lineSeg3D.get((Double)object3.getKey());
                    Point3d point3d2 = lineSeg3D.get((Double)object.getKey());
                    Vertex vertex = (Vertex)((Pair)object.getValue()).v1;
                    Vertex vertex2 = (Vertex)((Pair)object3.getValue()).v1;
                    Vertex vertex3 = (Vertex)((Pair)object.getValue()).v2;
                    Vertex vertex4 = (Vertex)((Pair)object3.getValue()).v2;
                    object3 = object;
                    if (point3d.distance(point3d2) < 2.0E-6) continue;
                    LineSeg3D lineSeg3D2 = new LineSeg3D(vertex.loc, vertex2.loc);
                    LineSeg3D lineSeg3D3 = new LineSeg3D(vertex3.loc, vertex4.loc);
                    if (model.findEdge(lineSeg3D2, vertex, vertex2) || model2.findEdge(lineSeg3D3, vertex3, vertex4) || (faceEdgeInsertArray2 = Model.findInsertPos((Face)serializable, vertex, vertex2, lineSeg3D2)) == null || (faceEdgeInsertArray = Model.findInsertPos(face, vertex3, vertex4, lineSeg3D3)) == null) continue;
                    Edge edge = model.addEdgeToRegion(lineSeg3D2, vertex, vertex2, nArray);
                    Edge edge2 = model2.addEdgeToRegion(lineSeg3D3, vertex3, vertex4, nArray);
                    Model.setMates(map3, map4, edge, edge2);
                    Face face3 = model.addEdgeToFace((Face)serializable, edge, faceEdgeInsertArray2[0], faceEdgeInsertArray2[1]);
                    Face face4 = model2.addEdgeToFace(face, edge2, faceEdgeInsertArray[0], faceEdgeInsertArray[1]);
                    if (face4 != null) {
                        Model.setMate(map5, face4, null);
                        stack.push(face4);
                    }
                    if (face3 == null && face4 == null) continue;
                    bl2 = true;
                    stack.push(face);
                    break;
                }
                if (!bl2) continue;
                continue block1;
            }
        }
    }

    private static void fr(Model model, Model model2, Map<Vertex, Vertex> map, Map<Edge, Edge> map2, Map<Face, Face> map3) {
        for (Map.Entry<Face, Face> entry : map3.entrySet()) {
            if (entry.getValue() != null) continue;
            Face face = entry.getKey();
            ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
            ArrayList<EdgeUse> arrayList2 = new ArrayList<EdgeUse>();
            for (FaceLoop faceLoop : face.edgeLoops) {
                if (faceLoop.vert != null) {
                    Vertex vertex = Model.getMate(map, faceLoop.vert);
                    if (vertex == null) {
                        System.err.println("5 Missing a vertex mate for " + faceLoop.vert);
                        continue;
                    }
                    arrayList.add(vertex);
                }
                for (EdgeUse edgeUse : faceLoop.edges) {
                    Edge edge = Model.getMate(map2, edgeUse.edge);
                    Vertex vertex = Model.getMate(map, edgeUse.v1());
                    if (edge == null || vertex == null) {
                        System.err.println("6 Missing a vertex or edge mate for " + edgeUse.edge + " " + edgeUse.v1());
                        continue;
                    }
                    assert (edge != null && vertex != null);
                    boolean bl = edge.v1 == vertex;
                    arrayList2.add(new EdgeUse(edge, bl));
                }
            }
            Face face2 = model.addFaceToRegion(face.plane, arrayList2, arrayList, face.groups);
            Model.setMate(map3, face, face2);
        }
    }

    private Vertex findVertex(Point3d point3d) {
        double d = Double.MAX_VALUE;
        Vertex vertex = null;
        AABox aABox = new AABox(point3d);
        for (Vertex vertex2 : this.findVerts(aABox)) {
            double d2 = point3d.distanceSquared(vertex2.loc);
            if (!(d2 < d)) continue;
            d = d2;
            vertex = vertex2;
        }
        return vertex != null && Math.sqrt(d) < 1.0E-6 ? vertex : null;
    }

    private boolean findEdge(IParametric3D iParametric3D, Vertex vertex, Vertex vertex2) {
        if (vertex.edges.size() > vertex2.edges.size()) {
            Vertex vertex3 = vertex;
            vertex = vertex2;
            vertex2 = vertex3;
        }
        for (int i = 0; i < vertex.edges.size(); ++i) {
            Vertex vertex4;
            Edge edge = vertex.edges.get(i);
            Vertex vertex5 = vertex4 = edge.v1 == vertex ? edge.v2 : edge.v1;
            if (vertex4 != vertex2) continue;
            return true;
        }
        return false;
    }

    private static boolean testPointInLoop(List<IParametric3D> list, Point3d point3d, Vector3d vector3d, boolean[] blArray) {
        int n = 0;
        double d = 1.0E-6 / vector3d.length();
        boolean bl = false;
        double[] dArray = new double[2];
        for (IParametric3D iParametric3D : list) {
            double d2;
            Point3d point3d2;
            Point3d point3d3 = iParametric3D.get(0.0);
            if (!Inter3D.copLineLineSeg(point3d, vector3d, point3d3, point3d2 = iParametric3D.get(1.0), dArray, 1.0E-6, d2 = 1.0E-6 / point3d3.distance(point3d2)) || !theUtil.ge0(dArray[0], d)) continue;
            if (theUtil.eq0(dArray[0], d)) {
                blArray[0] = true;
                return true;
            }
            if (theUtil.eq0(dArray[1], d2) || theUtil.eq(dArray[1], 1.0, d2)) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            return false;
        }
        blArray[0] = n % 2 != 0;
        return true;
    }

    private static double randomVecComp(Random random) {
        return random.nextDouble() * 2.0 - 1.0;
    }

    private static Vector3d newRandomVec2D(Random random) {
        return new Vector3d(Model.randomVecComp(random), Model.randomVecComp(random), 0.0);
    }

    private static Vector3d newRandomVec3D(Random random) {
        return new Vector3d(Model.randomVecComp(random), Model.randomVecComp(random), Model.randomVecComp(random));
    }

    private static boolean pointInLoop(List<IParametric3D> list, Plane3d plane3d, Point3d point3d) {
        Object object;
        Random random = new Random(1L);
        Matrix4d matrix4d = Util.getLocalToWorldXform(plane3d);
        int n = 3;
        for (int i = 0; i < n; ++i) {
            Vector3d object2 = Model.newRandomVec2D(random);
            matrix4d.transform(object2);
            object = new boolean[1];
            if (!Model.testPointInLoop(list, point3d, object2, object)) continue;
            return object[0];
        }
        for (IParametric3D iParametric3D : list) {
            boolean[] blArray;
            object = iParametric3D.get(0.5);
            Vector3d vector3d = Util3D.vector(point3d, (Point3d)object);
            if (vector3d.length() < 2.0E-6 || !Model.testPointInLoop(list, point3d, vector3d, blArray = new boolean[1])) continue;
            return blArray[0];
        }
        System.err.printf("No result found for pointInLoop %s%n", point3d.toString());
        return false;
    }

    private boolean testPointInEdgeLoop(Face face, Point3d point3d, Vector3d vector3d, AABox aABox, boolean[] blArray) {
        double[] dArray = Inter3D.rayAABoxIsect(point3d, vector3d, aABox.getMin(), aABox.getMax(), 1.0E-6);
        if (dArray != null) {
            Point3d point3d2 = Util3D.linePoint(point3d, vector3d, dArray[1]);
            List<Edge> list = Model.find(this.d_edgeSearch, new LineSegRTreeTest(point3d, point3d2));
            ArrayList<IParametric3D> arrayList = new ArrayList<IParametric3D>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Edge edge = list.get(i);
                if (!edge.faces.contains(face) || face.isInternalEdge(edge)) continue;
                arrayList.add(edge.curve);
            }
            return Model.testPointInLoop(arrayList, point3d, vector3d, blArray);
        }
        blArray[0] = false;
        return true;
    }

    private boolean pointInEdgeLoop(Face face, Plane3d plane3d, Point3d point3d, AABox aABox) {
        Serializable serializable;
        int n;
        boolean[] blArray = new boolean[1];
        Random random = new Random(1L);
        Matrix4d matrix4d = Util.getLocalToWorldXform(plane3d);
        int n2 = 3;
        for (n = 0; n < n2; ++n) {
            serializable = Model.newRandomVec2D(random);
            matrix4d.transform((Vector3d)serializable);
            if (!this.testPointInEdgeLoop(face, point3d, (Vector3d)serializable, aABox, blArray)) continue;
            return blArray[0];
        }
        for (n = 0; n < face.edgeLoops.size(); ++n) {
            serializable = face.edgeLoops.get(n);
            for (int i = 0; i < ((FaceLoop)serializable).edges.size(); ++i) {
                EdgeUse edgeUse = ((FaceLoop)serializable).edges.get(i);
                Point3d point3d2 = edgeUse.edge.curve.get(0.5);
                Vector3d vector3d = Util3D.vector(point3d, point3d2);
                if (vector3d.length() < 2.0E-6 || !this.testPointInEdgeLoop(face, point3d, vector3d, aABox, blArray)) continue;
                return blArray[0];
            }
        }
        System.err.printf("No result found for pointInLoop %s%n", point3d.toString());
        return false;
    }

    public Point3d pointInFace(Face face, Point3d point3d) {
        boolean bl;
        Point3d point3d2 = face.plane.projectOntoPlane(point3d);
        if (!Model.compare(point3d2, point3d) || !face.getBounds().contains(point3d, 1.0E-6)) {
            return null;
        }
        long l = System.nanoTime();
        int n = 0;
        for (FaceLoop serializable : face.edgeLoops) {
            n += serializable.edges.size();
        }
        if (n > 30) {
            bl = this.pointInEdgeLoop(face, face.plane, point3d2, face.getBounds());
        } else {
            ArrayList<IParametric3D> l2 = new ArrayList<IParametric3D>(n);
            for (int i = 0; i < face.edgeLoops.size(); ++i) {
                FaceLoop faceLoop = face.edgeLoops.get(i);
                for (int j = 0; j < faceLoop.edges.size(); ++j) {
                    l2.add(faceLoop.edges.get((int)j).edge.curve);
                }
            }
            bl = Model.pointInLoop(l2, face.plane, point3d2);
        }
        long l2 = System.nanoTime();
        t_pointInFace += (double)(l2 - l) * 1.0E-9;
        ++t_nPointInFace;
        return bl ? point3d2 : null;
    }

    private boolean pointInSolid(Collection<Face> collection, LineSeg3D lineSeg3D) {
        int n = 0;
        for (Face face : collection) {
            double[] dArray = this.isect(lineSeg3D, face);
            if (dArray == null || dArray.length <= 0) continue;
            if (Model.compare(lineSeg3D.get(dArray[0]), lineSeg3D.get(0.0))) {
                return true;
            }
            n += dArray.length;
        }
        return n % 2 != 0;
    }

    private boolean contains(Point3d point3d, Vector3d vector3d) {
        AABox aABox = this.getBoundingBox();
        if (!aABox.contains(point3d, 1.0E-6)) {
            return false;
        }
        double[] dArray = Inter3D.rayAABoxIsect(point3d, vector3d, aABox.getMin(), aABox.getMax(), 1.0E-6);
        if (dArray != null) {
            Point3d point3d2 = Util3D.linePoint(point3d, vector3d, dArray[1]);
            List<Face> list = Model.compare(point3d, point3d2) ? Model.find(this.d_faceSearch, new AABox(point3d)) : Model.find(this.d_faceSearch, new LineSegRTreeTest(point3d, point3d2));
            double d = Math.max(1.0, dArray[1] * 2.0);
            return this.pointInSolid(list, new LineSeg3D(point3d, Util3D.linePoint(point3d, vector3d, d)));
        }
        return false;
    }

    public boolean contains(Point3d point3d) {
        Random random = new Random(1L);
        Vector3d vector3d = Model.newRandomVec3D(random);
        return this.contains(point3d, vector3d);
    }

    private static boolean pointOnLoop(Point3d point3d, List<IParametric3D> list) {
        for (IParametric3D iParametric3D : list) {
            double d;
            Point3d point3d2 = iParametric3D.get(d = iParametric3D.getClosestT(point3d));
            if (!Model.compare(point3d2, point3d)) continue;
            return true;
        }
        return false;
    }

    private boolean pointOnBoundary(Point3d point3d, Face face) {
        int n = 0;
        for (FaceLoop serializable : face.edgeLoops) {
            n += serializable.edges.size();
        }
        if (n < 10) {
            for (FaceLoop faceLoop : face.edgeLoops) {
                if (!Model.pointOnLoop(point3d, faceLoop.getCurves())) continue;
                return true;
            }
        } else {
            for (Edge edge : this.findEdges(new AABox(point3d))) {
                double d;
                if (!edge.faces.contains(face) || !Model.compare(edge.curve.get(d = edge.curve.getClosestT(point3d)), point3d)) continue;
                return true;
            }
        }
        return false;
    }

    public static double[] isect(IParametric3D iParametric3D, IParametric3D iParametric3D2) {
        Point3d point3d = iParametric3D.get(0.0);
        Point3d point3d2 = iParametric3D.get(1.0);
        Point3d point3d3 = iParametric3D2.get(0.0);
        Point3d point3d4 = iParametric3D2.get(1.0);
        return Inter3D.lineSegLineSegIntersection(point3d, point3d2, point3d3, point3d4, 1.0E-6);
    }

    private static boolean compare(Edge edge, Edge edge2, Map<Vertex, Vertex> map) {
        Vertex vertex = map.get(edge.v1);
        Vertex vertex2 = map.get(edge.v2);
        return vertex == edge2.v1 && vertex2 == edge2.v2 || vertex == edge2.v2 && vertex2 == edge2.v1;
    }

    public double[] isect(IParametric3D iParametric3D, Face face) {
        double[] dArray = iParametric3D.getIsects(face.plane, 1.0E-6);
        if (dArray != null && dArray.length > 0) {
            ArrayList<Double> arrayList = new ArrayList<Double>(dArray.length);
            for (double d : dArray) {
                Point3d point3d = iParametric3D.get(d);
                if (this.pointInFace(face, point3d) == null) continue;
                arrayList.add(d);
            }
            return theUtil.toDoubleArray(arrayList);
        }
        return new double[0];
    }

    private static boolean compare(Face face, Face face2, Map<Vertex, Vertex> map, Map<Edge, Edge> map2) {
        if (face.edgeLoops.size() != face2.edgeLoops.size()) {
            return false;
        }
        for (FaceLoop faceLoop : face.edgeLoops) {
            boolean bl = false;
            for (FaceLoop faceLoop2 : face2.edgeLoops) {
                if (!Model.compare(faceLoop, faceLoop2, map, map2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean compare(FaceLoop faceLoop, FaceLoop faceLoop2, Map<Vertex, Vertex> map, Map<Edge, Edge> map2) {
        if (faceLoop.vert != null) {
            Vertex vertex = map.get(faceLoop.vert);
            return vertex != null && vertex == faceLoop2.vert;
        }
        if (faceLoop.edges.size() != faceLoop2.edges.size()) {
            return false;
        }
        for (EdgeUse edgeUse : faceLoop.edges) {
            Edge edge = map2.get(edgeUse.edge);
            if (edge == null) {
                return false;
            }
            boolean bl = false;
            for (EdgeUse edgeUse2 : faceLoop2.edges) {
                if (edgeUse2.edge != edge) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static boolean compare(Point3d point3d, Point3d point3d2) {
        double d = point3d.distance(point3d2);
        return d < 1.0E-6;
    }

    private static boolean curveOnSurface(IParametric3D iParametric3D, Face face) {
        double d = 1.0E-6;
        return face.plane.distance(iParametric3D.get(0.5)) <= d && face.plane.distance(iParametric3D.get(0.0)) <= d && face.plane.distance(iParametric3D.get(1.0)) <= d;
    }

    private static LineSeg3D isect(Plane3d plane3d, Plane3d plane3d2) {
        Tuple3d[] tuple3dArray = Inter3D.planePlaneIsect(plane3d, plane3d2, 1.0E-6);
        if (tuple3dArray == null) {
            return null;
        }
        return new LineSeg3D((Point3d)tuple3dArray[0], Util3D.add((Point3d)tuple3dArray[0], tuple3dArray[1]));
    }

    public void transform(Matrix4d matrix4d) {
        for (Vertex aModelObj : this.d_mainGroup.verts) {
            aModelObj.loc = Util3D.xform(matrix4d, aModelObj.loc);
            this.updateVertexSearch(aModelObj, 1);
        }
        for (Edge edge : this.d_mainGroup.edges) {
            edge.curve = edge.curve.transform(matrix4d);
            this.updateEdgeSearch(edge, 1);
        }
        for (Face face : this.d_mainGroup.faces) {
            face.calcPlane();
            face.invalidateBounds();
            this.updateFaceSearch(face, 1);
        }
    }

    public void optimize() {
        HashMap<IntArrHash, int[]> hashMap = new HashMap<IntArrHash, int[]>();
        Model.optimize(this.d_mainGroup.verts, hashMap);
        Model.optimize(this.d_mainGroup.edges, hashMap);
        Model.optimize(this.d_mainGroup.faces, hashMap);
    }

    private static void optimize(Collection<? extends AModelObj> collection, Map<IntArrHash, int[]> map) {
        for (AModelObj aModelObj : collection) {
            IntArrHash intArrHash = new IntArrHash(aModelObj.groups);
            int[] nArray = map.get(intArrHash);
            if (nArray == null) {
                map.put(intArrHash, aModelObj.groups);
                continue;
            }
            aModelObj.groups = nArray;
        }
    }

    public static class Vertices {
        public static Iterable<Vertex> get(final FaceLoop faceLoop) {
            return new Iterable<Vertex>(){

                @Override
                public Iterator<Vertex> iterator() {
                    return new LoopVertexIterator(faceLoop);
                }
            };
        }
    }

    public static class LoopVertexIterator
    implements Iterator<Vertex> {
        private final FaceLoop d_loop;
        private int d_index;

        public LoopVertexIterator(FaceLoop faceLoop) {
            this.d_loop = faceLoop;
            this.d_index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.d_loop.vert != null ? this.d_index == 0 : this.d_index < this.d_loop.edges.size();
        }

        @Override
        public Vertex next() {
            Vertex vertex = this.d_loop.vert != null ? this.d_loop.vert : this.d_loop.edges.get(this.d_index).v1();
            ++this.d_index;
            return vertex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntArrHash {
        public final int[] vals;

        public IntArrHash(int[] nArray) {
            this.vals = nArray;
        }

        public int hashCode() {
            int n = 0;
            for (int n2 : this.vals) {
                n += n2;
            }
            return n;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof IntArrHash && NmtUtil.equal(((IntArrHash)object).vals, this.vals);
        }
    }

    private static class FaceEdgeInsert {
        public FaceLoop loop;
        public int edgeIx;

        public FaceEdgeInsert() {
        }

        public FaceEdgeInsert(FaceLoop faceLoop, int n) {
            this.loop = faceLoop;
            this.edgeIx = n;
        }
    }

    private static class CrossoverSearcher<T extends AModelObj>
    implements GeomSearcher<T> {
        private static final int CROSSOVER = 30;
        private RTree<T> d_searchTree;
        private AABox d_cachedBounds;
        private Map<T, AABox> d_boxCache = new LinkedIdentityHashMap<T, AABox>();

        private CrossoverSearcher() {
        }

        @Override
        public void add(T t) {
            if (this.d_boxCache != null) {
                this.d_boxCache.put(t, ((AModelObj)t).getBounds());
                if (this.d_boxCache.size() == 30) {
                    this.d_searchTree = new RTree();
                    for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                        this.d_searchTree.insert((ISearchVol)entry.getValue(), entry.getKey());
                    }
                    this.d_boxCache = null;
                }
            } else {
                this.d_searchTree.insert(((AModelObj)t).getBounds(), t);
            }
            this.d_cachedBounds = null;
        }

        @Override
        public void remove(T t) {
            if (this.d_searchTree != null) {
                this.d_searchTree.remove(t);
                if (this.d_searchTree.count() == 29) {
                    this.d_boxCache = this.d_searchTree.getCachedBounds();
                    this.d_boxCache.remove(t);
                    this.d_searchTree = null;
                }
            } else {
                this.d_boxCache.remove(t);
            }
            this.d_cachedBounds = null;
        }

        @Override
        public void update(T t) {
            if (this.d_searchTree != null) {
                this.d_searchTree.remove(t);
                this.d_searchTree.insert(((AModelObj)t).getBounds(), t);
            } else {
                this.d_boxCache.remove(t);
                this.d_boxCache.put(t, ((AModelObj)t).getBounds());
            }
            this.d_cachedBounds = null;
        }

        @Override
        public void clear() {
            this.d_boxCache = new LinkedIdentityHashMap<T, AABox>();
            this.d_searchTree = null;
            this.d_cachedBounds = null;
        }

        @Override
        public List<T> find(ITest<AABox> iTest) {
            ArrayList<T> arrayList = new ArrayList<T>();
            if (this.d_searchTree != null) {
                this.d_searchTree.find(iTest, (IResult<T>)new CollResult(arrayList));
            } else {
                for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                    if (!iTest.test((AABox)entry.getValue()).positive) continue;
                    arrayList.add(entry.getKey());
                }
            }
            return arrayList;
        }

        @Override
        public GeomSearcher<T> clone(Map<T, T> map) {
            CrossoverSearcher crossoverSearcher;
            try {
                crossoverSearcher = (CrossoverSearcher)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            if (this.d_boxCache != null) {
                crossoverSearcher.d_boxCache = new LinkedIdentityHashMap<T, AABox>(this.d_boxCache.size());
                for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                    crossoverSearcher.d_boxCache.put(map.get(entry.getKey()), entry.getValue());
                }
            } else {
                crossoverSearcher.d_searchTree = this.d_searchTree.clone(map);
            }
            if (this.d_cachedBounds != null) {
                crossoverSearcher.d_cachedBounds = (AABox)this.d_cachedBounds.clone();
            }
            return crossoverSearcher;
        }

        @Override
        public AABox getBounds() {
            if (this.d_searchTree != null) {
                return this.d_searchTree.getBoundingBox();
            }
            if (this.d_cachedBounds == null) {
                this.d_cachedBounds = new AABox();
                for (AABox aABox : this.d_boxCache.values()) {
                    this.d_cachedBounds.add(aABox);
                }
            }
            return this.d_cachedBounds;
        }
    }

    private static class ListSearcher<T extends AModelObj>
    implements GeomSearcher<T> {
        private AABox d_cachedBounds;
        private Map<T, AABox> d_boxCache = new LinkedIdentityHashMap<T, AABox>();

        private ListSearcher() {
        }

        @Override
        public void add(T t) {
            this.d_boxCache.put(t, ((AModelObj)t).getBounds());
            this.d_cachedBounds = null;
        }

        @Override
        public void remove(T t) {
            this.d_boxCache.remove(t);
            this.d_cachedBounds = null;
        }

        @Override
        public void update(T t) {
            this.d_boxCache.remove(t);
            this.d_boxCache.put(t, ((AModelObj)t).getBounds());
            this.d_cachedBounds = null;
        }

        @Override
        public void clear() {
            this.d_boxCache = new LinkedIdentityHashMap<T, AABox>();
            this.d_cachedBounds = null;
        }

        @Override
        public List<T> find(ITest<AABox> iTest) {
            ArrayList<T> arrayList = new ArrayList<T>();
            for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                Containment containment = iTest.test(entry.getValue());
                if (!containment.positive) continue;
                arrayList.add(entry.getKey());
            }
            return arrayList;
        }

        @Override
        public GeomSearcher<T> clone(Map<T, T> map) {
            ListSearcher listSearcher;
            try {
                listSearcher = (ListSearcher)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            listSearcher.d_boxCache = new LinkedIdentityHashMap<T, AABox>(this.d_boxCache.size());
            for (Map.Entry<T, AABox> entry : this.d_boxCache.entrySet()) {
                listSearcher.d_boxCache.put(map.get(entry.getKey()), entry.getValue());
            }
            if (this.d_cachedBounds != null) {
                listSearcher.d_cachedBounds = (AABox)this.d_cachedBounds.clone();
            }
            return listSearcher;
        }

        @Override
        public AABox getBounds() {
            if (this.d_cachedBounds == null) {
                this.d_cachedBounds = new AABox();
                for (AABox aABox : this.d_boxCache.values()) {
                    this.d_cachedBounds.add(aABox);
                }
            }
            return this.d_cachedBounds;
        }
    }

    private static class TreeSearcher<T extends AModelObj>
    implements GeomSearcher<T> {
        private RTree<T> d_searchTree = new RTree();

        private TreeSearcher() {
        }

        @Override
        public void add(T t) {
            this.d_searchTree.insert(((AModelObj)t).getBounds(), t);
        }

        @Override
        public void remove(T t) {
            this.d_searchTree.remove(t);
        }

        @Override
        public void update(T t) {
            this.d_searchTree.remove(t);
            this.d_searchTree.insert(((AModelObj)t).getBounds(), t);
        }

        @Override
        public void clear() {
            this.d_searchTree.clear();
        }

        @Override
        public List<T> find(ITest<AABox> iTest) {
            ArrayList arrayList = new ArrayList();
            this.d_searchTree.find(iTest, (IResult<T>)new CollResult(arrayList));
            return arrayList;
        }

        @Override
        public GeomSearcher<T> clone(Map<T, T> map) {
            TreeSearcher treeSearcher;
            try {
                treeSearcher = (TreeSearcher)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            treeSearcher.d_searchTree = this.d_searchTree.clone(map);
            return treeSearcher;
        }

        @Override
        public AABox getBounds() {
            return this.d_searchTree.getBoundingBox();
        }
    }

    private static interface GeomSearcher<T extends AModelObj>
    extends Cloneable {
        public void add(T var1);

        public void remove(T var1);

        public void update(T var1);

        public void clear();

        public List<T> find(ITest<AABox> var1);

        public GeomSearcher<T> clone(Map<T, T> var1);

        public AABox getBounds();
    }

    public static class Group
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = 1L;
        public final int id;
        public final Collection<Face> faces;
        public final Collection<Edge> edges;
        public final Collection<Vertex> verts;

        public Group(int n, Class<? extends Collection> clazz) {
            this.id = n;
            this.faces = Group.newCollection(clazz);
            this.edges = Group.newCollection(clazz);
            this.verts = Group.newCollection(clazz);
        }

        private static <T> Collection<T> newCollection(Class<? extends Collection> clazz) {
            try {
                return clazz.newInstance();
            }
            catch (Exception exception) {
                return new ArrayList();
            }
        }

        public void add(AModelObj aModelObj) {
            if (aModelObj instanceof Vertex) {
                this.verts.add((Vertex)aModelObj);
            } else if (aModelObj instanceof Edge) {
                this.edges.add((Edge)aModelObj);
            } else if (aModelObj instanceof Face) {
                this.faces.add((Face)aModelObj);
            }
        }

        public void clear() {
            this.faces.clear();
            this.edges.clear();
            this.verts.clear();
        }
    }
}

