/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.CloneMap;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Edge;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Vertex;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;

public class FaceLoop
implements Serializable {
    static final long serialVersionUID = 1L;
    public final ArrayList<EdgeUse> edges = new ArrayList();
    public Vertex vert = null;

    public void flipOrient() {
        ArrayList<EdgeUse> arrayList = new ArrayList<EdgeUse>(this.edges.size());
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            EdgeUse edgeUse = this.edges.get(i);
            arrayList.add(new EdgeUse(edgeUse.edge, !edgeUse.orient));
        }
        this.edges.clear();
        this.edges.addAll(arrayList);
    }

    public List<IParametric3D> getCurves() {
        ArrayList<IParametric3D> arrayList = new ArrayList<IParametric3D>(this.edges.size());
        for (EdgeUse edgeUse : this.edges) {
            arrayList.add(edgeUse.curve());
        }
        return arrayList;
    }

    public Collection<Vertex> getVerts() {
        if (this.vert != null) {
            return Arrays.asList(this.vert);
        }
        LinkedIdentityHashSet<Vertex> linkedIdentityHashSet = new LinkedIdentityHashSet<Vertex>();
        for (EdgeUse edgeUse : this.edges) {
            linkedIdentityHashSet.add(edgeUse.edge.v1);
            linkedIdentityHashSet.add(edgeUse.edge.v2);
        }
        return linkedIdentityHashSet;
    }

    public boolean isValid() {
        return true;
    }

    public FaceLoop clone(CloneMap cloneMap) {
        FaceLoop faceLoop = new FaceLoop();
        if (this.vert != null) {
            faceLoop.vert = cloneMap.get(this.vert);
        }
        for (EdgeUse edgeUse : this.edges) {
            faceLoop.edges.add(edgeUse.clone(cloneMap));
        }
        return faceLoop;
    }

    public void addFace(Face face) {
        if (this.vert != null) {
            this.vert.face = face;
        } else {
            for (EdgeUse edgeUse : this.edges) {
                edgeUse.edge.addFace(face);
            }
        }
    }

    public void removeFace(Face face) {
        if (this.vert != null) {
            this.vert.face = null;
        } else {
            for (EdgeUse edgeUse : this.edges) {
                edgeUse.edge.faces.remove(face);
            }
        }
    }

    public boolean isOpen() {
        if (this.vert != null) {
            return false;
        }
        IdentityHashMap<Edge, Integer> identityHashMap = new IdentityHashMap<Edge, Integer>();
        for (EdgeUse serializable : this.edges) {
            Integer n = (Integer)identityHashMap.get(serializable.edge);
            if (n == null) {
                identityHashMap.put(serializable.edge, 1);
                continue;
            }
            identityHashMap.put(serializable.edge, n + 1);
        }
        for (Integer n : identityHashMap.values()) {
            if (n >= 2) continue;
            return true;
        }
        return false;
    }
}

