/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt;

import java.io.Serializable;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.TrimmedCurve3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.CloneMap;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Edge;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Vertex;

public class EdgeUse
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Edge edge;
    public final boolean orient;

    public EdgeUse(Edge edge, boolean bl) {
        this.edge = edge;
        this.orient = bl;
    }

    public Vertex v1() {
        return this.orient ? this.edge.v1 : this.edge.v2;
    }

    public Vertex v2() {
        return this.orient ? this.edge.v2 : this.edge.v1;
    }

    public IParametric3D curve() {
        return this.orient ? this.edge.curve : new TrimmedCurve3D(this.edge.curve, 1.0, 0.0);
    }

    public String toString() {
        return "[EdgeUse] " + this.orient + ": " + this.edge.v1 + " -> " + this.edge.v2;
    }

    public Vector3d getTangent(double d) {
        if (this.orient) {
            return this.edge.curve.getTangent(d);
        }
        Vector3d vector3d = this.edge.curve.getTangent(1.0 - d);
        vector3d.negate();
        return vector3d;
    }

    public EdgeUse reverse() {
        return new EdgeUse(this.edge, !this.orient);
    }

    public EdgeUse clone(CloneMap cloneMap) {
        return new EdgeUse(cloneMap.get(this.edge), this.orient);
    }
}

