/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry.manip;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.LineConstraint;

public abstract class APlaneHandle<T>
implements IHandle {
    private T d_geom;
    private Vector3d t_planeNormal;
    private Point3d t_pickLoc;
    private T t_origGeom;

    protected abstract Vector3d getPlaneNormal(T var1);

    protected abstract T modify(T var1, double var2);

    public APlaneHandle(T t) {
        this.d_geom = t;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof APlaneHandle;
    }

    public T getManipGeom() {
        return this.d_geom;
    }

    @Override
    public IIsectFilter getPickFilter() {
        return null;
    }

    @Override
    public ISnapConstraint getConstraint(Point3d point3d) {
        Vector3d vector3d = this.getPlaneNormal(this.d_geom);
        return new LineConstraint(point3d, vector3d);
    }

    @Override
    public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
        assert (iSnapConstraint instanceof LineConstraint);
        LineConstraint lineConstraint = (LineConstraint)iSnapConstraint;
        this.t_planeNormal = lineConstraint.dir;
        this.t_pickLoc = point3d;
        this.t_origGeom = this.d_geom;
    }

    @Override
    public Object modify(Point3d point3d) throws Exception {
        double d = Util3D.tOnLine(this.t_pickLoc, this.t_planeNormal, point3d);
        if (Double.isNaN(d)) {
            throw new Exception();
        }
        this.d_geom = this.modify(this.t_origGeom, d);
        return this.d_geom;
    }

    @Override
    public Object end() {
        this.t_pickLoc = null;
        this.t_planeNormal = null;
        this.t_origGeom = null;
        return this.d_geom;
    }
}

