/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Random;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter2D;
import pyrosim.legacy_2012_1.thunderheadeng.util.theMath;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Util2D {
    public static Point2d linePoint(Point2d point2d, Point2d point2d2, double d) {
        if (d == 1.0) {
            return new Point2d(point2d2);
        }
        return new Point2d(point2d.x + (point2d2.x - point2d.x) * d, point2d.y + (point2d2.y - point2d.y) * d);
    }

    public static Point2d linePoint(Point2d point2d, Vector2d vector2d, double d) {
        return new Point2d(point2d.x + vector2d.x * d, point2d.y + vector2d.y * d);
    }

    private static double dirDotTest(Vector2d vector2d, Vector2d vector2d2, double d) {
        double d2 = vector2d.lengthSquared();
        if (d2 <= d) {
            return Double.NaN;
        }
        double d3 = vector2d2.lengthSquared();
        if (d3 <= d) {
            return Double.NaN;
        }
        Vector2d vector2d3 = Util2D.scale(vector2d, 1.0 / Math.sqrt(d2));
        Vector2d vector2d4 = Util2D.scale(vector2d2, 1.0 / Math.sqrt(d3));
        return vector2d3.dot(vector2d4);
    }

    private static double randomVecComp(Random random) {
        return random.nextDouble() * 2.0 - 1.0;
    }

    public static Vector2d newRandomVec2D(Random random) {
        Vector2d vector2d = new Vector2d(Util2D.randomVecComp(random), Util2D.randomVecComp(random));
        vector2d.normalize();
        return vector2d;
    }

    public static boolean areLinesParallel(Vector2d vector2d, Vector2d vector2d2, double d) {
        double d2 = Util2D.dirDotTest(vector2d, vector2d2, d);
        return Double.isNaN(d2) || Math.abs(Math.abs(d2) - 1.0) <= d;
    }

    public static boolean areLinesAligned(Point2d point2d, Vector2d vector2d, Point2d point2d2, Vector2d vector2d2, double d) {
        return Util2D.areLinesParallel(vector2d, vector2d2, d) && Util2D.areLinesParallel(vector2d, Util2D.vector(point2d, point2d2), d);
    }

    public static boolean areLineSegsAligned(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4, double d) {
        Vector2d vector2d = Util2D.vector(point2d, point2d2);
        Vector2d vector2d2 = Util2D.vector(point2d3, point2d4);
        double d2 = Inter2D.nearestPtOnLine(point2d, vector2d, point2d3).distanceLinf(point2d3);
        double d3 = Inter2D.nearestPtOnLine(point2d, vector2d, point2d4).distanceLinf(point2d4);
        double d4 = Inter2D.nearestPtOnLine(point2d3, vector2d2, point2d).distanceLinf(point2d);
        double d5 = Inter2D.nearestPtOnLine(point2d3, vector2d2, point2d2).distanceLinf(point2d2);
        double d6 = Math.max(d2, d3);
        if (d4 > d6) {
            d6 = d4;
        }
        if (d5 > d6) {
            d6 = d5;
        }
        return d6 <= d;
    }

    public static Point2d add(Point2d point2d, Tuple2d tuple2d) {
        return new Point2d(point2d.x + tuple2d.x, point2d.y + tuple2d.y);
    }

    public static Vector2d vector(Point2d point2d, Point2d point2d2) {
        Vector2d vector2d = new Vector2d();
        vector2d.sub(point2d2, point2d);
        return vector2d;
    }

    public static Vector2d vectorN(Point2d point2d, Point2d point2d2) {
        Vector2d vector2d = new Vector2d();
        vector2d.sub(point2d2, point2d);
        vector2d.normalize();
        return vector2d;
    }

    public static Vector2d normalize(Vector2d vector2d) {
        Vector2d vector2d2 = new Vector2d();
        vector2d2.normalize(vector2d);
        return vector2d2;
    }

    public static Vector2d scale(Vector2d vector2d, double d) {
        return new Vector2d(vector2d.x * d, vector2d.y * d);
    }

    public static double cross(Vector2d vector2d, Vector2d vector2d2) {
        return vector2d.x * vector2d2.y - vector2d.y * vector2d2.x;
    }

    public static double cross(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    public static double tOnLine(Point2d point2d, Vector2d vector2d, Point2d point2d2) {
        Vector2d vector2d2 = Util2D.vector(point2d, point2d2);
        double d = vector2d.dot(vector2d2);
        return d / vector2d.lengthSquared();
    }

    public static Vector2d negate(Vector2d vector2d) {
        return new Vector2d(-vector2d.x, -vector2d.y);
    }

    public static double angle(Vector2d vector2d, Vector2d vector2d2) {
        double d = vector2d.angle(vector2d2);
        double d2 = Util2D.cross(vector2d, vector2d2);
        return d2 >= 0.0 ? d : -d;
    }

    public static double angle(double d, double d2, double d3, double d4) {
        double d5 = d * d3 + d2 * d4;
        double d6 = Math.sqrt(d * d + d2 * d2);
        double d7 = Math.sqrt(d3 * d3 + d4 * d4);
        return Math.acos(d5 / (d6 * d7));
    }

    public static double sAngle(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d * d4 - d2 * d3;
        double d7 = Math.sqrt(d * d + d2 * d2);
        double d8 = d6 / (d7 * (d5 = Math.sqrt(d3 * d3 + d4 * d4)));
        double d9 = d8 > 1.0 ? 1.5707963267948966 : (d8 < -1.0 ? -1.5707963267948966 : Math.asin(d8));
        double d10 = d * d3 + d2 * d4;
        if (d10 < 0.0) {
            d9 = d9 < 0.0 ? -d9 - Math.PI : Math.PI - d9;
        }
        return d9;
    }

    public static Point2d round(Point2d point2d, int n) {
        return new Point2d(theMath.round(point2d.x, n), theMath.round(point2d.y, n));
    }

    public static Point2d round(Point2d point2d, double d) {
        return new Point2d(theMath.round(point2d.x, d), theMath.round(point2d.y, d));
    }

    public static double simplePolygonArea(Point2d ... point2dArray) {
        if (point2dArray.length < 3) {
            return 0.0;
        }
        Point2d point2d = point2dArray[0];
        int n = point2d.equals(point2dArray[point2dArray.length - 1]) ? point2dArray.length - 1 : point2dArray.length;
        double d = 0.0;
        double d2 = point2dArray[1].x - point2d.x;
        double d3 = point2dArray[1].y - point2d.y;
        for (int i = 2; i < n; ++i) {
            Point2d point2d2 = point2dArray[i];
            double d4 = point2d2.x - point2d.x;
            double d5 = point2d2.y - point2d.y;
            d += d2 * d5 - d3 * d4;
            d2 = d4;
            d3 = d5;
        }
        return 0.5 * d;
    }

    public static Point2d simplePolygonCentroid(Point2d ... point2dArray) {
        double d = Util2D.simplePolygonArea(point2dArray);
        if (d == 0.0) {
            return null;
        }
        assert (point2dArray.length >= 3);
        Point2d point2d = point2dArray[0];
        int n = point2d.equals(point2dArray[point2dArray.length - 1]) ? point2dArray.length - 1 : point2dArray.length;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = point2dArray[1].x - point2d.x;
        double d5 = point2dArray[1].y - point2d.y;
        for (int i = 2; i < n; ++i) {
            Point2d point2d2 = point2dArray[i];
            double d6 = point2d2.x - point2d.x;
            double d7 = point2d2.y - point2d.y;
            double d8 = d4 * d7 - d6 * d5;
            d2 += (d4 + d6) * d8;
            d3 += (d5 + d7) * d8;
            d4 = d6;
            d5 = d7;
        }
        double d9 = 1.0 / (6.0 * d);
        return new Point2d(point2d.x + d9 * d2, point2d.y + d9 * d3);
    }

    public static boolean rectify(Point2d point2d, Point2d point2d2) {
        double d;
        boolean bl = false;
        if (point2d2.x < point2d.x) {
            d = point2d2.x;
            point2d2.x = point2d.x;
            point2d.x = d;
            bl = true;
        }
        if (point2d2.y < point2d.y) {
            d = point2d2.y;
            point2d2.y = point2d.y;
            point2d.y = d;
            bl = true;
        }
        return bl;
    }

    public static Point2d lerp(Point2d point2d, Point2d point2d2, double d) {
        return new Point2d(theUtil.lerp(point2d.x, point2d2.x, d), theUtil.lerp(point2d.y, point2d2.y, d));
    }

    public static Rectangle2D getBounds(Point2d ... point2dArray) {
        if (point2dArray.length == 0) {
            return new Rectangle2D.Double();
        }
        Point2d point2d = point2dArray[0];
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2d.x, point2d.y, 0.0, 0.0);
        for (int i = 1; i < point2dArray.length; ++i) {
            Point2d point2d2 = point2dArray[i];
            double_.add(point2d2.x, point2d2.y);
        }
        return double_;
    }

    public static Rectangle2D getBounds(List<Point2d> list) {
        if (list.size() == 0) {
            return new Rectangle2D.Double();
        }
        Point2d point2d = list.get(0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2d.x, point2d.y, 0.0, 0.0);
        for (int i = 1; i < list.size(); ++i) {
            Point2d point2d2 = list.get(i);
            double_.add(point2d2.x, point2d2.y);
        }
        return double_;
    }

    public static double[] getInterpolateParams(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4) {
        double[] dArray = new double[2];
        Util2D.getInterpolateParams(point2d, point2d2, point2d3, point2d4, dArray);
        return dArray;
    }

    public static void getInterpolateParams(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4, double[] dArray) {
        double d = point2d2.x - point2d.x;
        double d2 = point2d2.y - point2d.y;
        double d3 = point2d3.x - point2d.x;
        double d4 = point2d3.y - point2d.y;
        double d5 = point2d4.x - point2d.x;
        double d6 = point2d4.y - point2d.y;
        double d7 = 1.0 / Util2D.cross(d, d2, d3, d4);
        double d8 = Util2D.cross(d5, d6, d3, d4) * d7;
        double d9 = Util2D.cross(d, d2, d5, d6) * d7;
        dArray[0] = d8;
        dArray[1] = d9;
    }

    public static double interpolate(double d, double d2, double d3, double[] dArray) {
        return d + (d2 - d) * dArray[0] + (d3 - d) * dArray[1];
    }

    public static boolean isConvex(double d, Point2d ... point2dArray) {
        Point2d point2d;
        Point2d point2d2;
        int n;
        if (point2dArray.length < 3) {
            return false;
        }
        double d2 = d * d;
        Vector2d vector2d = new Vector2d();
        double d3 = Double.NaN;
        Vector2d vector2d2 = new Vector2d();
        double d4 = Double.NaN;
        vector2d.sub(point2dArray[1], point2dArray[0]);
        for (n = 1; n < point2dArray.length; ++n) {
            point2d2 = point2dArray[n];
            point2d = point2dArray[(n + 1) % point2dArray.length];
            vector2d2.sub(point2d, point2d2);
            d3 = Util2D.cross(vector2d, vector2d2);
            if (!theUtil.eq0(d3, d2)) {
                vector2d.set(vector2d2);
                break;
            }
            if (!(vector2d.dot(vector2d2) < 0.0)) continue;
            return false;
        }
        if (n == point2dArray.length) {
            return false;
        }
        ++n;
        while (n <= point2dArray.length) {
            point2d2 = point2dArray[n % point2dArray.length];
            point2d = point2dArray[(n + 1) % point2dArray.length];
            vector2d2.sub(point2d, point2d2);
            d4 = Util2D.cross(vector2d, vector2d2);
            if (!theUtil.eq0(d4, d2)) {
                if (d3 < 0.0 && d4 > 0.0 || d3 > 0.0 && d4 < 0.0) {
                    return false;
                }
                vector2d.set(vector2d2);
            } else if (vector2d.dot(vector2d2) < 0.0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static double triArea(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        double d = 0.5 * Math.abs(Util2D.cross(point2d, point2d2, point2d3));
        return d;
    }

    public static double cross(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        double d = point2d2.x * point2d.y - point2d.x * point2d2.y + (point2d3.x * point2d2.y - point2d2.x * point2d3.y) + (point2d.x * point2d3.y - point2d3.x * point2d.y);
        return d;
    }
}

