/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.nativebuffered.View;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Util {
    public static final double DBL_EPSILON = 1.0E-9;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    private static final Vector3d s_worldX = new Vector3d(1.0, 0.0, 0.0);
    private static final Vector3d s_worldY = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d s_worldZ = new Vector3d(0.0, 0.0, 1.0);
    private static final Plane3d s_zPlane = new Plane3d(0.0, 0.0, 1.0, 0.0);

    public static double metersToFeet(double d) {
        return SI.METER.getConverterTo(NonSI.FOOT).convert(d);
    }

    public static double feetToMeters(double d) {
        return NonSI.FOOT.getConverterTo(SI.METER).convert(d);
    }

    public static double inchesToMeters(double d) {
        return NonSI.INCH.getConverterTo(SI.METER).convert(d);
    }

    public static double metersToInches(double d) {
        return SI.METER.getConverterTo(NonSI.INCH).convert(d);
    }

    public static double[] rectify(double ... dArray) {
        assert (dArray.length == 2);
        if (dArray[0] > dArray[1]) {
            double d = dArray[1];
            dArray[1] = dArray[0];
            dArray[0] = d;
        }
        return dArray;
    }

    public static double clampT(double d, double d2, double d3) {
        assert (d2 <= d3);
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    public static void clampTs(double[] dArray, double d, double d2) {
        assert (d <= d2);
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] < d) {
                dArray[i] = d;
                continue;
            }
            if (!(dArray[i] > d2)) continue;
            dArray[i] = d2;
        }
    }

    public static double[] clampTRange(double d, double d2) {
        if (d > d2) {
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        return new double[]{d, d2};
    }

    public static boolean checkRange(double d, double d2, double d3, double d4) {
        return theUtil.ge(d3, d, d4) && theUtil.le(d3, d2, d4);
    }

    public static double clampTIfValid(double d, double d2, double d3, double d4) {
        if (d >= d3 && d - d3 <= d4) {
            return d3;
        }
        if (d <= d2 && d2 - d <= d4) {
            return d2;
        }
        return d < d2 || d > d3 ? Double.NaN : d;
    }

    public static boolean clampTIfValid(double[] dArray, double d, double d2, double d3) {
        for (int i = 0; i < dArray.length; ++i) {
            double d4 = dArray[i];
            if (d4 >= d2 && d4 - d2 <= d3) {
                dArray[i] = d2;
            } else if (d4 <= d && d - d4 <= d3) {
                dArray[i] = d;
            }
            if (!(dArray[i] < d) && !(dArray[i] > d2)) continue;
            return false;
        }
        return true;
    }

    public static Matrix4d rotMatZ(double d) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.rotZ(d);
        return matrix4d;
    }

    public static Matrix4d rotMat(double d, double d2, double d3, double d4) {
        AxisAngle4d axisAngle4d = new AxisAngle4d(d, d2, d3, d4);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(axisAngle4d);
        return matrix4d;
    }

    public static Matrix4d scaleMat(double d, double d2, double d3) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.m00 = d;
        matrix4d.m11 = d2;
        matrix4d.m22 = d3;
        matrix4d.m33 = 1.0;
        return matrix4d;
    }

    public static Matrix4d translateMat(double d, double d2, double d3) {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.m03 = d;
        matrix4d.m13 = d2;
        matrix4d.m23 = d3;
        matrix4d.m33 = 1.0;
        matrix4d.m22 = 1.0;
        matrix4d.m11 = 1.0;
        matrix4d.m00 = 1.0;
        return matrix4d;
    }

    public static Matrix4d mirrorMat(double d, double d2, double d3, double d4) {
        double d5 = 2.0 * d;
        double d6 = 2.0 * d2;
        double d7 = 2.0 * d3;
        return new Matrix4d(1.0 - d5 * d, -d5 * d2, -d5 * d3, -d5 * d4, -d6 * d, 1.0 - d6 * d2, -d6 * d3, -d6 * d4, -d7 * d, -d7 * d2, 1.0 - d7 * d3, -d7 * d4, 0.0, 0.0, 0.0, 1.0);
    }

    public static int getClosestAxis(Vector3d vector3d) {
        double d;
        int n;
        Vector3d vector3d2 = new Vector3d();
        vector3d2.normalize(vector3d);
        double d2 = vector3d2.dot(s_worldX);
        double d3 = vector3d2.dot(s_worldY);
        double d4 = vector3d2.dot(s_worldZ);
        double d5 = Math.abs(Math.abs(d2) - 1.0);
        double d6 = Math.abs(Math.abs(d3) - 1.0);
        double d7 = Math.abs(Math.abs(d4) - 1.0);
        if (d5 < d6) {
            n = 0;
            d = d5;
        } else {
            n = 1;
            d = d6;
        }
        if (d7 < d) {
            n = 2;
        }
        return n;
    }

    public static Point3d getClosestPoint(View view, Point3d point3d, double d, Point3d ... point3dArray) {
        return Util.getClosestPoint(view, point3d, d, Arrays.asList(point3dArray));
    }

    public static Point3d getClosestPoint(View view, Point3d point3d, double d, Collection<Point3d> collection) {
        Point3d point3d2 = view.worldToScreen(point3d);
        double d2 = d * d;
        Point3d point3d3 = null;
        double d3 = d2;
        for (Point3d point3d4 : collection) {
            if (point3d4 == null) continue;
            Point3d point3d5 = view.worldToScreen(point3d4);
            double d4 = point3d5.x - point3d2.x;
            double d5 = point3d5.y - point3d2.y;
            double d6 = d4 * d4 + d5 * d5;
            if (!(d6 <= d3)) continue;
            d3 = d6;
            point3d3 = point3d4;
        }
        return point3d3;
    }

    private static void getLocalAxes(Plane3d plane3d, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        plane3d.getNormal(vector3d3);
        if (Math.abs(vector3d3.x) < 0.015625 && Math.abs(vector3d3.y) < 0.015625) {
            vector3d.cross(s_worldY, vector3d3);
        } else {
            vector3d.cross(s_worldZ, vector3d3);
        }
        vector3d.normalize();
        vector3d2.cross(vector3d3, vector3d);
        vector3d2.normalize();
    }

    public static Matrix4d getWorldToLocalXform(Plane3d plane3d) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Util.getLocalAxes(plane3d, vector3d, vector3d3, vector3d2);
        double d = vector3d2.x * plane3d.w;
        double d2 = vector3d2.y * plane3d.w;
        double d3 = vector3d2.z * plane3d.w;
        return new Matrix4d(vector3d.x, vector3d.y, vector3d.z, vector3d.x * d + vector3d.y * d2 + vector3d.z * d3, vector3d3.x, vector3d3.y, vector3d3.z, vector3d3.x * d + vector3d3.y * d2 + vector3d3.z * d3, vector3d2.x, vector3d2.y, vector3d2.z, vector3d2.x * d + vector3d2.y * d2 + vector3d2.z * d3, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix4d getLocalToWorldXform(Plane3d plane3d) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Util.getLocalAxes(plane3d, vector3d, vector3d3, vector3d2);
        double d = -vector3d2.x * plane3d.w;
        double d2 = -vector3d2.y * plane3d.w;
        double d3 = -vector3d2.z * plane3d.w;
        return new Matrix4d(vector3d.x, vector3d3.x, vector3d2.x, d, vector3d.y, vector3d3.y, vector3d2.y, d2, vector3d.z, vector3d3.z, vector3d2.z, d3, 0.0, 0.0, 0.0, 1.0);
    }

    public static Plane3d getPlane(Matrix4d matrix4d) {
        return s_zPlane.transformBy(matrix4d);
    }
}

