/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.awt.geom.QuadCurve2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AParametric2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ShapeUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.util.theMath;

public interface Spline2D
extends IParametric2D {
    public Shape toShape();

    public static class Quadratic
    extends Cubic
    implements Spline2D,
    Serializable {
        static final long serialVersionUID = 1L;

        public Quadratic(Point2d point2d, Point2d point2d2, Point2d point2d3) {
            super(point2d, point2d2, point2d2, point2d3);
        }

        @Override
        protected void calcParams() {
            this.ay = 0.0;
            this.ax = 0.0;
            this.bx = this.p2.x - 2.0 * this.c1.x + this.p1.x;
            this.by = this.p2.y - 2.0 * this.c1.y + this.p1.y;
            this.cx = 2.0 * this.c1.x - 2.0 * this.p1.x;
            this.cy = 2.0 * this.c1.y - 2.0 * this.p1.y;
            this.dx = this.p1.x;
            this.dy = this.p1.y;
        }

        @Override
        public IParametric2D reverse() {
            return new Quadratic(this.p2, this.c1, this.p1);
        }

        @Override
        public IParametric2D subsegment(double d, double d2) {
            QuadCurve2D quadCurve2D;
            if (d2 < d) {
                quadCurve2D = (QuadCurve2D)((Quadratic)this.reverse()).toShape();
                double d3 = d;
                d = 1.0 - d2;
                d2 = 1.0 - d3;
            } else {
                quadCurve2D = (QuadCurve2D)this.toShape();
            }
            quadCurve2D = ShapeUtil.subcurve(quadCurve2D, d, d2);
            return new Quadratic(new Point2d(quadCurve2D.getX1(), quadCurve2D.getY1()), new Point2d(quadCurve2D.getCtrlX(), quadCurve2D.getCtrlY()), new Point2d(quadCurve2D.getX2(), quadCurve2D.getY2()));
        }

        @Override
        public Shape toShape() {
            return new QuadCurve2D.Double(this.p1.x, this.p1.y, this.c1.x, this.c1.y, this.p2.x, this.p2.y);
        }

        @Override
        public void append(Path2D.Double double_) {
            double_.quadTo(this.c1.x, this.c1.y, this.p2.x, this.p2.y);
        }
    }

    public static class Cubic
    extends AParametric2D
    implements Spline2D,
    Serializable {
        static final long serialVersionUID = 1L;
        protected final Point2d p1;
        protected final Point2d c1;
        protected final Point2d c2;
        protected final Point2d p2;
        protected double ax;
        protected double bx;
        protected double cx;
        protected double dx;
        protected double ay;
        protected double by;
        protected double cy;
        protected double dy;
        private static Comparator<Double> s_uniqueComp = new Comparator<Double>(){

            @Override
            public int compare(Double d, Double d2) {
                int n = d.compareTo(d2);
                if (n != 0) {
                    return n;
                }
                return Integer.compare(System.identityHashCode(d), System.identityHashCode(d2));
            }
        };

        public Cubic(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4) {
            this.p1 = point2d;
            this.c1 = point2d2;
            this.c2 = point2d3;
            this.p2 = point2d4;
            this.calcParams();
        }

        @Override
        public boolean epsilonEquals(IParametric2D iParametric2D, double d) {
            if (this == iParametric2D) {
                return true;
            }
            if (!(iParametric2D instanceof Cubic)) {
                return false;
            }
            Cubic cubic = (Cubic)iParametric2D;
            return this.p1.epsilonEquals(cubic.p1, d) && this.p2.epsilonEquals(cubic.p2, d) && this.c1.epsilonEquals(cubic.c1, d) && this.c2.epsilonEquals(cubic.c2, d);
        }

        @Override
        public Point2d get(double d) {
            if (d == 1.0) {
                return new Point2d(this.p2);
            }
            double d2 = d * d;
            double d3 = d2 * d;
            return new Point2d(this.ax * d3 + this.bx * d2 + this.cx * d + this.dx, this.ay * d3 + this.by * d2 + this.cy * d + this.dy);
        }

        protected void calcParams() {
            this.ax = this.p2.x - 3.0 * this.c2.x + 3.0 * this.c1.x - this.p1.x;
            this.ay = this.p2.y - 3.0 * this.c2.y + 3.0 * this.c1.y - this.p1.y;
            this.bx = 3.0 * this.c2.x - 6.0 * this.c1.x + 3.0 * this.p1.x;
            this.by = 3.0 * this.c2.y - 6.0 * this.c1.y + 3.0 * this.p1.y;
            this.cx = 3.0 * this.c1.x - 3.0 * this.p1.x;
            this.cy = 3.0 * this.c1.y - 3.0 * this.p1.y;
            this.dx = this.p1.x;
            this.dy = this.p1.y;
        }

        @Override
        public Vector2d getTangent(double d) {
            double d2 = d * d;
            return new Vector2d(3.0 * this.ax * d2 + 2.0 * this.bx * d + this.cx, 3.0 * this.ay * d2 + 2.0 * this.by * d + this.cy);
        }

        public Point2d getP1() {
            return this.p1;
        }

        public Point2d getP2() {
            return this.p2;
        }

        public Point2d getC1() {
            return this.c1;
        }

        public Point2d getC2() {
            return this.c2;
        }

        @Override
        public void setBegin(Point2d point2d) {
            this.p1.set(point2d);
            this.calcParams();
        }

        @Override
        public void setEnd(Point2d point2d) {
            this.p2.set(point2d);
            this.calcParams();
        }

        @Override
        public double length() {
            return 0.0;
        }

        @Override
        public boolean isValid(double d) {
            double d2 = this.p1.distanceLinf(this.c1);
            d2 += this.c1.distanceLinf(this.c2);
            return (d2 += this.c2.distanceLinf(this.p2)) >= d;
        }

        @Override
        public List<double[]> getIsects(IParametric2D iParametric2D, double d) {
            if (iParametric2D instanceof LineSeg2D) {
                LineSeg2D lineSeg2D = (LineSeg2D)iParametric2D;
                return this.getLinesegIsects(lineSeg2D.p1, lineSeg2D.p2, d);
            }
            if (iParametric2D instanceof Spline2D) {
                return Collections.EMPTY_LIST;
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        public List<double[][]> getAlignedSegs(IParametric2D iParametric2D, double d) {
            return Collections.EMPTY_LIST;
        }

        @Override
        public double getClosestT(Point2d point2d) {
            return this.getClosestPointPW(point2d, 10, 12);
        }

        private double clamp(double d, double d2, double d3) {
            if (d < d2) {
                return d2;
            }
            if (d > d3) {
                return d3;
            }
            return d;
        }

        private double getClosestPointPW(Point2d point2d, int n, int n2) {
            double d;
            if (n < 4) {
                n = 4;
            }
            Point2d[] point2dArray = new Point2d[n + 1];
            point2dArray[0] = this.get(0.0);
            point2dArray[1] = this.get(1.0);
            double d2 = 1.0 / (double)n;
            for (int i = 0; i <= n; ++i) {
                double d3 = (double)i * d2;
                point2dArray[i] = this.get(d3);
            }
            TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>(s_uniqueComp);
            for (int i = 0; i < n; ++i) {
                Point2d point2d2 = point2dArray[i];
                Point2d point2d3 = point2dArray[i + 1];
                double d4 = Inter2D.nearestTOnLineSeg(point2d, point2d2, point2d3);
                double d5 = (double)i * d2;
                d = d5 + d4 * d2;
                Point2d point2d4 = Util2D.linePoint(point2d2, point2d3, d4);
                double d6 = point2d4.distanceSquared(point2d);
                treeMap.put(d6, d);
            }
            assert (treeMap.size() >= 4);
            double d7 = Double.MAX_VALUE;
            double d8 = Double.MAX_VALUE;
            Iterator iterator = treeMap.entrySet().iterator();
            for (int i = 0; i < 4; ++i) {
                Map.Entry entry = iterator.next();
                d = this.getClosestTNewton(point2d, (Double)entry.getValue(), n2);
                double d9 = this.get(d).distanceSquared(point2d);
                if (!(d9 < d8)) continue;
                d8 = d9;
                d7 = d;
            }
            return d7;
        }

        private double getClosestPointBF(Point2d point2d, double d) {
            double d2 = Double.MAX_VALUE;
            double d3 = -1.0;
            for (double d4 = 0.0; d4 <= 1.0; d4 += d) {
                double d5 = this.get(d4).distanceSquared(point2d);
                if (!(d5 < d2)) continue;
                d2 = d5;
                d3 = d4;
            }
            return d3;
        }

        private double getClosestTNewton(Point2d point2d, double d, int n) {
            double d2 = d;
            double d3 = d;
            double d4 = 1.0E-6;
            for (int i = 0; i < n; ++i) {
                double d5;
                double d6 = d2 * d2;
                double d7 = d6 * d2;
                double d8 = d7 * d2;
                double d9 = 2.0 * this.cy * this.cy + 2.0 * this.cx * this.cx + (-4.0 * point2d.x + 4.0 * this.dx + 12.0 * d2 * this.cx) * this.bx + 12.0 * d6 * this.bx * this.bx + (-12.0 * d2 * point2d.y + 12.0 * d2 * this.dy + 24.0 * d6 * this.cy) * this.ay + 30.0 * d8 * this.ay * this.ay + (-12.0 * d2 * point2d.x + 12.0 * d2 * this.dx + 24.0 * d6 * this.cx + 40.0 * d7 * this.bx) * this.ax + 30.0 * d8 * this.ax * this.ax + (-4.0 * point2d.y + 4.0 * this.dy + 12.0 * d2 * this.cy + 40.0 * d7 * this.ay) * this.by + 12.0 * d6 * this.by * this.by;
                if (d9 == 0.0) {
                    return d;
                }
                if ((d2 -= (d5 = 2.0 * (this.ax * d7 + this.bx * d6 + this.cx * d2 + this.dx - point2d.x) * (3.0 * this.ax * d6 + 2.0 * this.bx * d2 + this.cx) + 2.0 * (this.ay * d7 + this.by * d6 + this.cy * d2 + this.dy - point2d.y) * (3.0 * this.ay * d6 + 2.0 * this.by * d2 + this.cy)) / d9) < 0.0 || d2 > 1.0) {
                    return d;
                }
                if (i > 0 && Math.abs(d2 - d3) <= d4) {
                    return d2;
                }
                d3 = d2;
            }
            return d2;
        }

        private double getClosestPointNM(Point2d point2d, double d, double d2, double d3, int n) {
            double[] dArray = new double[]{d, d2, d3};
            double[] dArray2 = new double[3];
            double d4 = Double.MAX_VALUE;
            double d5 = Double.MAX_VALUE;
            double[] dArray3 = new double[4];
            double d6 = 0.001;
            for (int i = 0; i < n; ++i) {
                int n2;
                dArray2[0] = this.get(dArray[0]).distanceSquared(point2d);
                dArray2[1] = this.get(dArray[1]).distanceSquared(point2d);
                dArray2[2] = this.get(dArray[2]).distanceSquared(point2d);
                double d7 = (dArray[1] - dArray[2]) * dArray2[0] + (dArray[2] - dArray[0]) * dArray2[1] + (dArray[0] - dArray[1]) * dArray2[2];
                if (d7 == 0.0) {
                    return Double.POSITIVE_INFINITY;
                }
                d4 = 0.5 * ((dArray[1] * dArray[1] - dArray[2] * dArray[2]) * dArray2[0] + (dArray[2] * dArray[2] - dArray[0] * dArray[0]) * dArray2[1] + (dArray[0] * dArray[0] - dArray[1] * dArray[1]) * dArray2[2]) / d7;
                if (d4 < 0.0 || d4 > 1.0) {
                    return Double.POSITIVE_INFINITY;
                }
                double d8 = (-2.0 * point2d.y + 2.0 * this.dy) * this.cy + 2.0 * d4 * this.cy * this.cy + (-2.0 * point2d.x + 2.0 * this.dx) * this.cx + 2.0 * d4 * this.cx * this.cx + (-4.0 * d4 * point2d.x + 4.0 * d4 * this.dx + 6.0 * d4 * d4 * this.cx) * this.bx + 4.0 * d4 * d4 * d4 * this.bx * this.bx + (-6.0 * d4 * d4 * point2d.y + 6.0 * d4 * d4 * this.dy + 8.0 * d4 * d4 * d4 * this.cy) * this.ay + 6.0 * d4 * d4 * d4 * d4 * d4 * this.ay * this.ay + (-6.0 * d4 * d4 * point2d.x + 6.0 * d4 * d4 * this.dx + 8.0 * d4 * d4 * d4 * this.cx + 10.0 * d4 * d4 * d4 * d4 * this.bx) * this.ax + 6.0 * d4 * d4 * d4 * d4 * d4 * this.ax * this.ax + (-4.0 * d4 * point2d.y + 4.0 * d4 * this.dy + 6.0 * d4 * d4 * this.cy + 10.0 * d4 * d4 * d4 * d4 * this.ay) * this.by + 4.0 * d4 * d4 * d4 * this.by * this.by;
                double d9 = 2.0 * this.cy * this.cy + 2.0 * this.cx * this.cx + (-4.0 * point2d.x + 4.0 * this.dx + 12.0 * d4 * this.cx) * this.bx + 12.0 * d4 * d4 * this.bx * this.bx + (-12.0 * d4 * point2d.y + 12.0 * d4 * this.dy + 24.0 * d4 * d4 * this.cy) * this.ay + 30.0 * d4 * d4 * d4 * d4 * this.ay * this.ay + (-12.0 * d4 * point2d.x + 12.0 * d4 * this.dx + 24.0 * d4 * d4 * this.cx + 40.0 * d4 * d4 * d4 * this.bx) * this.ax + 30.0 * d4 * d4 * d4 * d4 * this.ax * this.ax + (-4.0 * point2d.y + 4.0 * this.dy + 12.0 * d4 * this.cy + 40.0 * d4 * d4 * d4 * this.ay) * this.by + 12.0 * d4 * d4 * this.by * this.by;
                if (d9 != 0.0 && ((d4 -= d8 / d9) < 0.0 || d4 > 1.0)) {
                    return Double.POSITIVE_INFINITY;
                }
                if (i > 0 && Math.abs(d4 - d5) <= d6) {
                    return d4;
                }
                d5 = d4;
                dArray3[0] = (dArray[0] - dArray[1]) * (dArray[0] - dArray[2]) / ((dArray[0] - dArray[1]) * (dArray[0] - dArray[2])) * dArray2[0];
                dArray3[1] = (dArray[1] - dArray[0]) * (dArray[1] - dArray[2]) / ((dArray[1] - dArray[0]) * (dArray[1] - dArray[2])) * dArray2[1];
                dArray3[2] = (dArray[2] - dArray[0]) * (dArray[2] - dArray[1]) / ((dArray[2] - dArray[0]) * (dArray[2] - dArray[1])) * dArray2[2];
                dArray3[3] = (d4 - dArray[1]) * (d4 - dArray[2]) / ((dArray[0] - dArray[1]) * (dArray[0] - dArray[2])) * dArray2[0] + (d4 - dArray[0]) * (d4 - dArray[2]) / ((dArray[1] - dArray[0]) * (dArray[1] - dArray[2])) * dArray2[1] + (d4 - dArray[0]) * (d4 - dArray[1]) / ((dArray[2] - dArray[0]) * (dArray[2] - dArray[1])) * dArray2[2];
                int n3 = 0;
                for (n2 = 1; n2 < 4; ++n2) {
                    if (!(dArray3[n2] > dArray3[n3])) continue;
                    n3 = n2;
                }
                if (n3 > 2) continue;
                dArray[n3] = d4;
                for (n2 = 0; n2 < 3; ++n2) {
                    for (int j = n2 + 1; j < 3; ++j) {
                        if (dArray[n2] != dArray[j]) continue;
                        dArray[j] = dArray[j] < 0.5 ? dArray[j] + 1.0E-4 : dArray[j] - 1.0E-4;
                    }
                }
            }
            return d4;
        }

        @Override
        public List<double[]> getLineIsects(Point2d point2d, Vector2d vector2d, double d) {
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            double d2 = 1.0 / vector2d.length();
            Vector2d vector2d2 = new Vector2d(vector2d);
            vector2d2.scale(d2);
            Vector2d vector2d3 = new Vector2d();
            vector2d3.set(-vector2d2.y, vector2d2.x);
            double d3 = this.ax * vector2d3.x + this.ay * vector2d3.y;
            double d4 = this.bx * vector2d3.x + this.by * vector2d3.y;
            double d5 = this.cx * vector2d3.x + this.cy * vector2d3.y;
            double d6 = (this.dx - point2d.x) * vector2d3.x + (this.dy - point2d.y) * vector2d3.y;
            double[] dArray = theMath.solveCubic(d3, d4, d5, d6);
            if (dArray.length == 0) {
                return arrayList;
            }
            double d7 = this.ax * vector2d2.x + this.ay * vector2d2.y;
            double d8 = this.bx * vector2d2.x + this.by * vector2d2.y;
            double d9 = this.cx * vector2d2.x + this.cy * vector2d2.y;
            double d10 = (this.dx - point2d.x) * vector2d2.x + (this.dy - point2d.y) * vector2d2.y;
            for (double d11 : dArray) {
                if (Double.isNaN(d11 = Util.clampTIfValid(d11, 0.0, 1.0, d))) continue;
                double d12 = d11 * d11;
                double d13 = d12 * d11;
                double d14 = d7 * d13 + d8 * d12 + d9 * d11 + d10;
                arrayList.add(new double[]{d11, d14 *= d2});
            }
            return arrayList;
        }

        @Override
        public IParametric2D reverse() {
            return new Cubic(this.p2, this.c2, this.c1, this.p1);
        }

        @Override
        public IParametric2D subsegment(double d, double d2) {
            CubicCurve2D cubicCurve2D;
            if (d2 < d) {
                cubicCurve2D = (CubicCurve2D)((Cubic)this.reverse()).toShape();
                double d3 = d;
                d = 1.0 - d2;
                d2 = 1.0 - d3;
            } else {
                cubicCurve2D = (CubicCurve2D)this.toShape();
            }
            cubicCurve2D = ShapeUtil.subcurve(cubicCurve2D, d, d2);
            return new Cubic(new Point2d(cubicCurve2D.getX1(), cubicCurve2D.getY1()), new Point2d(cubicCurve2D.getCtrlX1(), cubicCurve2D.getCtrlY1()), new Point2d(cubicCurve2D.getCtrlX2(), cubicCurve2D.getCtrlY2()), new Point2d(cubicCurve2D.getX2(), cubicCurve2D.getY2()));
        }

        @Override
        public Shape toShape() {
            return new CubicCurve2D.Double(this.p1.x, this.p1.y, this.c1.x, this.c1.y, this.c2.x, this.c2.y, this.p2.x, this.p2.y);
        }

        @Override
        public void append(Path2D.Double double_) {
            double_.curveTo(this.c1.x, this.c1.y, this.c2.x, this.c2.y, this.p2.x, this.p2.y);
        }
    }
}

