/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import javax.vecmath.Point2d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class PolyBuilder {
    private final double d_distTol;
    private final double d_vertWeldDist;
    private final HashMap<Point2d, Vert> d_vertMap;
    private final List<Edge> d_edges = new ArrayList<Edge>();

    public PolyBuilder(double d) {
        this(d, d);
    }

    public PolyBuilder(double d, double d2) {
        this.d_vertMap = new LinkedHashMap<Point2d, Vert>();
        this.d_distTol = d;
        this.d_vertWeldDist = d2;
    }

    public boolean addEdge(double d, double d2, double d3, double d4) {
        return this.addEdge(new Point2d(d, d2), new Point2d(d3, d4));
    }

    public boolean addEdge(Point2d point2d, Point2d point2d2) {
        Vert vert;
        Vert vert2 = this.getVert(point2d);
        if (vert2 == (vert = this.getVert(point2d2))) {
            return false;
        }
        Edge edge = new Edge(vert2, vert, this.d_distTol);
        for (Edge edge2 : this.d_edges) {
            List<double[]> list = this.isect(edge, edge2);
            for (double[] dArray : list) {
                Point2d point2d3;
                Point2d point2d4 = this.getVert(edge, dArray[0]);
                if (!point2d4.equals(point2d3 = this.getVert(edge2, dArray[1]))) continue;
                Vert vert3 = this.d_vertMap.get(point2d4);
                if (vert3 == null) {
                    vert3 = new Vert(point2d4);
                    this.d_vertMap.put(point2d4, vert3);
                }
                if (!edge.divs.containsValue(vert3)) {
                    dArray[0] = Inter2D.nearestTOnLineSeg(vert3.p, ((Edge)edge).v1.p, ((Edge)edge).v2.p);
                    edge.divs.put(dArray[0], vert3);
                }
                if (edge2.divs.containsValue(vert3)) continue;
                dArray[1] = Inter2D.nearestTOnLineSeg(vert3.p, ((Edge)edge2).v1.p, ((Edge)edge2).v2.p);
                edge2.divs.put(dArray[1], vert3);
            }
        }
        this.d_edges.add(edge);
        return true;
    }

    private Point2d getVert(Edge edge, double d) {
        return Util2D.round(Util2D.linePoint(((Edge)edge).v1.p, ((Edge)edge).v2.p, d), this.d_distTol);
    }

    private Vert getVert(Point2d point2d) {
        Point2d point2d2 = Util2D.round(point2d, this.d_vertWeldDist);
        Vert vert = this.d_vertMap.get(point2d2);
        if (vert == null) {
            vert = new Vert(point2d);
            this.d_vertMap.put(point2d2, vert);
        }
        return vert;
    }

    private List<double[]> isect(Edge edge, Edge edge2) {
        if (edge.equals(edge2)) {
            ArrayList<double[]> arrayList = new ArrayList<double[]>(1);
            arrayList.add(new double[]{0.0, 0.0});
            arrayList.add(new double[]{1.0, 1.0});
            return arrayList;
        }
        if (!Inter2D.aabbAABBIntersect(edge.d_minx, edge.d_miny, edge.d_maxx, edge.d_maxy, edge2.d_minx, edge2.d_miny, edge2.d_maxx, edge2.d_maxy)) {
            return Collections.EMPTY_LIST;
        }
        double[] dArray = Inter2D.isectLinesegLineseg(((Edge)edge).v1.p, ((Edge)edge).v2.p, ((Edge)edge2).v1.p, ((Edge)edge2).v2.p, this.d_distTol);
        if (dArray != null) {
            return Arrays.asList(new double[][]{dArray});
        }
        double[][] dArray2 = Inter2D.lineSeglineSegOverlap(((Edge)edge).v1.p, ((Edge)edge).v2.p, ((Edge)edge2).v1.p, ((Edge)edge2).v2.p, this.d_distTol);
        if (dArray2 != null) {
            ArrayList<double[]> arrayList = new ArrayList<double[]>(2);
            arrayList.add(new double[]{dArray2[0][0], dArray2[1][0]});
            arrayList.add(new double[]{dArray2[0][1], dArray2[1][1]});
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public Result build() {
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>(this.d_vertMap.size());
        HashMap<Point2d, Integer> hashMap = new HashMap<Point2d, Integer>();
        for (Vert object2 : this.d_vertMap.values()) {
            if (hashMap.containsKey(object2.p)) continue;
            hashMap.put(object2.p, hashMap.size());
            arrayList.add(object2.p);
        }
        ArrayList arrayList2 = new ArrayList(this.d_edges.size() * 2);
        HashSet<IEdge> hashSet = new HashSet<IEdge>();
        for (Edge edge : this.d_edges) {
            Iterator iterator = edge.divs.values().iterator();
            int n = (Integer)hashMap.get(((Vert)iterator.next()).p);
            while (iterator.hasNext()) {
                Vert vert = (Vert)iterator.next();
                int n2 = (Integer)hashMap.get(vert.p);
                IEdge iEdge = new IEdge(n, n2);
                if (hashSet.add(iEdge)) {
                    arrayList2.add(n);
                    arrayList2.add(n2);
                }
                n = n2;
            }
        }
        return new Result(arrayList.toArray(new Point2d[arrayList.size()]), theUtil.toIntArray(arrayList2));
    }

    private static class IEdge {
        private final int i1;
        private final int i2;

        public IEdge(int n, int n2) {
            this.i1 = n;
            this.i2 = n2;
        }

        public int hashCode() {
            return this.i1 + this.i2;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            IEdge iEdge = (IEdge)object;
            return this.i1 == iEdge.i1 && this.i2 == iEdge.i2 || this.i1 == iEdge.i2 && this.i2 == iEdge.i1;
        }
    }

    public static class Result {
        public final Point2d[] verts;
        public final int[] edges;

        public Result(Point2d[] point2dArray, int[] nArray) {
            this.verts = point2dArray;
            this.edges = nArray;
        }
    }

    private static class Edge {
        private final Vert v1;
        private final Vert v2;
        private final TreeMap<Double, Vert> divs;
        private double d_minx;
        private double d_miny;
        private double d_maxx;
        private double d_maxy;

        public Edge(Vert vert, Vert vert2, double d) {
            this.v1 = vert;
            this.v2 = vert2;
            this.divs = new TreeMap();
            this.divs.put(0.0, vert);
            this.divs.put(1.0, vert2);
            if (vert.p.x <= vert2.p.x) {
                this.d_minx = vert.p.x;
                this.d_maxx = vert2.p.x;
            } else {
                this.d_minx = vert2.p.x;
                this.d_maxx = vert.p.x;
            }
            if (vert.p.y <= vert2.p.y) {
                this.d_miny = vert.p.y;
                this.d_maxy = vert2.p.y;
            } else {
                this.d_miny = vert2.p.y;
                this.d_maxy = vert.p.y;
            }
            this.d_minx -= d;
            this.d_miny -= d;
            this.d_maxx += d;
            this.d_maxy += d;
        }

        public boolean equals(Edge edge) {
            return this.v1 == edge.v1 && this.v2 == edge.v2 || this.v1 == edge.v2 && this.v2 == edge.v1;
        }
    }

    private static class Vert {
        public final Point2d p;

        public Vert(Point2d point2d) {
            this.p = point2d;
        }
    }
}

