/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.io.Serializable;
import java.util.Arrays;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Plane3d
implements Serializable,
ILegacy_2012_1 {
    static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Plane3d() {
    }

    public Plane3d(Plane3d plane3d) {
        this(plane3d.x, plane3d.y, plane3d.z, plane3d.w);
    }

    public Plane3d(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public Plane3d(Vector3d vector3d, Point3d point3d) {
        this.x = vector3d.x;
        this.y = vector3d.y;
        this.z = vector3d.z;
        this.w = Plane3d.calcD(vector3d, point3d);
    }

    public Plane3d(Point3d ... point3dArray) {
        this.set(point3dArray);
    }

    @Override
    public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.geometry.Plane3d(this.x, this.y, this.z, this.w);
    }

    public Plane3d normalize() {
        double d = 1.0 / Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Plane3d(this.x * d, this.y * d, this.z * d, this.w * d);
    }

    public static Vector4d normalizeEq(Vector4d vector4d) {
        double d = 1.0 / Math.sqrt(vector4d.x * vector4d.x + vector4d.y * vector4d.y + vector4d.z * vector4d.z);
        vector4d.x *= d;
        vector4d.y *= d;
        vector4d.z *= d;
        vector4d.w *= d;
        return vector4d;
    }

    public boolean isValid() {
        return this.x != 0.0 || this.y != 0.0 || this.z != 0.0;
    }

    public boolean isParallel(Plane3d plane3d, double d) {
        double d2 = plane3d.x * this.x + plane3d.y * this.y + plane3d.z * this.z;
        return theUtil.eq(Math.abs(d2), 1.0, d);
    }

    public void set(double d, Point3d ... point3dArray) {
        Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(point3dArray), d);
        if (plane3d == null) {
            this.set(0.0, 0.0, 0.0, 0.0);
        } else {
            this.set(plane3d);
        }
    }

    public void set(Point3d ... point3dArray) {
        this.set(0.0, point3dArray);
    }

    public void set(Vector4d vector4d) {
        this.set(vector4d.x, vector4d.y, vector4d.z, vector4d.w);
    }

    public void set(Plane3d plane3d) {
        this.set(plane3d.x, plane3d.y, plane3d.z, plane3d.w);
    }

    public void set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public Vector4d toVec4d() {
        return new Vector4d(this.x, this.y, this.z, this.w);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Plane3d)) {
            return false;
        }
        Plane3d plane3d = (Plane3d)object;
        return this == plane3d || this.x == plane3d.x && this.y == plane3d.y && this.z == plane3d.z && this.w == plane3d.w;
    }

    public boolean epsilonEquals(Plane3d plane3d, double d) {
        if (this == plane3d) {
            return true;
        }
        double d2 = Math.max(Math.abs(this.x - plane3d.x), Math.abs(this.y - plane3d.y));
        d2 = Math.max(d2, Math.abs(this.z - plane3d.z));
        return (d2 = Math.max(d2, Math.abs(this.w - plane3d.w))) <= d;
    }

    public Vector3d getNormal() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public void getNormal(Vector3d vector3d) {
        vector3d.set(this.x, this.y, this.z);
    }

    public void negateEq() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
    }

    public Plane3d negate() {
        return new Plane3d(-this.x, -this.y, -this.z, -this.w);
    }

    private static double calcD(Vector3d vector3d, Point3d point3d) {
        return -vector3d.x * point3d.x - vector3d.y * point3d.y - vector3d.z * point3d.z;
    }

    public double distance(Point3d point3d) {
        double d = Math.abs(this.x * point3d.x + this.y * point3d.y + this.z * point3d.z + this.w);
        double d2 = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return d / d2;
    }

    public Point3d projectOntoPlane(Point3d point3d) {
        double d = this.dot(point3d);
        point3d = new Point3d(point3d);
        point3d.x -= this.x * d;
        point3d.y -= this.y * d;
        point3d.z -= this.z * d;
        return point3d;
    }

    public double dot(Point3d point3d) {
        return this.x * point3d.x + this.y * point3d.y + this.z * point3d.z + this.w;
    }

    public double dot(double d, double d2, double d3) {
        return this.x * d + this.y * d2 + this.z * d3 + this.w;
    }

    public Point3d getPointOnPlane() {
        if (theUtil.eq(1.0, this.x * this.x + this.y * this.y + this.z * this.z, 1.0E-9)) {
            return new Point3d(-this.x * this.w, -this.y * this.w, -this.z * this.w);
        }
        if (!theUtil.eq0(this.x, 1.0E-9)) {
            return new Point3d(-this.w / this.x, 0.0, 0.0);
        }
        if (!theUtil.eq0(this.y, 1.0E-9)) {
            return new Point3d(0.0, -this.w / this.y, 0.0);
        }
        if (!theUtil.eq0(this.z, 1.0E-9)) {
            return new Point3d(0.0, 0.0, -this.w / this.z);
        }
        return new Point3d(0.0, 0.0, 0.0);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public Plane3d transformBy(Matrix4d matrix4d) {
        Point3d point3d = new Point3d(-this.x * this.w, -this.y * this.w, -this.z * this.w);
        Vector3d vector3d = new Vector3d(this.x, this.y, this.z);
        matrix4d.transform(point3d);
        matrix4d.transform(vector3d);
        vector3d.normalize();
        return new Plane3d(vector3d, point3d);
    }
}

