/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AParametric2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.IParametric2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter2D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;

public class LineSeg2D
extends AParametric2D
implements IParametric2D {
    public final Point2d p1;
    public final Point2d p2;

    public LineSeg2D(Point2d point2d, Point2d point2d2) {
        this.p1 = point2d;
        this.p2 = point2d2;
    }

    @Override
    public double length() {
        return this.p1.distance(this.p2);
    }

    @Override
    public boolean isValid(double d) {
        return !this.p1.epsilonEquals(this.p2, d);
    }

    @Override
    public void setBegin(Point2d point2d) {
        this.p1.set(point2d);
    }

    @Override
    public void setEnd(Point2d point2d) {
        this.p2.set(point2d);
    }

    @Override
    public boolean epsilonEquals(IParametric2D iParametric2D, double d) {
        if (this == iParametric2D) {
            return true;
        }
        if (!(iParametric2D instanceof LineSeg2D)) {
            return false;
        }
        LineSeg2D lineSeg2D = (LineSeg2D)iParametric2D;
        return this.p1.epsilonEquals(lineSeg2D.p1, d) && this.p2.epsilonEquals(lineSeg2D.p2, d);
    }

    @Override
    public Point2d get(double d) {
        return Util2D.linePoint(this.p1, this.p2, d);
    }

    @Override
    public Vector2d getTangent(double d) {
        return Util2D.vector(this.p1, this.p2);
    }

    @Override
    public double getClosestT(Point2d point2d) {
        return Inter2D.nearestTOnLineSeg(point2d, this.p1, this.p2);
    }

    @Override
    public List<double[]> getLineIsects(Point2d point2d, Vector2d vector2d, double d) {
        double[] dArray = Inter2D.isectLineLine(this.p1, Util2D.vector(this.p1, this.p2), point2d, vector2d, d);
        if (dArray == null) {
            return Collections.EMPTY_LIST;
        }
        dArray[0] = Util.clampTIfValid(dArray[0], 0.0, 1.0, d);
        if (Double.isNaN(dArray[0])) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(dArray);
    }

    @Override
    public List<double[]> getIsects(IParametric2D iParametric2D, double d) {
        List<double[]> list = iParametric2D.getLinesegIsects(this.p1, this.p2, d);
        for (double[] dArray : list) {
            double d2 = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = d2;
        }
        return list;
    }

    @Override
    public List<double[][]> getAlignedSegs(IParametric2D iParametric2D, double d) {
        if (!(iParametric2D instanceof LineSeg2D)) {
            return Collections.EMPTY_LIST;
        }
        LineSeg2D lineSeg2D = (LineSeg2D)iParametric2D;
        double[][] dArray = Inter2D.lineSeglineSegOverlap(this.p1, this.p2, lineSeg2D.p1, lineSeg2D.p2, d);
        if (dArray == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<double[][]> arrayList = new ArrayList<double[][]>(1);
        arrayList.add(dArray);
        return arrayList;
    }

    @Override
    public IParametric2D subsegment(double d, double d2) {
        d = Util.clampT(d, 0.0, 1.0);
        d2 = Util.clampT(d2, 0.0, 1.0);
        return new LineSeg2D(this.get(d), this.get(d2));
    }

    @Override
    public void append(Path2D.Double double_) {
        double_.lineTo(this.p2.x, this.p2.y);
    }

    @Override
    public IParametric2D reverse() {
        return new LineSeg2D(this.p2, this.p1);
    }

    public String toString() {
        return super.toString() + ": " + this.p1 + " -> " + this.p2;
    }
}

