/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.util.Arrays;
import java.util.Random;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Inter3D {
    public static final double DBL_EPSILON = 1.0E-9;

    public static boolean linePlaneIntersection(Point3d point3d, Point3d point3d2, Point3d point3d3, Plane3d plane3d, double d) {
        Vector3d vector3d = new Vector3d();
        vector3d.sub(point3d3, point3d2);
        vector3d.normalize();
        return Inter3D.linePlaneIntersection(point3d, point3d2, vector3d, plane3d, d);
    }

    public static double linePlaneIntersectionT(Point3d point3d, Vector3d vector3d, Plane3d plane3d, double d) {
        double d2 = vector3d.x * plane3d.x + vector3d.y * plane3d.y + vector3d.z * plane3d.z;
        if (theUtil.eq0(d2, d)) {
            return Double.NaN;
        }
        return -(plane3d.w + plane3d.x * point3d.x + plane3d.y * point3d.y + plane3d.z * point3d.z) / d2;
    }

    public static boolean linePlaneIntersection(Point3d point3d, Point3d point3d2, Vector3d vector3d, Plane3d plane3d, double d) {
        double d2 = Inter3D.linePlaneIntersectionT(point3d2, vector3d, plane3d, d);
        if (Double.isNaN(d2)) {
            return false;
        }
        point3d.x = point3d2.x + vector3d.x * d2;
        point3d.y = point3d2.y + vector3d.y * d2;
        point3d.z = point3d2.z + vector3d.z * d2;
        return true;
    }

    public static Point3d linePlaneIntersection(Point3d point3d, Vector3d vector3d, Plane3d plane3d, double d) {
        Point3d point3d2 = new Point3d();
        return Inter3D.linePlaneIntersection(point3d2, point3d, vector3d, plane3d, d) ? point3d2 : null;
    }

    public static Point3d lineSegPlaneIntersection(Point3d point3d, Point3d point3d2, Plane3d plane3d, double d) {
        double d2 = Inter3D.linePlaneIntersectionT(point3d, Util3D.vector(point3d, point3d2), plane3d, d);
        if (Double.isNaN(d2)) {
            return null;
        }
        if (Double.isNaN(d2 = Util.clampTIfValid(d2, 0.0, 1.0, d))) {
            return null;
        }
        return Util3D.linesegPoint(point3d, point3d2, d2);
    }

    public static Point3d rayPlaneIntersection(Point3d point3d, Vector3d vector3d, Plane3d plane3d, double d) {
        double d2 = Inter3D.linePlaneIntersectionT(point3d, vector3d, plane3d, d);
        if (Double.isNaN(d2)) {
            return null;
        }
        if (Double.isNaN(d2 = Util.clampTIfValid(d2, 0.0, Double.MAX_VALUE, d))) {
            return null;
        }
        return Util3D.linePoint(point3d, vector3d, d2);
    }

    public static boolean lineXPlaneIntersection(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2) {
        if (theUtil.eq0(vector3d.x, d2)) {
            return false;
        }
        double d3 = (d - point3d2.x) / vector3d.x;
        point3d.x = d;
        point3d.y = point3d2.y + vector3d.y * d3;
        point3d.z = point3d2.z + vector3d.z * d3;
        return true;
    }

    public static boolean lineYPlaneIntersection(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2) {
        if (theUtil.eq0(vector3d.y, d2)) {
            return false;
        }
        double d3 = (d - point3d2.y) / vector3d.y;
        point3d.x = point3d2.x + vector3d.x * d3;
        point3d.y = d;
        point3d.z = point3d2.z + vector3d.z * d3;
        return true;
    }

    public static boolean lineZPlaneIntersection(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2) {
        if (theUtil.eq0(vector3d.z, d2)) {
            return false;
        }
        double d3 = (d - point3d2.z) / vector3d.z;
        point3d.x = point3d2.x + vector3d.x * d3;
        point3d.y = point3d2.y + vector3d.y * d3;
        point3d.z = d;
        return true;
    }

    public static Point3d lineZPlaneIntersection(Point3d point3d, Vector3d vector3d, double d, double d2) {
        Point3d point3d2 = new Point3d();
        return Inter3D.lineZPlaneIntersection(point3d2, point3d, vector3d, d, d2) ? point3d2 : null;
    }

    public static boolean lineSegPolyIntersection(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, Plane3d plane3d, double d, Point3d ... point3dArray) {
        Point3d point3d4 = Inter3D.lineSegPolyIntersection(point3d2, point3d3, plane3d, d, point3dArray);
        if (point3d4 != null) {
            point3d.set(point3d4);
            return true;
        }
        return false;
    }

    public static Point3d lineSegPolyIntersection(Point3d point3d, Point3d point3d2, Plane3d plane3d, double d, Point3d ... point3dArray) {
        Point3d point3d3;
        Vector3d vector3d = Util3D.vector(point3d, point3d2);
        double d2 = Inter3D.linePlaneIntersectionT(point3d, vector3d, plane3d, d);
        if (!Double.isNaN(d2) && theUtil.ge0(d2, d) && theUtil.le(d2, 1.0, d) && Inter3D.pointInPoly(d, point3d3 = Util3D.linePoint(point3d, vector3d, d2), point3dArray)) {
            return point3d3;
        }
        return null;
    }

    public static Point3d linePolyIntersection(Point3d point3d, Vector3d vector3d, Plane3d plane3d, double d, Point3d ... point3dArray) {
        Point3d point3d2 = new Point3d();
        return Inter3D.linePolyIntersection(point3d2, point3d, vector3d, plane3d, d, point3dArray) ? point3d2 : null;
    }

    public static boolean linePolyIntersection(Point3d point3d, Point3d point3d2, Vector3d vector3d, Plane3d plane3d, double d, Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        if (!Inter3D.linePlaneIntersection(point3d, point3d2, vector3d, plane3d, 1.0E-9)) {
            return false;
        }
        return Inter3D.pointInPoly(d, point3d, point3dArray);
    }

    public static boolean linePointIntersect(Point3d point3d, Vector3d vector3d, Point3d point3d2, double d) {
        Point3d point3d3 = Inter3D.linePointProximity(point3d, vector3d, point3d2);
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d2, point3d3);
        double d2 = vector3d2.lengthSquared();
        return d2 <= d;
    }

    public static double pointOnLine(Point3d point3d, Vector3d vector3d, Point3d point3d2, double d) {
        if (!Util3D.areParallel(vector3d, Util3D.vector(point3d, point3d2), d)) {
            return Double.NaN;
        }
        return Inter3D.nearestTOnLine(point3d, vector3d, point3d2);
    }

    public static double nearestTOnLine(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        double d = vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z;
        double d2 = point3d2.x - point3d.x;
        double d3 = point3d2.y - point3d.y;
        double d4 = point3d2.z - point3d.z;
        return (vector3d.x * d2 + vector3d.y * d3 + vector3d.z * d4) / d;
    }

    public static double nearestTOnLineSeg(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 == 0.0) {
            return 0.0;
        }
        double d5 = point3d3.x - point3d.x;
        double d6 = point3d3.y - point3d.y;
        double d7 = point3d3.z - point3d.z;
        double d8 = d * d5 + d2 * d6 + d3 * d7;
        if (d8 <= 0.0) {
            return 0.0;
        }
        if (d8 >= d4) {
            return 1.0;
        }
        return d8 / d4;
    }

    public static double distSqToNearestPtOnLine(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        double d = vector3d.x * vector3d.x + vector3d.y * vector3d.y + vector3d.z * vector3d.z;
        double d2 = point3d2.x - point3d.x;
        double d3 = point3d2.y - point3d.y;
        double d4 = point3d2.z - point3d.z;
        double d5 = vector3d.x * d2 + vector3d.y * d3 + vector3d.z * d4;
        return d2 * d2 + d3 * d3 + d4 * d4 - d5 * d5 / d;
    }

    public static double distSqToNearestPtOnLineSeg(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        double d4 = d * d + d2 * d2 + d3 * d3;
        if (d4 == 0.0) {
            return point3d3.distanceSquared(point3d);
        }
        double d5 = point3d3.x - point3d.x;
        double d6 = point3d3.y - point3d.y;
        double d7 = point3d3.z - point3d.z;
        double d8 = d * d5 + d2 * d6 + d3 * d7;
        if (d8 <= 0.0) {
            return point3d3.distanceSquared(point3d);
        }
        if (d8 >= d4) {
            return point3d3.distanceSquared(point3d2);
        }
        return Math.max(0.0, d5 * d5 + d6 * d6 + d7 * d7 - d8 * d8 / d4);
    }

    public static Point3d nearestPointOnLine(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        double d = Inter3D.nearestTOnLine(point3d, vector3d, point3d2);
        return Util3D.linePoint(point3d, vector3d, d);
    }

    public static Point3d nearestPointOnLineSeg(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        double d = Inter3D.nearestTOnLineSeg(point3d, point3d2, point3d3);
        return Util3D.linesegPoint(point3d, point3d2, d);
    }

    public static double pointOnLineSeg(Point3d point3d, Point3d point3d2, Point3d point3d3, double d) {
        double d2 = Inter3D.pointOnLine(point3d, Util3D.vector(point3d, point3d2), point3d3, d);
        if (Double.isNaN(d2)) {
            return d2;
        }
        double[] dArray = new double[]{d2};
        return Util.clampTIfValid(dArray, 0.0, 1.0, d) ? dArray[0] : Double.NaN;
    }

    public static Point3d copLineSegLineSeg(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d) {
        double[] dArray = Inter3D.copLineSegLineSegT(point3d, point3d2, point3d3, point3d4, d);
        if (dArray == null) {
            return null;
        }
        return Util3D.linesegPoint(point3d, point3d2, dArray[0]);
    }

    public static double[] copLineSegLineSegT(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d) {
        double[] dArray;
        Vector3d vector3d;
        Vector3d vector3d2 = Util3D.vector(point3d, point3d2);
        if (!Inter3D.copLineLine(point3d, vector3d2, point3d3, vector3d = Util3D.vector(point3d3, point3d4), dArray = new double[2], d)) {
            return null;
        }
        if (!Util.clampTIfValid(dArray, 0.0, 1.0, d)) {
            return null;
        }
        return dArray;
    }

    public static boolean areCoplanar(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d) {
        Plane3d plane3d = new Plane3d(point3d, point3d2, point3d3);
        double d2 = plane3d.dot(point3d4);
        return Math.abs(d2) <= d;
    }

    public static boolean copLineLine(Point3d point3d, Vector3d vector3d, Point3d point3d2, Vector3d vector3d2, double[] dArray, double d) {
        assert (dArray.length >= 2);
        Vector3d vector3d3 = Util3D.cross(vector3d, vector3d2);
        double d2 = vector3d3.lengthSquared();
        if (theUtil.eq0(Math.sqrt(d2), d)) {
            return false;
        }
        double d3 = 1.0 / d2;
        Vector3d vector3d4 = Util3D.vector(point3d, point3d2);
        Vector3d vector3d5 = new Vector3d();
        vector3d5.cross(vector3d4, vector3d2);
        dArray[0] = Util3D.dot(vector3d5, vector3d3) * d3;
        vector3d3.negate();
        vector3d4.negate();
        vector3d5.cross(vector3d4, vector3d);
        dArray[1] = Util3D.dot(vector3d5, vector3d3) * d3;
        return true;
    }

    public static boolean copLineLineSeg(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, double[] dArray, double d, double d2) {
        Vector3d vector3d2 = Util3D.vector(point3d2, point3d3);
        if (!Inter3D.copLineLine(point3d, vector3d, point3d2, vector3d2, dArray, d)) {
            return false;
        }
        dArray[1] = Util.clampTIfValid(dArray[1], 0.0, 1.0, d2);
        return !Double.isNaN(dArray[1]);
    }

    public static Point3d linePointProximity(Point3d point3d, Vector3d vector3d, Point3d point3d2) {
        Vector3d vector3d2 = new Vector3d(vector3d);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(point3d2, point3d);
        double d = vector3d2.dot(vector3d3);
        vector3d2.scale(d);
        Point3d point3d3 = new Point3d();
        point3d3.add(point3d, vector3d2);
        return point3d3;
    }

    public static Point3d lineLineSegIntersection(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, double d) {
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d3, point3d2);
        return Inter3D.lineLineSegIntersection(point3d, vector3d, point3d2, point3d3, vector3d2, d);
    }

    public static Point3d lineLineSegIntersection(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d2, double d) {
        Point3d point3d4 = new Point3d();
        Point3d point3d5 = new Point3d();
        boolean bl = Inter3D.lineLineSegProximity(point3d4, point3d5, point3d, vector3d, point3d2, point3d3, vector3d2);
        if (!bl) {
            return null;
        }
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub(point3d5, point3d4);
        double d2 = vector3d3.lengthSquared();
        if (d2 <= d) {
            return point3d4;
        }
        return null;
    }

    public static double[] lineSegLineSegIntersection(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d) {
        Point3d point3d5;
        double[] dArray = Inter3D.lineSegLineSegProximityT(point3d, point3d2, point3d3, point3d4, d);
        if (dArray == null) {
            return null;
        }
        Point3d point3d6 = Util3D.linesegPoint(point3d, point3d2, dArray[0]);
        return (double[])(point3d6.distance(point3d5 = Util3D.linesegPoint(point3d3, point3d4, dArray[1])) <= d ? dArray : null);
    }

    public static double[] lineSeglineSegOverlap(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d) {
        double d2;
        Vector3d vector3d;
        Vector3d vector3d2 = Util3D.vector(point3d, point3d2);
        if (!Util3D.areAligned(point3d, vector3d2, point3d3, vector3d = Util3D.vector(point3d3, point3d4), d)) {
            return null;
        }
        double d3 = Inter3D.nearestTOnLine(point3d, vector3d2, point3d3);
        double[] dArray = Util.clampTRange(d3, d2 = Inter3D.nearestTOnLine(point3d, vector3d2, point3d4));
        if (dArray[0] < 1.0 && dArray[1] > 0.0 && dArray[0] != dArray[1]) {
            return dArray;
        }
        return null;
    }

    public static double[] lineLineProximityT(Point3d point3d, Vector3d vector3d, Point3d point3d2, Vector3d vector3d2, double d) {
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        if (theUtil.eq0(vector3d3.length(), d)) {
            return null;
        }
        double[] dArray = new double[2];
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d3, vector3d2);
        vector3d4.normalize();
        Plane3d plane3d = Util3D.getPlane(vector3d4, point3d2);
        dArray[0] = Inter3D.linePlaneIntersectionT(point3d, vector3d, plane3d, d);
        Vector3d vector3d5 = new Vector3d();
        vector3d5.cross(vector3d3, vector3d);
        vector3d5.normalize();
        Plane3d plane3d2 = Util3D.getPlane(vector3d5, point3d);
        dArray[1] = Inter3D.linePlaneIntersectionT(point3d2, vector3d2, plane3d2, d);
        return dArray;
    }

    public static double[] lineSegLineSegProximityT(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d) {
        Vector3d vector3d;
        Vector3d vector3d2 = Util3D.vector(point3d, point3d2);
        double[] dArray = Inter3D.lineLineProximityT(point3d, vector3d2, point3d3, vector3d = Util3D.vector(point3d3, point3d4), d);
        if (dArray == null) {
            return null;
        }
        Util.clampTs(dArray, 0.0, 1.0);
        return dArray;
    }

    public static double[] lineLineSegProximityT(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, double d) {
        Vector3d vector3d2 = Util3D.vector(point3d2, point3d3);
        double[] dArray = Inter3D.lineLineProximityT(point3d, vector3d, point3d2, vector3d2, d);
        if (dArray == null) {
            return null;
        }
        dArray[1] = Util.clampT(dArray[1], 0.0, 1.0);
        return dArray;
    }

    public static boolean lineSegLineSegProximity(Point3d point3d, Point3d point3d2, Vector3d vector3d, Point3d point3d3, Point3d point3d4, Vector3d vector3d2, Point3d point3d5, Point3d point3d6) {
        return Inter3D.lineSegLineSegProximity(point3d, point3d2, vector3d, point3d3, point3d4, vector3d2, point3d5, point3d6, 1.0E-9);
    }

    public static boolean lineSegLineSegProximity(Point3d point3d, Point3d point3d2, Vector3d vector3d, Point3d point3d3, Point3d point3d4, Vector3d vector3d2, Point3d point3d5, Point3d point3d6, double d) {
        double[] dArray = Inter3D.lineSegLineSegProximityT(point3d, point3d2, point3d3, point3d4, d);
        if (dArray == null) {
            return false;
        }
        if (point3d5 != null) {
            point3d5.set(Util3D.linesegPoint(point3d, point3d2, dArray[0]));
        }
        if (point3d6 != null) {
            point3d6.set(Util3D.linesegPoint(point3d3, point3d4, dArray[1]));
        }
        return true;
    }

    public static boolean lineLineProximity(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, Point3d point3d4, Vector3d vector3d2) {
        return Inter3D.lineLineProximity(point3d, point3d2, point3d3, vector3d, point3d4, vector3d2, 1.0E-9);
    }

    public static boolean lineLineProximity(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, Point3d point3d4, Vector3d vector3d2, double d) {
        double[] dArray = Inter3D.lineLineProximityT(point3d3, vector3d, point3d4, vector3d2, d);
        if (dArray == null) {
            return false;
        }
        if (point3d != null) {
            point3d.set(Util3D.linePoint(point3d3, vector3d, dArray[0]));
        }
        if (point3d2 != null) {
            point3d2.set(Util3D.linePoint(point3d4, vector3d2, dArray[1]));
        }
        return true;
    }

    public static boolean lineLineSegProximity(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, Point3d point3d4, Point3d point3d5) {
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub(point3d5, point3d4);
        return Inter3D.lineLineSegProximity(point3d, point3d2, point3d3, vector3d, point3d4, point3d5, vector3d2);
    }

    public static boolean lineLineSegProximity(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, Point3d point3d4, Point3d point3d5, Vector3d vector3d2) {
        double[] dArray = Inter3D.lineLineSegProximityT(point3d3, vector3d, point3d4, point3d5, 1.0E-9);
        if (dArray == null) {
            return false;
        }
        if (point3d != null) {
            point3d.set(Util3D.linePoint(point3d3, vector3d, dArray[0]));
        }
        if (point3d2 != null) {
            point3d2.set(Util3D.linesegPoint(point3d4, point3d5, dArray[1]));
        }
        return true;
    }

    public static boolean pointWithinSeg(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d) {
        double d = Util3D.dot(vector3d, point3d);
        double d2 = Util3D.dot(vector3d, point3d2);
        double d3 = Util3D.dot(vector3d, point3d3);
        return !(d < d2 && d < d3) && (!(d > d2) || !(d > d3));
    }

    public static boolean constrainPoint(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        if (Util3D.isPointBehindPlane(point3d, point3d2, vector3d)) {
            point3d.set(point3d2);
            return true;
        }
        return false;
    }

    public static double lineXPlaneIsect(Point3d point3d, Vector3d vector3d, double d, double d2) {
        if (theUtil.eq0(vector3d.x, d2)) {
            return Double.NaN;
        }
        return (d - point3d.x) / vector3d.x;
    }

    public static double lineYPlaneIsect(Point3d point3d, Vector3d vector3d, double d, double d2) {
        if (theUtil.eq0(vector3d.y, d2)) {
            return Double.NaN;
        }
        return (d - point3d.y) / vector3d.y;
    }

    public static double lineZPlaneIsect(Point3d point3d, Vector3d vector3d, double d, double d2) {
        if (theUtil.eq0(vector3d.z, d2)) {
            return Double.NaN;
        }
        return (d - point3d.z) / vector3d.z;
    }

    public static double lineXFaceIsect(Point3d point3d, Vector3d vector3d, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Inter3D.lineXPlaneIsect(point3d, vector3d, d5, d6);
        if (Double.isNaN(d7)) {
            return d7;
        }
        double d8 = point3d.y + vector3d.y * d7;
        double d9 = point3d.z + vector3d.z * d7;
        if (theUtil.le(d, d8, d6) && theUtil.le(d8, d2, d6) && theUtil.le(d3, d9, d6) && theUtil.le(d9, d4, d6)) {
            return d7;
        }
        return Double.NaN;
    }

    public static double lineYFaceIsect(Point3d point3d, Vector3d vector3d, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Inter3D.lineYPlaneIsect(point3d, vector3d, d5, d6);
        if (Double.isNaN(d7)) {
            return d7;
        }
        double d8 = point3d.x + vector3d.x * d7;
        double d9 = point3d.z + vector3d.z * d7;
        if (theUtil.le(d, d8, d6) && theUtil.le(d8, d2, d6) && theUtil.le(d3, d9, d6) && theUtil.le(d9, d4, d6)) {
            return d7;
        }
        return Double.NaN;
    }

    public static double lineZFaceIsect(Point3d point3d, Vector3d vector3d, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Inter3D.lineZPlaneIsect(point3d, vector3d, d5, d6);
        if (Double.isNaN(d7)) {
            return d7;
        }
        double d8 = point3d.x + vector3d.x * d7;
        double d9 = point3d.y + vector3d.y * d7;
        if (theUtil.le(d, d8, d6) && theUtil.le(d8, d2, d6) && theUtil.le(d3, d9, d6) && theUtil.le(d9, d4, d6)) {
            return d7;
        }
        return Double.NaN;
    }

    public static double rayXFaceIsect(Point3d point3d, Vector3d vector3d, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Inter3D.lineXFaceIsect(point3d, vector3d, d, d2, d3, d4, d5, d6);
        if (Double.isNaN(d8)) {
            return d8;
        }
        if (theUtil.lt0(d8, d7)) {
            return Double.NaN;
        }
        return d8 < 0.0 ? 0.0 : d8;
    }

    public static double rayYFaceIsect(Point3d point3d, Vector3d vector3d, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Inter3D.lineYFaceIsect(point3d, vector3d, d, d2, d3, d4, d5, d6);
        if (Double.isNaN(d8)) {
            return d8;
        }
        if (theUtil.lt0(d8, d7)) {
            return Double.NaN;
        }
        return d8 < 0.0 ? 0.0 : d8;
    }

    public static double rayZFaceIsect(Point3d point3d, Vector3d vector3d, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Inter3D.lineZFaceIsect(point3d, vector3d, d, d2, d3, d4, d5, d6);
        if (Double.isNaN(d8)) {
            return d8;
        }
        if (theUtil.lt0(d8, d7)) {
            return Double.NaN;
        }
        return d8 < 0.0 ? 0.0 : d8;
    }

    public static double linesegXFaceIsect(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Inter3D.lineXFaceIsect(point3d, vector3d, d, d2, d3, d4, d5, d6);
        if (Double.isNaN(d8)) {
            return d8;
        }
        return Util.clampTIfValid(d8, 0.0, 1.0, d7);
    }

    public static double linesegYFaceIsect(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Inter3D.lineYFaceIsect(point3d, vector3d, d, d2, d3, d4, d5, d6);
        if (Double.isNaN(d8)) {
            return d8;
        }
        return Util.clampTIfValid(d8, 0.0, 1.0, d7);
    }

    public static double linesegZFaceIsect(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Inter3D.lineZFaceIsect(point3d, vector3d, d, d2, d3, d4, d5, d6);
        if (Double.isNaN(d8)) {
            return d8;
        }
        return Util.clampTIfValid(d8, 0.0, 1.0, d7);
    }

    public static double[] rayAABoxIsect(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, double d) {
        double[] dArray = Inter3D.lineAABoxIsect(point3d, vector3d, point3d2, point3d3, d);
        if (dArray == null) {
            return null;
        }
        double d2 = d / vector3d.length();
        if (theUtil.lt0(dArray[1], d2)) {
            return null;
        }
        if (dArray[0] < 0.0) {
            dArray[0] = 0.0;
        }
        if (dArray[1] < 0.0) {
            dArray[1] = 0.0;
        }
        return dArray;
    }

    public static double[] linesegAABoxIsect(Point3d point3d, Point3d point3d2, Vector3d vector3d, Point3d point3d3, Point3d point3d4, double d) {
        double[] dArray = Inter3D.lineAABoxIsect(point3d, vector3d, point3d3, point3d4, d);
        if (dArray == null) {
            return null;
        }
        double d2 = d / vector3d.length();
        if (theUtil.lt0(dArray[1], d2) || theUtil.gt(dArray[0], 1.0, d2)) {
            return null;
        }
        Util.clampTs(dArray, 0.0, 1.0);
        return dArray;
    }

    public static double[] lineAABoxIsect(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, double d) {
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double d4 = Inter3D.lineXFaceIsect(point3d, vector3d, point3d2.y, point3d3.y, point3d2.z, point3d3.z, point3d2.x, d);
        if (!Double.isNaN(d4)) {
            if (d4 < d2) {
                d2 = d4;
            }
            if (d4 > d3) {
                d3 = d4;
            }
        }
        if (!Double.isNaN(d4 = Inter3D.lineXFaceIsect(point3d, vector3d, point3d2.y, point3d3.y, point3d2.z, point3d3.z, point3d3.x, d))) {
            if (d4 < d2) {
                d2 = d4;
            }
            if (d4 > d3) {
                d3 = d4;
            }
        }
        if (!Double.isNaN(d4 = Inter3D.lineYFaceIsect(point3d, vector3d, point3d2.x, point3d3.x, point3d2.z, point3d3.z, point3d2.y, d))) {
            if (d4 < d2) {
                d2 = d4;
            }
            if (d4 > d3) {
                d3 = d4;
            }
        }
        if (!Double.isNaN(d4 = Inter3D.lineYFaceIsect(point3d, vector3d, point3d2.x, point3d3.x, point3d2.z, point3d3.z, point3d3.y, d))) {
            if (d4 < d2) {
                d2 = d4;
            }
            if (d4 > d3) {
                d3 = d4;
            }
        }
        if (!Double.isNaN(d4 = Inter3D.lineZFaceIsect(point3d, vector3d, point3d2.x, point3d3.x, point3d2.y, point3d3.y, point3d2.z, d))) {
            if (d4 < d2) {
                d2 = d4;
            }
            if (d4 > d3) {
                d3 = d4;
            }
        }
        if (!Double.isNaN(d4 = Inter3D.lineZFaceIsect(point3d, vector3d, point3d2.x, point3d3.x, point3d2.y, point3d3.y, point3d3.z, d))) {
            if (d4 < d2) {
                d2 = d4;
            }
            if (d4 > d3) {
                d3 = d4;
            }
        }
        if (d2 == Double.MAX_VALUE || d3 == -1.7976931348623157E308) {
            return null;
        }
        return new double[]{d2, d3};
    }

    private static boolean pointInsideAABB(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        return point3d2.x <= point3d.x && point3d.x <= point3d3.x && point3d2.y <= point3d.y && point3d.y <= point3d3.y && point3d2.z <= point3d.z && point3d.z <= point3d3.z;
    }

    public static boolean sphereSphereIsect(Point3d point3d, double d, Point3d point3d2, double d2, double d3) {
        return point3d.distance(point3d2) - d - d2 < -d3;
    }

    public static int sphereContainsAABB(Point3d point3d, double d, Point3d point3d2, Point3d point3d3) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(Inter3D.testSphereAABB(point3d, d, point3d2, point3d3));
    }

    public static Containment testSphereAABB(Point3d point3d, double d, Point3d point3d2, Point3d point3d3) {
        boolean bl;
        double d2 = point3d.x - point3d2.x;
        double d3 = point3d.y - point3d2.y;
        double d4 = point3d.z - point3d2.z;
        double d5 = point3d.x - point3d3.x;
        double d6 = point3d.y - point3d3.y;
        double d7 = point3d.z - point3d3.z;
        double d8 = d2 * d2;
        double d9 = d3 * d3;
        double d10 = d4 * d4;
        double d11 = d5 * d5;
        double d12 = d6 * d6;
        double d13 = d7 * d7;
        boolean bl2 = d8 + d9 + d10 <= d;
        boolean bl3 = bl = d11 + d12 + d13 <= d;
        if (bl2 && bl) {
            return Containment.INSIDE;
        }
        if (bl2 || bl) {
            return Containment.INTERSECTS;
        }
        double d14 = 0.0;
        if (point3d.x < point3d2.x) {
            d14 += d8;
        } else if (point3d.x > point3d3.x) {
            d14 += d11;
        }
        if (point3d.y < point3d2.y) {
            d14 += d9;
        } else if (point3d.y > point3d3.y) {
            d14 += d12;
        }
        if (point3d.z < point3d2.z) {
            d14 += d10;
        } else if (point3d.z > point3d3.z) {
            d14 += d13;
        }
        return d14 <= d ? Containment.INTERSECTS : Containment.OUTSIDE;
    }

    public static boolean pointInPoly(double d, Point3d point3d, Point3d ... point3dArray) {
        return Inter3D.classifyConvexPolyPoint((double)d, (Point3d)point3d, (Point3d[])point3dArray).positive;
    }

    public static PointClassify classifyConvexPolyPoint(double d, Point3d point3d, Point3d ... point3dArray) {
        assert (point3dArray.length >= 3);
        double d2 = d * d;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = null;
        int n = 0;
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d point3d2 = point3dArray[i];
            Point3d point3d3 = point3dArray[(i + 1) % point3dArray.length];
            vector3d2.sub(point3d3, point3d2);
            if (theUtil.eq0(vector3d2.lengthSquared(), d2)) continue;
            vector3d.sub(point3d, point3d2);
            vector3d3.cross(vector3d2, vector3d);
            double d3 = vector3d3.lengthSquared();
            if (theUtil.eq0(d3, d2)) {
                double d4 = vector3d.dot(vector3d2);
                return Util.checkRange(0.0, vector3d2.dot(vector3d2), d4, d) ? PointClassify.ON_BOUNDARY : PointClassify.OUTSIDE;
            }
            vector3d3.scale(1.0 / Math.sqrt(d3));
            if (vector3d4 == null) {
                vector3d4 = new Vector3d(vector3d3);
                continue;
            }
            if (vector3d4.dot(vector3d3) < 0.0) {
                return PointClassify.OUTSIDE;
            }
            ++n;
        }
        return n > 0 ? PointClassify.INSIDE : PointClassify.OUTSIDE;
    }

    public static boolean pointInSimplePoly(double d, Point3d point3d, Point3d[][] point3dArray) {
        return Inter3D.classifySimplePolyPoint((double)d, (Point3d)point3d, (Point3d[][])point3dArray).positive;
    }

    public static PointClassify classifySimplePolyPoint(double d, Point3d point3d, Point3d[][] point3dArray) {
        if (point3dArray.length == 0) {
            return PointClassify.OUTSIDE;
        }
        Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(point3dArray[0]));
        if (plane3d == null) {
            return PointClassify.OUTSIDE;
        }
        return Inter3D.classifySimplePolyPoint(d, point3d, plane3d, point3dArray);
    }

    public static boolean pointInSimplePoly(double d, Point3d point3d, Plane3d plane3d, Point3d[][] point3dArray) {
        return Inter3D.classifySimplePolyPoint((double)d, (Point3d)point3d, (Plane3d)plane3d, (Point3d[][])point3dArray).positive;
    }

    public static PointClassify classifySimplePolyPoint(double d, Point3d point3d, Plane3d plane3d, Point3d[][] point3dArray) {
        Random random = new Random(0L);
        Vector3d vector3d = plane3d.getNormal();
        Vector3d vector3d2 = new Vector3d();
        for (int i = 0; i < 15; ++i) {
            Vector3d vector3d3 = Util3D.newRandomVector(random);
            vector3d2.cross(vector3d, vector3d3);
            PointClassify pointClassify = Inter3D.testPointInSimplePoly(point3dArray, point3d, vector3d2, d);
            if (pointClassify == null) continue;
            return pointClassify;
        }
        System.err.println("Could not complete Inter3D.pointInSimplePoly using test point = " + point3d.toString());
        return PointClassify.OUTSIDE;
    }

    private static PointClassify testPointInSimplePoly(Point3d[][] point3dArray, Point3d point3d, Vector3d vector3d, double d) {
        int n = 0;
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d[] point3dArray2 = point3dArray[i];
            for (int j = 0; j < point3dArray2.length; ++j) {
                Point3d point3d2 = point3dArray2[j];
                Point3d point3d3 = point3dArray2[(j + 1) % point3dArray2.length];
                Vector3d vector3d2 = Util3D.vector(point3d2, point3d3);
                double[] dArray = Inter3D.lineLineProximityT(point3d, vector3d, point3d2, vector3d2, d);
                if (dArray == null || !Util.checkRange(0.0, 1.0, dArray[1], d)) continue;
                double d2 = dArray[0];
                double d3 = dArray[1];
                if (theUtil.eq0(d2, d)) {
                    return PointClassify.ON_BOUNDARY;
                }
                if (d2 < 0.0) continue;
                if (theUtil.eq0(d3, d) || theUtil.eq(d3, 1.0, d)) {
                    return null;
                }
                ++n;
            }
        }
        return n % 2 != 0 ? PointClassify.INSIDE : PointClassify.OUTSIDE;
    }

    public static void projectOntoAxis(Point3d[] point3dArray, Vector3d vector3d, double[] dArray) {
        double d;
        assert (point3dArray.length > 2);
        double d2 = d = Util3D.dot(vector3d, point3dArray[0]);
        for (int i = 1; i < point3dArray.length; ++i) {
            Point3d point3d = point3dArray[i];
            double d3 = Util3D.dot(vector3d, point3d);
            if (d3 < d) {
                d = d3;
                continue;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    public static Vector3d[] getEdges(Point3d ... point3dArray) {
        int n = point3dArray.length;
        Vector3d[] vector3dArray = new Vector3d[n];
        for (int i = 0; i < n; ++i) {
            Point3d point3d = point3dArray[i];
            Point3d point3d2 = point3dArray[(i + 1) % n];
            vector3dArray[i] = new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
        }
        return vector3dArray;
    }

    public static boolean faceFaceIsect(Point3d[] point3dArray, Point3d[] point3dArray2, double d) {
        assert (point3dArray.length > 2 && point3dArray2.length > 2);
        Plane3d plane3d = new Plane3d(point3dArray);
        Plane3d plane3d2 = new Plane3d(point3dArray2);
        Vector3d vector3d = plane3d.getNormal();
        double[] dArray = new double[2];
        double d2 = Util3D.dot(vector3d, point3dArray[0]);
        Inter3D.projectOntoAxis(point3dArray2, vector3d, dArray);
        if (d2 < dArray[0] || d2 > dArray[1]) {
            return false;
        }
        Vector3d vector3d2 = plane3d2.getNormal();
        Vector3d[] vector3dArray = Inter3D.getEdges(point3dArray);
        Vector3d[] vector3dArray2 = Inter3D.getEdges(point3dArray2);
        double[] dArray2 = new double[2];
        Vector3d vector3d3 = Util3D.cross(vector3d, vector3d2);
        vector3d3.normalize();
        if (vector3d3.dot(vector3d3) >= d) {
            d2 = Util3D.dot(vector3d2, point3dArray2[0]);
            Inter3D.projectOntoAxis(point3dArray, vector3d2, dArray2);
            if (d2 < dArray2[0] || d2 > dArray2[1]) {
                return false;
            }
            for (int i = 0; i < vector3dArray2.length; ++i) {
                for (int j = 0; j < vector3dArray.length; ++j) {
                    Vector3d vector3d4 = Util3D.cross(vector3dArray[j], vector3dArray2[i]);
                    vector3d4.normalize();
                    Inter3D.projectOntoAxis(point3dArray, vector3d4, dArray2);
                    Inter3D.projectOntoAxis(point3dArray2, vector3d4, dArray);
                    if (!(dArray2[1] < dArray[0]) && !(dArray[1] < dArray2[0])) continue;
                    return false;
                }
            }
        } else {
            Vector3d vector3d5;
            int n;
            for (n = 0; n < vector3dArray.length; ++n) {
                vector3d5 = Util3D.cross(vector3d, vector3dArray[n]);
                vector3d5.normalize();
                Inter3D.projectOntoAxis(point3dArray, vector3d5, dArray2);
                Inter3D.projectOntoAxis(point3dArray2, vector3d5, dArray);
                if (!(dArray2[1] < dArray[0]) && !(dArray[1] < dArray2[0])) continue;
                return false;
            }
            for (n = 0; n < vector3dArray2.length; ++n) {
                vector3d5 = Util3D.cross(vector3d2, vector3dArray2[n]);
                vector3d5.normalize();
                Inter3D.projectOntoAxis(point3dArray, vector3d5, dArray2);
                Inter3D.projectOntoAxis(point3dArray2, vector3d5, dArray);
                if (!(dArray2[1] < dArray[0]) && !(dArray[1] < dArray2[0])) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean faceAABoxIsect(double d, AABox aABox, Point3d ... point3dArray) {
        for (Point3d point3d : point3dArray) {
            if (!aABox.contains(point3d, d)) continue;
            return true;
        }
        for (Point3d point3d : aABox.getFaces()) {
            if (!Inter3D.faceFaceIsect(point3dArray, (Point3d[])point3d, d)) continue;
            return true;
        }
        return false;
    }

    public static int convexHullContainsAABB(Point3d point3d, Point3d point3d2, Plane3d ... plane3dArray) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(Inter3D.testConvexHullAABB(point3d, point3d2, plane3dArray));
    }

    public static Containment testConvexHullAABB(Point3d point3d, Point3d point3d2, Plane3d ... plane3dArray) {
        int n = 0;
        for (Plane3d plane3d : plane3dArray) {
            int n2 = 8;
            int n3 = 1;
            if (plane3d.dot(point3d.x, point3d.y, point3d.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d.x, point3d.y, point3d2.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d.x, point3d2.y, point3d.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d.x, point3d2.y, point3d2.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d2.x, point3d.y, point3d.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d2.x, point3d.y, point3d2.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d2.x, point3d2.y, point3d.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d2.x, point3d2.y, point3d2.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (n2 == 0) {
                return Containment.OUTSIDE;
            }
            n += n3;
        }
        return n == plane3dArray.length ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public static double[] movingSphereMovingSphereIsect(Point3d point3d, double d, Vector3d vector3d, Point3d point3d2, double d2, Vector3d vector3d2, double d3) {
        Vector3d vector3d3 = Util3D.sub(vector3d, (Tuple3d)vector3d2);
        return Inter3D.movingSphereSphereIsect(point3d, d, vector3d3, point3d2, d2, d3);
    }

    public static double[] movingSphereSphereIsect(Point3d point3d, double d, Vector3d vector3d, Point3d point3d2, double d2, double d3) {
        double d4 = d + d2;
        double[] dArray = Inter3D.raySphereIsectT(point3d, vector3d, point3d2, d4 * d4, d3);
        return dArray;
    }

    public static double[] raySphereIsectT(Point3d point3d, Vector3d vector3d, Point3d point3d2, double d, double d2) {
        double d3;
        double d4 = vector3d.lengthSquared();
        if (theUtil.eq0(d4, d2)) {
            return null;
        }
        Vector3d vector3d2 = Util3D.vector(point3d2, point3d);
        double d5 = 2.0 * vector3d.dot(vector3d2);
        double d6 = d5 * d5 - 4.0 * d4 * (d3 = Util3D.dot(point3d2, point3d2) + Util3D.dot(point3d, point3d) - 2.0 * Util3D.dot(point3d2, point3d) - d);
        if (theUtil.gt0(d6, d2)) {
            double d7 = Math.sqrt(d6);
            double d8 = 0.5 / d4;
            return new double[]{(-d5 - d7) * d8, (-d5 + d7) * d8};
        }
        if (theUtil.lt0(d6, d2)) {
            return null;
        }
        double d9 = -d5 / (2.0 * d4);
        return new double[]{d9, d9};
    }

    public static Point3d[] raySphereIsect(Point3d point3d, Vector3d vector3d, Point3d point3d2, double d, double d2) {
        double[] dArray = Inter3D.raySphereIsectT(point3d, vector3d, point3d2, d, d2);
        if (dArray != null) {
            Point3d[] point3dArray = new Point3d[]{Util3D.linePoint(point3d, vector3d, dArray[0]), Util3D.linePoint(point3d, vector3d, dArray[1])};
            return point3dArray;
        }
        return null;
    }

    public static boolean pointInSphere(Point3d point3d, Point3d point3d2, double d) {
        return point3d.distanceSquared(point3d2) <= d;
    }

    public static boolean movingSphereLineSegIsect(Point3d point3d, double d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, double[] dArray, double d2) {
        if (d == 0.0) {
            Point3d point3d4 = Inter3D.copRayLineSeg(point3d, vector3d, point3d2, point3d3, dArray, d2);
            if (point3d4 != null) {
                dArray[1] = dArray[0];
            }
            return point3d4 != null;
        }
        if (Inter3D.rayCapsuleIsect(point3d, vector3d, point3d2, point3d3, d, dArray, d2)) {
            return !theUtil.eq(dArray[0], dArray[1], d2);
        }
        return false;
    }

    public static Point3d copRayLineSeg(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, double[] dArray, double d) {
        Point3d point3d4;
        Vector3d vector3d2 = Util3D.vector(point3d2, point3d3);
        if (!Inter3D.copLineLine(point3d, vector3d, point3d2, vector3d2, dArray, d)) {
            if (Inter3D.isOnLine(point3d2, point3d, vector3d, d)) {
                double d2 = Util3D.tOnLine(point3d, vector3d, point3d2);
                double d3 = Util3D.tOnLine(point3d, vector3d, point3d3);
                if (d2 < 0.0 && d3 > 0.0 || d2 > 0.0 && d3 < 0.0) {
                    dArray[0] = 0.0;
                    dArray[1] = Util3D.tOnLineSeg(point3d2, point3d3, point3d);
                    return new Point3d(point3d);
                }
                if (d2 >= 0.0 && d3 >= 0.0) {
                    if (d2 <= d3) {
                        dArray[0] = d2;
                        dArray[1] = 0.0;
                        return new Point3d(point3d2);
                    }
                    dArray[0] = d3;
                    dArray[1] = 1.0;
                    return new Point3d(point3d3);
                }
            }
            return null;
        }
        Point3d point3d5 = Util3D.linePoint(point3d, vector3d, dArray[0]);
        return point3d5.distance(point3d4 = Util3D.linesegPoint(point3d2, point3d3, dArray[1])) <= d ? point3d4 : null;
    }

    public static boolean isOnLine(Point3d point3d, Point3d point3d2, Vector3d vector3d, double d) {
        Point3d point3d3 = Inter3D.nearestPointOnLine(point3d2, vector3d, point3d);
        return point3d3.distance(point3d) <= d;
    }

    public static Point3d edgeCenter(Point3d point3d, Point3d point3d2) {
        return new Point3d((point3d.x + point3d2.x) * 0.5, (point3d.y + point3d2.y) * 0.5, (point3d.z + point3d2.z) * 0.5);
    }

    public static double[] lineSegCapsuleIsect(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4, double d, double d2) {
        double[] dArray;
        Vector3d vector3d = Util3D.vector(point3d, point3d2);
        boolean bl = Inter3D.rayCapsuleIsect(point3d, vector3d, point3d3, point3d4, d, dArray = new double[2], d2);
        if (!bl) {
            return null;
        }
        Util.clampTs(dArray, 0.0, 1.0);
        if (theUtil.eq(dArray[0], dArray[1], d2)) {
            return null;
        }
        assert (dArray[0] < dArray[1]);
        return dArray;
    }

    public static boolean rayCapsuleIsect(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3, double d, double[] dArray, double d2) {
        Point3d point3d4 = Inter3D.edgeCenter(point3d2, point3d3);
        Vector3d vector3d2 = Util3D.vector(point3d2, point3d3);
        double d3 = vector3d2.length();
        vector3d2.scale(1.0 / d3);
        return Inter3D.rayCapsuleIsect(point3d, vector3d, point3d4, vector3d2, d3, d, dArray, d2);
    }

    public static boolean rayCapsuleIsect(Point3d point3d, Vector3d vector3d, Point3d point3d2, Vector3d vector3d2, double d, double d2, double[] dArray, double d3) {
        return Inter3D.rayCapsuleIsect(point3d.x, point3d.y, point3d.z, vector3d.x, vector3d.y, vector3d.z, point3d2.x, point3d2.y, point3d2.z, vector3d2.x, vector3d2.y, vector3d2.z, d, d2, dArray, d3);
    }

    public static boolean rayCapsuleIsect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double[] dArray, double d15) {
        double d16 = d - d7;
        double d17 = d2 - d8;
        double d18 = d3 - d9;
        double d19 = d4 * d4 + d5 * d5 + d6 * d6;
        double d20 = d4 * d10 + d5 * d11 + d6 * d12;
        double d21 = d16 * d4 + d17 * d5 + d18 * d6;
        double d22 = d16 * d10 + d17 * d11 + d18 * d12;
        double d23 = d16 * d16 + d17 * d17 + d18 * d18;
        double d24 = d19 - d20 * d20;
        double d25 = d13 * 0.5;
        double d26 = d14 * d14;
        if (Math.abs(d24) < d15 * d15) {
            double d27;
            double d28;
            double d29 = d20 > 0.0 ? d25 : -d25;
            double d30 = d29 * d20;
            double d31 = d21 + d30;
            double d32 = d31 * d31 - d19 * ((d28 = d23 + d25 * d25 - d26) + (d27 = (d29 + d29) * d22));
            if (theUtil.le0(d32, d15)) {
                return false;
            }
            double d33 = d21 - d30;
            double d34 = d33 * d33 - d19 * (d28 - d27);
            if (theUtil.le0(d34, d15)) {
                return false;
            }
            double d35 = 1.0 / d19;
            dArray[0] = (-d31 - Math.sqrt(d32)) * d35;
            dArray[1] = (-d33 + Math.sqrt(d34)) * d35;
        } else {
            double d36 = d21 - d22 * d20;
            double d37 = d36 * d36 - d24 * (d23 - d22 * d22 - d26);
            if (d37 < 0.0) {
                return false;
            }
            double d38 = 1.0 / d24;
            d37 = Math.sqrt(d37);
            dArray[0] = (-d36 - d37) * d38;
            dArray[1] = (-d36 + d37) * d38;
            double d39 = d22 + dArray[0] * d20;
            double d40 = d22 + dArray[1] * d20;
            if (Math.abs(d39) > d25) {
                double d41;
                double d42;
                double d43 = d39 < 0.0 ? d25 : -d25;
                double d44 = d43 * d20;
                d36 = d21 + d44;
                d37 = d36 * d36 - d19 * ((d42 = d23 + d25 * d25 - d26) + (d41 = (d43 + d43) * d22));
                if (d37 < 0.0) {
                    return false;
                }
                d38 = 1.0 / d19;
                d37 = Math.sqrt(d37);
                dArray[0] = (-d36 - d37) * d38;
                if (Math.abs(d40) > d25) {
                    dArray[1] = d39 * d40 > 0.0 ? (-d36 + d37) * d38 : ((d37 = (d36 = d21 - d44) * d36 - d19 * (d42 - d41)) <= 0.0 ? -d36 * d38 : (-d36 + Math.sqrt(d37)) * d38);
                }
            } else if (Math.abs(d40) > d25) {
                double d45 = d40 < 0.0 ? d25 : -d25;
                d36 = d21 + d45 * d20;
                d37 = d36 * d36 - d19 * (d23 + (d45 + d45) * d22 + d25 * d25 - d26);
                dArray[1] = d37 <= 0.0 ? -d36 / d19 : (-d36 + Math.sqrt(d37)) / d19;
            }
        }
        return true;
    }

    public static Tuple3d[] planePlaneIsect(Plane3d plane3d, Plane3d plane3d2, double d) {
        if (Util3D.areParallel(plane3d, plane3d2, d)) {
            return null;
        }
        Vector3d vector3d = Util3D.cross(plane3d.getNormal(), plane3d2.getNormal());
        double d2 = plane3d.y * plane3d2.z - plane3d.z * plane3d2.y;
        if (!theUtil.eq0(d2, d)) {
            double d3 = (plane3d.z * plane3d2.w - plane3d2.z * plane3d.w) / d2;
            double d4 = (plane3d.y * plane3d2.w - plane3d2.y * plane3d.w) / -d2;
            return new Tuple3d[]{new Point3d(0.0, d3, d4), vector3d};
        }
        double d5 = plane3d.x * plane3d2.z - plane3d.z * plane3d2.x;
        if (!theUtil.eq0(d5, d)) {
            double d6 = (plane3d.z * plane3d2.w - plane3d2.z * plane3d.w) / d5;
            double d7 = (plane3d.x * plane3d2.w - plane3d2.x * plane3d.w) / -d5;
            return new Tuple3d[]{new Point3d(d6, 0.0, d7), vector3d};
        }
        double d8 = plane3d.x * plane3d2.y - plane3d.y * plane3d2.x;
        if (!theUtil.eq0(d8, d)) {
            double d9 = (plane3d.y * plane3d2.w - plane3d2.y * plane3d.w) / d8;
            double d10 = (plane3d.x * plane3d2.w - plane3d2.x * plane3d.w) / -d8;
            return new Tuple3d[]{new Point3d(d9, d10, 0.0), vector3d};
        }
        return null;
    }

    public static enum PointClassify {
        INSIDE(true),
        ON_BOUNDARY(true),
        OUTSIDE(false);

        public final boolean positive;

        private PointClassify(boolean bl) {
            this.positive = bl;
        }
    }
}

