/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.util.Random;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.GeomTests;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util2D;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Inter2D {
    public static double ISECT_TOL = 1.0E-7;

    public static double[] isectLinesegLineseg(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4, double d) {
        double[] dArray = Inter2D.isectLineLine(point2d, Util2D.vector(point2d, point2d2), point2d3, Util2D.vector(point2d3, point2d4), 1.0E-12);
        if (dArray == null) {
            return null;
        }
        if (!Util.clampTIfValid(dArray, 0.0, 1.0, d)) {
            return null;
        }
        return dArray;
    }

    public static boolean copLineSegLineSegCrossExact(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4) {
        return Inter2D.copLineSegLineSegCrossExact(point2d.x, point2d.y, point2d2.x, point2d2.y, point2d3.x, point2d3.y, point2d4.x, point2d4.y);
    }

    public static boolean copLineSegLineSegCrossExact(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = GeomTests.orient2d(d5, d6, d7, d8, d, d2);
        double d10 = GeomTests.orient2d(d5, d6, d7, d8, d3, d4);
        if (d9 < 0.0 && d10 < 0.0 || d9 > 0.0 && d10 > 0.0 || d9 == 0.0 && d10 == 0.0) {
            return false;
        }
        double d11 = GeomTests.orient2d(d, d2, d3, d4, d5, d6);
        double d12 = GeomTests.orient2d(d, d2, d3, d4, d7, d8);
        assert (d11 != 0.0 || d12 != 0.0);
        return d11 >= 0.0 && d12 <= 0.0 || d11 <= 0.0 && d12 >= 0.0;
    }

    public static double[] isectLineLine(Point2d point2d, Vector2d vector2d, Point2d point2d2, Vector2d vector2d2, double d) {
        double d2 = vector2d2.y * vector2d.x - vector2d2.x * vector2d.y;
        if (theUtil.eq0(d2, d)) {
            return null;
        }
        double d3 = 1.0 / d2;
        double d4 = point2d.y - point2d2.y;
        double d5 = point2d.x - point2d2.x;
        double d6 = (vector2d2.x * d4 - vector2d2.y * d5) * d3;
        double d7 = (vector2d.x * d4 - vector2d.y * d5) * d3;
        return new double[]{d6, d7};
    }

    public static double[] isectLineSegLineSeg(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4, double d) {
        double[] dArray = Inter2D.isectLineLine(point2d, Util2D.vector(point2d, point2d2), point2d3, Util2D.vector(point2d3, point2d4), d);
        if (dArray == null) {
            return null;
        }
        if (!Util.clampTIfValid(dArray, 0.0, 1.0, d)) {
            return null;
        }
        return dArray;
    }

    public static Point2d[] extendSeg(Point2d point2d, Point2d point2d2, Point2d point2d3, Vector2d vector2d, double d) {
        Vector2d vector2d2 = Util2D.vector(point2d, point2d2);
        double[] dArray = Inter2D.isectLineLine(point2d, vector2d2, point2d3, vector2d, d);
        if (dArray != null) {
            if (dArray[0] < 0.0) {
                return new Point2d[]{Util2D.linePoint(point2d, vector2d2, dArray[0]), point2d2};
            }
            if (dArray[0] > 1.0) {
                return new Point2d[]{point2d, Util2D.linePoint(point2d, vector2d2, dArray[0])};
            }
        }
        return new Point2d[]{point2d, point2d2};
    }

    public static double[][] lineSeglineSegOverlap(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4, double d) {
        double d2;
        double d3;
        Vector2d vector2d;
        Vector2d vector2d2 = Util2D.vector(point2d, point2d2);
        if (!Util2D.areLinesAligned(point2d, vector2d2, point2d3, vector2d = Util2D.vector(point2d3, point2d4), d)) {
            return null;
        }
        double d4 = Util2D.tOnLine(point2d, vector2d2, point2d3);
        if (d4 > (d3 = Util2D.tOnLine(point2d, vector2d2, point2d4))) {
            d2 = d4;
            d4 = d3;
            d3 = d2;
        }
        if (theUtil.gt(d4, 1.0, d) || theUtil.lt0(d3, -d)) {
            return null;
        }
        d4 = Util.clampT(d4, 0.0, 1.0);
        d3 = Util.clampT(d3, 0.0, 1.0);
        d2 = Util2D.tOnLine(point2d3, vector2d, Util2D.linePoint(point2d, vector2d2, d4));
        double d5 = Util2D.tOnLine(point2d3, vector2d, Util2D.linePoint(point2d, vector2d2, d3));
        d2 = Util.clampT(d2, 0.0, 1.0);
        d5 = Util.clampT(d5, 0.0, 1.0);
        return new double[][]{{d4, d3}, {d2, d5}};
    }

    public static Point2d nearestToLineSeg(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return Util2D.linePoint(point2d2, point2d3, Inter2D.nearestTOnLineSeg(point2d, point2d2, point2d3));
    }

    public static Point2d nearestPtOnLine(Point2d point2d, Vector2d vector2d, Point2d point2d2) {
        return Util2D.linePoint(point2d, vector2d, Inter2D.nearestTOnLine(point2d, vector2d, point2d2));
    }

    public static double nearestTOnLine(Point2d point2d, Vector2d vector2d, Point2d point2d2) {
        return Inter2D.nearestTOnLine(point2d.x, point2d.y, vector2d.x, vector2d.y, point2d2.x, point2d2.y);
    }

    public static double distSqToNearestPtOnLineSeg(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = d7 * d7 + d8 * d8;
        double d10 = d5 - d;
        double d11 = d6 - d2;
        if (d9 == 0.0) {
            return d10 * d10 + d11 * d11;
        }
        double d12 = d7 * d10 + d8 * d11;
        if (d12 <= 0.0) {
            return d10 * d10 + d11 * d11;
        }
        if (d12 >= d9) {
            d10 = d5 - d3;
            d11 = d6 - d4;
            return d10 * d10 + d11 * d11;
        }
        return Math.max(0.0, d10 * d10 + d11 * d11 - d12 * d12 / d9);
    }

    public static double distSqToNearestPtOnLine(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 * d3 + d4 * d4;
        double d8 = d5 - d;
        double d9 = d6 - d2;
        double d10 = d3 * d8 + d4 * d9;
        return d8 * d8 + d9 * d9 - d10 * d10 / d7;
    }

    public static double distSqToNearestPtOnLine2(double d, double d2, double d3, double d4, double d5, double d6) {
        return Inter2D.distSqToNearestPtOnLine(d, d2, d3 - d, d4 - d2, d5, d6);
    }

    public static double nearestTOnLine(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 * d3 + d4 * d4;
        if (d7 == 0.0) {
            return Double.NaN;
        }
        double d8 = d5 - d;
        double d9 = d6 - d2;
        return (d3 * d8 + d4 * d9) / d7;
    }

    public static double nearestTOnLineSeg(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        double d = Inter2D.nearestTOnLine(point2d2, Util2D.vector(point2d2, point2d3), point2d);
        return Double.isNaN(d) ? 0.0 : Util.clampT(d, 0.0, 1.0);
    }

    public static double pointOnLine(Point2d point2d, Vector2d vector2d, Point2d point2d2, double d) {
        if (!Util2D.areLinesParallel(vector2d, Util2D.vector(point2d, point2d2), d)) {
            return Double.NaN;
        }
        return Inter2D.nearestTOnLine(point2d, vector2d, point2d2);
    }

    public static double pointOnLineSeg(Point2d point2d, Point2d point2d2, Point2d point2d3, double d) {
        double d2 = Inter2D.pointOnLine(point2d, Util2D.vector(point2d, point2d2), point2d3, d);
        if (Double.isNaN(d2)) {
            return d2;
        }
        double[] dArray = new double[]{d2};
        return Util.clampTIfValid(dArray, 0.0, 1.0, d) ? dArray[0] : Double.NaN;
    }

    public static boolean aabbAABBIntersect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return d5 - d9 <= d3 + d9 && d7 + d9 >= d - d9 && d6 - d9 <= d4 + d9 && d8 + d9 >= d2 - d9;
    }

    public static boolean aabbAABBIntersect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return d5 <= d3 && d7 >= d && d6 <= d4 && d8 >= d2;
    }

    public static double[] lineCircleIsect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double[] dArray;
        double d9;
        double d10;
        double d11;
        double d12 = 2.0 * (d3 * (d -= d5) + d4 * (d2 -= d6));
        double d13 = d3 * d3 + d4 * d4;
        if (theUtil.lt0(d11 = d12 * d12 - 4.0 * d13 * (d10 = d * d + d2 * d2 - d7 * d7), d8)) {
            return null;
        }
        if (theUtil.le0(d11, d8)) {
            double d14 = -d12 / (2.0 * d13);
            return new double[]{d14, d14};
        }
        double d15 = 0.5 / d13;
        double d16 = Math.sqrt(d11);
        double d17 = (-d12 + d16) * d15;
        if (d17 <= (d9 = (-d12 - d16) * d15)) {
            double[] dArray2 = new double[2];
            dArray2[0] = d17;
            dArray = dArray2;
            dArray2[1] = d9;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = d9;
            dArray = dArray3;
            dArray3[1] = d17;
        }
        return dArray;
    }

    public static boolean pointInSimplePoly(double d, Point2d point2d, Point2d ... point2dArray) {
        Random random = new Random(0L);
        boolean[] blArray = new boolean[2];
        for (int i = 0; i < 15; ++i) {
            Vector2d vector2d = Util2D.newRandomVec2D(random);
            if (!Inter2D.testPointInSimplePoly(point2dArray, point2d, vector2d, d, blArray)) continue;
            return blArray[0] || blArray[1];
        }
        System.err.println("Could not complete Inter2D.pointInSimplePoly using test point = " + point2d.toString());
        return false;
    }

    private static boolean testPointInSimplePoly(Point2d[] point2dArray, Point2d point2d, Vector2d vector2d, double d, boolean[] blArray) {
        assert (blArray.length >= 2);
        int n = 0;
        for (int i = 0; i < point2dArray.length; ++i) {
            Point2d point2d2 = point2dArray[i];
            Point2d point2d3 = point2dArray[(i + 1) % point2dArray.length];
            Vector2d vector2d2 = Util2D.vector(point2d2, point2d3);
            double[] dArray = Inter2D.isectLineLine(point2d, vector2d, point2d2, vector2d2, d);
            if (dArray == null || !Util.checkRange(0.0, 1.0, dArray[1], d)) continue;
            double d2 = dArray[0];
            double d3 = dArray[1];
            if (theUtil.eq0(d2, d)) {
                blArray[0] = true;
                blArray[1] = false;
                return true;
            }
            if (d2 < 0.0) continue;
            if (theUtil.eq0(d3, d) || theUtil.eq(d3, 1.0, d)) {
                return false;
            }
            ++n;
        }
        blArray[0] = false;
        blArray[1] = n % 2 != 0;
        return true;
    }

    public static boolean pointInConvexPoly(double d, Point2d point2d, Point2d ... point2dArray) {
        assert (point2dArray.length >= 3);
        Vector2d vector2d = new Vector2d();
        Vector2d vector2d2 = new Vector2d();
        double d2 = Double.NaN;
        int n = 0;
        double d3 = d * d;
        for (int i = 0; i < point2dArray.length; ++i) {
            Point2d point2d2 = point2dArray[i];
            Point2d point2d3 = point2dArray[(i + 1) % point2dArray.length];
            vector2d2.sub(point2d3, point2d2);
            if (theUtil.eq0(vector2d2.lengthSquared(), d3)) continue;
            vector2d.sub(point2d, point2d2);
            double d4 = Util2D.cross(vector2d2, vector2d);
            if (theUtil.eq0(d4, d)) {
                double d5 = vector2d.dot(vector2d2);
                return Util.checkRange(0.0, vector2d2.dot(vector2d2), d5, d);
            }
            if (Double.isNaN(d2)) {
                d2 = d4;
                continue;
            }
            if (d2 < 0.0 && d4 > 0.0 || d2 > 0.0 && d4 < 0.0) {
                return false;
            }
            ++n;
        }
        return n > 0;
    }

    public static boolean pointInPoly(double d, Point2d point2d, boolean bl, Point2d ... point2dArray) {
        return bl && Inter2D.pointInConvexPoly(d, point2d, point2dArray) || !bl && Inter2D.pointInSimplePoly(d, point2d, point2dArray);
    }
}

