/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.BoundingSphere;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class ConvexHull
implements ITest<AABox> {
    public static final ConvexHull ACCEPT_NONE = new ConvexHull(new Plane3d(0.0, 0.0, -1.0, Double.MAX_VALUE));
    private final Plane3d[] d_planes;
    private final Tuple3d[][] d_planeEdges;

    public ConvexHull(Plane3d ... plane3dArray) {
        this(Arrays.asList(plane3dArray));
    }

    public ConvexHull(Collection<? extends Plane3d> collection) {
        this.d_planes = collection.toArray(new Plane3d[collection.size()]);
        ArrayList<Tuple3d[]> arrayList = new ArrayList<Tuple3d[]>();
        for (int i = 0; i < this.d_planes.length; ++i) {
            Plane3d plane3d = this.d_planes[i];
            for (int j = 1; j < this.d_planes.length; ++j) {
                Plane3d plane3d2 = this.d_planes[j];
                Tuple3d[] tuple3dArray = Inter3D.planePlaneIsect(plane3d, plane3d2, 1.0E-9);
                if (tuple3dArray == null) continue;
                arrayList.add(tuple3dArray);
            }
        }
        this.d_planeEdges = (Tuple3d[][])arrayList.toArray((T[])new Tuple3d[arrayList.size()][]);
    }

    public Plane3d[] getPlanes() {
        return this.d_planes;
    }

    public int contains(Point3d ... point3dArray) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(point3dArray));
    }

    @Override
    public Containment test(Point3d ... point3dArray) {
        int n = 0;
        for (Point3d point3d : point3dArray) {
            if (!this.contains(point3d)) continue;
            ++n;
        }
        if (n == 0) {
            return Containment.OUTSIDE;
        }
        if (n == point3dArray.length) {
            return Containment.INSIDE;
        }
        return Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(Point3d ... point3dArray) {
        return this.test(point3dArray) != Containment.OUTSIDE;
    }

    public boolean contains(Point3d point3d) {
        for (int i = 0; i < this.d_planes.length; ++i) {
            double d = this.d_planes[i].dot(point3d);
            if (!(d >= 0.0)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Point3d point3d, double d) {
        for (int i = 0; i < this.d_planes.length; ++i) {
            double d2 = this.d_planes[i].dot(point3d);
            if (!theUtil.gt0(d2, d)) continue;
            return false;
        }
        return true;
    }

    public int contains(AABox aABox) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(aABox));
    }

    @Override
    public Containment test(AABox aABox) {
        return this.test(aABox, 0.0);
    }

    public Containment test(AABox aABox, double d) {
        if (aABox.getMin().epsilonEquals(aABox.getMax(), d)) {
            return this.contains(aABox.getMin(), d) ? Containment.INSIDE : Containment.OUTSIDE;
        }
        Point3d point3d = aABox.getMin();
        Point3d point3d2 = aABox.getMax();
        int n = 0;
        for (int i = 0; i < this.d_planes.length; ++i) {
            int n2 = 8;
            int n3 = 1;
            Plane3d plane3d = this.d_planes[i];
            if (theUtil.gt0(plane3d.dot(point3d.x, point3d.y, point3d.z), 1.0E-9)) {
                n3 = 0;
                --n2;
            }
            if (theUtil.gt0(plane3d.dot(point3d.x, point3d.y, point3d2.z), 1.0E-9)) {
                n3 = 0;
                --n2;
            }
            if (theUtil.gt0(plane3d.dot(point3d.x, point3d2.y, point3d.z), 1.0E-9)) {
                n3 = 0;
                --n2;
            }
            if (theUtil.gt0(plane3d.dot(point3d.x, point3d2.y, point3d2.z), 1.0E-9)) {
                n3 = 0;
                --n2;
            }
            if (theUtil.gt0(plane3d.dot(point3d2.x, point3d.y, point3d.z), 1.0E-9)) {
                n3 = 0;
                --n2;
            }
            if (theUtil.gt0(plane3d.dot(point3d2.x, point3d.y, point3d2.z), 1.0E-9)) {
                n3 = 0;
                --n2;
            }
            if (theUtil.gt0(plane3d.dot(point3d2.x, point3d2.y, point3d.z), 1.0E-9)) {
                n3 = 0;
                --n2;
            }
            if (theUtil.gt0(plane3d.dot(point3d2.x, point3d2.y, point3d2.z), 1.0E-9)) {
                n3 = 0;
                --n2;
            }
            if (n2 == 0) {
                return Containment.OUTSIDE;
            }
            n += n3;
        }
        return n == this.d_planes.length ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(AABox aABox) {
        return this.test((AABox)aABox).positive;
    }

    public int contains(BoundingSphere boundingSphere) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(boundingSphere));
    }

    @Override
    public Containment test(BoundingSphere boundingSphere) {
        int n = 0;
        for (int i = 0; i < this.d_planes.length; ++i) {
            Plane3d plane3d = this.d_planes[i];
            double d = plane3d.dot(boundingSphere.center);
            if (d < boundingSphere.radius) {
                ++n;
                continue;
            }
            if (!(d >= 0.0)) continue;
            return Containment.OUTSIDE;
        }
        return n == 0 ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(BoundingSphere boundingSphere) {
        return this.test((BoundingSphere)boundingSphere).positive;
    }

    public ConvexHull transform(Matrix4d matrix4d) {
        Plane3d[] plane3dArray = new Plane3d[this.d_planes.length];
        for (int i = 0; i < this.d_planes.length; ++i) {
            Plane3d plane3d = this.d_planes[i];
            plane3dArray[i] = plane3d.transformBy(matrix4d);
        }
        return new ConvexHull(plane3dArray);
    }

    public ConvexHull intersect(ConvexHull convexHull, boolean bl) {
        if (convexHull.acceptsAll() || this.acceptsNone()) {
            return this;
        }
        if (this.acceptsAll() || convexHull.acceptsNone()) {
            return convexHull;
        }
        ArrayList<Plane3d> arrayList = new ArrayList<Plane3d>(this.d_planes.length + convexHull.d_planes.length);
        for (Plane3d plane3d : this.d_planes) {
            if (arrayList.contains(plane3d)) continue;
            arrayList.add(plane3d);
        }
        for (Plane3d plane3d : convexHull.d_planes) {
            if (arrayList.contains(plane3d)) continue;
            arrayList.add(plane3d);
        }
        Object object = new ConvexHull(arrayList.toArray(new Plane3d[arrayList.size()]));
        if (bl) {
            object = ((ConvexHull)object).optimize();
        }
        return object;
    }

    public boolean acceptsAll() {
        return this.d_planes.length == 0;
    }

    public boolean acceptsNone() {
        return this == ACCEPT_NONE || this.d_planes.length == 1 && this.d_planes[0].equals(ConvexHull.ACCEPT_NONE.d_planes[0]);
    }

    public ConvexHull mergeIfTouching(ConvexHull convexHull) {
        int n = 0;
        int n2 = 0;
        ArrayList<Plane3d> arrayList = new ArrayList<Plane3d>();
        for (Plane3d plane3d : this.d_planes) {
            if (!ConvexHull.isPlaneRedundant(convexHull.d_planes, plane3d) && !arrayList.contains(plane3d)) {
                arrayList.add(plane3d);
                continue;
            }
            ++n;
        }
        for (Plane3d plane3d : convexHull.d_planes) {
            if (!ConvexHull.isPlaneRedundant(this.d_planes, plane3d) && !arrayList.contains(plane3d)) {
                arrayList.add(plane3d);
                continue;
            }
            ++n2;
        }
        if (n == 0 && n2 == 0) {
            return null;
        }
        return new ConvexHull(arrayList).optimize();
    }

    public ConvexHull optimize() {
        Iterator<Plane3d> iterator;
        Plane3d plane3d2;
        Serializable serializable;
        Object object2 = new ArrayList<Plane3d>(Arrays.asList(this.d_planes));
        List<List<Plane3d>> list = ConvexHull.getParallelSets(this.d_planes);
        for (List<Plane3d> object3 : list) {
            serializable = new ArrayList();
            for (Plane3d plane3d2 : object3) {
                if (ConvexHull.isValidPlane(object3, plane3d2)) continue;
                serializable.add(plane3d2);
            }
            if (serializable.size() == object3.size()) {
                return ACCEPT_NONE;
            }
            iterator = serializable.iterator();
            while (iterator.hasNext()) {
                plane3d2 = iterator.next();
                object2.remove(plane3d2);
            }
        }
        if (ConvexHull.areAllParallel(object2)) {
            return new ConvexHull((Collection<? extends Plane3d>)object2);
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator2 = object2.iterator();
        block3: while (iterator2.hasNext()) {
            serializable = (Plane3d)iterator2.next();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                plane3d2 = iterator.next();
                if (serializable == plane3d2 || !(bl = ConvexHull.partOfMinHullOutline((List<Plane3d>)object2, (Plane3d)serializable, plane3d2))) continue;
                arrayList.add(serializable);
                continue block3;
            }
        }
        object2 = arrayList;
        if (object2.isEmpty()) {
            return ACCEPT_NONE;
        }
        return new ConvexHull(object2.toArray(new Plane3d[object2.size()]));
    }

    private static boolean partOfMinHullOutline(List<Plane3d> list, Plane3d plane3d, Plane3d plane3d2) {
        Tuple3d[] tuple3dArray = Inter3D.planePlaneIsect(plane3d, plane3d2, 1.0E-9);
        if (tuple3dArray == null) {
            return false;
        }
        double[] dArray = ConvexHull.clipToMinHull(list, (Point3d)tuple3dArray[0], (Vector3d)tuple3dArray[1], plane3d, plane3d2);
        return dArray != null;
    }

    private static double[] clipToMinHull(List<Plane3d> list, Point3d point3d, Vector3d vector3d, Plane3d plane3d, Plane3d plane3d2) {
        double d = -1.7976931348623157E308;
        double d2 = Double.MAX_VALUE;
        for (Plane3d plane3d3 : list) {
            Point3d point3d2;
            if (plane3d3 == plane3d || plane3d3 == plane3d2) continue;
            double d3 = Inter3D.linePlaneIntersectionT(point3d, vector3d, plane3d3, 1.0E-9);
            if (Double.isNaN(d3)) {
                if (!(plane3d3.dot(point3d) > 0.0)) continue;
                return null;
            }
            if (d3 <= d) {
                point3d2 = Util3D.linePoint(point3d, vector3d, d);
                if (!(plane3d3.dot(point3d2) > 0.0)) continue;
                return null;
            }
            if (d3 >= d2) {
                point3d2 = Util3D.linePoint(point3d, vector3d, d2);
                if (!(plane3d3.dot(point3d2) > 0.0)) continue;
                return null;
            }
            if (vector3d.dot(plane3d3.getNormal()) >= 0.0) {
                d2 = d3;
            } else {
                d = d3;
            }
            if (!(d >= d2)) continue;
            return null;
        }
        return new double[]{d, d2};
    }

    private static boolean areAllParallel(List<Plane3d> list) {
        if (list.isEmpty()) {
            return true;
        }
        Plane3d plane3d = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (plane3d.isParallel(list.get(i), 1.0E-9)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidPlane(List<Plane3d> list, Plane3d plane3d) {
        for (Plane3d plane3d2 : list) {
            double d;
            if (plane3d2.equals(plane3d) || !plane3d2.isParallel(plane3d, 1.0E-9) || !theUtil.ge0(d = ConvexHull.parallelPlaneDot(plane3d2, plane3d), 1.0E-9)) continue;
            return false;
        }
        return true;
    }

    private static List<List<Plane3d>> getParallelSets(Plane3d[] plane3dArray) {
        ArrayList<List<Plane3d>> arrayList = new ArrayList<List<Plane3d>>();
        for (Plane3d plane3d : plane3dArray) {
            List<Plane3d> list = null;
            for (List list2 : arrayList) {
                if (!((Plane3d)list2.get(0)).isParallel(plane3d, 1.0E-9)) continue;
                list = list2;
                break;
            }
            if (list == null) {
                list = new ArrayList<Plane3d>();
                arrayList.add(list);
            }
            list.add(plane3d);
        }
        return arrayList;
    }

    private static boolean isPlaneRedundant(Plane3d[] plane3dArray, Plane3d plane3d) {
        int n = 0;
        for (Plane3d plane3d2 : plane3dArray) {
            boolean bl = plane3d.isParallel(plane3d2, 1.0E-9);
            if (!bl) continue;
            ++n;
            double d = ConvexHull.parallelPlaneDot(plane3d2, plane3d);
            if (!theUtil.gt(d, 0.0, 1.0E-9)) continue;
            return false;
        }
        return n > 0;
    }

    private static double parallelPlaneDot(Plane3d plane3d, Plane3d plane3d2) {
        Point3d point3d = plane3d2.getPointOnPlane();
        return plane3d.dot(point3d);
    }

    public boolean intersectsLineSeg(Point3d point3d, Point3d point3d2, double d) {
        if (this.contains(point3d, d) || this.contains(point3d2, d)) {
            return true;
        }
        Vector3d vector3d = Util3D.vector(point3d, point3d2);
        for (Plane3d plane3d : this.d_planes) {
            double d2 = Inter3D.linePlaneIntersectionT(point3d, vector3d, plane3d, 1.0E-9);
            if (Double.isNaN(d2) || !theUtil.ge0(d2, d) || !theUtil.le(d2, 1.0, d) || !this.contains(Util3D.linePoint(point3d, vector3d, d2), d)) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsConvexPoly(double d, Point3d ... point3dArray) {
        Plane3d plane3d = Util3D.simplePolygonPlane(Arrays.asList(point3dArray));
        if (plane3d == null) {
            return false;
        }
        return this.intersectsConvexPoly(d, plane3d, point3dArray);
    }

    public boolean intersectsConvexPoly(double d, Plane3d plane3d, Point3d ... point3dArray) {
        for (Point3d serializableArray : point3dArray) {
            if (!this.contains(serializableArray, d)) continue;
            return true;
        }
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d point3d = point3dArray[i];
            Point3d point3d2 = point3dArray[(i + 1) % point3dArray.length];
            for (Plane3d plane3d2 : this.d_planes) {
                Point3d point3d3 = Inter3D.lineSegPlaneIntersection(point3d, point3d2, plane3d2, d);
                if (point3d3 == null || !this.contains(point3d3, d)) continue;
                return true;
            }
        }
        for (Tuple3d[] tuple3dArray : this.d_planeEdges) {
            Point3d point3d = (Point3d)tuple3dArray[0];
            Vector3d vector3d = (Vector3d)tuple3dArray[1];
            Point3d point3d4 = Inter3D.linePolyIntersection(point3d, vector3d, plane3d, d, point3dArray);
            if (point3d4 == null || !this.contains(point3d4, d)) continue;
            return true;
        }
        return false;
    }
}

