/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.BoundingSphere;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Box3d
implements ITest<AABox> {
    private final Point3d[] d_verts;
    private final Point3d[][] d_faces;
    private final Plane3d[] d_planes;

    public Box3d(Point3d ... point3dArray) {
        assert (point3dArray.length == 8);
        this.d_verts = point3dArray;
        this.d_faces = new Point3d[][]{{point3dArray[0], point3dArray[1], point3dArray[2], point3dArray[3]}, {point3dArray[6], point3dArray[5], point3dArray[4], point3dArray[7]}, {point3dArray[4], point3dArray[0], point3dArray[3], point3dArray[7]}, {point3dArray[1], point3dArray[5], point3dArray[6], point3dArray[2]}, {point3dArray[2], point3dArray[6], point3dArray[7], point3dArray[3]}, {point3dArray[0], point3dArray[4], point3dArray[5], point3dArray[1]}};
        this.d_planes = new Plane3d[6];
        for (int i = 0; i < 6; ++i) {
            this.d_planes[i] = new Plane3d(this.d_faces[i]);
        }
    }

    public Box3d(AABox aABox) {
        this(aABox.Mmm(), aABox.MMm(), aABox.MMM(), aABox.MmM(), aABox.mmm(), aABox.mMm(), aABox.mMM(), aABox.mmM());
    }

    public Point3d[] getVerts() {
        return this.d_verts;
    }

    public Point3d[][] getFaces() {
        return this.d_faces;
    }

    public Plane3d[] getPlanes() {
        return this.d_planes;
    }

    public int contains(Point3d ... point3dArray) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(point3dArray));
    }

    @Override
    public Containment test(Point3d ... point3dArray) {
        int n = 0;
        for (Point3d point3d : point3dArray) {
            if (!this.contains(point3d)) continue;
            ++n;
        }
        if (n == 0) {
            return Containment.OUTSIDE;
        }
        if (n == point3dArray.length) {
            return Containment.INSIDE;
        }
        return Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(Point3d ... point3dArray) {
        return this.test(point3dArray) != Containment.OUTSIDE;
    }

    public boolean contains(Point3d point3d) {
        return this.contains(point3d, 0.0);
    }

    public boolean contains(Point3d point3d, double d) {
        for (int i = 0; i < 6; ++i) {
            double d2 = this.d_planes[i].dot(point3d);
            if (!theUtil.gt0(d2, d)) continue;
            return false;
        }
        return true;
    }

    public int contains(AABox aABox) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(aABox));
    }

    @Override
    public Containment test(AABox aABox) {
        if (aABox.getMin().equals(aABox.getMax())) {
            return this.contains(aABox.getMin()) ? Containment.INSIDE : Containment.OUTSIDE;
        }
        Point3d point3d = aABox.getMin();
        Point3d point3d2 = aABox.getMax();
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            int n2 = 8;
            int n3 = 1;
            Plane3d plane3d = this.d_planes[i];
            if (plane3d.dot(point3d.x, point3d.y, point3d.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d.x, point3d.y, point3d2.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d.x, point3d2.y, point3d.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d.x, point3d2.y, point3d2.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d2.x, point3d.y, point3d.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d2.x, point3d.y, point3d2.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d2.x, point3d2.y, point3d.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (plane3d.dot(point3d2.x, point3d2.y, point3d2.z) >= 0.0) {
                n3 = 0;
                --n2;
            }
            if (n2 == 0) {
                return Containment.OUTSIDE;
            }
            n += n3;
        }
        return n == 6 ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(AABox aABox) {
        return this.test(aABox) != Containment.OUTSIDE;
    }

    public int contains(BoundingSphere boundingSphere) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(boundingSphere));
    }

    @Override
    public Containment test(BoundingSphere boundingSphere) {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            Plane3d plane3d = this.d_planes[i];
            double d = plane3d.dot(boundingSphere.center);
            if (d < boundingSphere.radius) {
                ++n;
                continue;
            }
            if (!(d >= 0.0)) continue;
            return Containment.OUTSIDE;
        }
        return n == 0 ? Containment.INSIDE : Containment.INTERSECTS;
    }

    public boolean containsAtLeastPart(BoundingSphere boundingSphere) {
        return this.test(boundingSphere) != Containment.OUTSIDE;
    }

    public boolean intersectsLineSeg(Point3d point3d, Point3d point3d2, double d) {
        if (this.contains(point3d, d) || this.contains(point3d2, d)) {
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            Point3d point3d3 = Inter3D.lineSegPolyIntersection(point3d, point3d2, this.d_planes[i], d, this.d_faces[i]);
            if (point3d3 == null) continue;
            return true;
        }
        return false;
    }

    public boolean intersectsConvexPoly(double d, Point3d ... point3dArray) {
        for (Point3d point3d : point3dArray) {
            if (!this.contains(point3d, d)) continue;
            return true;
        }
        for (int i = 0; i < 6; ++i) {
            if (!Inter3D.faceFaceIsect(this.d_faces[i], point3dArray, d)) continue;
            return true;
        }
        return false;
    }

    public ConvexHull toConvexHull() {
        return new ConvexHull(this.d_planes);
    }

    public Box3d transform(Matrix4d matrix4d) {
        Point3d[] point3dArray = new Point3d[this.d_verts.length];
        for (int i = 0; i < this.d_verts.length; ++i) {
            point3dArray[i] = Util3D.xform(matrix4d, this.d_verts[i]);
        }
        return new Box3d(point3dArray);
    }
}

