/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Inter3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;

public class BoundingSphere
implements ITest<AABox> {
    public final Point3d center = new Point3d();
    public double radius = -1.0;

    public BoundingSphere() {
    }

    public BoundingSphere(Point3d point3d, double d) {
        this.set(point3d, d);
    }

    public BoundingSphere(BoundingSphere boundingSphere) {
        this.set(boundingSphere);
    }

    public BoundingSphere(AABox aABox) {
        this.set(aABox);
    }

    public BoundingSphere reset() {
        this.radius = -1.0;
        return this;
    }

    public void set(Point3d point3d, double d) {
        this.center.set(point3d);
        this.radius = d;
    }

    public void set(AABox aABox) {
        this.center.add(aABox.getMin(), aABox.getMax());
        this.center.scale(0.5);
        this.radius = this.center.distance(aABox.getMax());
    }

    public void set(BoundingSphere boundingSphere) {
        this.center.set(boundingSphere.center);
        this.radius = boundingSphere.radius;
    }

    public boolean isValid() {
        return this.radius >= 0.0;
    }

    public BoundingSphere addEq(Point3d point3d) {
        if (!this.isValid()) {
            this.center.set(point3d);
            this.radius = 0.0;
            return this;
        }
        double d = this.radius * this.radius;
        Vector3d vector3d = new Vector3d();
        vector3d.sub(point3d, this.center);
        double d2 = vector3d.lengthSquared();
        if (d2 <= d) {
            return this;
        }
        double d3 = Math.sqrt(d2);
        this.radius = 0.5 * (this.radius + d3);
        double d4 = -this.radius / d3;
        vector3d.scale(d4);
        this.center.add(point3d, vector3d);
        return this;
    }

    public BoundingSphere addEq(BoundingSphere boundingSphere) {
        if (!boundingSphere.isValid()) {
            return this;
        }
        if (!this.isValid()) {
            this.set(boundingSphere);
            return this;
        }
        Vector3d vector3d = new Vector3d();
        vector3d.sub(boundingSphere.center, this.center);
        double d = vector3d.length();
        double d2 = 1.0 + boundingSphere.radius / d;
        vector3d.scale(d2);
        Point3d point3d = new Point3d();
        point3d.add(this.center, vector3d);
        return this.addEq(point3d);
    }

    public BoundingSphere scaleEq(double d) {
        this.center.scale(d);
        this.radius *= d;
        return this;
    }

    public int contains(AABox aABox) {
        return Inter3D.sphereContainsAABB(this.center, this.radius * this.radius, aABox.getMin(), aABox.getMax());
    }

    @Override
    public Containment test(AABox aABox) {
        return Inter3D.testSphereAABB(this.center, this.radius * this.radius, aABox.getMin(), aABox.getMax());
    }
}

