/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ISearchVol;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IContainer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;

public class ARTree<T, VolT extends ISearchVol>
implements IContainer<T, VolT>,
Serializable {
    private static final long serialVersionUID = -2674551795712987515L;
    public static final int DEF_MIN_FILL = 2;
    public static final int DEF_MAX_FILL = 4;
    private Map<T, RTreeNode<VolT>> d_nodeLookupMap;
    private RTreeNode<VolT> d_root;
    private int d_maxFill;
    private int d_minFill;
    private static int leaf_level;

    public ARTree() {
        this(2, 4);
    }

    public ARTree(int n, int n2) {
        this.d_maxFill = n2;
        this.d_minFill = n;
        this.d_root = new RTreeLeaf(this.d_maxFill);
        this.d_nodeLookupMap = this.newLookupMap();
    }

    public Map<T, VolT> getCachedBounds() {
        LinkedIdentityHashMap linkedIdentityHashMap = new LinkedIdentityHashMap(this.d_nodeLookupMap.size());
        this.getCachedBounds(linkedIdentityHashMap, this.d_root);
        return linkedIdentityHashMap;
    }

    private void getCachedBounds(Map<T, VolT> map, RTreeNode<VolT> rTreeNode) {
        if (rTreeNode.isLeaf()) {
            RTreeLeaf<VolT> rTreeLeaf = rTreeNode.asLeaf();
            for (int i = 0; i < rTreeLeaf.d_numEntries; ++i) {
                map.put(rTreeLeaf.d_entry[i].asLeaf().d_data, rTreeLeaf.d_entry[i].d_box);
            }
        } else {
            RTreeBranch<VolT> rTreeBranch = rTreeNode.asBranch();
            for (int i = 0; i < rTreeBranch.d_numEntries; ++i) {
                this.getCachedBounds(map, rTreeBranch.d_entry[i].asBranch().d_child);
            }
        }
    }

    private Map<T, RTreeNode<VolT>> newLookupMap() {
        return new IdentityHashMap();
    }

    public boolean isEmpty() {
        return this.d_root.d_numEntries == 0;
    }

    public int getMinFill() {
        return this.d_minFill;
    }

    public int getMaxFill() {
        return this.d_maxFill;
    }

    protected void clone(ARTree<T, VolT> aRTree, Map<T, T> map) {
        aRTree.d_root = this.d_root.clone(map);
        aRTree.d_root.buildLookupMap(aRTree.d_nodeLookupMap);
    }

    public void pauseCondensing() {
    }

    public void resumeCondensing() {
    }

    public boolean insert(VolT VolT, T t) {
        if (!VolT.isValid()) {
            return false;
        }
        LeafEntry<T, VolT> leafEntry = new LeafEntry<T, VolT>(VolT, t);
        RTreeNode rTreeNode = this.chooseLeaf(leafEntry);
        if (rTreeNode.d_numEntries < this.d_maxFill) {
            rTreeNode.setEntry(rTreeNode.d_numEntries++, leafEntry, this.d_nodeLookupMap);
            this.adjustTree(rTreeNode, null);
        } else {
            RTreeNode rTreeNode2 = this.splitNode(rTreeNode, leafEntry);
            RTreeNode<VolT> rTreeNode3 = this.adjustTree(rTreeNode, rTreeNode2);
            if (rTreeNode3 != null) {
                VolT VolT2 = ARTree.calcBox(this.d_root);
                VolT VolT3 = ARTree.calcBox(rTreeNode3);
                RTreeBranch<VolT> rTreeBranch = new RTreeBranch<VolT>(this.d_maxFill);
                ((RTreeNode)rTreeBranch).setEntry(0, new BranchEntry<VolT>(VolT2, this.d_root), this.d_nodeLookupMap);
                ((RTreeNode)rTreeBranch).setEntry(1, new BranchEntry<VolT>(VolT3, rTreeNode3), this.d_nodeLookupMap);
                rTreeBranch.d_numEntries = 2;
                this.d_root = rTreeBranch;
            }
        }
        return true;
    }

    public boolean remove(T t) {
        Serializable serializable;
        int n;
        RTreeNode<VolT> rTreeNode = this.d_nodeLookupMap.remove(t);
        if (rTreeNode == null) {
            return false;
        }
        if (this.d_nodeLookupMap.isEmpty()) {
            this.d_nodeLookupMap = this.newLookupMap();
        }
        for (n = 0; n < rTreeNode.d_numEntries; ++n) {
            serializable = rTreeNode.d_entry[n].asLeaf();
            if (serializable.d_data == t) break;
        }
        rTreeNode.removeEntry(n);
        this.condenseTree(rTreeNode);
        if (rTreeNode != this.d_root && this.d_root.d_numEntries == 1) {
            serializable = this.d_root;
            this.d_root = this.d_root.asBranch().getChild(0);
            this.d_root.d_parent = null;
            ((RTreeNode)serializable).d_entry[0] = null;
            ((RTreeNode)serializable).d_numEntries = 0;
            serializable = null;
        }
        return true;
    }

    public void clear() {
        this.d_root = new RTreeLeaf(this.d_maxFill);
        this.d_nodeLookupMap = this.newLookupMap();
    }

    @Override
    public void find(ITest<VolT> iTest, IRTreeTestResult<? super T> iRTreeTestResult) {
        this.find(new TestWrapper<VolT>(iTest), (IResult<? super T>)new ResultWrapper<T>(iRTreeTestResult));
    }

    @Override
    public void find(pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest<VolT> iTest, IResult<? super T> iResult) {
        ARTree.search(this.d_root, iTest, iResult);
    }

    private static <T, VolT extends ISearchVol> void search(RTreeNode<VolT> rTreeNode, pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest<VolT> iTest, IResult<? super T> iResult) {
        block4: for (int i = 0; i < rTreeNode.d_numEntries; ++i) {
            Containment containment = iTest.test(rTreeNode.d_entry[i].d_box);
            switch (containment) {
                case INSIDE: {
                    RTreeEntry rTreeEntry;
                    if (rTreeNode.isLeaf()) {
                        rTreeEntry = rTreeNode.d_entry[i].asLeaf();
                        iResult.mark(rTreeEntry.d_data, Containment.INSIDE);
                        continue block4;
                    }
                    rTreeEntry = rTreeNode.d_entry[i].asBranch();
                    ARTree.getAllObjects(((BranchEntry)rTreeEntry).d_child, iResult);
                    continue block4;
                }
                case INTERSECTS: {
                    RTreeEntry rTreeEntry;
                    if (rTreeNode.isLeaf()) {
                        rTreeEntry = rTreeNode.d_entry[i].asLeaf();
                        iResult.mark(rTreeEntry.d_data, Containment.INTERSECTS);
                        continue block4;
                    }
                    rTreeEntry = rTreeNode.d_entry[i].asBranch();
                    ARTree.search(((BranchEntry)rTreeEntry).d_child, iTest, iResult);
                }
            }
        }
    }

    @Override
    public void getAll(IResult<? super T> iResult) {
        ARTree.getAllObjects(this.d_root, iResult);
    }

    private static <T, VolT extends ISearchVol> void getAllObjects(RTreeNode<VolT> rTreeNode, IResult<? super T> iResult) {
        if (rTreeNode.isLeaf()) {
            for (int i = 0; i < rTreeNode.d_numEntries; ++i) {
                LeafEntry leafEntry = rTreeNode.d_entry[i].asLeaf();
                iResult.mark(leafEntry.d_data, Containment.INSIDE);
            }
        } else {
            for (int i = 0; i < rTreeNode.d_numEntries; ++i) {
                BranchEntry branchEntry = rTreeNode.d_entry[i].asBranch();
                ARTree.getAllObjects(branchEntry.d_child, iResult);
            }
        }
    }

    public VolT getBounds(VolT VolT) {
        if (this.d_root == null) {
            return VolT;
        }
        for (int i = 0; i < this.d_root.d_numEntries; ++i) {
            VolT.add((ISearchVol)this.d_root.d_entry[i].d_box);
        }
        return VolT;
    }

    public VolT getBoundingBox(VolT VolT) {
        return this.getBounds((T)VolT);
    }

    public VolT getBounds(T t) {
        RTreeNode<VolT> rTreeNode = this.d_nodeLookupMap.get(t);
        if (rTreeNode == null) {
            return null;
        }
        for (int i = 0; i < rTreeNode.d_numEntries; ++i) {
            LeafEntry leafEntry = rTreeNode.d_entry[i].asLeaf();
            if (leafEntry.d_data != t) continue;
            return (VolT)leafEntry.d_box;
        }
        return null;
    }

    private static <VolT extends ISearchVol> int getlevel(RTreeNode<VolT> rTreeNode) {
        int n = 0;
        RTreeNode rTreeNode2 = rTreeNode.d_parent;
        while (rTreeNode2 != null) {
            ++n;
            rTreeNode2 = rTreeNode2.d_parent;
        }
        return n;
    }

    public int validate() {
        leaf_level = -1;
        return ARTree.validate(this.d_root, 0);
    }

    private static <VolT extends ISearchVol> int validate(RTreeNode<VolT> rTreeNode, int n) {
        int n2 = ARTree.getlevel(rTreeNode);
        assert (n2 == n);
        if (rTreeNode.isLeaf()) {
            if (leaf_level == -1) {
                leaf_level = n2;
            }
            assert (n2 == leaf_level);
            return 1;
        }
        for (int i = 0; i < rTreeNode.d_numEntries; ++i) {
            if (rTreeNode.asBranch().getChild((int)i).d_parent != rTreeNode) {
                assert (false);
                return 0;
            }
            if (ARTree.validate(rTreeNode.asBranch().getChild(i), n + 1) != 0) continue;
            return 0;
        }
        return 1;
    }

    public int count() {
        return ARTree.count(this.d_root);
    }

    private static int count(RTreeNode rTreeNode) {
        if (rTreeNode.isLeaf()) {
            return rTreeNode.d_numEntries;
        }
        int n = 0;
        RTreeBranch rTreeBranch = rTreeNode.asBranch();
        for (int i = 0; i < rTreeNode.d_numEntries; ++i) {
            n += ARTree.count(rTreeBranch.getChild(i));
        }
        return n;
    }

    public int countNodes() {
        return ARTree.countNodes(this.d_root);
    }

    private static int countNodes(RTreeNode rTreeNode) {
        if (rTreeNode.isLeaf()) {
            return 1;
        }
        int n = 1;
        RTreeBranch rTreeBranch = rTreeNode.asBranch();
        for (int i = 0; i < rTreeNode.d_numEntries; ++i) {
            n += ARTree.countNodes(rTreeBranch.getChild(i));
        }
        return n;
    }

    private RTreeNode chooseLeaf(RTreeEntry rTreeEntry) {
        RTreeNode<VolT> rTreeNode = this.d_root;
        while (!rTreeNode.isLeaf()) {
            double d = Double.MAX_VALUE;
            RTreeEntry rTreeEntry2 = null;
            for (int i = 0; i < rTreeNode.d_numEntries; ++i) {
                ISearchVol iSearchVol = (ISearchVol)rTreeNode.d_entry[i].d_box.clone();
                iSearchVol.add((ISearchVol)rTreeEntry.d_box);
                double d2 = iSearchVol.volumeEps();
                double d3 = rTreeNode.d_entry[i].d_box.volumeEps();
                double d4 = d2 - d3;
                if (d4 < d) {
                    d = d4;
                    rTreeEntry2 = rTreeNode.d_entry[i];
                    continue;
                }
                if (d4 != d || !(d2 < rTreeEntry2.d_box.volumeEps())) continue;
                rTreeEntry2 = rTreeNode.d_entry[i];
            }
            rTreeNode = rTreeEntry2.asBranch().d_child;
        }
        return rTreeNode;
    }

    private RTreeNode splitNode(RTreeNode rTreeNode, RTreeEntry rTreeEntry) {
        int n;
        RTreeEntry[] rTreeEntryArray = new RTreeEntry[this.d_maxFill + 1];
        int[] nArray = new int[this.d_maxFill + 1];
        assert (rTreeNode.d_numEntries == this.d_maxFill);
        for (n = 0; n < this.d_maxFill; ++n) {
            rTreeEntryArray[n] = rTreeNode.d_entry[n];
            nArray[n] = 0;
        }
        rTreeEntryArray[this.d_maxFill] = rTreeEntry;
        nArray[this.d_maxFill] = 0;
        RTreeEntry[] rTreeEntryArray2 = new RTreeEntry[this.d_maxFill];
        RTreeEntry[] rTreeEntryArray3 = new RTreeEntry[this.d_maxFill];
        int n2 = 0;
        int n3 = 0;
        int[] nArray2 = this.QpickSeeds(rTreeEntryArray);
        rTreeEntryArray2[n2++] = rTreeEntryArray[nArray2[0]];
        nArray[nArray2[0]] = 1;
        Object VolT = rTreeEntryArray[nArray2[0]].d_box;
        rTreeEntryArray3[n3++] = rTreeEntryArray[nArray2[1]];
        nArray[nArray2[1]] = 1;
        Object VolT2 = rTreeEntryArray[nArray2[1]].d_box;
        while (n2 + n3 < this.d_maxFill + 1) {
            if (this.d_minFill - n2 >= this.d_maxFill + 1 - n2 - n3) {
                for (n = 0; n < this.d_maxFill + 1; ++n) {
                    if (nArray[n] != 0) continue;
                    rTreeEntryArray2[n2++] = rTreeEntryArray[n];
                }
                continue;
            }
            if (this.d_minFill - n3 >= this.d_maxFill + 1 - n2 - n3) {
                for (n = 0; n < this.d_maxFill + 1; ++n) {
                    if (nArray[n] != 0) continue;
                    rTreeEntryArray3[n3++] = rTreeEntryArray[n];
                }
                continue;
            }
            int n4 = this.QpickNext(rTreeEntryArray, nArray, VolT, VolT2);
            ISearchVol iSearchVol = (ISearchVol)VolT.clone();
            iSearchVol.add((ISearchVol)rTreeEntryArray[n4].d_box);
            ISearchVol iSearchVol2 = (ISearchVol)VolT2.clone();
            iSearchVol2.add((ISearchVol)rTreeEntryArray[n4].d_box);
            if (iSearchVol.volumeEps() - VolT.volumeEps() < iSearchVol2.volumeEps() - VolT2.volumeEps()) {
                rTreeEntryArray2[n2++] = rTreeEntryArray[n4];
                nArray[n4] = 1;
                continue;
            }
            rTreeEntryArray3[n3++] = rTreeEntryArray[n4];
            nArray[n4] = 1;
        }
        for (n = 0; n < n2; ++n) {
            rTreeNode.setEntry(n, rTreeEntryArray2[n], this.d_nodeLookupMap);
        }
        while (n < rTreeNode.d_entry.length) {
            rTreeNode.d_entry[n] = null;
            ++n;
        }
        rTreeNode.d_numEntries = n2;
        RTreeNode rTreeNode2 = null;
        rTreeNode2 = rTreeNode.isLeaf() ? new RTreeLeaf(this.d_maxFill) : new RTreeBranch(this.d_maxFill);
        rTreeNode2.d_parent = rTreeNode.d_parent;
        for (n = 0; n < n3; ++n) {
            rTreeNode2.setEntry(n, rTreeEntryArray3[n], this.d_nodeLookupMap);
        }
        rTreeNode2.d_numEntries = n3;
        return rTreeNode2;
    }

    private RTreeNode<VolT> adjustTree(RTreeNode<VolT> rTreeNode, RTreeNode<VolT> rTreeNode2) {
        RTreeNode<VolT> rTreeNode3 = rTreeNode;
        RTreeNode<VolT> rTreeNode4 = rTreeNode2;
        while (rTreeNode3 != this.d_root) {
            VolT VolT = ARTree.calcBox(rTreeNode3);
            RTreeBranch rTreeBranch = rTreeNode3.d_parent.asBranch();
            for (int i = 0; i < rTreeBranch.d_numEntries; ++i) {
                if (rTreeBranch.getChild(i) != rTreeNode3) continue;
                rTreeBranch.d_entry[i].d_box = VolT;
            }
            RTreeNode rTreeNode5 = null;
            if (rTreeNode4 != null) {
                VolT = ARTree.calcBox(rTreeNode4);
                BranchEntry<VolT> branchEntry = new BranchEntry<VolT>(VolT, rTreeNode4);
                if (rTreeBranch.d_numEntries < this.d_maxFill) {
                    rTreeBranch.d_entry[rTreeBranch.d_numEntries++] = branchEntry;
                } else {
                    rTreeNode5 = this.splitNode(rTreeBranch, branchEntry);
                }
            }
            rTreeNode3 = rTreeBranch;
            rTreeNode4 = rTreeNode5;
        }
        return rTreeNode4;
    }

    private void condenseTree(RTreeNode<VolT> rTreeNode) {
        this.forceCondense(rTreeNode);
    }

    private void forceCondense(RTreeNode<VolT> rTreeNode) {
        ArrayList<EliminatedNode<VolT>> arrayList = new ArrayList<EliminatedNode<VolT>>();
        Object object = rTreeNode;
        int n = 0;
        assert (rTreeNode.isLeaf());
        while (object != this.d_root) {
            int n2;
            RTreeBranch rTreeBranch = ((RTreeNode)object).d_parent.asBranch();
            for (n2 = 0; n2 < rTreeBranch.d_numEntries && rTreeBranch.getChild(n2) != object; ++n2) {
            }
            if (((RTreeNode)object).d_numEntries < this.d_minFill) {
                rTreeBranch.removeEntry(n2);
                arrayList.add(new EliminatedNode<VolT>(object, n));
            } else {
                rTreeBranch.d_entry[n2].d_box = ARTree.calcBox(object);
            }
            object = rTreeBranch;
            ++n;
        }
        for (EliminatedNode eliminatedNode : arrayList) {
            for (int i = 0; i < ((EliminatedNode)eliminatedNode).Node.d_numEntries; ++i) {
                this.insert(((EliminatedNode)eliminatedNode).Node.d_entry[i], eliminatedNode.Level);
            }
        }
    }

    private void insert(RTreeEntry<VolT> rTreeEntry, int n) {
        RTreeNode<VolT> rTreeNode;
        RTreeNode<VolT> rTreeNode2 = rTreeNode = this.chooseLeaf(rTreeEntry);
        for (int i = 0; i < n; ++i) {
            rTreeNode2 = rTreeNode2.d_parent;
        }
        assert (rTreeNode2 != null);
        if (rTreeNode2.d_numEntries < this.d_maxFill) {
            rTreeNode2.setEntry(rTreeNode2.d_numEntries++, rTreeEntry, this.d_nodeLookupMap);
            this.adjustTree(rTreeNode2, null);
        } else {
            RTreeNode rTreeNode3 = this.splitNode(rTreeNode2, rTreeEntry);
            if ((rTreeNode3 = this.adjustTree(rTreeNode2, rTreeNode3)) != null) {
                VolT VolT = ARTree.calcBox(this.d_root);
                Object VolT2 = ARTree.calcBox(rTreeNode3);
                RTreeBranch rTreeBranch = new RTreeBranch(this.d_maxFill);
                rTreeBranch.d_parent = null;
                ((RTreeNode)rTreeBranch).setEntry(0, new BranchEntry<VolT>(VolT, this.d_root), this.d_nodeLookupMap);
                ((RTreeNode)rTreeBranch).setEntry(1, new BranchEntry(VolT2, rTreeNode3), this.d_nodeLookupMap);
                rTreeBranch.d_numEntries = 2;
                this.d_root = rTreeBranch;
            }
        }
    }

    private static <VolT extends ISearchVol> VolT calcBox(RTreeNode<VolT> rTreeNode) {
        assert (rTreeNode.d_numEntries > 0);
        ISearchVol iSearchVol = (ISearchVol)rTreeNode.d_entry[0].d_box.clone();
        for (int i = 1; i < rTreeNode.d_numEntries; ++i) {
            iSearchVol.add((ISearchVol)rTreeNode.d_entry[i].d_box);
        }
        return (VolT)iSearchVol;
    }

    private int[] QpickSeeds(RTreeEntry[] rTreeEntryArray) {
        double d = -1.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.d_maxFill + 1; ++i) {
            for (int j = 0; j < this.d_maxFill + 1; ++j) {
                if (i == j) continue;
                ISearchVol iSearchVol = (ISearchVol)rTreeEntryArray[i].d_box.clone();
                iSearchVol.add((ISearchVol)rTreeEntryArray[j].d_box);
                double d2 = iSearchVol.volumeEps() - rTreeEntryArray[i].d_box.volumeEps() - rTreeEntryArray[j].d_box.volumeEps();
                if (d == -1.0) {
                    d = d2;
                    n = i;
                    n2 = j;
                    continue;
                }
                if (!(d2 > d)) continue;
                d = d2;
                n = i;
                n2 = j;
            }
        }
        return new int[]{n, n2};
    }

    private int QpickNext(RTreeEntry[] rTreeEntryArray, int[] nArray, VolT VolT, VolT VolT2) {
        double d = -1.0;
        int n = 0;
        for (int i = 0; i < this.d_maxFill + 1; ++i) {
            if (nArray[i] != 0) continue;
            ISearchVol iSearchVol = (ISearchVol)rTreeEntryArray[i].d_box.clone();
            iSearchVol.add((ISearchVol)VolT2);
            ISearchVol iSearchVol2 = (ISearchVol)rTreeEntryArray[i].d_box.clone();
            iSearchVol2.add((ISearchVol)VolT);
            double d2 = iSearchVol.volumeEps() - VolT2.volumeEps();
            double d3 = iSearchVol2.volumeEps() - VolT.volumeEps();
            if (d == -1.0) {
                d = Math.abs(d3 - d2);
                n = i;
                continue;
            }
            double d4 = Math.abs(d3 - d2);
            if (!(d4 > d)) continue;
            d = d4;
            n = i;
        }
        return n;
    }

    private static class ResultWrapper<T2>
    implements IResult<T2>,
    Serializable {
        private static final long serialVersionUID = -1528907801002008439L;
        private final IRTreeTestResult<T2> d_base;

        public ResultWrapper(IRTreeTestResult<T2> iRTreeTestResult) {
            this.d_base = iRTreeTestResult;
        }

        @Override
        public void mark(T2 T2, Containment containment) {
            switch (containment) {
                case INSIDE: {
                    if (!this.d_base.markInside(T2)) {
                        throw new CancellationException();
                    }
                }
                case INTERSECTS: {
                    if (this.d_base.markIntersecting(T2)) break;
                    throw new CancellationException();
                }
            }
        }
    }

    private static class TestWrapper<VolT>
    implements pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest<VolT>,
    Serializable {
        private static final long serialVersionUID = -1528907801002008438L;
        private final ITest<VolT> d_base;

        public TestWrapper(ITest<VolT> iTest) {
            this.d_base = iTest;
        }

        @Override
        public Containment test(VolT VolT) {
            int n = this.d_base.testContainment(VolT);
            switch (n) {
                case 0: {
                    return Containment.INSIDE;
                }
                case 1: {
                    return Containment.INTERSECTS;
                }
            }
            return Containment.OUTSIDE;
        }
    }

    public static interface IRTreeTestResult<T2> {
        public boolean markInside(T2 var1);

        public boolean markIntersecting(T2 var1);
    }

    public static interface ITest<VolT> {
        public int testContainment(VolT var1);
    }

    private static class RTreeLeaf<VolT extends ISearchVol>
    extends RTreeNode<VolT>
    implements Serializable {
        private static final long serialVersionUID = -1528907801002008437L;

        public RTreeLeaf(int n) {
            super(n);
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public <T> void setEntry(int n, RTreeEntry<VolT> rTreeEntry, Map<T, RTreeNode<VolT>> map) {
            super.setEntry(n, rTreeEntry, map);
            LeafEntry leafEntry = rTreeEntry.asLeaf();
            map.put(leafEntry.d_data, this);
        }

        @Override
        protected <T> RTreeNode<VolT> clone(Map<T, T> map) {
            RTreeLeaf<VolT> rTreeLeaf = new RTreeLeaf<VolT>(this.d_entry.length);
            rTreeLeaf.d_numEntries = this.d_numEntries;
            for (int i = 0; i < this.d_numEntries; ++i) {
                LeafEntry leafEntry = this.d_entry[i].asLeaf();
                T t = map.get(leafEntry.d_data);
                rTreeLeaf.d_entry[i] = new LeafEntry<T, ISearchVol>(leafEntry.d_box, t);
            }
            return rTreeLeaf;
        }

        @Override
        protected <T> void buildLookupMap(Map<T, RTreeNode<VolT>> map) {
            for (int i = 0; i < this.d_numEntries; ++i) {
                map.put(this.d_entry[i].asLeaf().d_data, this);
            }
        }
    }

    private static class RTreeBranch<VolT extends ISearchVol>
    extends RTreeNode<VolT>
    implements Serializable {
        private static final long serialVersionUID = -1528907801002008436L;

        public RTreeBranch(int n) {
            super(n);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public RTreeNode<VolT> getChild(int n) {
            return this.d_entry[n].asBranch().d_child;
        }

        @Override
        public <T> void setEntry(int n, RTreeEntry<VolT> rTreeEntry, Map<T, RTreeNode<VolT>> map) {
            super.setEntry(n, rTreeEntry, map);
            this.d_entry[n].asBranch().d_child.d_parent = this;
        }

        @Override
        public <T> RTreeNode<VolT> clone(Map<T, T> map) {
            RTreeBranch<VolT> rTreeBranch = new RTreeBranch<VolT>(this.d_entry.length);
            rTreeBranch.d_numEntries = this.d_numEntries;
            for (int i = 0; i < this.d_numEntries; ++i) {
                BranchEntry branchEntry = this.d_entry[i].asBranch();
                RTreeNode rTreeNode = branchEntry.d_child.clone(map);
                rTreeNode.d_parent = rTreeBranch;
                rTreeBranch.d_entry[i] = new BranchEntry<ISearchVol>(branchEntry.d_box, rTreeNode);
            }
            return rTreeBranch;
        }

        @Override
        protected <T> void buildLookupMap(Map<T, RTreeNode<VolT>> map) {
            for (int i = 0; i < this.d_numEntries; ++i) {
                this.d_entry[i].asBranch().d_child.buildLookupMap(map);
            }
        }
    }

    private static abstract class RTreeNode<VolT extends ISearchVol>
    implements Serializable {
        private static final long serialVersionUID = -1528907801002008435L;
        public RTreeNode<VolT> d_parent;
        public int d_numEntries;
        public RTreeEntry<VolT>[] d_entry;

        public RTreeNode(int n) {
            this.d_entry = new RTreeEntry[n];
            this.d_parent = null;
            this.d_numEntries = 0;
        }

        public abstract boolean isLeaf();

        public RTreeLeaf<VolT> asLeaf() {
            return (RTreeLeaf)this;
        }

        public RTreeBranch<VolT> asBranch() {
            return (RTreeBranch)this;
        }

        public <T> void setEntry(int n, RTreeEntry<VolT> rTreeEntry, Map<T, RTreeNode<VolT>> map) {
            this.d_entry[n] = rTreeEntry;
        }

        public void removeEntry(int n) {
            this.d_entry[n] = null;
            while (n < this.d_numEntries - 1) {
                this.d_entry[n] = this.d_entry[n + 1];
                ++n;
            }
            this.d_entry[n] = null;
            --this.d_numEntries;
        }

        public boolean isValid() {
            int n;
            int n2 = 0;
            for (n = 0; n < this.d_entry.length; ++n) {
                if (this.d_entry[n] == null) continue;
                ++n2;
            }
            if (n2 != this.d_numEntries) {
                return false;
            }
            for (n = 0; n < this.d_entry.length && this.d_entry[n] != null; ++n) {
                if (this.d_entry[n].isValid()) continue;
                return false;
            }
            ++n;
            while (n < this.d_entry.length) {
                if (this.d_entry[n] != null) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        protected abstract <T> void buildLookupMap(Map<T, RTreeNode<VolT>> var1);

        protected abstract <T> RTreeNode<VolT> clone(Map<T, T> var1);
    }

    private static class LeafEntry<T, VolT extends ISearchVol>
    extends RTreeEntry<VolT>
    implements Serializable {
        private static final long serialVersionUID = -1604564689350726465L;
        public final T d_data;

        public LeafEntry(VolT VolT, T t) {
            super(VolT);
            this.d_data = t;
        }
    }

    private static class BranchEntry<VolT extends ISearchVol>
    extends RTreeEntry<VolT>
    implements Serializable {
        private static final long serialVersionUID = -3018167839772030290L;
        public final RTreeNode<VolT> d_child;

        public BranchEntry(VolT VolT, RTreeNode<VolT> rTreeNode) {
            super(VolT);
            this.d_child = rTreeNode;
        }

        @Override
        public boolean isValid() {
            return this.d_child.isValid();
        }
    }

    private static abstract class RTreeEntry<VolT extends ISearchVol>
    implements Serializable {
        private static final long serialVersionUID = -8218641300778690290L;
        public VolT d_box;

        public RTreeEntry(VolT VolT) {
            this.d_box = VolT;
        }

        public <T> LeafEntry<T, VolT> asLeaf() {
            return (LeafEntry)this;
        }

        public BranchEntry asBranch() {
            return (BranchEntry)this;
        }

        public boolean isValid() {
            return true;
        }
    }

    private static class EliminatedNode<VolT extends ISearchVol>
    implements Serializable {
        private static final long serialVersionUID = -6295586569639947296L;
        private final RTreeNode<VolT> Node;
        private final int Level;

        public EliminatedNode(RTreeNode<VolT> rTreeNode, int n) {
            this.Node = rTreeNode;
            this.Level = n;
        }
    }
}

