/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.geometry;

import java.io.Serializable;
import javax.vecmath.Point3f;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ISearchVol;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class AABoxf
implements Serializable,
Cloneable,
ISearchVol,
ITest<AABoxf> {
    static final long serialVersionUID = 1L;
    public static final float VOL_EPS = 1.1920929E-7f;
    private float d_minx;
    private float d_miny;
    private float d_minz;
    private float d_maxx;
    private float d_maxy;
    private float d_maxz;

    public AABoxf() {
        this(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    }

    public AABoxf(AABoxf aABoxf) {
        this(aABoxf.d_minx, aABoxf.d_miny, aABoxf.d_minz, aABoxf.d_maxx, aABoxf.d_maxy, aABoxf.d_maxz);
    }

    public AABoxf(Point3f point3f, Point3f point3f2) {
        this.set(point3f, point3f2);
    }

    public AABoxf(float f, float f2, float f3, float f4, float f5, float f6) {
        this.d_minx = f;
        this.d_miny = f2;
        this.d_minz = f3;
        this.d_maxx = f4;
        this.d_maxy = f5;
        this.d_maxz = f6;
    }

    public AABoxf(Point3f ... point3fArray) {
        this();
        this.add(point3fArray);
    }

    public float getWidth() {
        return this.d_maxx - this.d_minx;
    }

    public float getDepth() {
        return this.d_maxy - this.d_miny;
    }

    public float getHeight() {
        return this.d_maxz - this.d_minz;
    }

    public static AABoxf infinite() {
        return new AABoxf(new Point3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY), new Point3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY));
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.d_minx) || Float.isInfinite(this.d_miny) || Float.isInfinite(this.d_minz) || Float.isInfinite(this.d_maxx) || Float.isInfinite(this.d_maxy) || Float.isInfinite(this.d_maxz);
    }

    public void reset() {
        this.d_minz = Float.MAX_VALUE;
        this.d_miny = Float.MAX_VALUE;
        this.d_minx = Float.MAX_VALUE;
        this.d_maxz = -3.4028235E38f;
        this.d_maxy = -3.4028235E38f;
        this.d_maxx = -3.4028235E38f;
    }

    @Override
    public boolean isValid() {
        return this.d_minx <= this.d_maxx && this.d_miny <= this.d_maxy && this.d_minz <= this.d_maxz;
    }

    public void set(Point3f point3f, Point3f point3f2) {
        this.d_minx = point3f.x;
        this.d_miny = point3f.y;
        this.d_minz = point3f.z;
        this.d_maxx = point3f2.x;
        this.d_maxy = point3f2.y;
        this.d_maxz = point3f2.z;
    }

    public void set(float f, float f2, float f3, float f4, float f5, float f6) {
        this.d_minx = f;
        this.d_miny = f2;
        this.d_minz = f3;
        this.d_maxx = f4;
        this.d_maxy = f5;
        this.d_maxz = f6;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("AABoxf{");
        stringBuffer.append(this.getMin().toString() + " --> ");
        stringBuffer.append(this.getMax().toString() + "}");
        return stringBuffer.toString();
    }

    public Point3f getCenter() {
        return new Point3f((this.d_minx + this.d_maxx) * 0.5f, (this.d_miny + this.d_maxy) * 0.5f, (this.d_minz + this.d_maxz) * 0.5f);
    }

    public Point3f getMin() {
        return new Point3f(this.d_minx, this.d_miny, this.d_minz);
    }

    public Point3f getMax() {
        return new Point3f(this.d_maxx, this.d_maxy, this.d_maxz);
    }

    public Point3f[] getVerts() {
        Point3f[] point3fArray = new Point3f[]{this.mmm(), this.mmM(), this.mMm(), this.mMM(), this.Mmm(), this.MmM(), this.MMm(), this.MMM()};
        return point3fArray;
    }

    public float getMinX() {
        return this.d_minx;
    }

    public float getMinY() {
        return this.d_miny;
    }

    public float getMinZ() {
        return this.d_minz;
    }

    public float getMaxX() {
        return this.d_maxx;
    }

    public float getMaxY() {
        return this.d_maxy;
    }

    public float getMaxZ() {
        return this.d_maxz;
    }

    @Override
    public void add(ISearchVol iSearchVol) {
        if (iSearchVol instanceof AABoxf) {
            this.add((AABoxf)iSearchVol);
        }
    }

    public void add(AABoxf aABoxf) {
        if (aABoxf.d_minx < this.d_minx) {
            this.d_minx = aABoxf.d_minx;
        }
        if (aABoxf.d_maxx > this.d_maxx) {
            this.d_maxx = aABoxf.d_maxx;
        }
        if (aABoxf.d_miny < this.d_miny) {
            this.d_miny = aABoxf.d_miny;
        }
        if (aABoxf.d_maxy > this.d_maxy) {
            this.d_maxy = aABoxf.d_maxy;
        }
        if (aABoxf.d_minz < this.d_minz) {
            this.d_minz = aABoxf.d_minz;
        }
        if (aABoxf.d_maxz > this.d_maxz) {
            this.d_maxz = aABoxf.d_maxz;
        }
    }

    public void add(Point3f ... point3fArray) {
        for (Point3f point3f : point3fArray) {
            this.add(point3f);
        }
    }

    public void add(Point3f point3f) {
        this.addPoint(point3f.x, point3f.y, point3f.z);
    }

    public void addPoint(float f, float f2, float f3) {
        if (f < this.d_minx) {
            this.d_minx = f;
        }
        if (f > this.d_maxx) {
            this.d_maxx = f;
        }
        if (f2 < this.d_miny) {
            this.d_miny = f2;
        }
        if (f2 > this.d_maxy) {
            this.d_maxy = f2;
        }
        if (f3 < this.d_minz) {
            this.d_minz = f3;
        }
        if (f3 > this.d_maxz) {
            this.d_maxz = f3;
        }
    }

    public void addForMin(Point3f point3f) {
        if (point3f.x < this.d_minx) {
            this.d_minx = point3f.x;
        }
        if (point3f.y < this.d_miny) {
            this.d_miny = point3f.y;
        }
        if (point3f.z < this.d_minz) {
            this.d_minz = point3f.z;
        }
    }

    public void addForMax(Point3f point3f) {
        if (point3f.x > this.d_maxx) {
            this.d_maxx = point3f.x;
        }
        if (point3f.y > this.d_maxy) {
            this.d_maxy = point3f.y;
        }
        if (point3f.z > this.d_maxz) {
            this.d_maxz = point3f.z;
        }
    }

    public float volume() {
        return (this.d_maxx - this.d_minx) * (this.d_maxy - this.d_miny) * (this.d_maxz - this.d_minz);
    }

    public float volume(float f) {
        float f2 = this.d_maxx - this.d_minx + f;
        float f3 = this.d_maxy - this.d_miny + f;
        float f4 = this.d_maxz - this.d_minz + f;
        return f2 * f3 * f4;
    }

    @Override
    public double volumeEps() {
        return this.volume(1.1920929E-7f);
    }

    public AABoxf ensureValidSize(float f, float f2) {
        Point3f point3f = this.getMin();
        Point3f point3f2 = this.getMax();
        if (!this.isValid()) {
            this.set(new Point3f(-f, -f, -f), new Point3f(f, f, f));
            return this;
        }
        if (point3f.equals(point3f2)) {
            this.set(new Point3f(point3f.x - f, point3f.y - f, point3f.z - f), new Point3f(point3f2.x + f, point3f2.y + f, point3f2.z + f));
            return this;
        }
        if (point3f.x == point3f2.x) {
            point3f.x -= f2;
            point3f2.x += f2;
        }
        if (point3f.y == point3f2.y) {
            point3f.y -= f2;
            point3f2.y += f2;
        }
        if (point3f.z == point3f2.z) {
            point3f.z -= f2;
            point3f2.z += f2;
        }
        this.set(point3f, point3f2);
        return this;
    }

    public boolean cull(Point3f point3f) {
        return !(point3f.x <= this.d_minx || point3f.x >= this.d_maxx || point3f.y <= this.d_miny || point3f.y >= this.d_maxy || point3f.z <= this.d_minz) && !(point3f.z >= this.d_maxz);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AABoxf)) {
            return false;
        }
        AABoxf aABoxf = (AABoxf)object;
        return this.d_minx == aABoxf.d_minx && this.d_miny == aABoxf.d_miny && this.d_minz == aABoxf.d_minz && this.d_maxx == aABoxf.d_maxx && this.d_maxy == aABoxf.d_maxy && this.d_maxz == aABoxf.d_maxz;
    }

    public int hashCode() {
        return theUtil.hashCode(this.d_minx + this.d_miny + this.d_minz + this.d_maxx + this.d_maxy + this.d_maxz);
    }

    @Override
    public Object clone() {
        return new AABoxf(this);
    }

    public boolean contains(Point3f point3f) {
        return this.d_minx <= point3f.x && point3f.x <= this.d_maxx && this.d_miny <= point3f.y && point3f.y <= this.d_maxy && this.d_minz <= point3f.z && point3f.z <= this.d_maxz;
    }

    public boolean containsOneOf(Point3f ... point3fArray) {
        for (Point3f point3f : point3fArray) {
            if (!this.contains(point3f)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Point3f point3f, float f) {
        return this.d_minx - f <= point3f.x && point3f.x <= this.d_maxx + f && this.d_miny - f <= point3f.y && point3f.y <= this.d_maxy + f && this.d_minz - f <= point3f.z && point3f.z <= this.d_maxz + f;
    }

    public boolean innerPt(Point3f point3f) {
        return this.d_minx < point3f.x && point3f.x < this.d_maxx && this.d_miny < point3f.y && point3f.y < this.d_maxy && this.d_minz < point3f.z && point3f.z < this.d_maxz;
    }

    @Override
    public Containment test(AABoxf aABoxf) {
        return AABoxf.contains(this.d_minx, this.d_miny, this.d_minz, this.d_maxx, this.d_maxy, this.d_maxz, aABoxf.d_minx, aABoxf.d_miny, aABoxf.d_minz, aABoxf.d_maxx, aABoxf.d_maxy, aABoxf.d_maxz);
    }

    public Containment test(AABoxf aABoxf, float f) {
        return AABoxf.contains(this.d_minx - f, this.d_miny - f, this.d_minz - f, this.d_maxx + f, this.d_maxy + f, this.d_maxz + f, aABoxf.d_minx - f, aABoxf.d_miny - f, aABoxf.d_minz - f, aABoxf.d_maxx + f, aABoxf.d_maxy + f, aABoxf.d_maxz + f);
    }

    private static final Containment contains(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        if (f <= f10 && f7 <= f4 && f2 <= f11 && f8 <= f5 && f3 <= f12 && f9 <= f6) {
            if (f <= f7 && f10 <= f4 && f2 <= f8 && f11 <= f5 && f3 <= f9 && f12 <= f6) {
                return Containment.INSIDE;
            }
            return Containment.INTERSECTS;
        }
        return Containment.OUTSIDE;
    }

    public int contains(AABoxf aABoxf) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(aABoxf));
    }

    public int contains(AABoxf aABoxf, float f) {
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.Containment.convert(this.test(aABoxf, f));
    }

    public boolean intersects(AABoxf aABoxf) {
        Point3f point3f = this.getMin();
        Point3f point3f2 = this.getMax();
        Point3f point3f3 = aABoxf.getMin();
        Point3f point3f4 = aABoxf.getMax();
        return point3f.x <= point3f4.x && point3f2.x >= point3f3.x && point3f.y <= point3f4.y && point3f2.y >= point3f3.y && point3f.z <= point3f4.z && point3f2.z >= point3f3.z;
    }

    public boolean intersects(AABoxf aABoxf, float f) {
        float f2 = this.d_minx - f;
        float f3 = this.d_miny - f;
        float f4 = this.d_minz - f;
        float f5 = aABoxf.d_minx - f;
        float f6 = aABoxf.d_miny - f;
        float f7 = aABoxf.d_minz - f;
        float f8 = this.d_maxx + f;
        float f9 = this.d_maxy + f;
        float f10 = this.d_maxz + f;
        float f11 = aABoxf.d_maxx + f;
        float f12 = aABoxf.d_maxy + f;
        float f13 = aABoxf.d_maxz + f;
        return f5 <= f8 && f11 >= f2 && f6 <= f9 && f12 >= f3 && f7 <= f10 && f13 >= f4;
    }

    public Point3f mmm() {
        return this.getMin();
    }

    public Point3f mmM() {
        return new Point3f(this.d_minx, this.d_miny, this.d_maxz);
    }

    public Point3f mMm() {
        return new Point3f(this.d_minx, this.d_maxy, this.d_minz);
    }

    public Point3f mMM() {
        return new Point3f(this.d_minx, this.d_maxy, this.d_maxz);
    }

    public Point3f Mmm() {
        return new Point3f(this.d_maxx, this.d_miny, this.d_minz);
    }

    public Point3f MmM() {
        return new Point3f(this.d_maxx, this.d_miny, this.d_maxz);
    }

    public Point3f MMm() {
        return new Point3f(this.d_maxx, this.d_maxy, this.d_minz);
    }

    public Point3f MMM() {
        return this.getMax();
    }

    public Point3f mmm(Point3f point3f) {
        point3f.set(this.d_minx, this.d_miny, this.d_minz);
        return point3f;
    }

    public Point3f mmM(Point3f point3f) {
        point3f.set(this.d_minx, this.d_miny, this.d_maxz);
        return point3f;
    }

    public Point3f mMm(Point3f point3f) {
        point3f.set(this.d_minx, this.d_maxy, this.d_minz);
        return point3f;
    }

    public Point3f mMM(Point3f point3f) {
        point3f.set(this.d_minx, this.d_maxy, this.d_maxz);
        return point3f;
    }

    public Point3f Mmm(Point3f point3f) {
        point3f.set(this.d_maxx, this.d_miny, this.d_minz);
        return point3f;
    }

    public Point3f MmM(Point3f point3f) {
        point3f.set(this.d_maxx, this.d_miny, this.d_maxz);
        return point3f;
    }

    public Point3f MMm(Point3f point3f) {
        point3f.set(this.d_maxx, this.d_maxy, this.d_minz);
        return point3f;
    }

    public Point3f MMM(Point3f point3f) {
        point3f.set(this.d_maxx, this.d_maxy, this.d_maxz);
        return point3f;
    }

    public Point3f[][] getFaces() {
        Point3f point3f = this.mmm();
        Point3f point3f2 = this.mmM();
        Point3f point3f3 = this.mMm();
        Point3f point3f4 = this.mMM();
        Point3f point3f5 = this.Mmm();
        Point3f point3f6 = this.MmM();
        Point3f point3f7 = this.MMm();
        Point3f point3f8 = this.MMM();
        return new Point3f[][]{{point3f3, point3f, point3f2, point3f4}, {point3f5, point3f7, point3f8, point3f6}, {point3f, point3f5, point3f6, point3f2}, {point3f7, point3f3, point3f4, point3f8}, {point3f, point3f3, point3f7, point3f5}, {point3f2, point3f6, point3f8, point3f4}};
    }

    public AABoxf scale(float f) {
        Point3f point3f = this.getCenter();
        float f2 = this.getWidth() * f * 0.5f;
        float f3 = this.getHeight() * f * 0.5f;
        float f4 = this.getDepth() * f * 0.5f;
        return new AABoxf(point3f.x - f2, point3f.y - f4, point3f.z - f3, point3f.x + f2, point3f.y + f4, point3f.z + f3);
    }
}

