/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.delaunay;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Point2d;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.TriangulatorInfo;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiDialog;

public class TriangulationViewer
extends JPanel {
    private static final long serialVersionUID = -1040243561985798067L;
    private Vector<Point2d> d_points = new Vector();
    private Vector<Edge> d_edges = new Vector();
    private Vector<Tri> d_tris = new Vector();
    private Vector<Point2d> d_voronoiPts = new Vector();
    private Vector<int[]> d_voronoiPolys = new Vector();
    private double d_xmin;
    private double d_xmax;
    private double d_ymin;
    private double d_ymax;
    private AffineTransform d_transform = new AffineTransform();
    private float d_size = 0.0f;
    static boolean dirty = true;
    GeneralPath path;

    public static void main(String[] stringArray) {
        System.out.println("Triangle...");
        JFrame jFrame = new JFrame("Triangle");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setLayout(new BorderLayout());
        jFrame.getContentPane().add(new TriangulationViewer());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void view(JDialog jDialog, TriangulatorInfo triangulatorInfo) {
        guiDialog guiDialog2 = new guiDialog((Window)jDialog, "Triangle", 1);
        guiDialog2.getDialogPane().setLayout(new BorderLayout());
        guiDialog2.getDialogPane().add(new TriangulationViewer(triangulatorInfo));
        guiDialog2.doModal();
    }

    public TriangulationViewer() {
        this((TriangulatorInfo)null);
    }

    public TriangulationViewer(final TriangulatorInfo triangulatorInfo) {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                System.out.println("key pressed");
                if (keyEvent.getKeyCode() == 82) {
                    TriangulationViewer.this.init(triangulatorInfo);
                    TriangulationViewer.this.repaint();
                }
            }
        });
        this.init(triangulatorInfo);
        this.setPreferredSize(new Dimension(800, 800));
        this.setFocusable(true);
    }

    private void init(TriangulatorInfo triangulatorInfo) {
        if (triangulatorInfo != null) {
            this.initData(triangulatorInfo);
        } else {
            this.readFile();
        }
    }

    private void clearMinMax() {
        this.d_xmin = Double.MAX_VALUE;
        this.d_ymin = Double.MAX_VALUE;
        this.d_xmax = -1.7976931348623157E308;
        this.d_ymax = -1.7976931348623157E308;
    }

    private void updateMinMax(Point2d point2d) {
        if (point2d.x < this.d_xmin) {
            this.d_xmin = point2d.x;
        }
        if (point2d.x > this.d_xmax) {
            this.d_xmax = point2d.x;
        }
        if (point2d.y < this.d_ymin) {
            this.d_ymin = point2d.y;
        }
        if (point2d.y > this.d_ymax) {
            this.d_ymax = point2d.y;
        }
    }

    private void initData(TriangulatorInfo triangulatorInfo) {
        assert (triangulatorInfo.colors != null);
        this.d_points.clear();
        this.d_tris.clear();
        this.d_points.addAll(Arrays.asList(triangulatorInfo.points));
        for (int i = 0; i < triangulatorInfo.triangles.length; i += 3) {
            int n = i / 3;
            int n2 = triangulatorInfo.colors[n];
            int n3 = triangulatorInfo.triangles[i];
            int n4 = triangulatorInfo.triangles[i + 1];
            int n5 = triangulatorInfo.triangles[i + 2];
            this.updateMinMax(this.d_points.get(n3));
            this.updateMinMax(this.d_points.get(n4));
            this.updateMinMax(this.d_points.get(n5));
            this.d_tris.add(new Tri(n3, n4, n5, n2));
        }
    }

    private void readFile() {
        int n;
        int n2;
        String string;
        Throwable throwable;
        BufferedReader bufferedReader;
        this.d_points.clear();
        this.d_tris.clear();
        this.clearMinMax();
        try {
            bufferedReader = new BufferedReader(new FileReader("triangle.data"));
            throwable = null;
            try {
                string = bufferedReader.readLine();
                assert (string != null);
                n2 = Integer.parseInt(string);
                for (n = 0; n < n2; ++n) {
                    string = bufferedReader.readLine();
                    assert (string != null);
                    String[] stringArray = string.split(",");
                    double d = Double.parseDouble(stringArray[0]);
                    double d2 = Double.parseDouble(stringArray[1]);
                    Point2d point2d = new Point2d(d, d2);
                    this.d_points.add(point2d);
                }
                string = bufferedReader.readLine();
                assert (string != null);
                n = Integer.parseInt(string);
                for (int i = 0; i < n; ++i) {
                    string = bufferedReader.readLine();
                    assert (string != null);
                    String[] stringArray = string.split(" ");
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    int n5 = Integer.parseInt(stringArray[2]);
                    int n6 = Integer.parseInt(stringArray[3]);
                    this.updateMinMax(this.d_points.get(n3));
                    this.updateMinMax(this.d_points.get(n4));
                    this.updateMinMax(this.d_points.get(n5));
                    this.d_tris.add(new Tri(n3, n4, n5, n6));
                }
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bufferedReader != null) {
                    if (throwable != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        bufferedReader.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedReader = new BufferedReader(new FileReader("voronoi.data"));
            throwable = null;
            try {
                string = bufferedReader.readLine();
                assert (string != null);
                n2 = Integer.parseInt(string);
                for (n = 0; n < n2; ++n) {
                    string = bufferedReader.readLine();
                    assert (string != null);
                    String[] stringArray = string.split(" ");
                    double d = Double.parseDouble(stringArray[0]);
                    double d3 = Double.parseDouble(stringArray[1]);
                    Point2d point2d = new Point2d(d, d3);
                    this.d_voronoiPts.add(point2d);
                }
                string = bufferedReader.readLine();
                assert (string != null);
                n = Integer.parseInt(string);
                for (int i = 0; i < n; ++i) {
                    string = bufferedReader.readLine();
                    assert (string != null);
                    String[] stringArray = string.split(" ");
                    int[] nArray = new int[stringArray.length - 1];
                    for (int j = 1; j < stringArray.length; ++j) {
                        nArray[j - 1] = Integer.parseInt(stringArray[j]);
                    }
                    this.d_voronoiPolys.add(nArray);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (bufferedReader != null) {
                    if (throwable != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        bufferedReader.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        Point2D.Double double_;
        Point2D.Double double_2;
        Point2D.Double double_3;
        Point2d point2d;
        Point2d point2d2;
        Point2d point2d3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(SystemColor.window);
        graphics2D.fill(new Rectangle(this.getSize()));
        this.updateTransform();
        graphics2D.setPaint(Color.LIGHT_GRAY);
        this.path = new GeneralPath();
        Color[] colorArray = new Color[]{new Color(207, 226, 172), new Color(184, 211, 136), new Color(161, 196, 104), new Color(131, 177, 66)};
        for (Tri object2 : this.d_tris) {
            graphics2D.setPaint(colorArray[object2.color]);
            this.path.reset();
            point2d3 = this.d_points.get(object2.p1);
            point2d2 = this.d_points.get(object2.p2);
            point2d = this.d_points.get(object2.p3);
            double_3 = new Point2D.Double(point2d3.x, point2d3.y);
            double_2 = new Point2D.Double(point2d2.x, point2d2.y);
            double_ = new Point2D.Double(point2d.x, point2d.y);
            this.d_transform.transform(double_3, double_3);
            this.d_transform.transform(double_2, double_2);
            this.d_transform.transform(double_, double_);
            this.path.moveTo((float)double_3.x, (float)double_3.y);
            this.path.lineTo((float)double_2.x, (float)double_2.y);
            this.path.lineTo((float)double_.x, (float)double_.y);
            this.path.lineTo((float)double_3.x, (float)double_3.y);
            graphics2D.fill(this.path);
        }
        for (int i = 0; i < this.d_tris.size(); ++i) {
            dirty = false;
            Tri tri = this.d_tris.get(i);
            point2d3 = this.d_points.get(tri.p1);
            point2d2 = this.d_points.get(tri.p2);
            point2d = this.d_points.get(tri.p3);
            double_3 = new Point2D.Double(point2d3.x, point2d3.y);
            double_2 = new Point2D.Double(point2d2.x, point2d2.y);
            double_ = new Point2D.Double(point2d.x, point2d.y);
            this.d_transform.transform(double_3, double_3);
            this.d_transform.transform(double_2, double_2);
            this.d_transform.transform(double_, double_);
            this.path.moveTo((float)double_3.x, (float)double_3.y);
            this.path.lineTo((float)double_2.x, (float)double_2.y);
            this.path.lineTo((float)double_.x, (float)double_.y);
            this.path.lineTo((float)double_3.x, (float)double_3.y);
        }
        graphics2D.setColor(Color.GRAY);
        graphics2D.draw(this.path);
        graphics2D.setColor(Color.BLUE);
        for (n = 0; n < this.d_voronoiPts.size(); ++n) {
            Point2d point2d4 = this.d_voronoiPts.get(n);
            Point2D.Double double_4 = new Point2D.Double(point2d4.x, point2d4.y);
            this.d_transform.transform(double_4, double_4);
            this.drawCircle(graphics2D, double_4.x, double_4.y, 1);
        }
        this.path = new GeneralPath();
        for (n = 0; n < this.d_voronoiPolys.size(); ++n) {
            int[] nArray = this.d_voronoiPolys.get(n);
            int n2 = nArray.length;
            System.out.println(n2);
            for (int i = 0; i < n2; ++i) {
                point2d2 = this.d_voronoiPts.get(nArray[i]);
                System.out.println(i + " " + (i + 1) % n2);
                point2d = this.d_voronoiPts.get(nArray[(i + 1) % n2]);
                double_3 = new Point2D.Double(point2d2.x, point2d2.y);
                double_2 = new Point2D.Double(point2d.x, point2d.y);
                this.d_transform.transform(double_3, double_3);
                this.d_transform.transform(double_2, double_2);
                this.path.moveTo((float)double_3.x, (float)double_3.y);
                this.path.lineTo((float)double_2.x, (float)double_2.y);
            }
        }
        graphics2D.setColor(Color.RED);
        graphics2D.draw(this.path);
    }

    private void updateTransform() {
        double d = this.d_xmin;
        double d2 = this.d_xmax;
        double d3 = this.d_ymin;
        double d4 = this.d_ymax;
        Dimension dimension = this.getSize();
        this.d_transform.setToIdentity();
        double d5 = Math.min((double)dimension.width / (d2 - d) / 1.4, (double)dimension.height / (d4 - d3) / 1.4);
        this.d_transform.scale(d5, -d5);
        this.d_transform.translate(-(d - 0.2 * (d2 - d)), -(d4 + 0.2 * (d4 - d3)));
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.updateTransform();
        this.d_size = (float)n3 / 800.0f;
    }

    private void drawCircle(Graphics2D graphics2D, double d, double d2, int n) {
        Arc2D.Double double_ = new Arc2D.Double(d - (double)(3.5f * this.d_size), d2 - (double)(3.5f * this.d_size), 7.0f * this.d_size, 7.0f * this.d_size, 0.0, 360.0, 0);
        if (n == 0) {
            graphics2D.draw(double_);
        } else {
            graphics2D.fill(double_);
        }
    }

    private static class Tri {
        public int p1;
        public int p2;
        public int p3;
        public int color;

        public Tri(int n, int n2, int n3, int n4) {
            this.p1 = n;
            this.p2 = n2;
            this.p3 = n3;
            this.color = n4;
        }
    }

    private static class Edge {
        public int p1;
        public int p2;

        public Edge(int n, int n2) {
            this.p1 = n;
            this.p2 = n2;
        }
    }
}

