/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.delaunay;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Point2d;

public class Triangles
extends JPanel {
    private static final long serialVersionUID = 2408084301129701635L;
    private Vector<Point2d> d_points = new Vector();
    private Vector<Edge> d_edges = new Vector();
    private Vector<Tri> d_tris = new Vector();
    private AffineTransform d_transform = new AffineTransform();
    private float d_size = 0.0f;

    public static void main(String[] stringArray) {
        System.out.println("Triangle...");
        JFrame jFrame = new JFrame("Triangle");
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.setLayout(new BorderLayout());
        jFrame.getContentPane().add(new Triangles());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public Triangles() {
        this.readFile();
        this.setPreferredSize(new Dimension(800, 800));
    }

    private void readFile() {
        this.d_points.clear();
        this.d_tris.clear();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader("triangle.data"));){
            int n;
            String string = bufferedReader.readLine();
            assert (string != null);
            int n2 = Integer.parseInt(string);
            for (n = 0; n < n2; ++n) {
                string = bufferedReader.readLine();
                assert (string != null);
                String[] stringArray = string.split(",");
                double d = Double.parseDouble(stringArray[0]);
                double d2 = Double.parseDouble(stringArray[1]);
                this.d_points.add(new Point2d(d, d2));
            }
            string = bufferedReader.readLine();
            assert (string != null);
            n = Integer.parseInt(string);
            for (int i = 0; i < n; ++i) {
                string = bufferedReader.readLine();
                assert (string != null);
                String[] stringArray = string.split(" ");
                int n3 = Integer.parseInt(stringArray[0]);
                int n4 = Integer.parseInt(stringArray[1]);
                int n5 = Integer.parseInt(stringArray[2]);
                this.d_tris.add(new Tri(n3, n4, n5));
            }
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println(string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Point2D.Double double_;
        Cloneable cloneable;
        Point2d point2d;
        Point2d point2d2;
        Object object;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(SystemColor.window);
        graphics2D.fill(new Rectangle(this.getSize()));
        this.updateTransform();
        Path2D.Double double_2 = new Path2D.Double();
        graphics2D.setPaint(Color.LIGHT_GRAY);
        for (n = 0; n < this.d_tris.size(); ++n) {
            object = this.d_tris.get(n);
            point2d2 = this.d_points.get(((Tri)object).p1);
            point2d = this.d_points.get(((Tri)object).p2);
            cloneable = this.d_points.get(((Tri)object).p3);
            double_ = new Point2D.Double(point2d2.x, point2d2.y);
            Point2D.Double double_3 = new Point2D.Double(point2d.x, point2d.y);
            Point2D.Double double_4 = new Point2D.Double(cloneable.x, cloneable.y);
            this.d_transform.transform(double_, double_);
            this.d_transform.transform(double_3, double_3);
            this.d_transform.transform(double_4, double_4);
            double_2.moveTo(double_.x, double_.y);
            double_2.lineTo(double_3.x, double_3.y);
            double_2.lineTo(double_4.x, double_4.y);
            double_2.lineTo(double_.x, double_.y);
        }
        graphics2D.fill(double_2);
        graphics2D.setColor(Color.RED);
        for (n = 0; n < this.d_edges.size(); ++n) {
            object = this.d_edges.get(n);
            point2d2 = this.d_points.get(((Edge)object).p1);
            point2d = this.d_points.get(((Edge)object).p2);
            cloneable = new Point2D.Double(point2d2.x, point2d2.y);
            double_ = new Point2D.Double(point2d.x, point2d.y);
            this.d_transform.transform((Point2D)cloneable, (Point2D)cloneable);
            this.d_transform.transform(double_, double_);
            double_2.moveTo(((Point2D.Double)cloneable).x, ((Point2D.Double)cloneable).y);
            double_2.lineTo(double_.x, double_.y);
        }
        graphics2D.draw(double_2);
    }

    private void updateTransform() {
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 1.0;
        Dimension dimension = this.getSize();
        this.d_transform.setToIdentity();
        double d5 = Math.min((double)dimension.width / (d2 - d) / 1.4, (double)dimension.height / (d4 - d3) / 1.4);
        this.d_transform.scale(d5, -d5);
        this.d_transform.translate(-(d - 0.2 * (d2 - d)), -(d4 + 0.2 * (d4 - d3)));
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.updateTransform();
        this.d_size = (float)n3 / 800.0f;
    }

    private void drawCircle(Graphics2D graphics2D, double d, double d2, int n) {
        Arc2D.Double double_ = new Arc2D.Double(d - (double)(3.5f * this.d_size), d2 - (double)(3.5f * this.d_size), 7.0f * this.d_size, 7.0f * this.d_size, 0.0, 360.0, 0);
        if (n == 0) {
            graphics2D.draw(double_);
        } else {
            graphics2D.fill(double_);
        }
    }

    private static class Tri {
        public int p1;
        public int p2;
        public int p3;

        public Tri(int n, int n2, int n3) {
            this.p1 = n;
            this.p2 = n2;
            this.p3 = n3;
        }
    }

    private static class Edge {
        public int p1;
        public int p2;

        public Edge(int n, int n2) {
            this.p1 = n;
            this.p2 = n2;
        }
    }
}

