/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.delaunay;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.vecmath.Point2d;
import org.junit.Assert;
import org.junit.Test;

public class GeomTests {
    static double epsilon;
    static double splitter;
    static double ccwerrboundA;
    static double iccerrboundA;

    public static void main(String[] stringArray) {
        System.out.println("GeomTests...");
        GeomTests.init();
        System.out.println(Math.ulp(1.0));
        System.out.println(epsilon);
        System.out.println(ccwerrboundA);
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d point2d2 = new Point2d(3.0, 2.0);
        Point2d point2d3 = new Point2d(2.0, 4.0);
        Point2d point2d4 = new Point2d(5.0, 1.0);
        Point2d point2d5 = new Point2d(6.0, 4.0);
        Point2d point2d6 = new Point2d(0.3333333333333333, 0.2222222222222222);
        Point2d point2d7 = new Point2d(0.333333, 0.222222);
        Point2d point2d8 = new Point2d(0.333333, 0.222222);
        Point2d point2d9 = new Point2d(1.0, 2.0);
        Point2d point2d10 = new Point2d(5.0, 2.0);
        System.out.println(GeomTests.orient2d(point2d, point2d2, point2d3));
        System.out.println(GeomTests.orient2d(point2d, point2d2, point2d4));
        System.out.println(GeomTests.orient2d(point2d, point2d2, point2d5));
        System.out.println(GeomTests.orient2d(point2d, point2d2, point2d6));
        System.out.println(GeomTests.orient2d(point2d, point2d2, point2d7));
        System.out.println(GeomTests.orient2d(point2d, point2d2, point2d8));
        System.out.println(GeomTests.orient2d(point2d9, point2d2, point2d10));
        System.out.println(GeomTests.orient2dbig(point2d, point2d2, point2d3));
        System.out.println(GeomTests.orient2dbig(point2d, point2d2, point2d4));
        System.out.println(GeomTests.orient2dbig(point2d, point2d2, point2d5));
        System.out.println(GeomTests.orient2dbig(point2d, point2d2, point2d6));
        System.out.println(GeomTests.orient2dbig(point2d, point2d2, point2d7));
        System.out.println(GeomTests.orient2dbig(point2d, point2d2, point2d8));
    }

    @Test
    public void testInCircle() {
        System.out.println("\nInCircle Test...");
        Point2d point2d = new Point2d(0.0, 0.0);
        Point2d point2d2 = new Point2d(3.0, 0.0);
        Point2d point2d3 = new Point2d(1.5, 1.5);
        Point2d point2d4 = new Point2d(2.0, 0.0);
        Point2d point2d5 = new Point2d(3.0, 3.0);
        Point2d point2d6 = new Point2d(1.5, -1.5);
        Point2d point2d7 = new Point2d(1.5 + 1.5 * Math.cos(0.5235987755982988), 0.75);
        System.out.println(GeomTests.inCircle(point2d, point2d2, point2d3, point2d4));
        System.out.println(GeomTests.inCircle(point2d, point2d2, point2d3, point2d5));
        System.out.println(GeomTests.inCircle(point2d, point2d2, point2d3, point2d6));
        System.out.println(GeomTests.inCircle(point2d, point2d2, point2d3, point2d7));
        System.out.println(GeomTests.inCircleExact(point2d, point2d2, point2d3, point2d4));
        System.out.println(GeomTests.inCircleExact(point2d, point2d2, point2d3, point2d5));
        System.out.println(GeomTests.inCircleExact(point2d, point2d2, point2d3, point2d6));
        System.out.println(GeomTests.inCircleExact(point2d, point2d2, point2d3, point2d7));
        Assert.assertTrue((GeomTests.inCircle(point2d, point2d2, point2d3, point2d4) > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((GeomTests.inCircle(point2d, point2d2, point2d3, point2d5) < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((GeomTests.inCircle(point2d, point2d2, point2d3, point2d6) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((GeomTests.inCircle(point2d, point2d2, point2d3, point2d7) < 0.0 ? 1 : 0) != 0);
        point2d = new Point2d(1.0, 0.0);
        point2d2 = new Point2d(0.0, 1.0);
        point2d3 = new Point2d(-1.0, 0.0);
        point2d4 = new Point2d(0.0, 0.0);
        point2d5 = new Point2d(1.0, 1.0);
        point2d6 = new Point2d(0.0, -1.0);
        System.out.println(GeomTests.inCircle(point2d, point2d2, point2d3, point2d4));
        System.out.println(GeomTests.inCircle(point2d, point2d2, point2d3, point2d5));
        System.out.println(GeomTests.inCircle(point2d, point2d2, point2d3, point2d6));
        System.out.println(GeomTests.inCircle(point2d, point2d2, point2d3, point2d7));
        System.out.println(GeomTests.inCircleExact(point2d, point2d2, point2d3, point2d4));
        System.out.println(GeomTests.inCircleExact(point2d, point2d2, point2d3, point2d5));
        System.out.println(GeomTests.inCircleExact(point2d, point2d2, point2d3, point2d6));
        System.out.println(GeomTests.inCircleExact(point2d, point2d2, point2d3, point2d7));
    }

    @Test
    public void testOrient2dError() {
        Point2d point2d = new Point2d(6.9, 15.6999999999999);
        Point2d point2d2 = new Point2d(6.7, 15.5);
        Point2d point2d3 = new Point2d(6.8, 15.6);
        double d = GeomTests.orient2d(point2d, point2d2, point2d3);
        System.out.println(d);
        d = GeomTests.orient2dbigDiag(point2d.x, point2d.y, point2d2.x, point2d2.y, point2d3.x, point2d3.y);
        System.out.println(d);
        Point2d point2d4 = new Point2d(6.7, 15.5);
        point2d4.sub(point2d);
        for (int i = 0; i < 10000; ++i) {
            double d2 = Math.random();
            double d3 = point2d.x + point2d4.x * d2;
            double d4 = point2d.y + point2d4.y * d2;
            d = GeomTests.orient2d(point2d.x, point2d.y, point2d2.x, point2d2.y, d3, d4);
        }
    }

    public static void init() {
        double d;
        boolean bl = true;
        double d2 = 0.5;
        epsilon = 1.0;
        splitter = 1.0;
        double d3 = 1.0;
        do {
            d = d3;
            epsilon *= d2;
            if (bl) {
                splitter *= 2.0;
            }
            bl = !bl;
        } while ((d3 = 1.0 + epsilon) != 1.0 && d3 != d);
        splitter += 1.0;
        ccwerrboundA = 1.0E-8;
        iccerrboundA = 1.0E-8;
    }

    public static double orient2d(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return GeomTests.orient2d(point2d.x, point2d.y, point2d2.x, point2d2.y, point2d3.x, point2d3.y);
    }

    public static double orient2d(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = d - d5;
        double d9 = d2 - d6;
        double d10 = d3 - d5;
        double d11 = d4 - d6;
        double d12 = d8 * d11;
        double d13 = d9 * d10;
        double d14 = d12 - d13;
        if (d12 > 0.0) {
            if (d13 <= 0.0) {
                return d14;
            }
            d7 = d12 + d13;
        } else if (d12 < 0.0) {
            if (d13 >= 0.0) {
                return d14;
            }
            d7 = -d12 - d13;
        } else {
            return d14;
        }
        double d15 = ccwerrboundA * d7;
        if (d14 >= d15 || -d14 >= d15) {
            return d14;
        }
        return GeomTests.orient2dbig(d, d2, d3, d4, d5, d6);
    }

    public static double orient2dbig(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return GeomTests.orient2dbig(point2d.x, point2d.y, point2d2.x, point2d2.y, point2d3.x, point2d3.y);
    }

    public static double orient2dbig(double d, double d2, double d3, double d4, double d5, double d6) {
        MathContext mathContext = MathContext.UNLIMITED;
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d2);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(d3);
        BigDecimal bigDecimal4 = BigDecimal.valueOf(d4);
        BigDecimal bigDecimal5 = BigDecimal.valueOf(d5);
        BigDecimal bigDecimal6 = BigDecimal.valueOf(d6);
        BigDecimal bigDecimal7 = bigDecimal.subtract(bigDecimal5, mathContext);
        BigDecimal bigDecimal8 = bigDecimal2.subtract(bigDecimal6, mathContext);
        BigDecimal bigDecimal9 = bigDecimal3.subtract(bigDecimal5, mathContext);
        BigDecimal bigDecimal10 = bigDecimal4.subtract(bigDecimal6, mathContext);
        BigDecimal bigDecimal11 = bigDecimal7.multiply(bigDecimal10, mathContext);
        BigDecimal bigDecimal12 = bigDecimal8.multiply(bigDecimal9, mathContext);
        BigDecimal bigDecimal13 = bigDecimal11.subtract(bigDecimal12, mathContext);
        return bigDecimal13.doubleValue();
    }

    public static double orient2dbigDiag(double d, double d2, double d3, double d4, double d5, double d6) {
        MathContext mathContext = MathContext.UNLIMITED;
        BigDecimal bigDecimal = BigDecimal.valueOf(d);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(d2);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(d3);
        BigDecimal bigDecimal4 = BigDecimal.valueOf(d4);
        BigDecimal bigDecimal5 = BigDecimal.valueOf(d5);
        BigDecimal bigDecimal6 = BigDecimal.valueOf(d6);
        BigDecimal bigDecimal7 = bigDecimal.subtract(bigDecimal5, mathContext);
        BigDecimal bigDecimal8 = bigDecimal2.subtract(bigDecimal6, mathContext);
        BigDecimal bigDecimal9 = bigDecimal3.subtract(bigDecimal5, mathContext);
        BigDecimal bigDecimal10 = bigDecimal4.subtract(bigDecimal6, mathContext);
        BigDecimal bigDecimal11 = bigDecimal7.multiply(bigDecimal10, mathContext);
        BigDecimal bigDecimal12 = bigDecimal8.multiply(bigDecimal9, mathContext);
        double d7 = d - d5;
        double d8 = d2 - d6;
        double d9 = d3 - d5;
        double d10 = d4 - d6;
        System.out.println(" acx: " + d7);
        System.out.println("    : " + bigDecimal7);
        System.out.println(" bcy: " + d10);
        System.out.println("    : " + bigDecimal10);
        System.out.println(" acy: " + d8);
        System.out.println("    : " + bigDecimal8);
        System.out.println(" bcx: " + d9);
        System.out.println("    : " + bigDecimal9);
        System.out.println("  exact left: " + bigDecimal11);
        System.out.println("  exact right: " + bigDecimal12);
        BigDecimal bigDecimal13 = bigDecimal11.subtract(bigDecimal12, mathContext);
        return bigDecimal13.doubleValue();
    }

    public static double inCircle(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4) {
        double d = point2d.x - point2d4.x;
        double d2 = point2d.y - point2d4.y;
        double d3 = d * d + d2 * d2;
        double d4 = point2d2.x - point2d4.x;
        double d5 = point2d3.y - point2d4.y;
        double d6 = d4 * d5;
        double d7 = point2d3.x - point2d4.x;
        double d8 = point2d2.y - point2d4.y;
        double d9 = d7 * d8;
        double d10 = d6 - d9;
        double d11 = d4 * d4 + d8 * d8;
        double d12 = d * d5;
        double d13 = d7 * d2;
        double d14 = d12 - d13;
        double d15 = d7 * d7 + d5 * d5;
        double d16 = d * d8;
        double d17 = d4 * d2;
        double d18 = d16 - d17;
        double d19 = d3 * d10 - d11 * d14 + d15 * d18;
        double d20 = (Math.abs(d6) + Math.abs(d9)) * d3 + (Math.abs(d12) + Math.abs(d13)) * d11 + (Math.abs(d16) + Math.abs(d17)) * d15;
        double d21 = iccerrboundA * d20;
        if (d19 > d21 || -d19 > d21) {
            return d19;
        }
        return GeomTests.inCircleExact(point2d, point2d2, point2d3, point2d4);
    }

    public static double inCircleExact(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4) {
        BigDecimal bigDecimal = BigDecimal.valueOf(point2d.x);
        BigDecimal bigDecimal2 = BigDecimal.valueOf(point2d.y);
        BigDecimal bigDecimal3 = BigDecimal.valueOf(point2d2.x);
        BigDecimal bigDecimal4 = BigDecimal.valueOf(point2d2.y);
        BigDecimal bigDecimal5 = BigDecimal.valueOf(point2d3.x);
        BigDecimal bigDecimal6 = BigDecimal.valueOf(point2d3.y);
        BigDecimal bigDecimal7 = BigDecimal.valueOf(point2d4.x);
        BigDecimal bigDecimal8 = BigDecimal.valueOf(point2d4.y);
        BigDecimal bigDecimal9 = bigDecimal.subtract(bigDecimal7);
        BigDecimal bigDecimal10 = bigDecimal3.subtract(bigDecimal7);
        BigDecimal bigDecimal11 = bigDecimal5.subtract(bigDecimal7);
        BigDecimal bigDecimal12 = bigDecimal2.subtract(bigDecimal8);
        BigDecimal bigDecimal13 = bigDecimal4.subtract(bigDecimal8);
        BigDecimal bigDecimal14 = bigDecimal6.subtract(bigDecimal8);
        BigDecimal bigDecimal15 = bigDecimal9.multiply(bigDecimal9).add(bigDecimal12.multiply(bigDecimal12));
        BigDecimal bigDecimal16 = bigDecimal10.multiply(bigDecimal10).add(bigDecimal13.multiply(bigDecimal13));
        BigDecimal bigDecimal17 = bigDecimal11.multiply(bigDecimal11).add(bigDecimal14.multiply(bigDecimal14));
        BigDecimal bigDecimal18 = bigDecimal10.multiply(bigDecimal14).subtract(bigDecimal11.multiply(bigDecimal13));
        BigDecimal bigDecimal19 = bigDecimal9.multiply(bigDecimal14).subtract(bigDecimal11.multiply(bigDecimal12));
        BigDecimal bigDecimal20 = bigDecimal9.multiply(bigDecimal13).subtract(bigDecimal10.multiply(bigDecimal12));
        BigDecimal bigDecimal21 = bigDecimal15.multiply(bigDecimal18);
        bigDecimal21 = bigDecimal21.subtract(bigDecimal16.multiply(bigDecimal19));
        bigDecimal21 = bigDecimal21.add(bigDecimal17.multiply(bigDecimal20));
        return bigDecimal21.doubleValue();
    }

    static {
        GeomTests.init();
    }
}

