/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.delaunay;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.vecmath.Point2d;
import org.junit.Assert;
import org.junit.Test;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.GeomTests;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.delaunay.TriangulatorInfo;

public class DnyUtil {
    public static FindResult findTriangle(TriangulatorInfo triangulatorInfo, Point2d point2d) {
        return DnyUtil.findTriangle(Arrays.asList(triangulatorInfo.points), triangulatorInfo.triangles, triangulatorInfo.adjTris, point2d);
    }

    public static FindResult findTriangle(TriangulatorInfo triangulatorInfo, Point2d point2d, int n) {
        return DnyUtil.findTriangle(Arrays.asList(triangulatorInfo.points), triangulatorInfo.triangles, triangulatorInfo.adjTris, point2d, n);
    }

    public static FindResult findTriangle(List<? extends Point2d> list, int[] nArray, int[] nArray2, Point2d point2d) {
        return DnyUtil.findTriangle(list, nArray, nArray2, point2d, -1);
    }

    public static FindResult findTriangle(List<? extends Point2d> list, int[] nArray, int[] nArray2, Point2d point2d, int n) {
        Handle handle;
        if (nArray.length == 0) {
            return null;
        }
        int n2 = nArray.length / 3;
        if (n < 0) {
            int n3 = 0;
            while (n3 * n3 * n3 < n2) {
                ++n3;
            }
            double d = Double.MAX_VALUE;
            int n4 = 0;
            Random random = new Random(0L);
            for (int i = 0; i < n3; ++i) {
                int n5 = (int)(random.nextDouble() * (double)n2) * 3;
                Point2d point2d2 = list.get(nArray[n5 + 0]);
                double d2 = point2d2.distanceSquared(point2d);
                if (!(d2 < d)) continue;
                d = d2;
                n4 = n5;
            }
            n = n4;
            if (list.get(nArray[n + 0]).equals(point2d) || list.get(nArray[n + 1]).equals(point2d)) {
                return new FindResult(n / 3, FindClass.ONVERT);
            }
        } else {
            n *= 3;
        }
        if (GeomTests.orient2d(list.get((handle = new Handle(nArray, nArray2, n, 0)).getA()), list.get(handle.getB()), point2d) < 0.0) {
            int n6 = handle.getNeighborA();
            handle.moveToNeighbor(n6);
        }
        while (handle.tri >= 0) {
            Point2d point2d3 = list.get(handle.getA());
            Point2d point2d4 = list.get(handle.getB());
            Point2d point2d5 = list.get(handle.getC());
            if (point2d5.equals(point2d)) {
                return new FindResult(handle.tri / 3, FindClass.ONVERT);
            }
            double d = GeomTests.orient2d(point2d5, point2d4, point2d);
            double d3 = GeomTests.orient2d(point2d3, point2d5, point2d);
            boolean bl = false;
            if (d > 0.0) {
                if (d3 > 0.0) {
                    double d4 = (point2d5.x - point2d.x) * (point2d4.x - point2d3.x) + (point2d5.y - point2d.y) * (point2d4.y - point2d3.y);
                    if (d4 > 0.0) {
                        bl = true;
                    }
                } else {
                    bl = false;
                }
            } else if (d3 > 0.0) {
                bl = true;
            } else {
                FindClass findClass = d == 0.0 || d3 == 0.0 ? FindClass.ONEDGE : FindClass.INSIDE;
                return new FindResult(handle.tri / 3, findClass);
            }
            if (bl) {
                handle.moveToNeighbor(handle.getNeighborC());
                continue;
            }
            handle.moveToNeighbor(handle.getNeighborB());
        }
        return null;
    }

    public static boolean contains(Point2d[] point2dArray, int[] nArray, int n, Point2d point2d) {
        Point2d point2d2 = point2dArray[nArray[(n *= 3) + 0]];
        Point2d point2d3 = point2dArray[nArray[n + 1]];
        Point2d point2d4 = point2dArray[nArray[n + 2]];
        return DnyUtil.contains(point2d2, point2d3, point2d4, point2d);
    }

    public static boolean contains(Point2d point2d, Point2d point2d2, Point2d point2d3, Point2d point2d4) {
        return GeomTests.orient2d(point2d, point2d2, point2d4) >= 0.0 && GeomTests.orient2d(point2d2, point2d3, point2d4) >= 0.0 && GeomTests.orient2d(point2d3, point2d, point2d4) >= 0.0;
    }

    private static TriangulatorInfo testTriangulate(double ... dArray) {
        Mesh mesh = new Mesh();
        int n = 0;
        while (n < dArray.length) {
            double d = dArray[n++];
            double d2 = dArray[n++];
            mesh.addPoint(d, d2);
        }
        if (!mesh.triangulateConvexHull(0)) {
            return null;
        }
        return mesh.getOutput(1);
    }

    @Test
    public void testFind1() {
        TriangulatorInfo triangulatorInfo = DnyUtil.testTriangulate(0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        Assert.assertNotNull((Object)triangulatorInfo);
        Point2d point2d = new Point2d(0.6, 0.6);
        FindResult findResult = DnyUtil.findTriangle(triangulatorInfo, point2d);
        Assert.assertNotNull((Object)findResult);
        Assert.assertSame((Object)0, (Object)findResult.tri);
        Assert.assertTrue((boolean)DnyUtil.contains(triangulatorInfo.points, triangulatorInfo.triangles, findResult.tri, point2d));
        findResult = DnyUtil.findTriangle(triangulatorInfo, new Point2d(0.4, 0.5));
        Assert.assertNull((Object)findResult);
    }

    @Test
    public void testFind2() {
        TriangulatorInfo triangulatorInfo = DnyUtil.testTriangulate(0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.5, 0.5);
        Assert.assertNotNull((Object)triangulatorInfo);
        Point2d point2d = new Point2d(0.6, 0.6);
        FindResult findResult = DnyUtil.findTriangle(triangulatorInfo, point2d);
        Assert.assertNotNull((Object)findResult);
        Assert.assertTrue((boolean)DnyUtil.contains(triangulatorInfo.points, triangulatorInfo.triangles, findResult.tri, point2d));
        findResult = DnyUtil.findTriangle(triangulatorInfo, new Point2d(0.4, 0.5));
        Assert.assertNull((Object)findResult);
    }

    @Test
    public void testFind3() {
        double d = 1.0;
        double d2 = 150.0;
        double d3 = -29.0;
        double d4 = 34.0;
        double d5 = d2 - d;
        double d6 = d4 - d3;
        Mesh mesh = new Mesh();
        mesh.addPoint(d, d3);
        mesh.addPoint(d2, d3);
        mesh.addPoint(d2, d4);
        mesh.addPoint(d, d4);
        mesh.addEdge(0, 1);
        mesh.addEdge(1, 2);
        mesh.addEdge(2, 3);
        mesh.addEdge(3, 0);
        mesh.setMaxArea(d5 * d6 / 30.0);
        boolean bl = mesh.triangulateConvexHull(1, 30.0);
        Assert.assertTrue((boolean)bl);
        TriangulatorInfo triangulatorInfo = mesh.getOutput(1);
        Random random = new Random(0L);
        int n = 100;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Point2d point2d = new Point2d(DnyUtil.generateCoord(random, d, d5), DnyUtil.generateCoord(random, d3, d6));
            FindResult findResult = DnyUtil.findTriangle(triangulatorInfo, point2d, n2);
            Assert.assertNotNull((Object)findResult);
            boolean bl2 = DnyUtil.contains(triangulatorInfo.points, triangulatorInfo.triangles, findResult.tri, point2d);
            Assert.assertTrue((boolean)bl2);
            n2 = findResult.tri;
        }
        Assert.assertNull((Object)DnyUtil.findTriangle(triangulatorInfo, new Point2d(-30.0, 40.0), n2));
        Assert.assertNull((Object)DnyUtil.findTriangle(triangulatorInfo, new Point2d(200.0, 0.0)));
    }

    private static double generateCoord(Random random, double d, double d2) {
        double d3 = random.nextDouble();
        return d + d2 * d3;
    }

    public static class Handle {
        private static final int[] plus1mod3 = new int[]{1, 2, 0};
        private static final int[] plus2mod3 = new int[]{2, 0, 1};
        public final int[] tris;
        public final int[] adj;
        public int tri;
        public int orient;

        public Handle(int[] nArray, int[] nArray2, int n, int n2) {
            this.tris = nArray;
            this.adj = nArray2;
            this.tri = n;
            this.orient = n2;
        }

        public int getA() {
            return this.tris[this.tri + this.orient];
        }

        public int getB() {
            return this.tris[this.tri + plus1mod3[this.orient]];
        }

        public int getC() {
            return this.tris[this.tri + plus2mod3[this.orient]];
        }

        public int getNeighborA() {
            return this.adj[this.tri + this.orient] * 3;
        }

        public int getNeighborB() {
            return this.adj[this.tri + plus1mod3[this.orient]] * 3;
        }

        public int getNeighborC() {
            return this.adj[this.tri + plus2mod3[this.orient]] * 3;
        }

        public void moveToNeighbor(int n) {
            int n2 = 0;
            if (n >= 0) {
                for (int i = 1; i < 3; ++i) {
                    if (this.adj[n + i] * 3 != this.tri) continue;
                    n2 = i;
                    break;
                }
            }
            this.tri = n;
            this.orient = n2;
        }
    }

    public static class FindResult {
        public final int tri;
        public final FindClass where;

        public FindResult(int n, FindClass findClass) {
            this.tri = n;
            this.where = findClass;
        }
    }

    public static enum FindClass {
        INSIDE,
        ONVERT,
        ONEDGE;

    }
}

