/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng;

import java.io.IOException;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeneralPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NGon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.ListSet;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.theHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.theHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.theLinkedHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v1.util.theLinkedHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v4.geometry.objs.Mesh;
import pyrosim.legacy_2012_1.thunderheadeng.legacy.v5.geometry.objs.WallGeom;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class TeciIO {
    public static final int VERSION_001 = 1;
    public static final int VERSION_002 = 2;
    public static final int VERSION_003 = 3;
    public static final int VERSION_004 = 4;
    public static final int VERSION_005 = 5;
    public static final int VERSION_006 = 6;
    public static final int VERSION_007 = 7;
    public static final int CURR_VERSION = 7;
    private final int d_version;

    public TeciIO(int n) {
        this.d_version = n;
    }

    public Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (this.d_version < 2) {
            if (string.equals("thunderheadeng.util.LinkedIdentityHashMap")) {
                return LinkedIdentityHashMap.class;
            }
            if (string.equals("thunderheadeng.util.LinkedIdentityHashSet")) {
                return LinkedIdentityHashSet.class;
            }
            if (string.equals("thunderheadeng.util.ListSet")) {
                return ListSet.class;
            }
            if (string.equals("thunderheadeng.util.theHashMap")) {
                return theHashMap.class;
            }
            if (string.equals("thunderheadeng.util.theHashSet")) {
                return theHashSet.class;
            }
            if (string.equals("thunderheadeng.util.theLinkedHashMap")) {
                return theLinkedHashMap.class;
            }
            if (string.equals("thunderheadeng.util.theLinkedHashSet")) {
                return theLinkedHashSet.class;
            }
        }
        if (this.d_version < 3 && string.equals("thunderheadeng.scene3d.nativebuffered.Image")) {
            return Image.class;
        }
        if (this.d_version < 5 && string.equals("thunderheadeng.geometry.objs.Mesh")) {
            return Mesh.class;
        }
        if (this.d_version < 6 && string.equals("thunderheadeng.geometry.objs.WallGeom")) {
            return WallGeom.class;
        }
        if (string.startsWith("thunderheadeng.") || string.startsWith("[Lthunderheadeng.")) {
            String string2 = string;
            string2 = string2.replaceFirst("thunderheadeng.", "pyrosim.legacy_2012_1.thunderheadeng.");
            return Class.forName(string2);
        }
        return null;
    }

    public Object resolveObject(Object object) {
        if (this.d_version < 2) {
            if (object instanceof LinkedIdentityHashMap) {
                return ((LinkedIdentityHashMap)object).convert();
            }
            if (object instanceof theLinkedHashMap) {
                return ((theLinkedHashMap)object).convert();
            }
            if (object instanceof theHashMap) {
                return ((theHashMap)object).convert();
            }
            if (object instanceof LinkedIdentityHashSet) {
                return ((LinkedIdentityHashSet)object).convert();
            }
            if (object instanceof theLinkedHashSet) {
                return ((theLinkedHashSet)object).convert();
            }
            if (object instanceof theHashSet) {
                return ((theHashSet)object).convert();
            }
            if (object instanceof ListSet) {
                return ((ListSet)object).convert();
            }
        }
        if (this.d_version < 4 && object instanceof NGon) {
            return TeciIO.resolvePre4NGon((NGon)object);
        }
        if (this.d_version < 5 && object instanceof Mesh) {
            return ((Mesh)object).fromLegacy();
        }
        if (this.d_version < 6 && object instanceof WallGeom) {
            return ((WallGeom)object).fromLegacy();
        }
        if (this.d_version < 7 && object instanceof Quad) {
            Quad quad = (Quad)object;
            return PolyUtil.newPoly(quad.p1, quad.p2, quad.p3, quad.p4);
        }
        return object;
    }

    private static IPolygon resolvePre4NGon(NGon nGon) {
        Point3d[] point3dArray = nGon.points;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < point3dArray.length) {
            Point3d point3d;
            Point3d point3d2 = point3dArray[n];
            arrayList.add(n++);
            while (n < point3dArray.length && !point3d2.equals(point3d = point3dArray[n++])) {
            }
        }
        if (arrayList.size() <= 1) {
            return nGon;
        }
        return new GeneralPoly(point3dArray, theUtil.toIntArray(arrayList));
    }
}

