/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.legacy.v31.domain.geom;

import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.Util;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AbstractFDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.AbstractFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ExtrudedPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class Slab
extends AbstractFDSObject {
    static final long serialVersionUID = 1L;
    public static final int NUM_FACES = 5;
    private static final String[] FDS_FACE_NAMES = new String[]{Intl.intl("Min X"), Intl.intl("Max X"), Intl.intl("Min Y"), Intl.intl("Max Y"), Intl.intl("Min Z"), Intl.intl("Max Z")};
    private static final int FACE_POINTS = 0;
    private static final int FACE_POINTS_EXTRUDED = 1;
    private static final int FACE_P1_P2 = 2;
    private static final int FACE_P2_P3 = 3;
    private static final int FACE_P3_P1 = 4;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = false;
    private UnitDouble d_thickness;
    private UnitPoint3D d_pt1;
    private UnitPoint3D d_pt2;
    private UnitPoint3D d_pt3;

    @Override
    public IPyroObject convert() {
        Point3d[] point3dArray = Util.convertArray(Geometry.LU, this.d_pt1, this.d_pt2, this.d_pt3);
        Vector3d vector3d = Util3D.simplePolygonNormal(Arrays.asList(point3dArray));
        if (vector3d == null) {
            vector3d = new Vector3d(0.0, 0.0, 1.0);
        }
        vector3d.scale(-this.d_thickness.getValue(Geometry.LU));
        IPolygon iPolygon = PolyUtil.newPoly(point3dArray);
        ExtrudedPoly extrudedPoly = new ExtrudedPoly(iPolygon, vector3d);
        Surface[] surfaceArray = this.convertSurfs();
        Obstruction obstruction = new Obstruction(this.d_name, extrudedPoly, surfaceArray);
        this.convertProps(obstruction, Slab.convertOptions(this.d_permitHole, this.d_thicken, this.d_sawtooth));
        return obstruction;
    }

    public static class SlabFace
    extends AbstractFace {
        static final long serialVersionUID = 1L;
        public Slab d_slab;
        public int d_faceIndex;
    }
}

