/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.legacy.v31.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import java.util.Vector;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.EvacProps;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.legacy.v31.domain.geom.IFace;

public abstract class AbstractFDSObject
extends APyroObject
implements FDSObject {
    static final long serialVersionUID = 1L;
    protected String d_name;
    protected Vector<IFace> d_faces;
    protected Color d_color = null;
    protected boolean d_visible = true;
    protected IInPin d_controlPin;
    protected TexOrigin d_texOrigin;
    protected EvacProps d_evac;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_evac == null) {
            this.d_evac = EvacProps.DEFAULT;
        }
    }

    protected Surface[] convertSurfs() {
        Surface[] surfaceArray;
        Surface[] surfaceArray2 = new Surface[this.d_faces.size()];
        for (int i = 0; i < this.d_faces.size(); ++i) {
            surfaceArray2[i] = this.d_faces.get(i).getSurface();
        }
        if (GeomUtil.isUniform(surfaceArray2)) {
            Surface[] surfaceArray3 = new Surface[1];
            surfaceArray = surfaceArray3;
            surfaceArray3[0] = surfaceArray2[0];
        } else {
            surfaceArray = surfaceArray2;
        }
        return surfaceArray;
    }

    protected static int convertOptions(boolean bl, boolean bl2, boolean bl3) {
        int n = 0;
        if (bl) {
            n |= 4;
        }
        if (bl2) {
            n |= 1;
        }
        if (!bl3) {
            n |= 2;
        }
        return n;
    }

    protected void convertProps(pyrosim.legacy_2012_1.domain.geom.FDSObject fDSObject, int n) {
        Set<? extends IOutPin> set = this.d_controlPin.getConnections();
        if (!set.isEmpty()) {
            fDSObject.getInputPin().connect(set.iterator().next());
        }
        fDSObject.setEvac(this.d_evac);
        fDSObject.setColors(this.d_color);
        fDSObject.setVisible(this.d_visible);
        fDSObject.setEnabled(this.isEnabled());
        if (fDSObject instanceof IObstruction) {
            ((IObstruction)fDSObject).setOptions(n, true);
            ((IObstruction)fDSObject).setTextureOrigin(this.d_texOrigin);
        } else if (fDSObject instanceof Vent) {
            ((Vent)fDSObject).setTextureOrigin(this.d_texOrigin);
        }
    }

    @Override
    public IInPin getInputPin() {
        return this.d_controlPin;
    }
}

