/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.legacy.v26.domain.output;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.output.IMeasurementStat;
import pyrosim.legacy_2012_1.domain.output.StatGeom;
import pyrosim.legacy_2012_1.domain.output.StatisticMgr;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;

public abstract class AMeasurementStat
extends APyroObject {
    static final long serialVersionUID = 1L;
    protected IQuantity d_msr;
    protected Set<Grid> d_grids;
    protected Set<Integer> d_stats;

    protected abstract IMeasurementStat newStat(String var1, IQuantity var2, IGeom var3, Collection<Integer> var4);

    public IPyroObject convert() {
        ArrayList<IMeasurementStat> arrayList = new ArrayList<IMeasurementStat>(this.d_grids.size());
        boolean bl = this.d_grids.size() > 1;
        Collection<Integer> collection = AMeasurementStat.convertPre27Stats(this.d_stats);
        for (Grid grid : this.d_grids) {
            String string = this.d_msr.getDescription();
            if (bl) {
                string = string + "_" + grid.getName();
            }
            IMeasurementStat iMeasurementStat = this.newStat(string, this.d_msr, new StatGeom.GridGeom(grid), collection);
            arrayList.add(iMeasurementStat);
        }
        if (arrayList.size() == 1) {
            return (IPyroObject)arrayList.get(0);
        }
        StatisticMgr statisticMgr = new StatisticMgr(this.d_msr.getDescription());
        statisticMgr.addAll(arrayList);
        return statisticMgr;
    }

    private static Collection<Integer> convertPre27Stats(Set<Integer> set) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(set.size());
        for (Integer n : set) {
            switch (n) {
                case 0: {
                    arrayList.add(65536);
                    break;
                }
                case 1: {
                    arrayList.add(131072);
                    break;
                }
                case 2: {
                    arrayList.add(262144);
                }
            }
        }
        return arrayList;
    }
}

