/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.zones.Leak;
import pyrosim.legacy_2012_1.domain.zones.OuterZone;
import pyrosim.legacy_2012_1.domain.zones.Zone;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class ZoneParser
extends AFDS5Parser {
    private final Map<LeakKey, Pair<FDSParseRecord, UnitDouble>> d_leaks = new HashMap<LeakKey, Pair<FDSParseRecord, UnitDouble>>();
    private final List<Zone> d_zoneList = new ArrayList<Zone>();
    private static final String BASE_NAME = Intl.intl("ZONE");

    public Zone get(int n) {
        if (n < 0 || n >= this.d_zoneList.size()) {
            return null;
        }
        return this.d_zoneList.get(n);
    }

    public ZoneParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
        OuterZone outerZone = this.getContainer().getZoneMgr().getOuter();
        this.d_zoneList.add(outerZone);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("ZONE");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        UnitAABox unitAABox;
        Object object;
        String string = fDSParseRecord.getString("ID");
        if (fDSParseRecord.contains("XB")) {
            object = ZoneParser.parseXB(fDSParseRecord, "ZONE", "XB", true);
            unitAABox = new UnitAABox(object[0], object[1]);
        } else {
            object = new AABox();
            for (PyroMod pyroMod : this.getParsingInfo().getSourceContainers()) {
                for (Object object2 : pyroMod.getGridManager().flatten()) {
                    ((Grid)object2).getGeom().getBoundingBox((AABox)object);
                }
            }
            unitAABox = new UnitAABox((AABox)object, Geometry.GEOM_LENGTH_UNIT);
        }
        object = new Zone(string, unitAABox);
        List list = fDSParseRecord.getList("LEAK_AREA", false);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Pair<FDSParseRecord, UnitDouble> pair;
                Object object2;
                Object object3 = (UnitDouble)list.get(i);
                if (object3 == null || ((UnitDouble)object3).getValueNoUnit() == 0.0) continue;
                if (i == this.d_zoneList.size()) {
                    this.addWarning(fDSParseRecord, Intl.intl("Leak area specified with own ZONE."), Intl.intl("Ignoring leak area."));
                    continue;
                }
                if (((UnitDouble)object3).getValueNoUnit() < 0.0) {
                    this.addWarning(fDSParseRecord, Intl.intl("Negative leak area specified for ZONE record."), Intl.intl("Made leak area positive."));
                    object3 = ((UnitDouble)object3).abs();
                }
                if ((pair = this.d_leaks.get(object2 = new LeakKey(this.d_zoneList.size(), i))) != null) {
                    if (((UnitDouble)pair.v2).equals(object3)) continue;
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Leak area between ZONES %d and %d already specified with a different area."), i, this.d_zoneList.size()), Intl.intl("Ignoring second leak area definition."));
                    continue;
                }
                this.d_leaks.put((LeakKey)object2, new Pair<FDSParseRecord, Object>(fDSParseRecord, object3));
            }
        }
        this.d_zoneList.add((Zone)object);
        return true;
    }

    private void checkZoneIx(FDSParseRecord fDSParseRecord, int n) throws FDSRecordFormatException {
        if (n < 0 || n >= this.d_zoneList.size()) {
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Leak area specified for an invalid ZONE index: %d."), n));
        }
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        Object object;
        Object object2;
        for (Map.Entry<LeakKey, Pair<FDSParseRecord, UnitDouble>> entry : this.d_leaks.entrySet()) {
            object2 = entry.getKey();
            Pair<FDSParseRecord, UnitDouble> pair = entry.getValue();
            this.checkZoneIx((FDSParseRecord)pair.v1, ((LeakKey)object2).ix1);
            this.checkZoneIx((FDSParseRecord)pair.v1, ((LeakKey)object2).ix2);
        }
        int n = this.d_zoneList.size() - 1;
        int n2 = Integer.toString(n).length();
        object2 = this.getContainer().getZoneMgr();
        for (int i = 1; i < this.d_zoneList.size(); ++i) {
            Zone object3 = this.d_zoneList.get(i);
            if (object3.getName() == null) {
                object = String.format("%0" + n2 + "d", i);
                object3.setName(BASE_NAME + (String)object);
            }
            Util.autoRename(object2, object3);
            ((Composite)object2).add(object3);
            this.flagObjectAdded(object3);
        }
        for (Map.Entry<LeakKey, Pair<FDSParseRecord, UnitDouble>> entry : this.d_leaks.entrySet()) {
            object = entry.getKey();
            Pair<FDSParseRecord, UnitDouble> pair = entry.getValue();
            Zone zone = this.d_zoneList.get(((LeakKey)object).ix1);
            Zone zone2 = this.d_zoneList.get(((LeakKey)object).ix2);
            Leak leak = new Leak(zone, zone2, (UnitDouble)pair.v2);
            this.getContainer().getZoneLeakMgr().add(leak);
            this.flagObjectAdded(leak);
        }
    }

    private static class LeakKey {
        private final int ix1;
        private final int ix2;

        public LeakKey(int n, int n2) {
            this.ix1 = n;
            this.ix2 = n2;
        }

        public int hashCode() {
            return this.ix1 + this.ix2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof LeakKey)) {
                return false;
            }
            LeakKey leakKey = (LeakKey)object;
            return this.ix1 == leakKey.ix1 && this.ix2 == leakKey.ix2 || this.ix1 == leakKey.ix2 && this.ix2 == leakKey.ix1;
        }
    }
}

