/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridMergeUtil;
import pyrosim.legacy_2012_1.domain.GridUtil;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.FireSpread;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.tasks.AddGridBoundaryVentsTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.IGeomSource;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSParseWarning;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.FDS5Const;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDSObjParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExSpecParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.PinConnParser;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.IResult;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class VentParser
extends AFDSObjParser {
    private final PinConnParser d_pinConns;
    private final ExSpecParser d_specParser;
    private Map<FDSParseRecord, Vent> d_ventMap;
    private Map<Grid, GridMergeUtil.BoundaryInfo> d_gridFaces;

    public VentParser(FDS5ParsingInfo fDS5ParsingInfo, PinConnParser pinConnParser, ExSpecParser exSpecParser) {
        super(fDS5ParsingInfo);
        this.d_pinConns = pinConnParser;
        this.d_specParser = exSpecParser;
        this.d_ventMap = new HashMap<FDSParseRecord, Vent>();
        this.d_gridFaces = null;
    }

    public Map<FDSParseRecord, Vent> getVentMap() {
        return this.d_ventMap;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("VENT");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("SURF_ID", false);
        Surface surface = this.getSurfaceSafe(fDSParseRecord, string, Vent.getSurfaceFilter());
        this.d_ventMap.put(fDSParseRecord, null);
        String string2 = (String)fDSParseRecord.get("ID");
        if (string2 == null) {
            string2 = this.generateName(fDSParseRecord, Intl.intl("Vent"));
        }
        if (fDSParseRecord.contains("XB")) {
            UnitPoint3D[] unitPoint3DArray = VentParser.parseXB(fDSParseRecord, "VENT", "XB", true);
            if (VentParser.countDimensions(unitPoint3DArray[0], unitPoint3DArray[1]) > 2) {
                throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Vents must be specified as two-dimensional objects."));
            }
            Vent vent = new Vent(string2, surface, AARectangle.construct(unitPoint3DArray[0].getPoint3dValue(Geometry.LU), unitPoint3DArray[1].getPoint3dValue(Geometry.LU)));
            if (fDSParseRecord.contains("IOR")) {
                vent.setNormal(pyrosim.legacy_2012_1.io.fds.v5.common.GeomUtil.toWorldVec(fDSParseRecord.getInteger("IOR", false)));
            }
            this.addVent(fDSParseRecord, vent);
            this.addObject(vent);
        } else if (fDSParseRecord.contains("PBX")) {
            double d = fDSParseRecord.getUnitDouble("PBX", false).getValue(Geometry.LU);
            Plane3d plane3d = new Plane3d(1.0, 0.0, 0.0, -d);
            this.addVentsAlongPlane(fDSParseRecord, string2, surface, plane3d);
        } else if (fDSParseRecord.contains("PBY")) {
            double d = fDSParseRecord.getUnitDouble("PBY", false).getValue(Geometry.LU);
            Plane3d plane3d = new Plane3d(0.0, 1.0, 0.0, -d);
            this.addVentsAlongPlane(fDSParseRecord, string2, surface, plane3d);
        } else if (fDSParseRecord.contains("PBZ")) {
            double d = fDSParseRecord.getUnitDouble("PBZ", false).getValue(Geometry.LU);
            Plane3d plane3d = new Plane3d(0.0, 0.0, 1.0, -d);
            this.addVentsAlongPlane(fDSParseRecord, string2, surface, plane3d);
        } else {
            if (fDSParseRecord.contains("MB")) {
                FDS5Const.VentMB ventMB = VentParser.getMB(fDSParseRecord);
                return this.addVentsForGridFace(fDSParseRecord, surface, ventMB);
            }
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Vents must have geometry specified."));
        }
        return true;
    }

    private void addVent(FDSParseRecord fDSParseRecord, Vent vent) throws FDSRecordFormatException {
        AABox aABox = vent.getGeom().getBoundingBox(new AABox());
        TexOrigin texOrigin = VentParser.parseTexLoc(fDSParseRecord, aABox.getMin(), "VENT", "TEXTURE_ORIGIN");
        vent.setTextureOrigin(texOrigin);
        FireSpread fireSpread = this.parseFireSpread(fDSParseRecord, vent.getSurface(), aABox);
        vent.setFireSpread(fireSpread);
        Color color = this.parseColor(fDSParseRecord, "RGB", "COLOR", "TRANSPARENCY", false);
        this.applyColor(vent, color);
        VentParser.markSingleInputForRetrieval(fDSParseRecord, vent, this.d_pinConns, "DEVC_ID", "CTRL_ID");
        vent.setOptions(1, fDSParseRecord.getBoolean("OUTLINE", true));
        vent.setEvac(this.parseEvac(fDSParseRecord, "EVACUATION", "MESH_ID"));
        Vent.OpenProps openProps = this.parseOpenProps(fDSParseRecord);
        if (openProps != null) {
            if (vent.getSurface().getName().equals(PredefSurf.OPEN.name())) {
                vent.setOpenProps(openProps);
            } else {
                this.addWarning(fDSParseRecord, Intl.intl("OPEN vent properties specified for a non-OPEN vent."), Intl.intl("Ignoring OPEN vent properties"));
            }
        }
        this.d_ventMap.put(fDSParseRecord, vent);
        this.flagObjectAdded(vent);
    }

    private Vent.OpenProps parseOpenProps(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Cloneable cloneable;
        Serializable serializable;
        if (!(fDSParseRecord.contains("TMP_EXTERIOR") || fDSParseRecord.contains("MASS_FRACTION") || fDSParseRecord.contains("PRESSURE_RAMP") || fDSParseRecord.contains("DYNAMIC_PRESSURE"))) {
            return null;
        }
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("TMP_EXTERIOR", true);
        List list = fDSParseRecord.getList("MASS_FRACTION", true);
        IdentityHashMap<ExSpec, UnitDouble> identityHashMap = new IdentityHashMap<ExSpec, UnitDouble>();
        for (int i = 0; i < list.size(); ++i) {
            serializable = (UnitDouble)list.get(i);
            if (serializable == null || serializable.getValueNoUnit() == 0.0) continue;
            cloneable = this.d_specParser.getSpec(i);
            if (cloneable == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find SPEC %d"), i + 1), String.format(Intl.intl("Ignoring MASS_FRACTION(%d)"), i + 1));
                continue;
            }
            identityHashMap.put((ExSpec)cloneable, (UnitDouble)serializable);
        }
        if (fDSParseRecord.contains("PRESSURE_RAMP") && !fDSParseRecord.contains("DYNAMIC_PRESSURE")) {
            this.addWarning(fDSParseRecord, Intl.intl("PRESSURE_RAMP specified without DYNAMIC_PRESSURE"), "");
        }
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("DYNAMIC_PRESSURE", true);
        serializable = this.parseTimeFunction(fDSParseRecord, (String)null, "PRESSURE_RAMP");
        cloneable = new TimeBasedValue<UnitDouble>(unitDouble2, (TimeFunction)serializable);
        return new Vent.OpenProps(unitDouble, (TimeBasedValue<UnitDouble>)cloneable, identityHashMap);
    }

    private FireSpread parseFireSpread(FDSParseRecord fDSParseRecord, Surface surface, AABox aABox) throws FDSRecordFormatException {
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("SPREAD_RATE");
        if (unitDouble != null && unitDouble.getValueNoUnit() > 0.0) {
            if (!Vent.isValidFireSpreadSurf(surface)) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a valid surface for spreading a fire on a vent."), surface.getName()), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            UnitPoint3D unitPoint3D = VentParser.parseLoc(fDSParseRecord, Intl.intl("Vent"), "XYZ", false, false);
            if (unitPoint3D == null) {
                this.addWarning(fDSParseRecord, Intl.intl("Vent with a fire spread rate did not specify a spread origin."), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            UnitPoint3D unitPoint3D2 = new UnitPoint3D(aABox.getMin(), Geometry.LU);
            UnitPoint3D unitPoint3D3 = new UnitPoint3D(aABox.getMax(), Geometry.LU);
            if (unitPoint3D2.xu().compareTo(unitPoint3D.xu()) > 0 || unitPoint3D3.xu().compareTo(unitPoint3D.xu()) < 0 || unitPoint3D2.yu().compareTo(unitPoint3D.yu()) > 0 || unitPoint3D3.yu().compareTo(unitPoint3D.yu()) < 0 || unitPoint3D2.zu().compareTo(unitPoint3D.zu()) > 0 || unitPoint3D3.zu().compareTo(unitPoint3D.zu()) < 0) {
                this.addWarning(fDSParseRecord, Intl.intl("The fire spread origin must lie on the vent."), Intl.intl("Ignoring fire spread on vent."));
                return null;
            }
            return new FireSpread(unitPoint3D, unitDouble);
        }
        return null;
    }

    private boolean addVentsForGridFace(FDSParseRecord fDSParseRecord, Surface surface, FDS5Const.VentMB ventMB) throws FDSRecordFormatException {
        Map<Grid, GridMergeUtil.BoundaryInfo> map = this.getGridFaces();
        if (map.isEmpty()) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to match vent to mesh boundaries."), Intl.intl("Adding vent to Additional Records"));
            return false;
        }
        GridUtil.GridFace gridFace = null;
        switch (ventMB) {
            case XMIN: {
                gridFace = GridUtil.GridFace.XMIN;
                break;
            }
            case XMAX: {
                gridFace = GridUtil.GridFace.XMAX;
                break;
            }
            case YMIN: {
                gridFace = GridUtil.GridFace.YMIN;
                break;
            }
            case YMAX: {
                gridFace = GridUtil.GridFace.YMAX;
                break;
            }
            case ZMIN: {
                gridFace = GridUtil.GridFace.ZMIN;
                break;
            }
            case ZMAX: {
                gridFace = GridUtil.GridFace.ZMAX;
            }
        }
        List<Pair<Grid, List<Vent>>> list = GridUtil.constructVents(this.getContainer().getGridManager().flatten(), map, surface, gridFace);
        for (Pair<Grid, List<Vent>> pair : list) {
            for (Vent vent : (List)pair.v2) {
                this.addVent(fDSParseRecord, vent);
            }
        }
        new AddGridBoundaryVentsTask(this.getContainer(), list).run();
        return true;
    }

    private void addVentsAlongPlane(FDSParseRecord fDSParseRecord, String string, Surface surface, final Plane3d plane3d) throws FDSRecordFormatException {
        Object object;
        final ArrayList<AARectangle> arrayList2 = new ArrayList<AARectangle>();
        Map<Grid, GridMergeUtil.BoundaryInfo> map = this.getGridFaces();
        for (Map.Entry<Grid, GridMergeUtil.BoundaryInfo> object22 : map.entrySet()) {
            for (Face face : object22.getValue().faces) {
                AARectangle aARectangle;
                if (!VentParser.equal(face.plane, plane3d, 1.0E-9) || (aARectangle = AARectangle.construct(((AABox)(object = face.getBounds())).getMin(), ((AABox)object).getMax())) == null) continue;
                arrayList2.add(aARectangle);
            }
        }
        ITest<AABox> iTest = new ITest<AABox>(){

            @Override
            public Containment test(AABox aABox) {
                int n = 0;
                int n2 = 0;
                for (Point3d point3d : aABox.getVerts()) {
                    double d = plane3d.dot(point3d);
                    if (theUtil.eq0(d, 1.0E-9)) {
                        return Containment.INTERSECTS;
                    }
                    if (theUtil.gt0(d, 1.0E-9)) {
                        ++n;
                    } else {
                        ++n2;
                    }
                    if (n <= 0 || n2 <= 0) continue;
                    return Containment.INTERSECTS;
                }
                return Containment.OUTSIDE;
            }
        };
        IResult<IGeomSource> iResult = new IResult<IGeomSource>(){

            @Override
            public void mark(IGeomSource iGeomSource, Containment containment) {
                if (!(iGeomSource instanceof IObstruction)) {
                    return;
                }
                IObstruction iObstruction = (IObstruction)iGeomSource;
                IGeom iGeom = iObstruction.getGeom();
                if (iGeom.isShell() && !iObstruction.getOptions(1)) {
                    return;
                }
                for (IPolygon iPolygon : GeomUtil.explode(iGeom, IPolygon.class)) {
                    AARectangle aARectangle = VentParser.rectFromFace(iPolygon, plane3d);
                    if (aARectangle == null) continue;
                    arrayList2.add(aARectangle);
                }
            }
        };
        this.getContainer().getGeomLocator().updateDirty();
        this.getContainer().getGeomLocator().find(iTest, (IResult<? super IGeomSource>)iResult, true);
        if (arrayList2.isEmpty()) {
            String n = Intl.intl("Vent does not intersect any solid obstructions.");
            String string2 = Intl.intl("Skipping vent.");
            this.addWarning(new FDSParseWarning(fDSParseRecord, n, string2));
        } else {
            int n = 0;
            ArrayList<Vent> arrayList = new ArrayList<Vent>(arrayList2.size());
            for (AARectangle aARectangle : arrayList2) {
                String string3 = arrayList2.size() > 1 ? String.format("%s[%d]", string, n++) : string;
                Vent vent = new Vent(string3, surface, aARectangle);
                this.addVent(fDSParseRecord, vent);
                arrayList.add(vent);
            }
            if (arrayList.size() == 1) {
                this.addObject((IPyroObject)arrayList.get(0));
            } else {
                object = new ModelComposite(string);
                ((Composite)object).addAll(arrayList);
                this.getContainer().getObstructions().add((IPyroObject)object);
            }
        }
    }

    private static AARectangle rectFromFace(IFace iFace, Plane3d plane3d) {
        if (!(iFace instanceof IPolygon)) {
            return null;
        }
        IPolygon iPolygon = (IPolygon)iFace;
        if (!VentParser.equal(PolyUtil.getPlane(iPolygon), plane3d, 1.0E-9)) {
            return null;
        }
        AABox aABox = iFace.getBoundingBox(new AABox());
        return AARectangle.construct(aABox.getMin(), aABox.getMax());
    }

    private void applyColor(Vent vent, Color color) {
        if (color == INVISIBLE_COLOR) {
            vent.setVisible(false);
            vent.setColors(new Color[]{null});
        } else {
            vent.setColors(color);
        }
    }

    protected static FDS5Const.VentMB getMB(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = fDSParseRecord.getString("MB", false);
        if (string == null) {
            return null;
        }
        for (FDS5Const.VentMB ventMB : FDS5Const.VentMB.values()) {
            if (!string.equals(ventMB.fdsName)) continue;
            return ventMB;
        }
        throw new FDSRecordFormatException(String.format(Intl.intl("Unrecognized value for %1$S: %2$s"), "MB", string));
    }

    protected Map<Grid, GridMergeUtil.BoundaryInfo> getGridFaces() {
        if (this.d_gridFaces == null) {
            this.d_gridFaces = GridMergeUtil.mergeGrids(this.getContainer().getGridManager().flatten(), (Collection<? extends IPyroGeomSrc>)Collections.EMPTY_LIST).faces;
        }
        return this.d_gridFaces;
    }

    protected static boolean equal(Plane3d plane3d, Plane3d plane3d2, double d) {
        return plane3d.epsilonEquals(plane3d2, d) || plane3d.epsilonEquals(plane3d2.negate(), d);
    }
}

