/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.util.Lists;

public class TableParser
extends AFDS5Parser {
    public TableParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("TABL");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("ID");
        if (string == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Table entry has no ID."), Intl.intl("Adding table entry to additional records section."));
            return false;
        }
        List<Double> list = fDSParseRecord.getList("TABLE_DATA", false);
        if (list == null || list.isEmpty()) {
            this.addWarning(fDSParseRecord, Intl.intl("Table entry has no values."), Intl.intl("Ignoring table entry."));
            return true;
        }
        if (Lists.containsNull(list)) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Null values are not allowed in table entries."));
        }
        this.getParsingInfo().addTableRow(string, list);
        return true;
    }
}

