/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.TextureDBMgr;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AirDuct;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AirFlow;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Backing;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.FanSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISlip;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpecInjList;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpeciesInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfDescStatic;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ZonePath;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.texture.TextureDB;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.domain.zones.Zone;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.FDS5Const;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ExSpecParser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.ZoneParser;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Lists;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class SurfaceParser
extends AFDS5Parser {
    private final ExSpecParser d_specParser;
    private final ZoneParser d_zoneParser;

    public SurfaceParser(FDS5ParsingInfo fDS5ParsingInfo, ExSpecParser exSpecParser, ZoneParser zoneParser) {
        super(fDS5ParsingInfo);
        this.d_specParser = exSpecParser;
        this.d_zoneParser = zoneParser;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("SURF");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
        set.add("CELL_SIZE_FACTOR");
        set.add("STRETCH_FACTOR");
        set.add("EMISSIVITY_BACK");
        set.add("SPREAD_RATE");
        set.add("XYZ");
        set.add("EXTERNAL_FLUX");
        set.add("RAMP_EF");
        set.add("TAU_EF");
        set.add("H_FIXED");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("ID");
        if (!this.checkName(fDSParseRecord, string)) {
            return false;
        }
        String string2 = (String)fDSParseRecord.get("FYI");
        Color color = this.parseColor(fDSParseRecord, "RGB", "COLOR", "TRANSPARENCY", true);
        TextureInfo textureInfo = this.parseTexInfo(fDSParseRecord);
        ISurfDesc iSurfDesc = this.parseSurfaceDesc(fDSParseRecord);
        Surface surface = new Surface(string, color, textureInfo, iSurfDesc);
        if (string2 != null) {
            surface.setFYI(string2);
        }
        surface.setCustomFDSProps(this.getCustomVals(fDSParseRecord));
        int n = this.existsStatus(fDSParseRecord, surface, Surface.class);
        if (n != 0) {
            return this.convertToReturn(n);
        }
        this.getContainer().getSurfaceMgr().add(surface);
        this.flagObjectAdded(surface);
        return true;
    }

    private TextureInfo parseTexInfo(FDSParseRecord fDSParseRecord) {
        String string = (String)fDSParseRecord.get("TEXTURE_MAP", false);
        if (string == null) {
            return null;
        }
        TextureInfo textureInfo = null;
        TextureDBMgr textureDBMgr = this.getContainer().getTextureDBMgr();
        TextureDB textureDB = textureDBMgr.getDatabase();
        if (textureDB.names().contains(string)) {
            textureInfo = new TextureInfo(textureDB.getDefaultInfo(string));
        } else if (this.getParsingInfo().getParsingFile() != null) {
            try {
                FDS5ParsingInfo fDS5ParsingInfo = this.getParsingInfo();
                File file = new File(fDS5ParsingInfo.getParsingFile());
                File file2 = new File(file.getParentFile(), string);
                textureInfo = new TextureInfo(textureDBMgr.addToDB(file2));
                String string2 = textureInfo.getTexID();
                TextureInfo textureInfo2 = textureDB.getDefaultInfo(string2);
                UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("TEXTURE_WIDTH", true);
                UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("TEXTURE_HEIGHT", true);
                textureInfo2.setWidth(unitDouble);
                textureInfo2.setHeight(unitDouble2);
            }
            catch (Throwable throwable) {
                this.addWarning(fDSParseRecord, "Unable to create texture: " + string, "Texture Removed");
                throwable.printStackTrace();
                textureInfo = null;
            }
        }
        if (textureInfo != null) {
            if (fDSParseRecord.contains("TEXTURE_WIDTH")) {
                textureInfo.setWidth(fDSParseRecord.getUnitDouble("TEXTURE_WIDTH", false));
            }
            if (fDSParseRecord.contains("TEXTURE_HEIGHT")) {
                textureInfo.setHeight(fDSParseRecord.getUnitDouble("TEXTURE_HEIGHT", false));
            }
        }
        return textureInfo;
    }

    private ISurfDesc parseSurfaceDesc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        boolean bl = (Boolean)fDSParseRecord.get("ADIABATIC", true);
        if (bl) {
            ISlip iSlip = this.parseSlip(fDSParseRecord);
            return new SurfDescStatic.Adiabatic(iSlip);
        }
        ParticleInjection particleInjection = this.parsePartInj(fDSParseRecord);
        SpecInjList specInjList = this.parseSpeciesInjection(fDSParseRecord);
        HeatRelease heatRelease = this.parseHeatRelease(fDSParseRecord);
        Fuel.IReaction iReaction = this.parseReaction(fDSParseRecord, heatRelease);
        SurfComposition surfComposition = this.parseSurfComposition(fDSParseRecord);
        TempRegulation tempRegulation = this.parseTempRegulation(fDSParseRecord);
        ZonePath zonePath = this.parseZonePath(fDSParseRecord, "LEAK_PATH");
        boolean[] blArray = new boolean[1];
        AirFlow airFlow = this.parseAirFlow(fDSParseRecord, null, blArray);
        if (!surfComposition.d_layers.isEmpty() || fDSParseRecord.contains("ROUGHNESS") || fDSParseRecord.contains("FREE_SLIP") || fDSParseRecord.contains("NO_SLIP") || fDSParseRecord.contains("GEOMETRY")) {
            if (airFlow != null) {
                this.addWarning(fDSParseRecord, Intl.intl("Forced air flow information cannot be specified on layered surfaces."), Intl.intl("Ignoring forced air flow information."));
            }
            if (tempRegulation != null) {
                this.addWarning(fDSParseRecord, Intl.intl("Surface temperature information cannot be specified on layered surfaces."), Intl.intl("Ignoring temperature information."));
            }
            ISlip iSlip = this.parseSlip(fDSParseRecord);
            assert (iReaction != null);
            boolean bl2 = (Boolean)fDSParseRecord.get("BURN_AWAY", true);
            UnitDouble unitDouble = fDSParseRecord.getUnitDouble("SURFACE_DENSITY", true);
            if (unitDouble.getValueNoUnit() < 0.0) {
                unitDouble = null;
            }
            String string = fDSParseRecord.getString("GEOMETRY");
            LayeredSurfDesc.Geometry geometry = LayeredSurfDesc.Geometry.FLAT;
            if (string != null) {
                if (string.equals("CYLINDRICAL")) {
                    geometry = LayeredSurfDesc.Geometry.CYLINDRICAL;
                } else if (string.equals("SPHERICAL")) {
                    geometry = LayeredSurfDesc.Geometry.SPHERICAL;
                } else {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("Unknown GEOMETRY, %s."), string), Intl.intl("Ignoring GEOMETRY."));
                }
            }
            return new LayeredSurfDesc(geometry, iSlip, iReaction, surfComposition, specInjList, particleInjection, bl2, zonePath, unitDouble);
        }
        if (heatRelease != null) {
            if (airFlow != null) {
                this.addWarning(fDSParseRecord, Intl.intl("Forced air flow information cannot be specified on burners."), Intl.intl("Ignoring forced air flow information."));
            }
            if (specInjList != null) {
                this.addWarning(fDSParseRecord, Intl.intl("Burning surfaces cannot inject extra species."), Intl.intl("Ignoring extra species."));
            }
            if (zonePath != null) {
                this.addWarning(fDSParseRecord, Intl.intl("Burners cannot have a LEAK_PATH."), Intl.intl("Ignoring LEAK_PATH."));
            }
            if (tempRegulation == null) {
                tempRegulation = TempRegulation.newDefault();
            }
            return new BurnerSurfDesc(tempRegulation, heatRelease, particleInjection);
        }
        boolean bl3 = fDSParseRecord.getBoolean("POROUS", true);
        if (airFlow != null && bl3) {
            if (specInjList != null) {
                this.addWarning(fDSParseRecord, Intl.intl("Species injection is not allowed on porous surfaces."), Intl.intl("Ignoring species injection."));
            }
            if (zonePath != null) {
                this.addWarning(fDSParseRecord, Intl.intl("Fans cannot have a LEAK_PATH."), Intl.intl("Ignoring LEAK_PATH for fan surface."));
            }
            return new FanSurfDesc(airFlow);
        }
        airFlow = this.parseAirFlow(fDSParseRecord, specInjList, blArray);
        if (airFlow != null) {
            if (zonePath != null) {
                this.addWarning(fDSParseRecord, Intl.intl("LEAK_PATH is not allowed on exhaust and supply surfaces."), Intl.intl("Ignoring LEAK_PATH."));
            }
            if (blArray[0]) {
                if (tempRegulation != null) {
                    this.addWarning(fDSParseRecord, Intl.intl("Temperature information is irrelevant for air intake surfaces."), Intl.intl("Ignoring temperature information."));
                }
                return new InFlowSurfDesc(airFlow);
            }
            if (tempRegulation == null) {
                tempRegulation = TempRegulation.newDefault();
            }
            return new BlowerSurfDesc(tempRegulation, airFlow, particleInjection);
        }
        if (tempRegulation != null) {
            if (zonePath != null) {
                this.addWarning(fDSParseRecord, Intl.intl("LEAK_PATH is not allowed on temperature-regulated surfaces."), Intl.intl("Ignoring LEAK_PATH."));
            }
            return new ConstantTempSurfDesc(tempRegulation, particleInjection);
        }
        if (zonePath != null) {
            return new LeakSurfDesc(zonePath, bl3);
        }
        return new SurfDescStatic.Inert();
    }

    private ISlip parseSlip(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        boolean bl = fDSParseRecord.getBoolean("FREE_SLIP", true);
        boolean bl2 = fDSParseRecord.getBoolean("NO_SLIP", true);
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("ROUGHNESS", true);
        if (bl && bl2) {
            this.addWarning(fDSParseRecord, Intl.intl("FREE_SLIP cannot be used in conjunction with NO_SLIP."), Intl.intl("Using NO_SLIP."));
        }
        if ((bl || bl2) && unitDouble.getValueNoUnit() != 0.0) {
            this.addWarning(fDSParseRecord, Intl.intl("ROUGHNESS should not be used in conjection with FREE_SLIP or NO_SLIP."), Intl.intl("Ignoring ROUGHNESS"));
        }
        if (bl2) {
            return ISlip.NO_SLIP;
        }
        if (bl) {
            return ISlip.FREE_SLIP;
        }
        return new ISlip.RoughSlip(unitDouble);
    }

    private AirDuct parseAirDuct(FDSParseRecord fDSParseRecord) {
        ZonePath zonePath = this.parseZonePath(fDSParseRecord, "DUCT_PATH");
        if (zonePath == null) {
            return null;
        }
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("MAX_PRESSURE", true);
        return new AirDuct(zonePath, unitDouble);
    }

    private ZonePath parseZonePath(FDSParseRecord fDSParseRecord, String string) {
        int n;
        if (!fDSParseRecord.contains(string)) {
            return null;
        }
        FDSArray fDSArray = fDSParseRecord.getArray(string, true);
        int n2 = (Integer)fDSArray.get(0);
        if (n2 == (n = ((Integer)fDSArray.get(1)).intValue())) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%s must specify two different ZONEs."), string), String.format(Intl.intl("Ignoring %s"), string));
            return null;
        }
        Zone zone = this.d_zoneParser.get(n2);
        Zone zone2 = this.d_zoneParser.get(n);
        if (zone == null || zone2 == null) {
            int n3 = zone == null ? n2 : n;
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find ZONE %d."), n3), String.format(Intl.intl("Ignoring %s"), string));
            return null;
        }
        return new ZonePath(zone, zone2);
    }

    private ParticleInjection parsePartInj(FDSParseRecord fDSParseRecord) {
        String string = (String)fDSParseRecord.get("PART_ID");
        if (string == null) {
            return null;
        }
        Particle particle = this.getParsingInfo().findObject(Particle.class, string);
        if (particle == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("The particle, %s, could not be found in the model."), string), Intl.intl("Ignoring particle."));
            return null;
        }
        int n = (Integer)fDSParseRecord.get("NPPC", true);
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("DT_INSERT", false);
        if (unitDouble == null) {
            unitDouble = particle.getDescription().getOutput().d_dtInsert;
        }
        TimeBasedValue<UnitDouble> timeBasedValue = null;
        UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("PARTICLE_MASS_FLUX", false);
        if (unitDouble2 != null && unitDouble2.getValue(SIUS.unit(45)) > 0.0) {
            if (particle.isMassless()) {
                this.addWarning(fDSParseRecord, Intl.intl("A mass flux is specified for the particle, but the particle is massless."), Intl.intl("Ignoring mass flux."));
                timeBasedValue = null;
            } else {
                TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_PART", "RAMP_PART");
                timeBasedValue = new TimeBasedValue<UnitDouble>(unitDouble2, timeFunction);
            }
        }
        return new ParticleInjection(particle, n, timeBasedValue, unitDouble);
    }

    private SpecInjList parseSpeciesInjection(FDSParseRecord fDSParseRecord) {
        List list = fDSParseRecord.getList("MASS_FRACTION", false);
        List list2 = fDSParseRecord.getList("MASS_FLUX", false);
        int n = -1;
        List list3 = null;
        if (list != null && Lists.containsNonNull(list)) {
            list3 = list;
            n = 1;
        } else if (list2 != null && Lists.containsNonNull(list2)) {
            list3 = list2;
            n = 0;
        }
        if (list3 == null) {
            return null;
        }
        TimeBasedValue timeBasedValue = null;
        List list4 = fDSParseRecord.getList("TAU_MF", list3.size(), false);
        List list5 = fDSParseRecord.getList("RAMP_MF", list3.size(), false);
        ArrayList<SpeciesInjection> arrayList = new ArrayList<SpeciesInjection>();
        for (int i = 0; i < list3.size(); ++i) {
            Object t = list3.get(i);
            if (t == null) continue;
            UnitDouble unitDouble = (UnitDouble)list4.get(i);
            String string = (String)list5.get(i);
            TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, unitDouble, string);
            if (i == 0) {
                if (n == 0 && ((UnitDouble)t).getValueNoUnit() > 0.0) {
                    timeBasedValue = new TimeBasedValue(t, timeFunction);
                    continue;
                }
                if (n != 1 || !((Double)t > 0.0)) continue;
                this.addWarning(fDSParseRecord, Intl.intl("Specifying a mass fraction for the background species is not supported by PyroSim."), Intl.intl("Ignoring mass fraction of background species."));
                continue;
            }
            ExSpec exSpec = this.d_specParser.getSpec(i - 1);
            if (exSpec == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Extra species %d could not be found."), i), String.format(Intl.intl("Ignoring extra species %d."), i));
                continue;
            }
            arrayList.add(new SpeciesInjection(exSpec, t, timeFunction));
        }
        if (timeBasedValue == null && arrayList.isEmpty()) {
            return null;
        }
        return new SpecInjList(n, timeBasedValue, arrayList);
    }

    private Backing parseBacking(FDSParseRecord fDSParseRecord) {
        String string = (String)fDSParseRecord.get("BACKING", true);
        if (string.equals("VOID")) {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("TMP_BACK", true);
            return new Backing.AirGap(unitDouble);
        }
        if (string.equals("EXPOSED")) {
            return Backing.EXPOSED;
        }
        if (string.equals("INSULATED")) {
            return Backing.INSULATED;
        }
        this.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a recognized surface backing."), string), String.format(Intl.intl("Ignoring backing."), new Object[0]));
        return Backing.newDefault();
    }

    private HeatRelease parseHeatRelease(FDSParseRecord fDSParseRecord) {
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("HRRPUA", false);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("MLRPUA", false);
        if (unitDouble == null && unitDouble2 == null) {
            return null;
        }
        UnitDouble unitDouble3 = (UnitDouble)fDSParseRecord.get("E_COEFFICIENT", true);
        TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_Q", "RAMP_Q");
        if (unitDouble != null && unitDouble2 != null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%1$s and %2$s should not both be specified for a surface."), "HRRPUA", "MLRPUA"), String.format(Intl.intl("Ignoring %s."), "MLRPUA"));
        }
        HeatRelease.Type type = unitDouble != null ? new HeatRelease.HRRType(unitDouble, timeFunction) : new HeatRelease.MLRType(unitDouble2, timeFunction);
        return new HeatRelease(type, unitDouble3);
    }

    private TempRegulation parseTempRegulation(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (!(fDSParseRecord.contains("TMP_FRONT") || fDSParseRecord.contains("CONVECTIVE_HEAT_FLUX") || fDSParseRecord.contains("NET_HEAT_FLUX"))) {
            return null;
        }
        if (fDSParseRecord.contains("NET_HEAT_FLUX")) {
            if (fDSParseRecord.contains("CONVECTIVE_HEAT_FLUX")) {
                throw new FDSRecordFormatException(Intl.intl("SURFs may not specify both a NET_HEAT_FLUX and CONVECTIVE_HEAT_FLUX"));
            }
            if (fDSParseRecord.contains("TMP_FRONT") || fDSParseRecord.contains("EMISSIVITY")) {
                this.addWarning(fDSParseRecord, Intl.intl("SURF records should not specify TMP_FRONT or EMISSIVITY with NET_HEAT_FLUX"), Intl.intl("Ignoring TMP_FRONT and EMISSIVITY"));
            }
            UnitDouble unitDouble = fDSParseRecord.getUnitDouble("NET_HEAT_FLUX", true);
            return TempRegulation.newNetHeatFluxTR(unitDouble);
        }
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("TMP_FRONT", true);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("CONVECTIVE_HEAT_FLUX", true);
        String string = "RAMP_T";
        String string2 = "TAU_T";
        if (unitDouble2.getValueNoUnit() != 0.0) {
            string = "RAMP_Q";
            string2 = "TAU_Q";
        }
        TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, string2, string);
        double d = (Double)fDSParseRecord.get("EMISSIVITY", true);
        return TempRegulation.newFixedHeatFluxTR(unitDouble, unitDouble2, timeFunction, d);
    }

    private AirFlow parseAirFlow(FDSParseRecord fDSParseRecord, SpecInjList specInjList, boolean[] blArray) throws FDSRecordFormatException {
        Serializable serializable;
        AirFlow.IProfile iProfile;
        AirFlow.Rate rate;
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("VEL", false);
        UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("VOLUME_FLUX", false);
        UnitDouble unitDouble3 = (UnitDouble)fDSParseRecord.get("MASS_FLUX_TOTAL", false);
        Boolean bl = fDSParseRecord.getBoolean("POROUS", false);
        if (unitDouble == null && unitDouble2 == null && unitDouble3 == null && specInjList == null) {
            return null;
        }
        int n = 0;
        if (unitDouble != null) {
            ++n;
        }
        if (unitDouble2 != null) {
            ++n;
        }
        if (unitDouble3 != null) {
            ++n;
        }
        if (n > 1) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Only one of %1$s, %2$s, and %3$s can be specified for a surface."), "VEL", "VOLUME_FLUX", "MASS_FLUX_TOTAL"), String.format(Intl.intl("Using %s."), "VEL"));
        }
        TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_V", "RAMP_V");
        bl = (Boolean)fDSParseRecord.get("POROUS", true);
        if (bl.booleanValue()) {
            blArray[0] = false;
        }
        FDSArray fDSArray = fDSParseRecord.getArray("VEL_T", true);
        if (unitDouble != null) {
            unitDouble = bl == false ? this.extractFlowRate(unitDouble, blArray) : unitDouble;
            specInjList = this.validateForcedAirSpecInj(fDSParseRecord, specInjList, "VEL", blArray[0]);
            rate = new AirFlow.NormalVel(unitDouble, (UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList);
        } else if (unitDouble2 != null) {
            unitDouble2 = bl == false ? this.extractFlowRate(unitDouble2, blArray) : unitDouble2;
            specInjList = this.validateForcedAirSpecInj(fDSParseRecord, specInjList, "VOLUME_FLUX", blArray[0]);
            rate = new AirFlow.VolumeFlux(unitDouble2, (UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList);
        } else if (unitDouble3 != null) {
            unitDouble3 = bl == false ? this.extractFlowRate(unitDouble3, blArray) : unitDouble3;
            specInjList = this.validateForcedAirSpecInj(fDSParseRecord, specInjList, "MASS_FLUX_TOTAL", blArray[0]);
            rate = new AirFlow.TotalMassFlux(unitDouble3, (UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList);
        } else {
            assert (specInjList != null);
            blArray[0] = false;
            rate = specInjList.injType == 0 ? new AirFlow.ExSpecMassFlux((UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList) : new AirFlow.NormalVel(SIUS.newud(0.0, 8), (UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), timeFunction, specInjList);
        }
        String string = (String)fDSParseRecord.get("PROFILE", true);
        if (string == null || string.equals(FDS5Const.TOP_HAT)) {
            iProfile = new AirFlow.TopHatProf();
        } else if (string.equals("PARABOLIC")) {
            iProfile = new AirFlow.ParabolicProf();
        } else if (string.equals("ATMOSPHERIC")) {
            serializable = (UnitDouble)fDSParseRecord.get("Z0", true);
            double d = (Double)fDSParseRecord.get("PLE", true);
            iProfile = new AirFlow.AtmosphericProf(d, (UnitDouble)serializable);
        } else {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a recognized wind profile."), string), Intl.intl("Using a top hat wind profile."));
            iProfile = new AirFlow.TopHatProf();
        }
        serializable = this.parseAirDuct(fDSParseRecord);
        return new AirFlow(rate, iProfile, (AirDuct)serializable);
    }

    private UnitDouble extractFlowRate(UnitDouble unitDouble, boolean[] blArray) {
        if (new Double(unitDouble.getValueNoUnit()).compareTo(0.0) < 0) {
            blArray[0] = false;
            return unitDouble.negate();
        }
        blArray[0] = true;
        return unitDouble;
    }

    private SpecInjList validateForcedAirSpecInj(FDSParseRecord fDSParseRecord, SpecInjList specInjList, String string, boolean bl) {
        if (specInjList != null) {
            if (bl) {
                this.addWarning(fDSParseRecord, Intl.intl("Extra species are irrelevant for air intake surfaces."), Intl.intl("Ignoring extra species for surface."));
                return null;
            }
            if (specInjList.injType == 0) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%1$s cannot be specified with %2$s"), string, "MASS_FLUX"), Intl.intl("Ignoring extra species for surface."));
                return null;
            }
        }
        return specInjList;
    }

    private static boolean valsEqualZero(UnitDouble ... unitDoubleArray) {
        for (UnitDouble unitDouble : unitDoubleArray) {
            if (unitDouble == null || unitDouble.getValueNoUnit() == 0.0) continue;
            return false;
        }
        return true;
    }

    private Fuel.IReaction parseReaction(FDSParseRecord fDSParseRecord, HeatRelease heatRelease) {
        if (heatRelease == null) {
            return new Fuel.MaterialReac();
        }
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("IGNITION_TEMPERATURE", false);
        Fuel.ManualReac.IIgnition iIgnition = unitDouble != null ? new Fuel.ManualReac.TemperatureIgnite(unitDouble) : new Fuel.ManualReac.ImmediateIgnite();
        UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("HEAT_OF_VAPORIZATION", false);
        return new Fuel.ManualReac(heatRelease, unitDouble2, iIgnition);
    }

    private SurfComposition parseSurfComposition(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        List<SurfComposition.SurfLayer> list = this.parseLayers(fDSParseRecord);
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("TMP_INNER", true);
        TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "TAU_T", "RAMP_T");
        Backing backing = this.parseBacking(fDSParseRecord);
        boolean bl = fDSParseRecord.getBoolean("POROUS", true);
        Double d = fDSParseRecord.getDouble("LAYER_DIVIDE", true);
        if (d != null) {
            String string = Intl.intl("LAYER_DIVIDE should be >= 0 and <= number of layers.");
            if (d < 0.0) {
                d = null;
                this.addWarning(fDSParseRecord, string, Intl.intl("Using the default LAYER_DIVIDE value."));
            } else if (d > (double)list.size()) {
                d = list.size();
                this.addWarning(fDSParseRecord, string, String.format(Intl.intl("Clamped the LAYER_DIVIDE to %d."), list.size()));
            }
        }
        return new SurfComposition(unitDouble, timeFunction, backing, bl, d, list);
    }

    private List<SurfComposition.SurfLayer> parseLayers(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        ArrayList<SurfComposition.SurfLayer> arrayList = new ArrayList<SurfComposition.SurfLayer>();
        FDSArray fDSArray = fDSParseRecord.getArray("MATL_ID", false);
        if (fDSArray == null || !fDSArray.containsNonNull()) {
            return arrayList;
        }
        FDSArray fDSArray2 = fDSParseRecord.getArray("THICKNESS", true);
        FDSArray fDSArray3 = fDSParseRecord.getArray("MATL_MASS_FRACTION", true);
        for (int i = 0; i < FDS5Const.SURF_LAYER_DIMENSIONS[0]; ++i) {
            UnitDouble unitDouble = (UnitDouble)fDSArray2.get(i);
            double d = 0.0;
            ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList2 = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
            ArrayList<Material> arrayList3 = new ArrayList<Material>();
            for (int j = 0; j < FDS5Const.SURF_LAYER_DIMENSIONS[1]; ++j) {
                String string = (String)fDSArray.get(i, j);
                if (string == null) continue;
                Material material = this.getParsingInfo().findObject(Material.class, string);
                if (material == null) {
                    throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Could not find MATL %s."), string));
                }
                Double d2 = (Double)fDSArray3.get(i, j);
                if (d2 == null) {
                    arrayList3.add(material);
                    continue;
                }
                d += d2.doubleValue();
                arrayList2.add(new SurfComposition.SurfLayer.SurfComponent(d2, material));
            }
            if (arrayList2.isEmpty() && arrayList3.isEmpty()) continue;
            if (arrayList2.isEmpty() && arrayList3.size() == 1) {
                arrayList2.add(new SurfComposition.SurfLayer.SurfComponent(1.0, (Material)arrayList3.get(0)));
            } else {
                if (d > 1.0000001) {
                    throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Material mass fractions in layer %d add to more than 1."), i + 1));
                }
                if (d < 0.9999999 && arrayList3.isEmpty()) {
                    throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Material mass fractions in layer %d add to less than 1."), i + 1));
                }
                if (!arrayList3.isEmpty()) {
                    this.addWarning(fDSParseRecord, String.format(Intl.intl("A mass fraction was not specified for every material in layer %d."), i + 1), String.format(Intl.intl("Distributing remaining mass fraction evenly among materials with no specified mass fraction."), i + 1));
                    double d2 = (1.0 - d) / (double)arrayList3.size();
                    if (d2 != 0.0) {
                        for (Material material : arrayList3) {
                            arrayList2.add(new SurfComposition.SurfLayer.SurfComponent(d2, material));
                        }
                    }
                }
            }
            arrayList.add(new SurfComposition.SurfLayer(unitDouble, arrayList2));
        }
        return arrayList;
    }
}

