/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.output.AMsrStat;
import pyrosim.legacy_2012_1.domain.output.GasMsrStat;
import pyrosim.legacy_2012_1.domain.output.SolidMsrStat;
import pyrosim.legacy_2012_1.domain.output.StatGeom;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.common.StatisticMap;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class StatisticsParser
extends AFDS5Parser {
    private Map<StatHash, Set<Integer>> d_solidStatMap = new HashMap<StatHash, Set<Integer>>();
    private Map<StatHash, Set<Integer>> d_gasStatMap = new HashMap<StatHash, Set<Integer>>();

    public StatisticsParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("DEVC");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("STATISTICS", false);
        if (string == null) {
            return true;
        }
        Integer n = StatisticMap.getPyroVal(string);
        if (n == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Unrecognized statistic: %s"), string), Intl.intl("Ignoring statistic."));
            return true;
        }
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", "PART_ID", "SPEC_ID", "MATL_ID", "DUCT_ID", "NODE_ID", n, Intl.intl("Ignoring statistic."), true, false);
        if (iQuantity == null) {
            return true;
        }
        if (iQuantity.get().quantityType != QuantityType.GAS && iQuantity.get().quantityType != QuantityType.SOLID || (iQuantity.get().outputTypes & 1) != 1) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Statitistics can only be measured for solid and gas phase quantities."), new Object[0]), Intl.intl("Ignoring statistic."));
            return true;
        }
        if ((iQuantity.get().outputTypes & n) != n) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Invalid statistic for quantity %s."), fDSParseRecord.getString("QUANTITY")), Intl.intl("Ignoring statistic."));
            return true;
        }
        IGeom iGeom = this.parseGeom(fDSParseRecord, iQuantity, string, n);
        if (iGeom == null) {
            return true;
        }
        if (iQuantity.get().quantityType == QuantityType.SOLID) {
            this.parseSolidStat(fDSParseRecord, iQuantity, n, iGeom);
        } else {
            this.parseGasStat(fDSParseRecord, iQuantity, n, iGeom);
        }
        return true;
    }

    private IGeom parseGeom(FDSParseRecord fDSParseRecord, IQuantity iQuantity, String string, int n) throws FDSRecordFormatException {
        Serializable serializable;
        UnitPoint3D unitPoint3D = null;
        UnitPoint3D[] unitPoint3DArray = null;
        UnitPoint3D unitPoint3D2 = null;
        if (fDSParseRecord.contains("XB")) {
            unitPoint3DArray = StatisticsParser.parseXB(fDSParseRecord, Intl.intl("Gas-phase statistics"), "XB", true);
            serializable = Util3D.getMidPoint(unitPoint3DArray[0].getPoint3dValue(Geometry.LU), unitPoint3DArray[1].getPoint3dValue(Geometry.LU));
            unitPoint3D2 = new UnitPoint3D((Point3d)serializable, Geometry.LU);
        }
        if (fDSParseRecord.contains("XYZ")) {
            unitPoint3D = StatisticsParser.parseLoc(fDSParseRecord, "DEVC", "XYZ", true);
        }
        if (unitPoint3DArray == null && unitPoint3D == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Statistics must define either an XB or XYZ."), Intl.intl("Ignoring statistic."));
            return null;
        }
        if (n == 0x400000) {
            AARectangle aARectangle = this.toRect(unitPoint3DArray);
            if (aARectangle == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%s statistics must specify an area."), string), Intl.intl("Ignoring statistic."));
                return null;
            }
            serializable = aARectangle;
        } else if (n == 0x1000000) {
            if (unitPoint3D != null) {
                serializable = new Point(unitPoint3D.getPoint3dValue(Geometry.LU));
            } else {
                assert (unitPoint3D2 != null);
                serializable = new Point(unitPoint3D2.getPoint3dValue(Geometry.LU));
            }
        } else if (unitPoint3DArray != null) {
            serializable = new AABoxGeom(this.toBox(unitPoint3DArray).getValue(Geometry.LU));
        } else {
            Grid grid = this.getGridForPoint(unitPoint3D);
            if (grid == null) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find grid for point %s."), unitPoint3D.toString()), Intl.intl("Ignoring statistic."));
                return null;
            }
            serializable = new StatGeom.GridGeom(grid);
        }
        return serializable;
    }

    private void parseGasStat(FDSParseRecord fDSParseRecord, IQuantity iQuantity, int n, IGeom iGeom) throws FDSRecordFormatException {
        StatHash statHash = new StatHash(fDSParseRecord, iGeom, iQuantity);
        Set<Integer> set = this.d_gasStatMap.get(statHash);
        if (set == null) {
            set = new HashSet<Integer>();
            this.d_gasStatMap.put(statHash, set);
        }
        set.add(n);
    }

    private AARectangle toRect(UnitPoint3D[] unitPoint3DArray) {
        return unitPoint3DArray != null ? AARectangle.construct(unitPoint3DArray[0].getPoint3dValue(Geometry.LU), unitPoint3DArray[1].getPoint3dValue(Geometry.LU)) : null;
    }

    private UnitAABox toBox(UnitPoint3D[] unitPoint3DArray) {
        return unitPoint3DArray != null ? new UnitAABox(unitPoint3DArray[0], unitPoint3DArray[1]) : null;
    }

    private void parseSolidStat(FDSParseRecord fDSParseRecord, IQuantity iQuantity, int n, IGeom iGeom) throws FDSRecordFormatException {
        StatHash statHash = new StatHash(fDSParseRecord, iGeom, iQuantity);
        Set<Integer> set = this.d_solidStatMap.get(statHash);
        if (set == null) {
            set = new HashSet<Integer>();
            this.d_solidStatMap.put(statHash, set);
        }
        set.add(n);
    }

    private Grid getGridForPoint(UnitPoint3D unitPoint3D) {
        Point3d point3d = unitPoint3D.getValue(SI.METER);
        for (PyroMod pyroMod : this.getParsingInfo().getSourceContainers()) {
            for (Grid grid : pyroMod.getGridManager().flatten()) {
                Point3d point3d2 = grid.getMinPoint().getValue(SI.METER);
                Point3d point3d3 = grid.getMaxPoint().getValue(SI.METER);
                if (!(point3d.x >= point3d2.x) || !(point3d.x <= point3d3.x) || !(point3d.y >= point3d2.y) || !(point3d.y <= point3d3.y) || !(point3d.z >= point3d2.z) || !(point3d.z <= point3d3.z)) continue;
                return grid;
            }
        }
        return null;
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        AMsrStat aMsrStat;
        String string;
        StatHash statHash;
        for (Map.Entry<StatHash, Set<Integer>> entry : this.d_solidStatMap.entrySet()) {
            statHash = entry.getKey();
            string = this.getName(statHash.rec);
            aMsrStat = new SolidMsrStat(string, statHash.msr, statHash.geom, Collections.EMPTY_LIST, (Collection<Integer>)entry.getValue());
            this.getContainer().getMsrStatMgr().add(aMsrStat);
            this.flagObjectAdded(aMsrStat);
        }
        for (Map.Entry<StatHash, Set<Integer>> entry : this.d_gasStatMap.entrySet()) {
            statHash = entry.getKey();
            string = this.getName(statHash.rec);
            aMsrStat = new GasMsrStat(string, statHash.msr, statHash.geom, (Collection<Integer>)entry.getValue());
            this.getContainer().getMsrStatMgr().add(aMsrStat);
            this.flagObjectAdded(aMsrStat);
        }
    }

    private String getName(FDSParseRecord fDSParseRecord) {
        String string;
        String string2 = fDSParseRecord.getString("ID", false);
        String string3 = fDSParseRecord.getString("STATISTICS");
        assert (string3 != null);
        if (string2 == null) {
            String string4 = Util.getUniqueName(this.getContainer().getMsrStatMgr(), "STAT");
            this.addWarning(fDSParseRecord, Intl.intl("Statistic has no name."), String.format(Intl.intl("Assigning name to \"%s.\""), string4));
            return string4;
        }
        if (string2.length() > string3.length() + 1 && string2.endsWith("_" + string3)) {
            string2 = string2.substring(0, string2.lastIndexOf("_" + string3));
        }
        if (!(string = Util.getUniqueName(this.getContainer().getMsrStatMgr(), string2)).equals(string2)) {
            this.addWarning(fDSParseRecord, Intl.intl("Statistic did not have a unique name."), String.format(Intl.intl("Changing name from \"%1$s\" to \"%2$s.\""), string2, string));
        }
        return string;
    }

    private static class StatHash {
        public final FDSParseRecord rec;
        public final IGeom geom;
        public final IQuantity msr;

        public StatHash(FDSParseRecord fDSParseRecord, IGeom iGeom, IQuantity iQuantity) {
            this.rec = fDSParseRecord;
            this.geom = iGeom;
            this.msr = iQuantity;
        }

        public int hashCode() {
            return this.geom.hashCode() + this.msr.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            StatHash statHash = (StatHash)object;
            return this.geom.equals(statHash.geom) && this.msr.equals(statHash.msr);
        }
    }
}

