/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.output.PlanarSlice;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class SliceParser
extends AFDS5Parser {
    public SliceParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("SLCF");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
        set.add("MESH_NUMBER");
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        boolean bl = fDSParseRecord.getBoolean("VECTOR", true);
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, 128, Intl.intl("SLCF ignored"), true, false);
        if (iQuantity == null) {
            return false;
        }
        PlanarSlice planarSlice = null;
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("PBX");
        if (unitDouble != null) {
            planarSlice = new PlanarSlice(0, unitDouble, iQuantity, bl);
        } else {
            UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("PBY");
            if (unitDouble2 != null) {
                planarSlice = new PlanarSlice(1, unitDouble2, iQuantity, bl);
            } else {
                UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble("PBZ");
                if (unitDouble3 != null) {
                    planarSlice = new PlanarSlice(2, unitDouble3, iQuantity, bl);
                }
            }
        }
        if (planarSlice != null) {
            this.getContainer().getSlcfList().add(planarSlice);
            this.flagObjectAdded(planarSlice);
            return true;
        }
        this.addWarning(fDSParseRecord, Intl.intl("Unsupported Slice type encountered."), Intl.intl("Ignoring Slice record."));
        return false;
    }
}

