/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.Serializable;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.SimParams;
import pyrosim.legacy_2012_1.domain.Variant;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class SimParamsParser
extends AFDS5Parser {
    private int d_obstDefaults = 16;

    public SimParamsParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    public int getObstDefaults() {
        return this.d_obstDefaults;
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("HEAD");
        set.add("MISC");
        set.add("TIME");
        set.add("DUMP");
        set.add("RADI");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
        if (string.equals("MISC")) {
            set.add("ASSUMED_GAS_TEMPERATURE");
            set.add("CONDUCTIVITY");
            set.add("H_FIXED");
            set.add("MW");
            set.add("NOISE");
            set.add("SOLID_PHASE_ONLY");
        } else if (string.equals("DUMP")) {
            set.add("FLUSH_FILE_BUFFERS");
        }
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (fDSParseRecord.getType().equals("HEAD")) {
            return this.processHead(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("MISC")) {
            return this.processMisc(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("TIME")) {
            return this.processTime(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("DUMP")) {
            return this.processDump(fDSParseRecord);
        }
        if (fDSParseRecord.getType().equals("RADI")) {
            return this.processRadi(fDSParseRecord);
        }
        return true;
    }

    private boolean processHead(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        SimParams simParams = this.getContainer().getSimParams();
        String string = fDSParseRecord.getString("TITLE");
        if (string != null) {
            simParams.setJobTitle(string);
        }
        this.flagObjectAdded(simParams);
        return true;
    }

    private boolean processTime(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        this.getContainer().getSimParams().setCustomFDSProps("TIME", this.getCustomVals(fDSParseRecord));
        SimParams.Time time = this.getContainer().getSimParams().getTime();
        time.setTimeStepLocks(fDSParseRecord.getBoolean("LOCK_TIME_STEP", true), fDSParseRecord.getBoolean("RESTRICT_TIME_STEP", true));
        time.setInitTimeStep(fDSParseRecord.getUnitDouble("DT", true));
        time.setStartTime(fDSParseRecord.getUnitDouble("T_BEGIN", true));
        UnitDouble unitDouble = fDSParseRecord.contains("TWFIN") ? fDSParseRecord.getUnitDouble("TWFIN", true) : fDSParseRecord.getUnitDouble("T_END", true);
        time.setStopTime(unitDouble);
        time.setWallIncrement(fDSParseRecord.getInteger("WALL_INCREMENT", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processMisc(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        Object object;
        this.getContainer().getSimParams().setCustomFDSProps("MISC", this.getCustomVals(fDSParseRecord));
        SimParams.Calculations calculations = this.getContainer().getSimParams().getCalculations();
        calculations.setCorrectBaroclinicTorque(fDSParseRecord.getBoolean("BAROCLINIC", true));
        calculations.setUseMLTurbulentModel(fDSParseRecord.getBoolean("H_EDDY", true));
        calculations.setCflRange(fDSParseRecord.getDouble("CFL_MIN", true), fDSParseRecord.getDouble("CFL_MAX", true));
        calculations.setCsmag(fDSParseRecord.getDouble("CSMAG", true));
        calculations.setCalcDNS(fDSParseRecord.getBoolean("DNS", true));
        calculations.setCalcIsothermal(fDSParseRecord.getBoolean("ISOTHERMAL", true));
        calculations.setPrandtlNum(fDSParseRecord.getDouble("PR", true));
        calculations.setSchmidtNum(fDSParseRecord.getDouble("SC", true));
        calculations.setCForced(fDSParseRecord.getDouble("C_FORCED", true));
        calculations.setCHorizontal(fDSParseRecord.getDouble("C_HORIZONTAL", true));
        calculations.setCVertical(fDSParseRecord.getDouble("C_VERTICAL", true));
        calculations.setGPFlameExtinction(fDSParseRecord.getBoolean("SUPPRESSION", true));
        calculations.setVnRange(fDSParseRecord.getDouble("VN_MIN", true), fDSParseRecord.getDouble("VN_MAX", true));
        SimParams.Environment environment = this.getContainer().getSimParams().getEnvironment();
        this.readGravity(environment, fDSParseRecord);
        environment.setGroundLevel(fDSParseRecord.getUnitDouble("GROUND_LEVEL", true));
        environment.setRelHumidity(fDSParseRecord.getDouble("HUMIDITY", true));
        environment.setAtmLapseRate(fDSParseRecord.getUnitDouble("LAPSE_RATE", true));
        environment.setAmbPressure(fDSParseRecord.getUnitDouble("P_INF", true));
        environment.setAmbTemp(fDSParseRecord.getUnitDouble("TMPA", true));
        UnitDouble unitDouble = fDSParseRecord.getUnitDouble("U0", true);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("V0", true);
        UnitDouble unitDouble3 = fDSParseRecord.getUnitDouble("W0", true);
        if (unitDouble == null || unitDouble2 == null || unitDouble3 == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Prevailing velocity must have three values."));
        }
        environment.setAmbVel(new UnitPoint3D(unitDouble, unitDouble2, unitDouble3));
        SimParams.Particles particles = this.getContainer().getSimParams().getParticles();
        particles.setPourousFloor(fDSParseRecord.getBoolean("POROUS_FLOOR", true));
        particles.setAllowUndersideDroplets(fDSParseRecord.getBoolean("ALLOW_UNDERSIDE_DROPLETS", true));
        SimParams.RadiationTransport radiationTransport = this.getContainer().getSimParams().getRadiTransport();
        radiationTransport.setRadiationOn(fDSParseRecord.getBoolean("RADIATION", true));
        SimParams.Misc misc = this.getContainer().getSimParams().getMisc();
        String string = fDSParseRecord.getString("SURF_DEFAULT", true);
        if (string != null) {
            object = this.getParsingInfo().findObject(Surface.class, string);
            if (object == null) {
                throw new FDSRecordFormatException(fDSParseRecord, "The specified default surface, \"" + string + ",\" does not exist.");
            }
            misc.setSurfDefault((Surface)object);
        }
        if ((object = fDSParseRecord.getString("EVAC_SURF_DEFAULT", true)) != null) {
            serializable = this.getParsingInfo().findObject(Surface.class, (String)object);
            if (serializable == null) {
                throw new FDSRecordFormatException(fDSParseRecord, "The specified default surface, \"" + (String)object + ",\" does not exist.");
            }
            misc.setEvacProp("EVAC_SURF_DEFAULT", serializable);
        }
        if ((serializable = fDSParseRecord.getArray("TEXTURE_ORIGIN", true)) != null) {
            misc.setTextureOrigin(new UnitPoint3D(((FDSArray)serializable).toFlatArray(new UnitDouble[3])));
        }
        misc.taskSetPredictCOProd(fDSParseRecord.getBoolean("CO_PRODUCTION", true)).run();
        String string2 = fDSParseRecord.getString("BACKGROUND_SPECIES", true);
        if (!ExSpecList.PREDEFINED.containsKey(string2)) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Unknown background species, %s."), string2), Intl.intl("Using default background species."));
        } else {
            misc.taskSetBackgroundSpecies(string2).run();
        }
        boolean bl = fDSParseRecord.getBoolean("BNDF_DEFAULT", true);
        boolean bl2 = fDSParseRecord.getBoolean("THICKEN_OBSTRUCTIONS", true);
        this.d_obstDefaults = bl ? (this.d_obstDefaults |= 0x10) : (this.d_obstDefaults &= 0xFFFFFFEF);
        this.d_obstDefaults = bl2 ? (this.d_obstDefaults |= 1) : (this.d_obstDefaults &= 0xFFFFFFFE);
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private void readGravity(SimParams.Environment environment, FDSParseRecord fDSParseRecord) {
        Variant variant;
        FDSArray<UnitDouble> fDSArray = fDSParseRecord.getArray("GVEC", true);
        UnitPoint3D unitPoint3D = new UnitPoint3D(fDSArray.toFlatArray(new UnitDouble[3]));
        Variant variant2 = fDSParseRecord.contains("RAMP_GX") ? this.readGravityRamp("RAMP_GX", fDSParseRecord) : new Variant.UnitDoubleVar(unitPoint3D.xu());
        Variant variant3 = fDSParseRecord.contains("RAMP_GY") ? this.readGravityRamp("RAMP_GY", fDSParseRecord) : new Variant.UnitDoubleVar(unitPoint3D.yu());
        Variant variant4 = variant = fDSParseRecord.contains("RAMP_GZ") ? this.readGravityRamp("RAMP_GZ", fDSParseRecord) : new Variant.UnitDoubleVar(unitPoint3D.zu());
        if (variant2 == null || variant3 == null || variant == null) {
            this.addWarning(fDSParseRecord, Intl.intl("Unable to read gravity RAMP."), Intl.intl("Gravity will be set to default."));
        }
        environment.setGravityAccel(variant2, variant3, variant);
    }

    private Variant readGravityRamp(String string, FDSParseRecord fDSParseRecord) {
        String string2 = fDSParseRecord.getString(string);
        FDS5ParsingInfo.RampInfo rampInfo = this.getParsingInfo().getRampInfo(string2);
        Ramp ramp = null;
        if (rampInfo != null) {
            if (rampInfo.rec.contains("T")) {
                ramp = this.getParsingInfo().getRamp(string2, RampInputs.TIME, 6, false);
            } else if (rampInfo.rec.contains("X")) {
                ramp = this.getParsingInfo().getRamp(string2, RampInputs.XPOS, 6, false);
            }
        }
        if (rampInfo == null || ramp == null) {
            String string3 = String.format(Intl.intl("Unable to read RAMP record \"%s\"."), string2);
            this.addWarning(fDSParseRecord, string3, Intl.intl("Ramp Ignored"));
            return null;
        }
        return new Variant.RampVar(ramp, RampInputs.TIME, RampInputs.XPOS);
    }

    private boolean processRadi(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        this.getContainer().getSimParams().setCustomFDSProps("RADI", this.getCustomVals(fDSParseRecord));
        SimParams.RadiationTransport radiationTransport = this.getContainer().getSimParams().getRadiTransport();
        radiationTransport.setAngleIncrement(fDSParseRecord.getInteger("ANGLE_INCREMENT", true));
        radiationTransport.setIncludeExtraFuelBands(fDSParseRecord.getBoolean("CH4_BANDS", true));
        radiationTransport.setConstAbsorptionCoef(fDSParseRecord.getUnitDouble("KAPPA0", true));
        radiationTransport.setNumPolarAngles(fDSParseRecord.getInteger("NMIEANG", true));
        radiationTransport.setNumSolidAngles(fDSParseRecord.getInteger("NUMBER_RADIATION_ANGLES", true));
        radiationTransport.setRadCalcPathLen(fDSParseRecord.getUnitDouble("PATH_LENGTH", true));
        radiationTransport.setRadiativeLossFraction(fDSParseRecord.getDouble("RADIATIVE_FRACTION", true));
        radiationTransport.setAssumedRadSourceTemp(fDSParseRecord.getUnitDouble("RADTMP", true));
        radiationTransport.setTimeStepInc(fDSParseRecord.getInteger("TIME_STEP_INCREMENT", true));
        radiationTransport.setNonGrayGasAssumption(fDSParseRecord.getBoolean("WIDE_BAND_MODEL", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }

    private boolean processDump(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        this.getContainer().getSimParams().setCustomFDSProps("DUMP", this.getCustomVals(fDSParseRecord));
        SimParams.FileOutput fileOutput = this.getContainer().getSimParams().getFileOutput();
        fileOutput.setLimitCSVColumns(fDSParseRecord.getBoolean("COLUMN_DUMP_LIMIT", true));
        fileOutput.setDtBoundaryFile(fDSParseRecord.getUnitDouble("DT_BNDF", true));
        fileOutput.setDtDeviceFiles(fDSParseRecord.getUnitDouble("DT_DEVC", true));
        fileOutput.setDtHeatReleaseRateFiles(fDSParseRecord.getUnitDouble("DT_HRR", true));
        fileOutput.setDtIsofFiles(fDSParseRecord.getUnitDouble("DT_ISOF", true));
        fileOutput.setDtMassFiles(fDSParseRecord.getUnitDouble("DT_MASS", true));
        fileOutput.setDtParticleFiles(fDSParseRecord.getUnitDouble("DT_PART", true));
        fileOutput.setDtPlot3dFile(fDSParseRecord.getUnitDouble("DT_PL3D", true));
        fileOutput.setDtProfileDumpInterval(fDSParseRecord.getUnitDouble("DT_PROF", true));
        fileOutput.setDtRestartFile(fDSParseRecord.getUnitDouble("DT_RESTART", true));
        fileOutput.setDtSliceFiles(fDSParseRecord.getUnitDouble("DT_SLCF", true));
        fileOutput.setNumOutputFrames(fDSParseRecord.getInteger("NFRAMES", true));
        fileOutput.setVisualize3dSmoke(fDSParseRecord.getBoolean("SMOKE3D", true));
        fileOutput.setWriteSpeciesMassFile(fDSParseRecord.getBoolean("MASS_FILE", true));
        fileOutput.setWritePlot3dXYZFile(fDSParseRecord.getBoolean("WRITE_XYZ", true));
        IQuantity iQuantity = this.parseQuantity(fDSParseRecord, "SMOKE3D_QUANTITY", null, "SMOKE3D_SPEC_ID", null, null, null, 0, Intl.intl("Ignoring custom smoke."), false, false);
        if (iQuantity != null) {
            if (!SimParams.FileOutput.isValidSmokeQuantity(iQuantity.get())) {
                this.addWarning(fDSParseRecord, String.format(Intl.intl("%s is not a valid Smoke3D quantity."), fDSParseRecord.getString("SMOKE3D_QUANTITY")), Intl.intl("Ignoring custom smoke."));
            } else {
                fileOutput.setSmokeQuantity(iQuantity);
            }
        }
        SimParams.Particles particles = this.getContainer().getSimParams().getParticles();
        particles.setMaxParticlesPerMesh(fDSParseRecord.getInteger("MAXIMUM_DROPLETS", true));
        this.flagObjectAdded(this.getContainer().getSimParams());
        return true;
    }
}

