/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.reaction.Byproducts;
import pyrosim.legacy_2012_1.domain.reaction.FireSuppression;
import pyrosim.legacy_2012_1.domain.reaction.Fuel;
import pyrosim.legacy_2012_1.domain.reaction.HeatReleaseRate;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.domain.reaction.Soot;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class ReactionParser
extends AFDS5Parser {
    public ReactionParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("REAC");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        if (fDSParseRecord.contains("BOF") || fDSParseRecord.contains("E") || fDSParseRecord.contains("FUEL") || fDSParseRecord.contains("N_S") || fDSParseRecord.contains("NU") || fDSParseRecord.contains("OXIDIZER")) {
            this.addWarning(fDSParseRecord, Intl.intl("PyroSim does not currently support finite-rate reactions."), Intl.intl("Adding reaction to additional records section."));
            return false;
        }
        String string = (String)fDSParseRecord.get("ID");
        if (string == null || string.trim().equals("")) {
            string = Util.getUniqueName(this.getContainer().getReactions(), Intl.intl("REAC"));
        }
        Reaction reaction = new Reaction(string);
        reaction.setFYI(fDSParseRecord.getString("FYI", false));
        reaction.setFuel(this.parseFuel(fDSParseRecord));
        reaction.setHRR(this.parseHRR(fDSParseRecord));
        reaction.setByproducts(this.parseByproducts(fDSParseRecord));
        reaction.setSuppression(this.parseSuppression(fDSParseRecord));
        reaction.setCustomFDSProps(this.getCustomVals(fDSParseRecord));
        int n = this.existsStatus(fDSParseRecord, reaction, Reaction.class);
        if (n != 0) {
            return this.convertToReturn(n);
        }
        ReactionList reactionList = this.getContainer().getReactions();
        reactionList.add(reaction);
        this.flagObjectAdded(reaction);
        return true;
    }

    private Fuel parseFuel(FDSParseRecord fDSParseRecord) {
        double d = (Double)fDSParseRecord.get("C", true);
        double d2 = (Double)fDSParseRecord.get("H", true);
        double d3 = (Double)fDSParseRecord.get("O", true);
        double d4 = (Double)fDSParseRecord.get("N", true);
        double d5 = (Double)fDSParseRecord.get("OTHER", true);
        UnitDouble unitDouble = d5 > 0.0 ? fDSParseRecord.getUnitDouble("MW_OTHER", true) : null;
        double d6 = (Double)fDSParseRecord.get("Y_O2_INFTY", true);
        double d7 = (Double)fDSParseRecord.get("Y_F_INLET", true);
        return new Fuel(d, d2, d3, d4, d5, unitDouble, d6, d7);
    }

    private HeatReleaseRate parseHRR(FDSParseRecord fDSParseRecord) {
        return new HeatReleaseRate(fDSParseRecord.getBoolean("EDDY_DISSIPATION", true), fDSParseRecord.getDouble("C_EDC", true), fDSParseRecord.getUnitDouble("HRRPUA_SHEET", true), fDSParseRecord.getUnitDouble("HRRPUV_AVERAGE", true));
    }

    private FireSuppression parseSuppression(FDSParseRecord fDSParseRecord) {
        double d = (Double)fDSParseRecord.get("X_O2_LL", true);
        if (d == 0.0) {
            return null;
        }
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("CRITICAL_FLAME_TEMPERATURE", true);
        return new FireSuppression(d, unitDouble);
    }

    private Byproducts parseByproducts(FDSParseRecord fDSParseRecord) {
        Byproducts.Energy energy;
        double d = (Double)fDSParseRecord.get("CO_YIELD", true);
        double d2 = (Double)fDSParseRecord.get("H2_YIELD", true);
        double d3 = (Double)fDSParseRecord.get("SOOT_YIELD", true);
        Soot soot = d3 > 0.0 ? this.parseSoot(fDSParseRecord) : null;
        boolean bl = (Boolean)fDSParseRecord.get("IDEAL", true);
        if (fDSParseRecord.contains("HEAT_OF_COMBUSTION")) {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("HEAT_OF_COMBUSTION", false);
            energy = new Byproducts.FuelEnergy(unitDouble, bl);
        } else {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("EPUMO2", true);
            energy = new Byproducts.OxygenEnergy(unitDouble, bl);
        }
        return new Byproducts(d, d2, d3, soot, energy);
    }

    private Soot parseSoot(FDSParseRecord fDSParseRecord) {
        double d = (Double)fDSParseRecord.get("SOOT_H_FRACTION", true);
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("MAXIMUM_VISIBILITY", true);
        double d2 = (Double)fDSParseRecord.get("VISIBILITY_FACTOR", true);
        UnitDouble unitDouble2 = d2 > 0.0 ? fDSParseRecord.getUnitDouble("MASS_EXTINCTION_COEFFICIENT", true) : null;
        return new Soot(d, unitDouble, unitDouble2, d2);
    }
}

