/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;

public class RampParser
extends AFDS5Parser {
    public RampParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("RAMP");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    public boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = fDSParseRecord.getString("ID");
        if (string == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Ramp does not have ID."));
        }
        Double d = fDSParseRecord.getDouble("F");
        if (d == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Ramp does not have an F."));
        }
        Double d2 = fDSParseRecord.getDouble("T");
        Double d3 = fDSParseRecord.getDouble("X");
        if (d2 == null && d3 == null) {
            throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Ramp does not have a T or X."));
        }
        if (d2 == null) {
            d2 = d3;
        }
        String string2 = fDSParseRecord.getString("DEVC_ID");
        this.getParsingInfo().addRampValue(fDSParseRecord, string, d2, d, string2);
        return true;
    }
}

