/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.io.fds.v5.parsers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.io.fds.FDSArray;
import pyrosim.legacy_2012_1.io.fds.FDSParseRecord;
import pyrosim.legacy_2012_1.io.fds.FDSRecordFormatException;
import pyrosim.legacy_2012_1.io.fds.v5.FDS5Const;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.AFDS5Parser;
import pyrosim.legacy_2012_1.io.fds.v5.parsers.FDS5ParsingInfo;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class PropParser
extends AFDS5Parser {
    private static final FDSParseRecord s_defPropRec = new FDSParseRecord(FDS5Const.getRecordSpecs().get("PROP"), true);
    private final Map<String, FDSParseRecord> d_propMap = new HashMap<String, FDSParseRecord>();
    private final Map<String, HeatLinkModel> d_heatLinkModels = new HashMap<String, HeatLinkModel>();
    private final Map<String, SmokeLinkModel> d_smokeLinkModels = new HashMap<String, SmokeLinkModel>();
    private final Map<String, SprayModel> d_sprayModels = new HashMap<String, SprayModel>();
    private final Map<String, SprinklerLinkModel> d_sprkLinkModels = new HashMap<String, SprinklerLinkModel>();

    public PropParser(FDS5ParsingInfo fDS5ParsingInfo) {
        super(fDS5ParsingInfo);
    }

    @Override
    public void getRecordTypes(Set<String> set) {
        set.add("PROP");
    }

    @Override
    public void getUnsupportedFields(String string, Set<String> set) {
    }

    @Override
    protected void done() throws FDSRecordFormatException {
        super.done();
    }

    @Override
    protected boolean process(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string = (String)fDSParseRecord.get("ID");
        if (string == null || string.trim().equals("")) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("%s has no ID."), "PROP"), String.format(Intl.intl("Adding %s to additional records section."), "PROP"));
            return false;
        }
        if (this.d_propMap.containsKey(string)) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Duplicate %1$s ID found: %2$s"), "PROP", string), String.format(Intl.intl("Ignoring %s."), "PROP"));
            return true;
        }
        this.d_propMap.put(string, fDSParseRecord);
        this.processProp(string, fDSParseRecord);
        return true;
    }

    protected boolean processProp(String string, FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        String string2;
        if (fDSParseRecord.contains("PART_ID")) {
            this.parseSprayModel(fDSParseRecord);
        }
        if ((string2 = (String)fDSParseRecord.get("QUANTITY", false)) != null) {
            if (string2.equals("SPRINKLER LINK TEMPERATURE")) {
                this.parseSprinklerLinkModel(fDSParseRecord);
            } else if (string2.equals("LINK TEMPERATURE")) {
                this.parseHeatLinkModel(fDSParseRecord);
            } else if (string2.equals("spot obscuration") || string2.equals("CHAMBER OBSCURATION")) {
                this.parseSmokeLinkModel(fDSParseRecord);
            }
        }
        return true;
    }

    public FDSParseRecord getProp(String string) {
        return this.d_propMap.get(string);
    }

    public static FDSParseRecord getDefaultProp() {
        return s_defPropRec;
    }

    private <T extends INamed> void addModel(Composite<T> composite, Map<String, T> map, T t) {
        composite.add(t);
        this.flagObjectAdded(t);
        map.put(t.getName(), t);
    }

    protected HeatLinkModel parseHeatLinkModel(FDSParseRecord fDSParseRecord) {
        String string = (String)fDSParseRecord.get("ID");
        HeatLinkModel heatLinkModel = this.d_heatLinkModels.get(string);
        if (heatLinkModel != null) {
            return heatLinkModel;
        }
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("INITIAL_TEMPERATURE", true);
        UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("ACTIVATION_TEMPERATURE", true);
        UnitDouble unitDouble3 = (UnitDouble)fDSParseRecord.get("RTI", true);
        heatLinkModel = new HeatLinkModel(string, unitDouble3, unitDouble, unitDouble2);
        this.addModel(this.getContainer().getHeatLinkModels(), this.d_heatLinkModels, heatLinkModel);
        return heatLinkModel;
    }

    protected SmokeLinkModel parseSmokeLinkModel(FDSParseRecord fDSParseRecord) {
        SmokeLinkModel.ISpec iSpec;
        String string = (String)fDSParseRecord.get("ID");
        SmokeLinkModel smokeLinkModel = this.d_smokeLinkModels.get(string);
        if (smokeLinkModel != null) {
            return smokeLinkModel;
        }
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("ACTIVATION_OBSCURATION", true);
        ExSpec exSpec = null;
        String string2 = (String)fDSParseRecord.get("SPEC_ID", false);
        if (string2 != null && (exSpec = this.findObject(ExSpec.class, string2)) == null) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("Could not find custom smoke species, \"%s.\""), string2), String.format(Intl.intl("Tracking default smoke."), new Object[0]));
        }
        if (fDSParseRecord.contains("ALPHA_C") || fDSParseRecord.contains("ALPHA_E") || fDSParseRecord.contains("BETA_C") || fDSParseRecord.contains("BETA_E")) {
            iSpec = new SmokeLinkModel.Cleary(fDSParseRecord.getDouble("ALPHA_C", true), fDSParseRecord.getDouble("BETA_C", true), fDSParseRecord.getDouble("ALPHA_E", true), fDSParseRecord.getDouble("BETA_E", true));
        } else {
            UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("LENGTH", true);
            iSpec = new SmokeLinkModel.Heskestad(unitDouble2);
        }
        smokeLinkModel = new SmokeLinkModel(string, unitDouble, exSpec, iSpec);
        this.addModel(this.getContainer().getSmokeLinkModels(), this.d_smokeLinkModels, smokeLinkModel);
        return smokeLinkModel;
    }

    protected SprinklerLinkModel parseSprinklerLinkModel(FDSParseRecord fDSParseRecord) {
        String string = (String)fDSParseRecord.get("ID");
        SprinklerLinkModel sprinklerLinkModel = this.d_sprkLinkModels.get(string);
        if (sprinklerLinkModel != null) {
            return sprinklerLinkModel;
        }
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("INITIAL_TEMPERATURE", true);
        UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("ACTIVATION_TEMPERATURE", true);
        UnitDouble unitDouble3 = (UnitDouble)fDSParseRecord.get("RTI", true);
        UnitDouble unitDouble4 = (UnitDouble)fDSParseRecord.get("C_FACTOR", true);
        sprinklerLinkModel = new SprinklerLinkModel(string, unitDouble3, unitDouble, unitDouble2, unitDouble4);
        this.addModel(this.getContainer().getSprinklerLinkModels(), this.d_sprkLinkModels, sprinklerLinkModel);
        return sprinklerLinkModel;
    }

    protected SprayModel parseSprayModel(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        Serializable serializable;
        Serializable serializable2;
        String string = (String)fDSParseRecord.get("ID");
        SprayModel sprayModel = this.d_sprayModels.get(string);
        if (sprayModel != null) {
            return sprayModel;
        }
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("OFFSET", true);
        String string2 = (String)fDSParseRecord.get("PART_ID", false);
        if (string2 == null) {
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("%s was not specified."), "PART_ID"));
        }
        Particle particle = this.getParsingInfo().findObject(Particle.class, string2);
        if (particle == null) {
            throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Particle %s could not be found."), string2));
        }
        List<SprayModel.Jet> list = this.parseJets(fDSParseRecord, string);
        int n = fDSParseRecord.getInteger("DROPLETS_PER_SECOND", true);
        if (!fDSParseRecord.contains("DROPLETS_PER_SECOND") && (serializable2 = particle.getDescription()) instanceof GenericPartDesc) {
            serializable = (GenericPartDesc)serializable2;
            if (serializable.d_dropsPerSec != -1) {
                n = serializable.d_dropsPerSec;
            }
        }
        if ((serializable2 = fDSParseRecord.getUnitDouble("DT_INSERT", false)) == null) {
            serializable2 = particle.getDescription().getOutput().d_dtInsert;
        }
        serializable = this.parseFlowRate(fDSParseRecord);
        sprayModel = new SprayModel(string, particle, unitDouble, (SprayModel.FlowRate)serializable, n, (UnitDouble)serializable2, list);
        this.addModel(this.getContainer().getSprayModels(), this.d_sprayModels, sprayModel);
        return sprayModel;
    }

    private static <T> int countNonNull(T ... TArray) {
        int n = 0;
        for (T t : TArray) {
            if (t == null) continue;
            ++n;
        }
        return n;
    }

    private SprayModel.FlowRate parseFlowRate(FDSParseRecord fDSParseRecord) throws FDSRecordFormatException {
        SprayModel.FlowRate flowRate;
        TimeFunction timeFunction = this.parseTimeFunction(fDSParseRecord, "FLOW_TAU", "FLOW_RAMP");
        if (fDSParseRecord.contains("PRESSURE_RAMP")) {
            String string = fDSParseRecord.getString("PRESSURE_RAMP");
            Ramp ramp = this.getParsingInfo().getRamp(string, SprayModel.VaryingFlowRate.DEF_RAMP_INPUT, 39, true);
            if (ramp == null) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("The RAMP, \"%s\", does not exist."), string));
            }
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("K_FACTOR", false);
            UnitDouble unitDouble2 = (UnitDouble)fDSParseRecord.get("OPERATING_PRESSURE", false);
            UnitDouble unitDouble3 = (UnitDouble)fDSParseRecord.get("FLOW_RATE", false);
            int n = PropParser.countNonNull(unitDouble, unitDouble2, unitDouble3);
            if (n < 2) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Sprinklers and nozzles with varying pipe pressure must specify at least two of\nthese properties: %1$s, %2$s, and %3$s."), "K_FACTOR", "OPERATING_PRESSURE", "FLOW_RATE"));
            }
            flowRate = new SprayModel.VaryingFlowRate(ramp, unitDouble2, unitDouble, unitDouble3, timeFunction);
        } else if (fDSParseRecord.contains("FLOW_RATE")) {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("FLOW_RATE", false);
            flowRate = new SprayModel.ExplicitFlowRate(unitDouble, timeFunction);
        } else {
            UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("K_FACTOR", true);
            UnitDouble unitDouble4 = (UnitDouble)fDSParseRecord.get("OPERATING_PRESSURE", true);
            flowRate = new SprayModel.PressurizedFlowRate(unitDouble4, unitDouble, timeFunction);
        }
        return flowRate;
    }

    private List<SprayModel.Jet> parseJets(FDSParseRecord fDSParseRecord, String string) throws FDSRecordFormatException {
        if (fDSParseRecord.contains("SPRAY_PATTERN_TABLE")) {
            String string2 = (String)fDSParseRecord.get("SPRAY_PATTERN_TABLE");
            List<List<Double>> list = this.getParsingInfo().getTable(string2);
            if (list == null) {
                throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("Table %s could not be found."), string2));
            }
            ArrayList<SprayModel.Jet> arrayList = new ArrayList<SprayModel.Jet>(list.size());
            double d = 0.0;
            for (List<Double> list2 : list) {
                if (list2.size() < 6) {
                    throw new FDSRecordFormatException(fDSParseRecord, String.format(Intl.intl("%s must have 6 columns."), "SPRAY_PATTERN_TABLE"));
                }
                double d2 = list2.get(5);
                if (d2 < 0.0 || d2 > 1.0) {
                    throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Flow fraction must be between 0 and 1 inclusive."));
                }
                SprayModel.Jet jet = new SprayModel.Jet(SIUS.newud(list2.get(4), 8), null, d2, SIUS.newud(list2.get(2), 29), SIUS.newud(list2.get(3), 29), SIUS.newud(list2.get(0), 29), SIUS.newud(list2.get(1), 29));
                arrayList.add(jet);
                d += d2;
            }
            if (d > 1.00001) {
                throw new FDSRecordFormatException(fDSParseRecord, Intl.intl("Total flow fraction must be less than or equal to 1."));
            }
            return arrayList;
        }
        UnitDouble unitDouble = (UnitDouble)fDSParseRecord.get("DROPLET_VELOCITY", true);
        UnitDouble unitDouble2 = fDSParseRecord.getUnitDouble("ORIFICE_DIAMETER", false);
        if (unitDouble2 != null && fDSParseRecord.contains("DROPLET_VELOCITY")) {
            this.addWarning(fDSParseRecord, String.format(Intl.intl("PROP %1$s specifies both %2$s and %3$s."), string, "ORIFICE_DIAMETER", "DROPLET_VELOCITY"), String.format(Intl.intl("Ignoring %s."), "ORIFICE_DIAMETER"));
            unitDouble2 = null;
        } else if (unitDouble2 != null) {
            unitDouble = null;
        }
        FDSArray fDSArray = fDSParseRecord.getArray("SPRAY_ANGLE", true);
        return Arrays.asList(new SprayModel.Jet(unitDouble, unitDouble2, 1.0, (UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1)));
    }
}

